package fr.nocle.passegares.region;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;

import fr.nocle.passegares.R;

/**
 * Created by jonathanmm on 25/02/17.
 */

public class RegionsAdapter extends ArrayAdapter<Region> {
    private AlertDialog.Builder dialogInstallRegion;
    private final boolean installation;

    public RegionsAdapter(Context context, ArrayList<Region> liste, boolean installation)
    {
        super(context, 0, liste);
        dialogInstallRegion = new AlertDialog.Builder(context);
        this.installation = installation;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent)
    {
        Region r = getItem(position);

        if(r == null)
        {
            return convertView;
        }

        // Check if an existing view is being reused, otherwise inflate the view
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.region_viewer, parent, false);
        }

        TextView nomRegion = convertView.findViewById(R.id.nom_region);
        nomRegion.setText(r.getNom());

        configurerBoutonFavori(convertView, r);

        CheckBox estInstalle = convertView.findViewById(R.id.estInstalle);
        estInstalle.setChecked(r.isEstInstalle());

        estInstalle.setOnClickListener(view -> {
            if(!r.isEstInstalle())
            {
                afficherDialogueInstallation((CheckBox) view, r, dialogInstallRegion);
            } else {
                afficherDialogueDesinstallation((CheckBox) view, r, dialogInstallRegion);
            }
        });

        return convertView;
    }

    private void configurerBoutonFavori(View v, Region r)
    {
        ImageButton estFavori = v.findViewById(R.id.estFavori);
        if(r.isEstInstalle())
        {
            if(r.getFavori() > 0) {
                estFavori.setImageResource(R.drawable.fa_star);
            } else {
                estFavori.setImageResource(R.drawable.fa_starempty);
            }
            estFavori.setOnClickListener(view -> {
                RegionCtrl regionCtrl = new RegionCtrl(getContext());
                if(r.getFavori() > 0)
                {
                    regionCtrl.removeFavori(r);
                    Toast.makeText(getContext(), R.string.notificationRegionRetraitFavori, Toast.LENGTH_SHORT).show();
                } else {
                    regionCtrl.setFavori(r);
                    Toast.makeText(getContext(), R.string.notificationRegionAjoutFavori, Toast.LENGTH_SHORT).show();
                }
                regionCtrl.close();
                notifyDataSetInvalidated();
            });
            estFavori.setVisibility(View.VISIBLE);
        } else {
            estFavori.setVisibility(View.GONE);
        }
    }

    private void afficherDialogueInstallation(CheckBox view, Region region, AlertDialog.Builder dialogInstallRegion) {
        if(installation) //Pas de dialog, on installe direct !
        {
            lancerInstallation(region, view);
        } else {
            dialogInstallRegion.setMessage(R.string.dialogAjoutRegionExplication).setTitle(R.string.dialogAjoutRegionTitre);
            dialogInstallRegion.setPositiveButton(R.string.boutonValider, (dialog, id1) -> {
                // On valide l'installation des nouvelles données
                dialog.cancel();
                lancerInstallation(region, view);
            });
            dialogInstallRegion.setNegativeButton(R.string.boutonAnnuler, (dialog, id2) -> {
                // On refuse l'installation des données
                dialog.cancel();
                view.setChecked(false);
            });

            dialogInstallRegion.create();
            dialogInstallRegion.show();
        }
    }

    private void lancerInstallation(Region region, CheckBox checkBox)
    {
        ProgressDialog loadingDialog = ProgressDialog.show(getContext(), null, getContext().getString(R.string.dialogAjoutRegionEnCours), true);
        AjoutRegionThread p = new AjoutRegionThread(getContext(), loadingDialog, region);
        p.start();
        checkBox.setChecked(true);
        region.setEstInstalle(true);
        configurerBoutonFavori((View) checkBox.getParent(), region);
    }

    private void afficherDialogueDesinstallation(CheckBox view, Region region, AlertDialog.Builder dialogAction) {
        if(installation) //Pas de dialog, on désinstalle direct !
        {
            lancerDesinstallation(region, view);
        } else {
            dialogAction.setMessage(R.string.dialogSupprimerRegionExplication).setTitle(R.string.dialogSupprimerRegionTitre);
            dialogAction.setPositiveButton(R.string.boutonValider, (dialog, id1) -> {
                // On valide donc on lance l'action
                dialog.cancel();
                lancerDesinstallation(region, view);
            });
            dialogAction.setNegativeButton(R.string.boutonAnnuler, (dialog, id2) -> {
                // Annulation de l'action
                dialog.cancel();
                view.setChecked(true);
            });

            dialogAction.create();
            dialogAction.show();
        }
    }

    private void lancerDesinstallation(Region region, CheckBox checkBox)
    {
        ProgressDialog loadingDialog = ProgressDialog.show(getContext(), null, getContext().getString(R.string.dialogSupprimerRegionEnCours), true);
        SupprimerRegionThread p = new SupprimerRegionThread(getContext(), loadingDialog, region);
        p.start();
        checkBox.setChecked(false);
        ImageButton estFavori = ((View) checkBox.getParent()).findViewById(R.id.estFavori);
        estFavori.setVisibility(View.GONE);
    }
}
