package fr.nocle.passegares.region

import kotlin.Comparator

class RegionOutils {
    companion object
    {
        fun trierListeRegion(listeRegions: ArrayList<Region>)
        {
            listeRegions.sortWith(Comparator { r1: Region, r2: Region ->
                return@Comparator comparerRegions(r1, r2)
            })
        }

        fun comparerRegions(r1: Region, r2: Region): Int
        {
            if(r1.favori != 0 && r2.favori == 0)
            {
                return -1
            }

            if(r1.favori == 0 && r2.favori != 0)
            {
                return 1
            }

            if (r1.favori != r2.favori) {
                return r1.favori.compareTo(r2.favori)
            }

            if (r1.isEstInstalle && !r2.isEstInstalle) {
                return -1
            }

            if (!r1.isEstInstalle && r2.isEstInstalle) {
                return 1
            }

            return r1.ordre.toLong().compareTo(r2.ordre.toLong())
        }
    }
}