package fr.nocle.passegares.region;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import java.util.ArrayList;
import java.util.HashMap;

import fr.nocle.passegares.controlleur.Controlleur;

/**
 * Created by jonathanmm on 10/02/17.
 */

public class RegionCtrl extends Controlleur {
    public static int TOUTESREGIONS = 0;
    public static int REGIONSINSTALLE = 1;
    public static int REGIONSDISPONIBLE = 2;

    private HashMap<Long, Region> _cacheRegion;

    public RegionCtrl(Context contexte) {
        super(contexte);
        this.open();
        _cacheRegion = new HashMap<>();
    }

    public RegionCtrl(SQLiteDatabase bdd) {
        super(bdd);
        _cacheRegion = new HashMap<Long, Region>();
    }

    public void create(Region r)
    {
        bdd.insert(RegionBDD.TABLE_NOM, null, creerDepuisObj(r));
    }

    public Region get(long id)
    {
        if(_cacheRegion.containsKey(id))
        {
            return _cacheRegion.get(id);
        }

        Cursor c = bdd.query(RegionBDD.TABLE_NOM,
                new String[] {RegionBDD.TABLE_CLE, RegionBDD.TABLE_NOM_REGION,
                        RegionBDD.TABLE_EST_INSTALLE, RegionBDD.TABLE_ORDRE,
                        RegionBDD.TABLE_FAVORI, RegionBDD.TABLE_DOSSIER},
                RegionBDD.TABLE_CLE + " = ?", new String[] {String.valueOf(id)}, null, null, null);
        if(!c.moveToFirst())
        {
            c.close();
            return null;
        }
        Region r = new Region(id,
                c.getString(1),
                c.getInt(2) == 1,
                c.getInt(3),
                c.getInt(4),
                c.getString(5));
        c.close();
        _cacheRegion.put(id, r);
        return r;
    }

    public void update(Region r)
    {
        bdd.update(RegionBDD.TABLE_NOM, creerDepuisObj(r), RegionBDD.TABLE_CLE + " = ?", new String[] {String.valueOf(r.getId())});
        _cacheRegion.remove(r.getId()); // On le supprime du cache
    }

    public ArrayList<Region> getAllRegions(int onlyInstalled)
    {
        String condition = "";
        String[] conditionsWhere = new String[] {};
        if(onlyInstalled == REGIONSINSTALLE)
        {
            condition = RegionBDD.TABLE_EST_INSTALLE + " = ?";
            conditionsWhere = new String[] {"1"};
        } else if(onlyInstalled == REGIONSDISPONIBLE)
        {
            condition = RegionBDD.TABLE_EST_INSTALLE + " = ?";
            conditionsWhere = new String[] {"0"};
        }
        Cursor c = bdd.query(RegionBDD.TABLE_NOM,
                new String[] {RegionBDD.TABLE_CLE, RegionBDD.TABLE_NOM_REGION,
                        RegionBDD.TABLE_EST_INSTALLE, RegionBDD.TABLE_ORDRE,
                        RegionBDD.TABLE_FAVORI, RegionBDD.TABLE_DOSSIER},
                condition, conditionsWhere, null, null, RegionBDD.TABLE_ORDRE);

        ArrayList<Region> listeRegion = new ArrayList<Region>();
        while(c.moveToNext())
        {
            Region r = new Region(c.getLong(0),
                    c.getString(1),
                    c.getInt(2) == 1,
                    c.getInt(3),
                    c.getInt(4),
                    c.getString(5));
            listeRegion.add(r);
        }
        c.close();
        return listeRegion;
    }

    public static ContentValues creerDepuisObj(Region r)
    {
        ContentValues valeur = new ContentValues();
        valeur.put(RegionBDD.TABLE_CLE, r.getId());
        valeur.put(RegionBDD.TABLE_NOM_REGION, r.getNom());
        valeur.put(RegionBDD.TABLE_EST_INSTALLE, r.isEstInstalle());
        valeur.put(RegionBDD.TABLE_ORDRE, r.getOrdre());
        valeur.put(RegionBDD.TABLE_FAVORI, r.getFavori());
        valeur.put(RegionBDD.TABLE_DOSSIER, r.getDossierId());
        return valeur;
    }

    public void setFavori(Region r)
    {
        if(r.getFavori() > 0)
        {
            // Déjà en favori
            return;
        }

        Region regionMisAJour = get(r.getId());

        Cursor c = bdd.query(RegionBDD.TABLE_NOM, new String[]{"MAX(" + RegionBDD.TABLE_FAVORI + ")"}, null, null, null, null, null);
        int numeroFavori = 1;
        if(c.moveToFirst())
        {
            numeroFavori = c.getInt(0) + 1;
        }
        c.close();

        regionMisAJour.setFavori(numeroFavori);
        update(regionMisAJour);

        r.setFavori(numeroFavori);
    }

    public void removeFavori(Region r)
    {
        if(r.getFavori() == 0)
        {
            // Déjà pas en favori
            return;
        }
        bdd.execSQL("UPDATE " + RegionBDD.TABLE_NOM + " SET " + RegionBDD.TABLE_FAVORI + " = " + RegionBDD.TABLE_FAVORI + " - 1 WHERE " + RegionBDD.TABLE_FAVORI + " > " + r.getFavori());
        _cacheRegion = new HashMap<>(); // On vide entièrement le cache car on ne sait pas exactement ce qui a été mis à jour

        Region regionMisAJour = get(r.getId());
        regionMisAJour.setFavori(0);
        update(regionMisAJour);
        r.setFavori(0);
    }
}
