package fr.nocle.passegares.region

import android.content.Context
import android.content.DialogInterface
import fr.nocle.passegares.controlleur.ImportCSV
import fr.nocle.passegares.controlleur.LigneCtrl

internal class AjoutRegionThread(
    private val contexte: Context?,
    private val loadingDialog: DialogInterface,
    private val region: Region
) : Thread() {
    override fun run() {
        val regionCtrl = RegionCtrl(contexte)
        val bdd = regionCtrl.open()

        //On utilise une transaction pour que tout passe en même temps
        bdd.beginTransaction()
        ImportCSV.updateAllDataRegion(contexte, bdd, 1, -1, region)

        //Et on met à jour la région !
        region.setEstInstalle(true)
        regionCtrl.update(region)

        // On doit également recalculer les succès sur les lignes
        LigneCtrl.updateAllSuccesConcerningLignes(contexte, bdd)

        bdd.setTransactionSuccessful()
        bdd.endTransaction()
        regionCtrl.close()

        loadingDialog.dismiss()
    }
}
