package fr.nocle.passegares.region;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Collections;

import fr.nocle.passegares.R;

public class AjoutRegionFragment extends Fragment {
    private RegionCtrl regionCtrl;
    private final boolean installation;

    public AjoutRegionFragment(boolean installation)
    {
        this.installation = installation;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View view = inflater.inflate(R.layout.fragment_ajout_region, null);

        regionCtrl = new RegionCtrl(getActivity());
        try {
            regionCtrl.open();
            final ArrayList<Region> listeRegions = regionCtrl.getAllRegions(RegionCtrl.TOUTESREGIONS);

            RegionOutils.Companion.trierListeRegion(listeRegions);

            RegionsAdapter adapter = new RegionsAdapter(getActivity(), listeRegions, installation);
            ListView listView = view.findViewById(R.id.listeRegions);
            listView.setAdapter(adapter);
        } finally {
            regionCtrl.close();
        }

        return view;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        regionCtrl.close();
    }
}
