package fr.nocle.passegares.region;

import android.app.ActionBar;
import android.content.Intent;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.WindowCompat;

import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;

import fr.nocle.passegares.R;
import fr.nocle.passegares.outils.UserInterfaceOutils;

public class AjoutRegionActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                Build.VERSION.SDK_INT < Build.VERSION_CODES.VANILLA_ICE_CREAM)
        {
            WindowCompat.enableEdgeToEdge(getWindow());
        }
        setContentView(R.layout.activity_ajout_region);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        ActionBar actionBar = getActionBar();
        if(actionBar != null)
        {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }

        View contenu = findViewById(R.id.ajout_region_frame_layout);
        UserInterfaceOutils.gererBordABord(toolbar, contenu);

        AjoutRegionFragment fragment = new AjoutRegionFragment(false);

        getSupportFragmentManager().beginTransaction().replace(R.id.ajout_region_frame_layout, fragment).commit();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                this.finish();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
