package fr.nocle.passegares.preferences

import android.content.Context
import android.content.DialogInterface
import fr.nocle.passegares.bdd.BoutiqueBDD
import fr.nocle.passegares.bdd.GareBDD
import fr.nocle.passegares.bdd.GareDansLigneBDD
import fr.nocle.passegares.bdd.InventaireBDD
import fr.nocle.passegares.bdd.LigneBDD
import fr.nocle.passegares.region.RegionBDD
import fr.nocle.passegares.bdd.TamponBDD
import fr.nocle.passegares.controlleur.Controlleur
import fr.nocle.passegares.controlleur.ImportCSV
import fr.nocle.passegares.gares.CoordonneeBDD
import fr.nocle.passegares.succes.SuccesBDD

class ReinitThread(
    private val contexte: Context,
    private val loadingDialog: DialogInterface
) : Thread() {
    override fun run() {
        val ctrl = Controlleur(contexte)
        val bdd = ctrl.open()
        bdd.execSQL(TamponBDD.TABLE_SUPPRESSION)
        bdd.execSQL(GareBDD.TABLE_SUPPRESSION)
        bdd.execSQL(LigneBDD.TABLE_SUPPRESSION)
        bdd.execSQL(GareDansLigneBDD.TABLE_SUPPRESSION)
        bdd.execSQL(InventaireBDD.TABLE_SUPPRESSION)
        bdd.execSQL(RegionBDD.TABLE_SUPPRESSION)
        bdd.execSQL(BoutiqueBDD.TABLE_SUPPRESSION)
        bdd.execSQL(SuccesBDD.TABLE_SUPPRESSION)
        bdd.execSQL(CoordonneeBDD.TABLE_SUPPRESSION)

        bdd.execSQL(TamponBDD.TABLE_CREATION)
        bdd.execSQL(GareBDD.TABLE_CREATION)
        bdd.execSQL(LigneBDD.TABLE_CREATION)
        bdd.execSQL(GareDansLigneBDD.TABLE_CREATION)
        bdd.execSQL(InventaireBDD.TABLE_CREATION)
        bdd.execSQL(InventaireBDD.TABLE_INIT)
        bdd.execSQL(RegionBDD.TABLE_CREATION)
        bdd.execSQL(BoutiqueBDD.TABLE_CREATION)
        bdd.execSQL(SuccesBDD.TABLE_CREATION)
        bdd.execSQL(SuccesBDD.TABLE_INIT)
        bdd.execSQL(SuccesBDD.TABLE_ADD_NBGARE_1000)
        bdd.execSQL(SuccesBDD.TABLE_ADD_LIGNES)
        bdd.execSQL(CoordonneeBDD.TABLE_CREATION)

        ImportCSV.updatedataRegions(contexte, bdd, 1, -1)

        ctrl.close()

        loadingDialog.dismiss()
        //        Toast.makeText(contexte, "Réinitialisation terminée.", Toast.LENGTH_LONG).show();
    }
}