package fr.nocle.passegares.preferences

import android.content.Context
import android.content.DialogInterface
import fr.nocle.passegares.controlleur.Controlleur
import fr.nocle.passegares.controlleur.ImportCSV

internal class ReinitGDLThread(
    private val contexte: Context?,
    private val loadingDialog: DialogInterface
) : Thread() {
    override fun run() {
        val ctrl = Controlleur(contexte)
        val bdd = ctrl.open()

        ImportCSV.reinitDataGareDansLigne(contexte, bdd)

        ctrl.close()

        loadingDialog.dismiss()
        //        Toast.makeText(contexte, "Réinitialisation terminée.", Toast.LENGTH_LONG).show();
    }
}