package fr.nocle.passegares.preferences

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.util.Log
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AlertDialog
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat
import fr.nocle.passegares.BuildConfig
import fr.nocle.passegares.CreditsActivity
import fr.nocle.passegares.R
import fr.nocle.passegares.interfaces.ToolbarManager
import fr.nocle.passegares.region.AjoutRegionActivity
import androidx.core.net.toUri

class PreferencesFragment : PreferenceFragmentCompat() {
    private var _toolbarManager: ToolbarManager? = null

    override fun onCreatePreferences(
        savedInstanceState: Bundle?,
        rootKey: String?
    ) {
        setPreferencesFromResource(R.xml.preferences, rootKey)

        val versionAPKPref = findPreference<Preference>("versionAPK")
        val versionName = BuildConfig.VERSION_NAME
        versionAPKPref?.setSummary(versionName)

        versionAPKPref?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            val dialog = AlertDialog.Builder(requireActivity())
            dialog.setMessage(R.string.nouveautesRelease)
                .setTitle(R.string.dialogMiseAJourTitle)
            dialog.setPositiveButton(
                R.string.boutonDAccord
            ) { dialog, id -> dialog.cancel() }
            dialog.create()
            dialog.show()
            true
        }

        val ajoutRegion = findPreference<Preference>("ajoutRegion")
        ajoutRegion?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            val i = Intent(activity, AjoutRegionActivity::class.java)
            startActivity(i)
            true
        }

        val preferencesAvancees = findPreference<Preference>("preferencesAvancees")
        preferencesAvancees?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            activity?.supportFragmentManager?.beginTransaction()?.replace(R.id.settings_content, PreferencesAvanceesFragment())?.addToBackStack(null)?.commit()
            true
        }

        val credits = findPreference<Preference>("credits")
        credits?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            val i = Intent(activity, CreditsActivity::class.java)
            startActivity(i)
            true
        }

        val confidentialite = findPreference<Preference>("confidentialite")
        confidentialite?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            val browserIntent = Intent(
                Intent.ACTION_VIEW,
                "http://passegares.nocle.fr/politique-confidentialite.html".toUri()
            )
            startActivity(browserIntent)
            true
        }

        val depot = findPreference<Preference>("depot")
        depot?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            val browserIntent =
                Intent(Intent.ACTION_VIEW, "https://framagit.org/JonathanMM/passegares".toUri())
            startActivity(browserIntent)
            true
        }
    }

    @RequiresApi(Build.VERSION_CODES.M)
    override fun onAttach(context: Context) {
        super.onAttach(context)
        initializeManagerAndToolbar()
    }

    override fun onAttach(activity: Activity) {
        super.onAttach(activity)

        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            initializeManagerAndToolbar()
        }
    }

    private fun initializeManagerAndToolbar() {
        this.createCallbackToolbarManager()

        this.initializeToolbar()
    }

    private fun initializeToolbar() {
        _toolbarManager!!.setTitleToolbar(R.string.preferences)
    }

    private fun createCallbackToolbarManager() {
        try {
            _toolbarManager = activity as ToolbarManager?
        } catch (ex: ClassCastException) {
            Log.e("Preferences", "Problème lors du cast de l'activité : " + ex.message)
        }
    }

    override fun onResume() {
        super.onResume()
        this.initializeToolbar()
    }
}
