package fr.nocle.passegares.preferences

import android.app.AlertDialog
import android.app.ProgressDialog
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.widget.Toast
import androidx.activity.result.contract.ActivityResultContracts
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat
import fr.nocle.passegares.BuildConfig
import fr.nocle.passegares.R
import fr.nocle.passegares.controlleur.Controlleur
import fr.nocle.passegares.controlleur.ExportImportBDD

class PreferencesAvanceesFragment : PreferenceFragmentCompat() {
    private val enregistrerBddAction = registerForActivityResult(
        ActivityResultContracts.CreateDocument("application/x-sqlite3"))
    { uri: Uri? ->
        val isSuccess = ExportImportBDD.exporterBDD(uri, activity)
        if (isSuccess) Toast.makeText(
            activity,
            getString(R.string.exportMessageSucces),
            Toast.LENGTH_LONG
        ).show()
        else Toast.makeText(activity, R.string.exportMessageErreur, Toast.LENGTH_LONG).show()
    }

    private val importerBddAction = registerForActivityResult(
        ActivityResultContracts.OpenDocument()
    ) { uri: Uri? ->
        val adresse = ExportImportBDD.importerBDD(activity, uri)
        if (adresse == null) Toast.makeText(
            activity,
            R.string.importMessageErreur,
            Toast.LENGTH_LONG
        ).show()
        else {
            val baseContext = activity?.baseContext
            val i = baseContext?.packageManager?.getLaunchIntentForPackage(
                BuildConfig.APPLICATION_ID)
            i!!.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
            startActivity(i)
            Toast.makeText(activity, R.string.importMessageSucces, Toast.LENGTH_LONG)
                .show()
        }
    }

    override fun onCreatePreferences(
        savedInstanceState: Bundle?,
        rootKey: String?
    ) {
        setPreferencesFromResource(R.xml.preferencesavancees, rootKey)

        val viderBDDPref = findPreference<Preference>("viderBDD")
        //On fait une dialogue de confirmation
        val dialogViderBDD = AlertDialog.Builder(activity)

        //On créer aussi une dialogue de chargement
        dialogViderBDD.setMessage(R.string.dialogVidageBDDExplication)
            .setTitle(R.string.dialogVidageBDDTitre)
        dialogViderBDD.setPositiveButton(
            R.string.boutonEffacer
        ) { dialog, id -> // On valide la suppression des données
            dialog.cancel()
            val loadingDialog = ProgressDialog.show(
                activity,
                null,
                getString(R.string.dialogVidageBDDSuppressionEnCours),
                true
            )

            val p = ReinitThread(requireContext(), loadingDialog)
            p.start()
        }
        dialogViderBDD.setNegativeButton(
            R.string.boutonAnnuler
        ) { dialog, id -> // On refuse la suppression des données
            dialog.cancel()
        }

        dialogViderBDD.create()
        viderBDDPref?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            dialogViderBDD.show()
            true
        }

        val reinitGDLPref = findPreference<Preference>("reinitGDL")
        //On fait une dialogue de confirmation
        val dialogReinitGDL = AlertDialog.Builder(activity)

        //On créer aussi une dialogue de chargement
        dialogReinitGDL.setMessage(R.string.dialogReinitGDLExplication)
            .setTitle(R.string.dialogReinitGDLTitre)
        dialogReinitGDL.setPositiveButton(
            R.string.boutonReinit
        ) { dialog, id -> // On valide la suppression des données
            dialog.cancel()
            val loadingDialog = ProgressDialog.show(
                activity,
                null,
                getString(R.string.dialogReinitGDLSuppressionEnCours),
                true
            )

            val p = ReinitGDLThread(activity, loadingDialog)
            p.start()
        }
        dialogReinitGDL.setNegativeButton(
            R.string.boutonAnnuler
        ) { dialog, id -> // On refuse la suppression des données
            dialog.cancel()
        }

        dialogReinitGDL.create()
        reinitGDLPref?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            dialogReinitGDL.show()
            true
        }

        val exportBDD = findPreference<Preference>("exportBDD")
        exportBDD?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            //Vaccum
            val ctrl = Controlleur(activity)
            ctrl.open()
            ctrl.vacuum()
            ctrl.close()

            enregistrerBddAction.launch("passegares.db")
            true
        }

        val importBDD = findPreference<Preference>("importBDD")
        importBDD?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            importerBddAction.launch(arrayOf("*/*"))
            true
        }

        // Reconstruction des données
        val reconstructDonnees = findPreference<Preference>("reconstructDonnees")
        //On fait une dialogue de confirmation
        val dialogReconstructDonnees = AlertDialog.Builder(activity)

        //On créer aussi une dialogue de chargement
        dialogReconstructDonnees.setMessage(R.string.dialogReconstructDonneesExplication)
            .setTitle(R.string.dialogReconstructDonneesTitre)
        dialogReconstructDonnees.setPositiveButton(
            R.string.boutonReconstruct
        ) { dialog, id -> // On lance le processus
            dialog.cancel()
            val loadingDialog = ProgressDialog.show(
                activity,
                null,
                getString(R.string.dialogReconstructDonneesEnCours),
                true
            )

            val p = ReconstructDonneesThread(activity, loadingDialog)
            p.start()
        }
        dialogReconstructDonnees.setNegativeButton(
            R.string.boutonAnnuler
        ) { dialog, id -> // On refuse la suppression des données
            dialog.cancel()
        }

        dialogReconstructDonnees.create()
        reconstructDonnees?.onPreferenceClickListener = Preference.OnPreferenceClickListener {
            dialogReconstructDonnees.show()
            true
        }
    }
}