package fr.nocle.passegares.preferences

import android.os.Build
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.core.view.WindowCompat
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat
import fr.nocle.passegares.R
import fr.nocle.passegares.interfaces.ToolbarManager
import fr.nocle.passegares.outils.UserInterfaceOutils

class PreferencesActivity: AppCompatActivity(),
    ToolbarManager,
    PreferenceFragmentCompat.OnPreferenceStartFragmentCallback {
    override fun onPreferenceStartFragment(
        caller: PreferenceFragmentCompat,
        pref: Preference
    ): Boolean {
        supportFragmentManager.beginTransaction().replace(R.id.content, PreferencesFragment())
            .commit()
        return true
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
            Build.VERSION.SDK_INT < Build.VERSION_CODES.VANILLA_ICE_CREAM
        ) {
            WindowCompat.enableEdgeToEdge(window)
        }
        setContentView(R.layout.activity_settings)

        val toolbar = findViewById<Toolbar?>(R.id.toolbar)
        setSupportActionBar(toolbar)
        val actionBar = getActionBar()
        actionBar?.setDisplayHomeAsUpEnabled(true)

        val contenu = findViewById<View?>(R.id.settings_content)
        UserInterfaceOutils.gererBordABord(toolbar, contenu)

        supportFragmentManager.
            beginTransaction().
            replace(R.id.settings_content, PreferencesFragment()).
            commit()
    }

    override fun onSupportNavigateUp(): Boolean {
        if (supportFragmentManager.popBackStackImmediate()) {
            return true
        }

        this.finish()
        return super.onSupportNavigateUp()
    }

    override fun setTitleToolbar(ressource: Int) {
        this.setTitle(ressource)
    }

    override fun setTitleToolbar(title: String?) {
        this.title = title
    }
}