package fr.nocle.passegares.navigation;

import android.Manifest;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.preference.PreferenceManager;

import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.navigation.NavigationView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import fr.nocle.passegares.BuildConfig;
import fr.nocle.passegares.LocationService;
import fr.nocle.passegares.MonnaieFragment;
import fr.nocle.passegares.R;
import fr.nocle.passegares.interfaces.LocationManager;
import fr.nocle.passegares.interfaces.OnNavigateIntentManager;
import fr.nocle.passegares.interfaces.OnUpdateManager;
import fr.nocle.passegares.interfaces.ToolbarManager;
import fr.nocle.passegares.radar.MessageHandler;
import fr.nocle.passegares.radar.RadarFragment;
import fr.nocle.passegares.succes.SuccesFragment;
import fr.nocle.passegares.visa.ResumeVisaSwipeFragment;

public class MainMenuActivity extends AppCompatActivity
        implements NavigationView.OnNavigationItemSelectedListener,
        BottomNavigationView.OnNavigationItemSelectedListener,
        LocationManager,
        OnNavigateIntentManager,
        OnUpdateManager,
        ToolbarManager {

    private Fragment fragmentRadar;
    private Fragment fragmentTicket;
    private Fragment fragmentTampons;
    private Fragment fragmentSucces;
    private BottomNavigationView bottomNavigationView;
    private FragmentManager fragmentManager;

    private MessageHandler messageHandler;
    private Intent serviceLocation;
    private boolean serviceLocationEnCours = false;
    private boolean installationEnCours = false;

    private int fragmentActuel = 0;

    private static final int DEMANDE_DROIT_LOCALISATION = 1;
    private static final int RESULT_PREMIER_LANCEMENT = 1;

    private static final String CLE_FRAGMENT_ACTUEL = "fragmentActuel";

    public static final String PREFERENCE_PRECEDENTE_VERSION = "derniereVersionMaJDialogue";
    public static final String PREFERENCE_PREMIER_LANCEMENT = "premierLancement";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                Build.VERSION.SDK_INT < Build.VERSION_CODES.VANILLA_ICE_CREAM)
        {
            WindowCompat.enableEdgeToEdge(getWindow());
        }
        setContentView(R.layout.activity_mainmenu);

        // Recover the instance state.
        if (savedInstanceState != null) {
            fragmentActuel = savedInstanceState.getInt(CLE_FRAGMENT_ACTUEL);
        } else {
            fragmentActuel = R.id.bottomnav_radar;
        }

        this.checkFirstLaunch();

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                getWindow().setStatusBarColor(getColor(R.color.applicationColor));
        }

        bottomNavigationView = findViewById(R.id.nav_bottomview);

        bottomNavigationView.setOnNavigationItemSelectedListener(this);

        adaptElementsWithInsets();

        //On récupère le fragment manager pour gérer le bouton retour
        fragmentManager = getSupportFragmentManager();

        //On lance directement le fragment radar
        this.demarrerFragment(fragmentActuel);

        //Et on démarre la localisation
        this.onStartLocation();
    }

    private void adaptElementsWithInsets() {
        View toolbarLayout = findViewById(R.id.toolbar_layout);
        ViewCompat.setOnApplyWindowInsetsListener(toolbarLayout, (v, windowInsets) -> {
            Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.displayCutout() +
                    WindowInsetsCompat.Type.systemBars());
            v.setPadding(insets.left, insets.top, insets.right, 0);

            return WindowInsetsCompat.CONSUMED;
        });

        ViewGroup.LayoutParams bottomNavViewParams = bottomNavigationView.getLayoutParams();
        int initialBottomNavViewHeight = bottomNavViewParams.height;
        ViewCompat.setOnApplyWindowInsetsListener(bottomNavigationView, (v, windowInsets) -> {
            Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.displayCutout() +
                    WindowInsetsCompat.Type.systemBars());
            ViewGroup.LayoutParams lp = v.getLayoutParams();
            lp.height = initialBottomNavViewHeight + insets.bottom;
            v.setLayoutParams(lp);

            v.setPadding(insets.left, 0, insets.right, insets.bottom);

            return WindowInsetsCompat.CONSUMED;
        });

        View mainContent = findViewById(R.id.activity_main_frame_layout);
        ViewCompat.setOnApplyWindowInsetsListener(mainContent, (v, windowInsets) -> {
            Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.displayCutout() +
                    WindowInsetsCompat.Type.systemBars());

            v.setPadding(insets.left, 0, insets.right, 0);

            return WindowInsetsCompat.CONSUMED;
        });
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        this.onPauseLocation();
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        this.onResumeLocation();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        // On sauvegarde le fragment actuel
        outState.putInt(CLE_FRAGMENT_ACTUEL, fragmentActuel);

        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onDestroy()
    {
        super.onDestroy();
        this.onStopLocation();
    }

    private void demarrerFragment(int idFragment)
    {
        switch(idFragment)
        {
            // TabBar
            case R.id.bottomnav_radar:
                this.showRadarFragment();
                break;
            case R.id.bottomnav_tampon:
                this.showVoirTamponsFragment();
                break;
            case R.id.bottomnav_succes:
                this.showSuccesFragment();
                break;
            case R.id.bottomnav_tickets:
                this.showTicketFragment();
                break;
        }
        fragmentActuel = idFragment;
    }

    @Override
    public boolean onNavigationItemSelected(MenuItem item) {
        // Lancement du bon fragment
        int id = item.getItemId();
        demarrerFragment(id);
        return true;
    }

    private void showRadarFragment(){
        if (this.fragmentRadar == null) this.fragmentRadar = new RadarFragment();
        this.startTransactionFragment(this.fragmentRadar);
    }

    private void showTicketFragment(){
        if (this.fragmentTicket == null) this.fragmentTicket = new MonnaieFragment();
        this.startTransactionFragment(this.fragmentTicket);
    }

    private void showVoirTamponsFragment(){
        if (this.fragmentTampons == null) this.fragmentTampons = new ResumeVisaSwipeFragment();
        this.startTransactionFragment(this.fragmentTampons);
    }

    private void showSuccesFragment(){
        if (this.fragmentSucces == null) this.fragmentSucces = new SuccesFragment();
        this.startTransactionFragment(this.fragmentSucces);
    }

    private void startTransactionFragment(Fragment fragment){
        if (!fragment.isVisible()){
            FragmentTransaction transaction = fragmentManager.beginTransaction()
                    .replace(R.id.activity_main_frame_layout, fragment);
            transaction.addToBackStack(null);
            transaction.commit();
        }
    }

    private void onStartLocation() {
        if(installationEnCours) return;

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_DENIED || ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_DENIED) {
            this.setTextLocation(R.string.localisationImpossible);
        } else {
            this.setTextLocation(R.string.localisationEnCours);
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                        Manifest.permission.ACCESS_FINE_LOCATION) && ActivityCompat.shouldShowRequestPermissionRationale(this,
                        Manifest.permission.ACCESS_COARSE_LOCATION)) {

                    messageHandler = new MessageHandler(this);
                    Log.d("LOCPG", "Demarrage du service");
                    serviceLocation = new Intent(this, LocationService.class);
                    serviceLocation.putExtra("MESSAGER", new Messenger(messageHandler));
                    serviceLocation.setAction("START");
                }
            } else {
                messageHandler = new MessageHandler(this);
                Log.d("LOCPG", "Demarrage du service");
                serviceLocation = new Intent(this, LocationService.class);
                serviceLocation.putExtra("MESSAGER", new Messenger(messageHandler));
                serviceLocation.setAction("START");
            }
        }
    }

    private void setTextLocation(int ressource)
    {
        if(this.fragmentRadar != null && this.fragmentRadar.isVisible())
        {
            View view = this.fragmentRadar.getView();
            TextView nom = view.findViewById(R.id.garePlusProcheNom);
            nom.setText(ressource);
            TextView surTitre = view.findViewById(R.id.garePlusProcheSurTitre);
            surTitre.setVisibility(View.GONE);
            TextView sousTitre = view.findViewById(R.id.garePlusProcheSousTitre);
            sousTitre.setVisibility(View.GONE);
        }
    }

    private void onPauseLocation() {
        if(serviceLocation != null && serviceLocationEnCours) {
            this.stopService(serviceLocation);
            serviceLocationEnCours = false;
        }
    }

    private void onResumeLocation() {
        if(installationEnCours) return;

        this.invalidateOptionsMenu();
        if(serviceLocation == null) {
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.ACCESS_COARSE_LOCATION, Manifest.permission.ACCESS_FINE_LOCATION}, DEMANDE_DROIT_LOCALISATION);
        } else {
            if(!serviceLocationEnCours) {
                this.startService(serviceLocation);
                serviceLocationEnCours = true;
            }
        }
    }

    private void onStopLocation() {
        this.stopService(serviceLocation);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case DEMANDE_DROIT_LOCALISATION: {
                View view = this.fragmentRadar.getView();
                // If request is cancelled, the result arrays are empty.
                TextView surTitre = (TextView) view.findViewById(R.id.garePlusProcheSurTitre);
                surTitre.setVisibility(View.GONE);
                TextView sousTitre = (TextView) view.findViewById(R.id.garePlusProcheSousTitre);
                sousTitre.setVisibility(View.GONE);
                TextView nomGare = (TextView) view.findViewById(R.id.garePlusProcheNom);
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    //Bon, bah, on demande la localisation
                    if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED)
                    {
                        return;
                    }

                    nomGare.setText(R.string.localisationEnCours);
                    messageHandler = new MessageHandler(this);
                    serviceLocation = new Intent(this, LocationService.class);
                    serviceLocation.putExtra("MESSAGER", new Messenger(messageHandler));
                    serviceLocation.setAction("START");
                } else {
                    nomGare.setText(R.string.localisationImpossible);
                    return;
                }
            }
        }
    }

    private SharedPreferences onGetPreferences() {
        return PreferenceManager.getDefaultSharedPreferences(this);
    }

    @Override
    public boolean onMoveActivity(Class activityClass) {
        Intent i = new Intent(this, activityClass);
        startActivity(i);
        return true;
    }

    @Override
    public boolean onMoveActivity(Class activityClass, String name, boolean value) {
        Intent i = new Intent(this, activityClass);
        i.putExtra(name, value);
        startActivity(i);
        return true;
    }

    @Override
    public boolean onMoveActivity(Class activityClass, String name, int value) {
        Intent i = new Intent(this, activityClass);
        i.putExtra(name, value);
        startActivity(i);
        return true;
    }

    @Override
    public boolean onMoveActivity(Class activityClass, String name1, int value1, String name2, boolean value2) {
        Intent i = new Intent(this, activityClass);
        i.putExtra(name1, value1);
        i.putExtra(name2, value2);
        startActivity(i);
        return true;
    }

    @Override
    public boolean getBooleanExtra(String name, boolean defaultValue) {
        return getIntent().getBooleanExtra(name, defaultValue);
    }

    private void checkFirstLaunch() {
        SharedPreferences preferences = this.onGetPreferences();
        boolean premierLancement = preferences.getBoolean(PREFERENCE_PREMIER_LANCEMENT, true);
        int lastVersionUpdate = preferences.getInt(PREFERENCE_PRECEDENTE_VERSION, 0);

        if(premierLancement && lastVersionUpdate != BuildConfig.VERSION_CODE)
        {
            Intent i = new Intent(this, PremierLancementActivity.class);
            startActivityForResult(i, RESULT_PREMIER_LANCEMENT);
            installationEnCours = true;
            SharedPreferences.Editor editor = preferences.edit();
            editor.putBoolean(MainMenuActivity.PREFERENCE_PREMIER_LANCEMENT, false); //On marque comme étant fait.
            editor.putInt(PREFERENCE_PRECEDENTE_VERSION, BuildConfig.VERSION_CODE); //On désactive en même temps la popup des nouveautés
            editor.apply();
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data)
    {
        super.onActivityResult(requestCode, resultCode, data);

        if(requestCode == RESULT_PREMIER_LANCEMENT) {
            this.setInstallationTerminee();
            this.onStartLocation();
        }
    }

    @Override
    public void OnCheckUpdate() {
        checkDisplayUpdateDialog();
    }

    private void checkDisplayUpdateDialog() {
        SharedPreferences preferences = onGetPreferences();
        int lastVersionUpdate = preferences.getInt(PREFERENCE_PRECEDENTE_VERSION, 0);
        if(lastVersionUpdate != BuildConfig.VERSION_CODE)
        {
            //On affiche la boîte de dialogue de mise à jour
            AlertDialog.Builder dialog = new AlertDialog.Builder(this);
            dialog.setMessage(R.string.nouveautesRelease)
                    .setTitle(R.string.dialogMiseAJourTitle);
            dialog.setPositiveButton(R.string.boutonDAccord, new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int id) {
                    dialog.cancel();
                }
            });
            dialog.create();
            dialog.show();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putInt(PREFERENCE_PRECEDENTE_VERSION, BuildConfig.VERSION_CODE);
            editor.apply();
        }
    }

    @Override
    public void setTitleToolbar(int ressource) {
        this.setTitle(ressource);
    }

    @Override
    public void setTitleToolbar(String title) {
        this.setTitle(title);
    }

    @Override
    public void askRestoreGarePlusProche() {
        if(messageHandler != null) {
            Message message = Message.obtain();
            message.arg1 = MessageHandler.ACTUALISER_GARE_PLUS_PROCHE;
            messageHandler.sendMessage(message);
        }
    }

    public void setInstallationTerminee()
    {
        installationEnCours = false;
    }
}
