package fr.nocle.passegares.controlleur;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import androidx.annotation.NonNull;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

import fr.nocle.passegares.bdd.GareBDD;
import fr.nocle.passegares.bdd.TamponBDD;
import fr.nocle.passegares.modele.Tampon;

/**
 * Created by jonathanmm on 02/09/16.
 */
public class TamponCtrl extends Controlleur {

    public TamponCtrl(Context contexte) {
        super(contexte);
        this.open();
    }
    public TamponCtrl(SQLiteDatabase bdd) {
        super(bdd);
    }

    public void create(@NonNull Tampon t)
    {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        ContentValues valeur = new ContentValues();
        valeur.put(TamponBDD.TABLE_NOM_GARE, t.getIdGare());
        valeur.put(TamponBDD.TABLE_DATE_VALIDATION, formatDate.format(t.getDate()));
        bdd.insert(TamponBDD.TABLE_NOM, null, valeur);
    }

    public void delete(long id)
    {
        bdd.delete(TamponBDD.TABLE_NOM, TamponBDD.TABLE_CLE + " = ?", new String[] {String.valueOf(id)});
    }

    public void update(@NonNull Tampon t)
    {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        ContentValues valeur = new ContentValues();
        valeur.put(TamponBDD.TABLE_NOM_GARE, t.getIdGare());
        valeur.put(TamponBDD.TABLE_DATE_VALIDATION, formatDate.format(t.getDate()));
        bdd.update(TamponBDD.TABLE_NOM, valeur, TamponBDD.TABLE_CLE + " = ?", new String[] {String.valueOf(t.getId())});
    }

    public Tampon get(long id)
    {
        Cursor c = bdd.query(TamponBDD.TABLE_NOM, new String[] {TamponBDD.TABLE_NOM_GARE, TamponBDD.TABLE_DATE_VALIDATION}, TamponBDD.TABLE_CLE + " = ?", new String[] {String.valueOf(id)}, null, null, null);
        c.moveToFirst();
        Tampon t = new Tampon(id, c.getLong(0), c.getString(1));
        c.close();
        return t;
    }

    public ArrayList<Tampon> getAll(long idGare)
    {
        Cursor c = bdd.query(TamponBDD.TABLE_NOM, new String[] {TamponBDD.TABLE_CLE, TamponBDD.TABLE_NOM_GARE, TamponBDD.TABLE_DATE_VALIDATION}, TamponBDD.TABLE_NOM_GARE + " = ?", new String[] {String.valueOf(idGare)}, null, null, null);
        ArrayList<Tampon> listeTampons = new ArrayList<Tampon>();
        GareCtrl gareControlleur = new GareCtrl(bdd);
        while (c.moveToNext()) {
            Tampon t = new Tampon(c.getLong(0), gareControlleur.get(c.getLong(1)), c.getString(2));
            listeTampons.add(t);
        }
        c.close();
        return listeTampons;
    }

    /**
     * Supprimer les tampons orphelins
     */
    public void deleteOrphan()
    {
        bdd.delete(TamponBDD.TABLE_NOM, "NOT EXISTS (SELECT * FROM " + GareBDD.TABLE_NOM + " g WHERE g."+GareBDD.TABLE_CLE+" = "+ TamponBDD.TABLE_NOM+"."+TamponBDD.TABLE_NOM_GARE+" )", null);
    }
}
