package fr.nocle.passegares.boutique;

import android.app.ActionBar;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.WindowCompat;

import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;

import fr.nocle.passegares.R;
import fr.nocle.passegares.achatDialog.AchatDialog;
import fr.nocle.passegares.adapter.ObjetVendableAdapter;
import fr.nocle.passegares.controlleur.BoutiqueCtrl;
import fr.nocle.passegares.modele.Boutique;
import fr.nocle.passegares.modele.ObjetVendable;
import fr.nocle.passegares.outils.UserInterfaceOutils;

public class BoutiqueActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                Build.VERSION.SDK_INT < Build.VERSION_CODES.VANILLA_ICE_CREAM)
        {
            WindowCompat.enableEdgeToEdge(getWindow());
        }
        setContentView(R.layout.activity_boutique);

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        ActionBar actionBar = getActionBar();
        if(actionBar != null)
        {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }

        View contenu = findViewById(R.id.contenu_boutique);
        UserInterfaceOutils.gererBordABord(toolbar, contenu);

        Intent i = getIntent();
        final long idBoutique = i.getLongExtra("BOUTIQUEID", 0);

        final BoutiqueCtrl boutiqueCtrl = new BoutiqueCtrl(this);
        Boutique boutique = boutiqueCtrl.get(idBoutique);

        TextView nomBoutiqueLabel = (TextView) findViewById(R.id.nomBoutiqueLabel);
        nomBoutiqueLabel.setText(boutique.getNom());

        //On affiche la liste des objets
        final ArrayList<ObjetVendable> listeObjetsEnVente = boutiqueCtrl.getListeObjetsEnVente();
        ObjetVendableAdapter adapter = new ObjetVendableAdapter(this, listeObjetsEnVente);

        ListView listeArticles = (ListView) findViewById(R.id.listeArticles);
        listeArticles.setAdapter(adapter);

        //On prépare la boîte de dialogue
        AchatDialog achatDialog = new AchatDialog(this);

        listeArticles.setOnItemClickListener(achatDialog.getOnItemClickListener(listeObjetsEnVente));
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                this.finish();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
