package fr.nocle.passegares;

import android.location.Location;
import android.location.LocationListener;
import android.os.Bundle;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

import androidx.annotation.NonNull;

import fr.nocle.passegares.controlleur.GareCtrl;
import fr.nocle.passegares.controlleur.TamponCtrl;
import fr.nocle.passegares.radar.RadarFragment;

/**
 * Created by jonathanmm on 15/10/16.
 */

class PositionListener implements LocationListener {
    private RadarFragment mainActivity;
    private GareCtrl gareControlleur;
    private TamponCtrl tamponControlleur;
    private Messenger messageHandler;

    @Deprecated
    public PositionListener(RadarFragment activity, GareCtrl gareControlleur, TamponCtrl tamponControlleur) {
        mainActivity = activity;
        this.gareControlleur = gareControlleur;
        this.tamponControlleur = tamponControlleur;
        this.messageHandler = null;
    }

    public PositionListener(Messenger messager) {
        mainActivity = null;
        Log.d("LOCPG", "Création du listener !");
        this.messageHandler = messager;
    }

    @Override
    public void onLocationChanged(Location location) {
        Log.d("LOCPG", "Nouvelle localisation !");
        Message message = Message.obtain();
        message.arg1 = 0;
        Bundle envoi = new Bundle();
        envoi.putDouble("LAT", location.getLatitude());
        envoi.putDouble("LON", location.getLongitude());
        message.setData(envoi);
        try {
            messageHandler.send(message);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onProviderEnabled(@NonNull String provider) {
    }

    @Override
    public void onProviderDisabled(@NonNull String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }
}