/*
 * Copyright 2019 Thibault Seisel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package fr.nihilus.music.spotify.service

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass

/**
 * A character sequence generated by an authorization server
 * that grants access to resources from the Spotify Web API.
 * An access token can be used a [certain amount of time][expiresIn] until it expires,
 * then it should be renewed by the authorization server.
 */
@JsonClass(generateAdapter = true)
data class OAuthToken(

    /**
     * The access token string as issued by the authorization server.
     */
    @Json(name = "access_token")
    val token: String,

    /**
     * The type of token this is, typically just the string `bearer`.
     */
    @Json(name = "token_type")
    val type: String,
    /**
     * The number of seconds the access token is granted for.
     * An expired token cannot be used and should be renewed.
     */
    @Json(name = "expires_in")
    val expiresIn: Int
)