---
title: How to use tags?
categories:
  - Tags
description: "How to tag apps and shortcuts? Why?"
type: Document
---

App and shortcuts can be tagged.

Tags are short strings that you can use to find results based on more than the default name. In the following example, the app "Lite" has two tags, "facebook" and "messenger":

![Lite Messenger](/screenshots/tags-example.png)

Tags can be used to:

* Give a more meaningful name to an app. Some apps have a name that is hard to remember, or maybe you liked the old app name better (for instance, the app listing your contacts on Android was renamed from "People" to "Contacts"). Whatever the reason, you can just add a tag to the app, and it will appear in your search results
* Group similar apps into buckets. You can, for instance, add the "game" tags to all the games on your device. By typing "game", you'll now be able to view all your games. This is especially powerful coupled with the [tag bar feature](/tags/use-tag-bar/)

Some apps come pre-tagged in KISS ("Clock", for instance, can be searched with "timer", "countdown", "alarm", ...).

To add a new tag, long press an app, then select "Add or edit tags":

![App menu](/screenshots/tags-menu.png)

A new dialog will pop-up. You can enter as many tags as you want, separated with a space. Existing tags will be auto-completed:

![Select tags for app](/screenshots/tags-dialog.png)

> Tip: tags are case sensitive. Make sure you're consistent!

If you want, you can choose to hide the tags from the results unless they match the current query. This can clean up your search results, you can do so by disabling `⋮, KISS Settings, User Experience, Show app tags`.
