---
title: How to use gestures?
categories:
  - Advanced
description: "How to use gestures in KISS?"
type: Document
---

Gesture support is enabled by default in KISS, but can be hard to access if you're not using minimalistic mode.

## Supported gestures
KISS currently supports four gestures:

* Swiping up
* Swiping down
* Swiping left
* Swiping right

### Gestures in minimalistic mode
That's the easiest way to use gestures. Simply swipe up/down/left/right on the large wallpaper (red rectangle):

![Gestures on minimalistic mode in KISS](/screenshots/gestures-minimalistic.png)

To turn on minimalistic mode, go to `⋮, KISS Settings, User Experience, Minimalistic UI`.

Note that in this mode, a bonus gesture can be supported if you enable `⋮, KISS Settings, User Experience, Show history on touch`: in this case, simply touching (not swiping) the wallpaper will display the history.

### Gestures in non-minimalistic mode
If you're not using minimalistic, gestures are still supported but are harder to access, as you need to swipe up or down on the very thin margin between the list and the side of your screen (red rectangles):

![Gestures on non-minimalistic mode in KISS](/screenshots/gestures-non-minimalistic.png)

## Gestures configuration
By default, the following actions are configured over the gesture area described above:

* Scroll up to display the keyboard (start touch event on wallpaper and finish touch event on wallpaper)
* Scroll down to display notifications
* Scroll left or right to display the apps
* Long press does nothing

You can configure the action to run for these gestures from `⋮, KISS Settings, User Experience, Action on swipe ...`.

Available actions are:

* Do nothing
* Display keyboard (default for up)
* Display notification shade (default for down)
* Display apps list
* Display history
* Display KISS menu

## Double tap to lock
> This will only work for Android Pie and above.

You can enable double tap to lock from `⋮, KISS Settings, User Experience, Double tap to lock screen`.

Be careful, this will only work over an empty area and may be hard to do in non-minimalistic mode -- see "Gestures in non-minimalistic mode" above.

The first time you do a double tap, a permission dialog will appear, make sure to enable KISS.

## Disable gestures
From `⋮, KISS Settings, User Experience, Action on swipe up`, you can select "Do nothing" as an action. Do the same thing for `Action on swipe down` to totally disable gestures.
