package fr.jnda.ipcalc.ui

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import fr.jnda.ipcalc.R
import fr.jnda.ipcalc.databinding.MainInfoBinding
import fr.jnda.ipcalc.helper.toSpannedText
import fr.jnda.ipcalc.utils.IPv4Helper
import fr.jnda.ipcalc.utils.IPv6Helper
import java.util.Locale

class MainInfo : BaseFragment() {

    private lateinit var binding: MainInfoBinding
    private var ipAddress: TextView? = null
    private var subnetAddress: TextView? = null
    private var networkAddress: TextView? = null
    private var broadcastAddress: TextView? = null
    private var hostMin: TextView? = null
    private var hostMax: TextView? = null
    private var hostCount: TextView? = null
    private var addressClass: TextView? = null

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        binding = MainInfoBinding.inflate(layoutInflater)
        ipAddress = binding.idIpAddress
        subnetAddress = binding.idSubnetAddress
        networkAddress = binding.idNetworkAddress
        broadcastAddress = binding.idBroadcastAddress
        hostMin = binding.idHostMin
        hostMax = binding.idHostMax
        hostCount = binding.idHostCount
        addressClass = binding.idAddressClass
        clearInfo()
        return binding.root
    }

    override fun displayInfo(ipv4Helper: IPv4Helper, address: String) {
        ipAddress?.text = address.toSpannedText(getString(R.string.address_ip))
        subnetAddress?.text = ipv4Helper.getNetmask().toSpannedText(getString(R.string.address_subnet))
        networkAddress?.text = ipv4Helper.getNetworkAddress().toSpannedText(getString(R.string.address_network))
        broadcastAddress?.text = ipv4Helper.getBroadcastAddress().toSpannedText(getString(R.string.address_broadcast))
        hostMin?.text = ipv4Helper.getFirstHost().toSpannedText(getString(R.string.address_hostmin))
        hostMax?.text = ipv4Helper.getLastHost().toSpannedText(getString(R.string.address_hostmax))
        hostCount?.text = String.format(Locale.US, "%,d", ipv4Helper.getNumberOfHosts()).toSpannedText(getString(R.string.address_hostcount))
        addressClass?.text = getClassOfIp(address).toSpannedText(getString(R.string.address_class))
    }

    override fun displayInfo(ipv6Helper: IPv6Helper, address: String) {
        ipAddress?.text = address.toSpannedText(getString(R.string.address_ip))
        subnetAddress?.text = ipv6Helper.getNetmask().toSpannedText(getString(R.string.address_subnet))
        networkAddress?.text = ipv6Helper.getNetworkAddress().toSpannedText(getString(R.string.address_network))
        broadcastAddress?.text = "N/A".toSpannedText(getString(R.string.address_broadcast))
        hostMin?.text = ipv6Helper.getFirstHost().toSpannedText(getString(R.string.address_hostmin))
        hostMax?.text = ipv6Helper.getLastHost().toSpannedText(getString(R.string.address_hostmax))
        hostCount?.text = String.format(Locale.US, "%s", ipv6Helper.getNumberOfHosts().toString()).toSpannedText(getString(R.string.address_hostcount))
        addressClass?.text = "N/A".toSpannedText(getString(R.string.address_class))
    }

    override fun clearInfo() {
        ipAddress?.text = ""
        subnetAddress?.text = ""
        networkAddress?.text = ""
        broadcastAddress?.text = ""
        hostMin?.text = ""
        hostMax?.text = ""
        hostCount?.text = ""
        addressClass?.text = ""
    }

    private fun getClassOfIp(ip: String): String {
        val firstOctet = ip.split(".")[0].toInt()
        return when {
            firstOctet in 0..127 -> getString(R.string.lbl_classeA)
            firstOctet in 128..191 -> getString(R.string.lbl_classeB)
            firstOctet in 192..223 -> getString(R.string.lbl_classeC)
            firstOctet in 224..239 -> getString(R.string.lbl_classeD)
            firstOctet in 240..255 -> getString(R.string.lbl_classeE)
            else -> getString(R.string.lbl_indetermine)
        }
    }
}