package fr.jnda.ipcalc.ui

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import fr.jnda.ipcalc.R
import fr.jnda.ipcalc.databinding.FragmentBinariesInfoBinding
import fr.jnda.ipcalc.helper.toSpannedText
import fr.jnda.ipcalc.utils.IPv4Helper
import fr.jnda.ipcalc.utils.IPv6Helper
import java.net.InetAddress
import java.util.*

class BinariesInfo : BaseFragment() {

    private lateinit var binding: FragmentBinariesInfoBinding
    private lateinit var ipAddress: TextView
    private lateinit var subnetAddress: TextView
    private lateinit var networkAddress: TextView
    private lateinit var broadcastAddress: TextView
    private lateinit var hostMin: TextView
    private lateinit var hostMax: TextView

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        binding = FragmentBinariesInfoBinding.inflate(layoutInflater)
        ipAddress = binding.idIpAddress
        subnetAddress = binding.idSubnetAddress
        networkAddress = binding.idNetworkAddress
        broadcastAddress = binding.idBroadcastAddress
        hostMin = binding.idHostMin
        hostMax = binding.idHostMax
        clearInfo()
        return binding.root
    }

    override fun displayInfo(ipv4Helper: IPv4Helper, address: String) {
        ipAddress.text = address.toIPv4BinariesString().toSpannedText(getString(R.string.address_ip))
        subnetAddress.text = ipv4Helper.getNetmask().toIPv4BinariesString().toSpannedText(getString(R.string.address_subnet))
        networkAddress.text = ipv4Helper.getNetworkAddress().toIPv4BinariesString().toSpannedText(getString(R.string.address_network))
        broadcastAddress.text = ipv4Helper.getBroadcastAddress().toIPv4BinariesString().toSpannedText(getString(R.string.address_broadcast))
        hostMin.text = ipv4Helper.getFirstHost().toIPv4BinariesString().toSpannedText(getString(R.string.address_hostmin))
        hostMax.text = ipv4Helper.getLastHost().toIPv4BinariesString().toSpannedText(getString(R.string.address_hostmax))
    }

    override fun displayInfo(ipv6Helper: IPv6Helper, address: String) {
        ipAddress.text = address.toIPv6BinariesString().toSpannedText(getString(R.string.address_ip))
        subnetAddress.text = "N/A".toSpannedText(getString(R.string.address_subnet))
        networkAddress.text = ipv6Helper.getNetworkAddress().toIPv6BinariesString().toSpannedText(getString(R.string.address_network))
        broadcastAddress.text = "N/A".toSpannedText(getString(R.string.address_broadcast))
        hostMin.text = ipv6Helper.getFirstHost().toIPv6BinariesString().toSpannedText(getString(R.string.address_hostmin))
        hostMax.text = ipv6Helper.getLastHost().toIPv6BinariesString().toSpannedText(getString(R.string.address_hostmax))
    }

    private fun String.toIPv4BinariesString(): String {
        val bytes = InetAddress.getByName(this).address
        return bytes.joinToString(" . ") { byte ->
            String.format(Locale.US, "%8s", Integer.toBinaryString(byte.toInt() and 0xFF)).replace(' ', '0')
        }
    }

    private fun String.toIPv6BinariesString(): String {
        val bytes = InetAddress.getByName(this).address
        return bytes.joinToString(" : ") { byte ->
            String.format(Locale.US, "%8s", Integer.toBinaryString(byte.toInt() and 0xFF)).replace(' ', '0')
        }
    }

    override fun clearInfo() {
        ipAddress.text = ""
        subnetAddress.text = ""
        networkAddress.text = ""
        broadcastAddress.text = ""
        hostMin.text = ""
        hostMax.text = ""
    }
}