/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

// styles personnalisés
const layers = {
  "line-casing": {
    id: "route-draw-line-casing",
    type: "line",
    source: "",
    layout: {
      "line-cap": "round",
      "line-join": "round",
    },
    paint: {
      "line-color": "#ffffff",
      "line-opacity": [
        "case",
        ["boolean", ["get", "invisible"], false], 0,
        ["boolean", ["get", "fictif"], false], 0,
        1],
      "line-width": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        5,
        5,
        5,
        18,
        20,
      ],
    },
    filter: ["!", ["boolean", ["get", "fictif"], false]],
  },
  "line": {
    id: "route-draw-line",
    type: "line",
    source: "",
    layout: {
      "line-cap": "round",
      "line-join": "round",
    },
    paint: {
      "line-color": "#307CCD",
      "line-opacity": [
        "case",
        ["boolean", ["get", "invisible"], false], 0,
        1],
      "line-width": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        2,
        5,
        2,
        18,
        17,
      ],
    },
    filter: ["!", ["boolean", ["get", "fictif"], false]],
  },
  "line-dashed": {
    id: "route-draw-line-dashed",
    type: "line",
    source: "",
    layout: {
      "line-cap": "round",
      "line-join": "round",
    },
    paint: {
      "line-color": "#307CCD",
      "line-dasharray": [1, 2],
      "line-width": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        2,
        5,
        2,
        18,
        17,
      ],
    },
    filter: ["boolean", ["get", "fictif"], false],
  },
  "point-casing": {
    id: "route-draw-point-casing",
    type: "circle",
    source: "",
    paint: {
      "circle-radius": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        ["case",
          ["boolean", ["get", "highlight"], false], 43,
          ["any",
            ["boolean", ["==", ["get", "order"], "departure"], false],
            ["boolean", ["==", ["get", "order"], "destination"], false]], 9,
          6],
        5,
        ["case",
          ["boolean", ["get", "highlight"], false], 43,
          ["any",
            ["boolean", ["==", ["get", "order"], "departure"], false],
            ["boolean", ["==", ["get", "order"], "destination"], false]], 9,
          6],
        18,
        ["case",
          ["boolean", ["get", "highlight"], false], 43,
          ["any",
            ["boolean", ["==", ["get", "order"], "departure"], false],
            ["boolean", ["==", ["get", "order"], "destination"], false]], 22,
          17],
      ],
      "circle-color": "#307CCD",
    }
  },
  "point": {
    id: "route-draw-point",
    type: "circle",
    source: "",
    paint: {
      "circle-radius": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        ["case",
          ["boolean", ["get", "highlight"], false], 40,
          ["any",
            ["boolean", ["==", ["get", "order"], "departure"], false],
            ["boolean", ["==", ["get", "order"], "destination"], false]], 7,
          4],
        5,
        ["case",
          ["boolean", ["get", "highlight"], false], 40,
          ["any",
            ["boolean", ["==", ["get", "order"], "departure"], false],
            ["boolean", ["==", ["get", "order"], "destination"], false]], 7,
          4],
        18,
        ["case",
          ["boolean", ["get", "highlight"], false], 40,
          ["any",
            ["boolean", ["==", ["get", "order"], "departure"], false],
            ["boolean", ["==", ["get", "order"], "destination"], false]], 20,
          15],
      ],
      "circle-color": "#ffffff",
    },
  },
  "point-departure": {
    id: "route-draw-point-departure",
    type: "symbol",
    source: "",
    layout: {
      "icon-image": "routeDepartureIcon",
      "icon-allow-overlap": true,
      "icon-size": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        ["case",
          ["boolean", ["get", "highlight"], false], 40/50,
          14/50],
        5,
        ["case",
          ["boolean", ["get", "highlight"], false], 60/50,
          14/50],
        18,
        ["case",
          ["boolean", ["get", "highlight"], false], 60/50,
          40/50],
      ],
    },
    filter: ["==", ["get", "order"], "departure"],
  },
  "point-destination": {
    id: "route-draw-point-destination",
    type: "symbol",
    source: "",
    layout: {
      "icon-image": "routeDestinationIcon",
      "icon-allow-overlap": true,
      "icon-size": [
        "interpolate",
        ["exponential", 1.5],
        ["zoom"],
        0,
        ["case",
          ["boolean", ["get", "highlight"], false], 40/50,
          14/50],
        5,
        ["case",
          ["boolean", ["get", "highlight"], false], 60/50,
          14/50],
        18,
        ["case",
          ["boolean", ["get", "highlight"], false], 60/50,
          40/50],
      ],
    },
    filter: ["==", ["get", "order"], "destination"],
  },
};

export default layers;
