/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.11.0/LICENSE.txt
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).maplibregl={})}(this,(function(t){"use strict";var e,i,r="5.11.0";function n(t,e,i,r){return new(i||(i=Promise))((function(n,a){function s(t){try{l(r.next(t))}catch(t){a(t)}}function o(t){try{l(r.throw(t))}catch(t){a(t)}}function l(t){var e;t.done?n(t.value):(e=t.value,e instanceof i?e:new i((function(t){t(e)}))).then(s,o)}l((r=r.apply(t,e||[])).next())}))}function a(t,e){this.x=t,this.y=e}function s(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}"function"==typeof SuppressedError&&SuppressedError,a.prototype={clone(){return new a(this.x,this.y)},add(t){return this.clone()._add(t)},sub(t){return this.clone()._sub(t)},multByPoint(t){return this.clone()._multByPoint(t)},divByPoint(t){return this.clone()._divByPoint(t)},mult(t){return this.clone()._mult(t)},div(t){return this.clone()._div(t)},rotate(t){return this.clone()._rotate(t)},rotateAround(t,e){return this.clone()._rotateAround(t,e)},matMult(t){return this.clone()._matMult(t)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(t){return this.x===t.x&&this.y===t.y},dist(t){return Math.sqrt(this.distSqr(t))},distSqr(t){const e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle(){return Math.atan2(this.y,this.x)},angleTo(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith(t){return this.angleWithSep(t.x,t.y)},angleWithSep(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult(t){const e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add(t){return this.x+=t.x,this.y+=t.y,this},_sub(t){return this.x-=t.x,this.y-=t.y,this},_mult(t){return this.x*=t,this.y*=t,this},_div(t){return this.x/=t,this.y/=t,this},_multByPoint(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint(t){return this.x/=t.x,this.y/=t.y,this},_unit(){return this._div(this.mag()),this},_perp(){const t=this.y;return this.y=this.x,this.x=-t,this},_rotate(t){const e=Math.cos(t),i=Math.sin(t),r=i*this.x+e*this.y;return this.x=e*this.x-i*this.y,this.y=r,this},_rotateAround(t,e){const i=Math.cos(t),r=Math.sin(t),n=e.y+r*(this.x-e.x)+i*(this.y-e.y);return this.x=e.x+i*(this.x-e.x)-r*(this.y-e.y),this.y=n,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:a},a.convert=function(t){if(t instanceof a)return t;if(Array.isArray(t))return new a(+t[0],+t[1]);if(void 0!==t.x&&void 0!==t.y)return new a(+t.x,+t.y);throw new Error("Expected [x, y] or {x, y} point format")};var o=function(){if(i)return e;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return i=1,e=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var a=this.sampleCurveDerivativeX(i);if(Math.abs(a)<1e-6)break;i-=n/a}var s=0,o=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?s=i:o=i,i=.5*(o-s)+s;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},e}(),l=s(o);let c,h;function u(){return null==c&&(c="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),c}var d=1e-6,p="undefined"!=typeof Float32Array?Float32Array:Array;function f(){var t=new p(4);return p!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}function m(){var t=new p(9);return p!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function _(){var t=new p(16);return p!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function g(t){var e=new p(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function y(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function x(t,e){var i=e[0],r=e[1],n=e[2],a=e[3],s=e[4],o=e[5],l=e[6],c=e[7],h=e[8],u=e[9],d=e[10],p=e[11],f=e[12],m=e[13],_=e[14],g=e[15],y=i*o-r*s,x=i*l-n*s,v=i*c-a*s,b=r*l-n*o,w=r*c-a*o,T=n*c-a*l,P=h*m-u*f,M=h*_-d*f,S=h*g-p*f,I=u*_-d*m,C=u*g-p*m,A=d*g-p*_,E=y*A-x*C+v*I+b*S-w*M+T*P;return E?(t[0]=(o*A-l*C+c*I)*(E=1/E),t[1]=(n*C-r*A-a*I)*E,t[2]=(m*T-_*w+g*b)*E,t[3]=(d*w-u*T-p*b)*E,t[4]=(l*S-s*A-c*M)*E,t[5]=(i*A-n*S+a*M)*E,t[6]=(_*v-f*T-g*x)*E,t[7]=(h*T-d*v+p*x)*E,t[8]=(s*C-o*S+c*P)*E,t[9]=(r*S-i*C-a*P)*E,t[10]=(f*w-m*v+g*y)*E,t[11]=(u*v-h*w-p*y)*E,t[12]=(o*M-s*I-l*P)*E,t[13]=(i*I-r*M+n*P)*E,t[14]=(m*x-f*b-_*y)*E,t[15]=(h*b-u*x+d*y)*E,t):null}function v(t,e,i){var r=e[0],n=e[1],a=e[2],s=e[3],o=e[4],l=e[5],c=e[6],h=e[7],u=e[8],d=e[9],p=e[10],f=e[11],m=e[12],_=e[13],g=e[14],y=e[15],x=i[0],v=i[1],b=i[2],w=i[3];return t[0]=x*r+v*o+b*u+w*m,t[1]=x*n+v*l+b*d+w*_,t[2]=x*a+v*c+b*p+w*g,t[3]=x*s+v*h+b*f+w*y,t[4]=(x=i[4])*r+(v=i[5])*o+(b=i[6])*u+(w=i[7])*m,t[5]=x*n+v*l+b*d+w*_,t[6]=x*a+v*c+b*p+w*g,t[7]=x*s+v*h+b*f+w*y,t[8]=(x=i[8])*r+(v=i[9])*o+(b=i[10])*u+(w=i[11])*m,t[9]=x*n+v*l+b*d+w*_,t[10]=x*a+v*c+b*p+w*g,t[11]=x*s+v*h+b*f+w*y,t[12]=(x=i[12])*r+(v=i[13])*o+(b=i[14])*u+(w=i[15])*m,t[13]=x*n+v*l+b*d+w*_,t[14]=x*a+v*c+b*p+w*g,t[15]=x*s+v*h+b*f+w*y,t}function b(t,e,i){var r,n,a,s,o,l,c,h,u,d,p,f,m=i[0],_=i[1],g=i[2];return e===t?(t[12]=e[0]*m+e[4]*_+e[8]*g+e[12],t[13]=e[1]*m+e[5]*_+e[9]*g+e[13],t[14]=e[2]*m+e[6]*_+e[10]*g+e[14],t[15]=e[3]*m+e[7]*_+e[11]*g+e[15]):(n=e[1],a=e[2],s=e[3],o=e[4],l=e[5],c=e[6],h=e[7],u=e[8],d=e[9],p=e[10],f=e[11],t[0]=r=e[0],t[1]=n,t[2]=a,t[3]=s,t[4]=o,t[5]=l,t[6]=c,t[7]=h,t[8]=u,t[9]=d,t[10]=p,t[11]=f,t[12]=r*m+o*_+u*g+e[12],t[13]=n*m+l*_+d*g+e[13],t[14]=a*m+c*_+p*g+e[14],t[15]=s*m+h*_+f*g+e[15]),t}function w(t,e,i){var r=i[0],n=i[1],a=i[2];return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*n,t[5]=e[5]*n,t[6]=e[6]*n,t[7]=e[7]*n,t[8]=e[8]*a,t[9]=e[9]*a,t[10]=e[10]*a,t[11]=e[11]*a,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function T(t,e,i){var r=Math.sin(i),n=Math.cos(i),a=e[4],s=e[5],o=e[6],l=e[7],c=e[8],h=e[9],u=e[10],d=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=a*n+c*r,t[5]=s*n+h*r,t[6]=o*n+u*r,t[7]=l*n+d*r,t[8]=c*n-a*r,t[9]=h*n-s*r,t[10]=u*n-o*r,t[11]=d*n-l*r,t}function P(t,e,i){var r=Math.sin(i),n=Math.cos(i),a=e[0],s=e[1],o=e[2],l=e[3],c=e[8],h=e[9],u=e[10],d=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=a*n-c*r,t[1]=s*n-h*r,t[2]=o*n-u*r,t[3]=l*n-d*r,t[8]=a*r+c*n,t[9]=s*r+h*n,t[10]=o*r+u*n,t[11]=l*r+d*n,t}function M(t,e,i){var r=Math.sin(i),n=Math.cos(i),a=e[0],s=e[1],o=e[2],l=e[3],c=e[4],h=e[5],u=e[6],d=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=a*n+c*r,t[1]=s*n+h*r,t[2]=o*n+u*r,t[3]=l*n+d*r,t[4]=c*n-a*r,t[5]=h*n-s*r,t[6]=u*n-o*r,t[7]=d*n-l*r,t}var S=function(t,e,i,r,n){var a=1/Math.tan(e/2);if(t[0]=a/i,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=n&&n!==1/0){var s=1/(r-n);t[10]=(n+r)*s,t[14]=2*n*r*s}else t[10]=-1,t[14]=-2*r;return t},I=function(t,e,i,r,n,a,s){var o=1/(e-i),l=1/(r-n),c=1/(a-s);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*c,t[11]=0,t[12]=(e+i)*o,t[13]=(n+r)*l,t[14]=(s+a)*c,t[15]=1,t};function C(){var t=new p(3);return p!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function A(t){var e=new p(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function E(t){var e=t[0],i=t[1],r=t[2];return Math.sqrt(e*e+i*i+r*r)}function z(t,e,i){var r=new p(3);return r[0]=t,r[1]=e,r[2]=i,r}function D(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}function k(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i,t}function R(t,e){var i=e[0],r=e[1],n=e[2],a=i*i+r*r+n*n;return a>0&&(a=1/Math.sqrt(a)),t[0]=e[0]*a,t[1]=e[1]*a,t[2]=e[2]*a,t}function L(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function F(t,e,i){var r=e[0],n=e[1],a=e[2],s=i[0],o=i[1],l=i[2];return t[0]=n*l-a*o,t[1]=a*s-r*l,t[2]=r*o-n*s,t}function B(t,e,i){var r=i[0],n=i[1],a=i[2],s=i[3],o=e[0],l=e[1],c=e[2],h=n*c-a*l,u=a*o-r*c,d=r*l-n*o;return t[0]=o+s*(h+=h)+n*(d+=d)-a*(u+=u),t[1]=l+s*u+a*h-r*d,t[2]=c+s*d+r*u-n*h,t}function O(t,e,i,r){var n=[],a=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],a[0]=n[0],a[1]=n[1]*Math.cos(r)-n[2]*Math.sin(r),a[2]=n[1]*Math.sin(r)+n[2]*Math.cos(r),t[0]=a[0]+i[0],t[1]=a[1]+i[1],t[2]=a[2]+i[2],t}function j(t,e,i,r){var n=[],a=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],a[0]=n[2]*Math.sin(r)+n[0]*Math.cos(r),a[1]=n[1],a[2]=n[2]*Math.cos(r)-n[0]*Math.sin(r),t[0]=a[0]+i[0],t[1]=a[1]+i[1],t[2]=a[2]+i[2],t}function V(t,e,i,r){var n=[],a=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],a[0]=n[0]*Math.cos(r)-n[1]*Math.sin(r),a[1]=n[0]*Math.sin(r)+n[1]*Math.cos(r),a[2]=n[2],t[0]=a[0]+i[0],t[1]=a[1]+i[1],t[2]=a[2]+i[2],t}var N,U=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t},Z=E;function G(t,e,i){var r=e[0],n=e[1],a=e[2],s=e[3];return t[0]=i[0]*r+i[4]*n+i[8]*a+i[12]*s,t[1]=i[1]*r+i[5]*n+i[9]*a+i[13]*s,t[2]=i[2]*r+i[6]*n+i[10]*a+i[14]*s,t[3]=i[3]*r+i[7]*n+i[11]*a+i[15]*s,t}function $(){var t=new p(4);return p!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function q(t,e,i,r){var n=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",a=Math.PI/360;e*=a,r*=a,i*=a;var s=Math.sin(e),o=Math.cos(e),l=Math.sin(i),c=Math.cos(i),h=Math.sin(r),u=Math.cos(r);switch(n){case"xyz":t[0]=s*c*u+o*l*h,t[1]=o*l*u-s*c*h,t[2]=o*c*h+s*l*u,t[3]=o*c*u-s*l*h;break;case"xzy":t[0]=s*c*u-o*l*h,t[1]=o*l*u-s*c*h,t[2]=o*c*h+s*l*u,t[3]=o*c*u+s*l*h;break;case"yxz":t[0]=s*c*u+o*l*h,t[1]=o*l*u-s*c*h,t[2]=o*c*h-s*l*u,t[3]=o*c*u+s*l*h;break;case"yzx":t[0]=s*c*u+o*l*h,t[1]=o*l*u+s*c*h,t[2]=o*c*h-s*l*u,t[3]=o*c*u-s*l*h;break;case"zxy":t[0]=s*c*u-o*l*h,t[1]=o*l*u+s*c*h,t[2]=o*c*h+s*l*u,t[3]=o*c*u-s*l*h;break;case"zyx":t[0]=s*c*u-o*l*h,t[1]=o*l*u+s*c*h,t[2]=o*c*h-s*l*u,t[3]=o*c*u+s*l*h;break;default:throw new Error("Unknown angle order "+n)}return t}function W(){var t=new p(2);return p!=Float32Array&&(t[0]=0,t[1]=0),t}function H(t,e){var i=new p(2);return i[0]=t,i[1]=e,i}function X(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t}function Y(t){var e=t[0],i=t[1];return Math.sqrt(e*e+i*i)}function K(t){return t[0]=0,t[1]=0,t}C(),N=new p(4),p!=Float32Array&&(N[0]=0,N[1]=0,N[2]=0,N[3]=0),C(),z(1,0,0),z(0,1,0),$(),$(),m();var J=function(t){var e=t[0],i=t[1];return e*e+i*i};W();const Q=8192;function tt(t,e,i){return e*(Q/(t.tileSize*Math.pow(2,i-t.tileID.overscaledZ)))}function et(){return new Float64Array(4)}function it(){return new Float64Array(3)}function rt(){return new Float64Array(16)}function nt(){const t=new Float64Array(16);return y(t),t}function at(){const t=new Float32Array(16);return y(t),t}function st(t,e,i,r,n=!1){if(!i[0]&&!i[1])return[0,0];const a=n?"map"===r?-t.bearingInRadians:0:"viewport"===r?t.bearingInRadians:0;if(a){const t=Math.sin(a),e=Math.cos(a);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e]}return[n?i[0]:tt(e,i[0],t.zoom),n?i[1]:tt(e,i[1],t.zoom)]}function ot(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]}function lt(t,e,i){const r=(n=[t[0],t[1],t[2],e[0],e[1],e[2],i[0],i[1],i[2]])[0]*((h=n[8])*(s=n[4])-(o=n[5])*(c=n[7]))+n[1]*(-h*(a=n[3])+o*(l=n[6]))+n[2]*(c*a-s*l);var n,a,s,o,l,c,h;if(0===r)return null;const u=F([],[e[0],e[1],e[2]],[i[0],i[1],i[2]]),d=F([],[i[0],i[1],i[2]],[t[0],t[1],t[2]]),p=F([],[t[0],t[1],t[2]],[e[0],e[1],e[2]]),f=k([],u,-t[3]);return D(f,f,k([],d,-e[3])),D(f,f,k([],p,-i[3])),k(f,f,1/r),f}function ct(t,e,i){const r=e[0]*i[0]+e[1]*i[1]+e[2]*i[2];return 0===r?null:(-(t[0]*i[0]+t[1]*i[1]+t[2]*i[2])-i[3])/r}function ht(t,e,i,r){const n=Math.sqrt(t*t+e*e),a=Math.sqrt(i*i+r*r);t/=n,e/=n,i/=a,r/=a;const s=Math.acos(t*i+e*r);return-e*i+t*r>0?s:-s}function ut(t,e){const i=pt(t,360),r=pt(e,360),n=r-i,a=r>i?n-360:n+360;return Math.abs(n)<Math.abs(a)?n:a}function dt(t,e){const i=pt(t,2*Math.PI),r=pt(e,2*Math.PI);return Math.min(Math.abs(i-r),Math.abs(i-r+2*Math.PI),Math.abs(i-r-2*Math.PI))}function pt(t,e){return(t%e+e)%e}function ft(t,e,i,r,n){return mt(r,n,vt((t-e)/(i-e),0,1))}function mt(t,e,i){return t*(1-i)+e*i}function _t(t){let e=1/0,i=1/0,r=-1/0,n=-1/0;for(const a of t)e=Math.min(e,a.x),i=Math.min(i,a.y),r=Math.max(r,a.x),n=Math.max(n,a.y);return[e,i,r,n]}function gt(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,i=e*t;return 4*(t<.5?i:3*(t-e)+i-.75)}function yt(t,e,i,r){const n=new l(t,e,i,r);return t=>n.solve(t)}const xt=yt(.25,.1,.25,1);function vt(t,e,i){return Math.min(i,Math.max(e,t))}function bt(t,e,i){const r=i-e,n=((t-e)%r+r)%r+e;return n===e?i:n}function wt(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}function Tt(t,e){const i={};for(let r=0;r<e.length;r++){const n=e[r];n in t&&(i[n]=t[n])}return i}let Pt=1;function Mt(){return Pt++}function St(t){return Math.pow(2,t)}function It(t){return Math.log(t)/Math.LN2}function Ct(t,e,i){const r={};for(const i in t)r[i]=e.call(this,t[i],i,t);return r}function At(t,e,i){const r={};for(const i in t)e.call(this,t[i],i,t)&&(r[i]=t[i]);return r}function Et(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!Et(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!Et(t[i],e[i]))return!1;return!0}return t===e}function zt(t){return Array.isArray(t)?t.map(zt):"object"==typeof t&&t?Ct(t,zt):t}const Dt={};function kt(t){Dt[t]||("undefined"!=typeof console&&console.warn(t),Dt[t]=!0)}function Rt(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}function Lt(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let Ft=null;function Bt(t){if(null==Ft){const e=t.navigator?t.navigator.userAgent:null;Ft=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")))}return Ft}function Ot(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const jt="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function Vt(t,e,i,r){return t.addEventListener(e,i,r),{unsubscribe:()=>{t.removeEventListener(e,i,r)}}}function Nt(t){return t*Math.PI/180}function Ut(t){return t/Math.PI*180}function Zt(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing}function Gt(t,e,i){const r=H(e.x-i.x,e.y-i.y),n=H(t.x-i.x,t.y-i.y);var a,s;return Ut(Math.atan2(r[0]*n[1]-r[1]*n[0],(a=r)[0]*(s=n)[0]+a[1]*s[1]))}function $t(t,e,i){const r=new Float64Array(4);return q(r,t,e-90,i),r}const qt=85.051129,Wt={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},Ht={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0};function Xt(t,e){return Wt[e]&&"touches"in t}const Yt="AbortError";function Kt(){return new Error(Yt)}let Jt,Qt;const te={frame(t,e,i){const r=requestAnimationFrame((t=>{n(),e(t)})),{unsubscribe:n}=Vt(t.signal,"abort",(()=>{n(),cancelAnimationFrame(r),i(Kt())}),!1)},frameAsync(t){return new Promise(((e,i)=>{this.frame(t,e,i)}))},getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>(Jt||(Jt=document.createElement("a")),Jt.href=t,Jt.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return!!matchMedia&&(null==Qt&&(Qt=matchMedia("(prefers-reduced-motion: reduce)")),Qt.matches)}},ee=new class{constructor(){this._realTime="undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),this._frozenAt=null}getCurrentTime(){return null!==this._frozenAt?this._frozenAt:this._realTime()}setNow(t){this._frozenAt=t}restoreNow(){this._frozenAt=null}isFrozen(){return null!==this._frozenAt}};function ie(){return ee.getCurrentTime()}class re{static testProp(t){if(!re.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in re.docStyle)return t[e];return t[0]}static create(t,e,i){const r=window.document.createElement(t);return void 0!==e&&(r.className=e),i&&i.appendChild(r),r}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){re.docStyle&&re.selectProp&&(re.userSelect=re.docStyle[re.selectProp],re.docStyle[re.selectProp]="none")}static enableDrag(){re.docStyle&&re.selectProp&&(re.docStyle[re.selectProp]=re.userSelect)}static setTransform(t,e){t.style[re.transformProp]=e}static addEventListener(t,e,i,r={}){t.addEventListener(e,i,"passive"in r?r:r.capture)}static removeEventListener(t,e,i,r={}){t.removeEventListener(e,i,"passive"in r?r:r.capture)}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",re.suppressClickInternal,!0)}static suppressClick(){window.addEventListener("click",re.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",re.suppressClickInternal,!0)}),0)}static getScale(t){const e=t.getBoundingClientRect();return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,e,i){const r=e.boundingClientRect;return new a((i.clientX-r.left)/e.x-t.clientLeft,(i.clientY-r.top)/e.y-t.clientTop)}static mousePos(t,e){const i=re.getScale(t);return re.getPoint(t,i,e)}static touchPos(t,e){const i=[],r=re.getScale(t);for(let n=0;n<e.length;n++)i.push(re.getPoint(t,r,e[n]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t)}static sanitize(t){const e=(new DOMParser).parseFromString(t,"text/html").body||document.createElement("body"),i=e.querySelectorAll("script");for(const t of i)t.remove();return re.clean(e),e.innerHTML}static isPossiblyDangerous(t,e){const i=e.replace(/\s+/g,"").toLowerCase();return!(!["src","href","xlink:href"].includes(t)||!i.includes("javascript:")&&!i.includes("data:"))||!!t.startsWith("on")||void 0}static clean(t){const e=t.children;for(const t of e)re.removeAttributes(t),re.clean(t)}static removeAttributes(t){for(const{name:e,value:i}of t.attributes)re.isPossiblyDangerous(e,i)&&t.removeAttribute(e)}}re.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,re.selectProp=re.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),re.transformProp=re.testProp(["transform","WebkitTransform"]);const ne={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function ae(t){return ne.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const se="global-dispatcher";class oe extends Error{constructor(t,e,i,r){super(`AJAXError: ${e} (${t}): ${i}`),this.status=t,this.statusText=e,this.url=i,this.body=r}}const le=()=>Lt(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,ce=function(t,e){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const i=ae(t.url);if(i)return i(t,e);if(Lt(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:se},e)}if(!(/^file:/.test(i=t.url)||/^file:/.test(le())&&!/^\w+:/.test(i))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,e){return n(this,void 0,void 0,(function*(){const i=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:le(),signal:e.signal});let r,n;"json"!==t.type||i.headers.has("Accept")||i.headers.set("Accept","application/json");try{r=yield fetch(i)}catch(e){throw new oe(0,e.message,t.url,new Blob)}if(!r.ok){const e=yield r.blob();throw new oe(r.status,r.statusText,t.url,e)}n="arrayBuffer"===t.type||"image"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text();const a=yield n;if(e.signal.aborted)throw Kt();return{data:a,cacheControl:r.headers.get("Cache-Control"),expires:r.headers.get("Expires")}}))}(t,e);if(Lt(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:se},e)}var i;return function(t,e){return new Promise(((i,r)=>{var n;const a=new XMLHttpRequest;a.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(a.responseType="arraybuffer");for(const e in t.headers)a.setRequestHeader(e,t.headers[e]);"json"===t.type&&(a.responseType="text",(null===(n=t.headers)||void 0===n?void 0:n.Accept)||a.setRequestHeader("Accept","application/json")),a.withCredentials="include"===t.credentials,a.onerror=()=>{r(new Error(a.statusText))},a.onload=()=>{if(!e.signal.aborted)if((a.status>=200&&a.status<300||0===a.status)&&null!==a.response){let e=a.response;if("json"===t.type)try{e=JSON.parse(a.response)}catch(t){return void r(t)}i({data:e,cacheControl:a.getResponseHeader("Cache-Control"),expires:a.getResponseHeader("Expires")})}else{const e=new Blob([a.response],{type:a.getResponseHeader("Content-Type")});r(new oe(a.status,a.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{a.abort(),r(Kt())})),a.send(t.body)}))}(t,e)},he=(t,e)=>ce(wt(t,{type:"json"}),e);function ue(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return!0;const e=new URL(t),i=window.location;return e.protocol===i.protocol&&e.host===i.host}const de={supported:!1,testSupport:function(t){!me&&fe&&(_e?ge(t):pe=t)}};let pe,fe,me=!1,_e=!1;function ge(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,fe),t.isContextLost())return;de.supported=!0}catch(t){}t.deleteTexture(e),me=!0}var ye;"undefined"!=typeof document&&(fe=document.createElement("img"),fe.onload=()=>{pe&&ge(pe),pe=null,_e=!0},fe.onerror=()=>{me=!0,pe=null},fe.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let e,i,r,a;t.resetRequestQueue=()=>{e=[],i=0,r=0,a={}},t.addThrottleControl=t=>{const e=r++;return a[e]=t,e},t.removeThrottleControl=t=>{delete a[t],o()},t.getImage=(t,i,r=!0)=>new Promise(((n,a)=>{de.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),wt(t,{type:"image"});const s={abortController:i,requestParameters:t,supportImageRefresh:r,state:"queued",onError:t=>{a(t)},onSuccess:t=>{n(t)}};e.push(s),o()}));const s=t=>n(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:e,supportImageRefresh:r,onError:a,onSuccess:s,abortController:c}=t,h=!1===r&&!Lt(self)&&!ae(e.url)&&(!e.headers||Object.keys(e.headers).reduce(((t,e)=>t&&"accept"===e),!0));i++;const u=h?l(e,c):ce(e,c);try{const e=yield u;delete t.abortController,t.state="completed",e.data instanceof HTMLImageElement||Ot(e.data)?s(e):e.data&&s({data:yield(d=e.data,"function"==typeof createImageBitmap?(t=>n(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})))(d):(t=>new Promise(((e,i)=>{const r=new Image;r.onload=()=>{e(r),URL.revokeObjectURL(r.src),r.onload=null,window.requestAnimationFrame((()=>{r.src=jt}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):jt})))(d)),cacheControl:e.cacheControl,expires:e.expires})}catch(e){delete t.abortController,a(e)}finally{i--,o()}var d})),o=()=>{const t=(()=>{for(const t of Object.keys(a))if(a[t]())return!0;return!1})()?ne.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:ne.MAX_PARALLEL_IMAGE_REQUESTS;for(let r=i;r<t&&e.length>0;r++){const t=e.shift();t.abortController.signal.aborted?r--:s(t)}},l=(t,e)=>new Promise(((i,r)=>{const n=new Image,a=t.url,s=t.credentials;s&&"include"===s?n.crossOrigin="use-credentials":(s&&"same-origin"===s||!ue(a))&&(n.crossOrigin="anonymous"),e.signal.addEventListener("abort",(()=>{n.src="",r(Kt())})),n.fetchPriority="high",n.onload=()=>{n.onerror=n.onload=null,i({data:n})},n.onerror=()=>{n.onerror=n.onload=null,e.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."))},n.src=a}))}(ye||(ye={})),ye.resetRequestQueue();class xe{constructor(t){this._transformRequestFn=null!=t?t:null}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}setTransformRequest(t){this._transformRequestFn=t}}function ve(t,e,i){i[t]&&-1!==i[t].indexOf(e)||(i[t]=i[t]||[],i[t].push(e))}function be(t,e,i){if(i&&i[t]){const r=i[t].indexOf(e);-1!==r&&i[t].splice(r,1)}}class we{constructor(t,e={}){wt(this,e),this.type=t}}class Te extends we{constructor(t,e={}){super("error",wt({error:t},e))}}class Pe{on(t,e){return this._listeners=this._listeners||{},ve(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return be(t,e,this._listeners),be(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},ve(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new we(t,e||{}));const i=t.type;if(this.listens(i)){t.target=this;const e=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of e)i.call(this,t);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const e of r)be(i,e,this._oneTimeListeners),e.call(this,t);const n=this._eventedParent;n&&(wt(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(t))}else t instanceof Te&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Me={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"array",value:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},encoding:{type:"enum",values:{mvt:{},mlt:{}},default:"mvt"},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const Se=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function Ie(t,e){const i={};for(const e in t)"ref"!==e&&(i[e]=t[e]);return Se.forEach((t=>{t in e&&(i[t]=e[t])})),i}function Ce(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=Ie(t[i],e[t[i].ref]));return t}function Ae(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!Ae(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!Ae(t[i],e[i]))return!1;return!0}return t===e}function Ee(t,e){t.push(e)}function ze(t,e,i){Ee(i,{command:"addSource",args:[t,e[t]]})}function De(t,e,i){Ee(e,{command:"removeSource",args:[t]}),i[t]=!0}function ke(t,e,i,r){De(t,i,r),ze(t,e,i)}function Re(t,e,i){let r;for(r in t[i])if(Object.prototype.hasOwnProperty.call(t[i],r)&&"data"!==r&&!Ae(t[i][r],e[i][r]))return!1;for(r in e[i])if(Object.prototype.hasOwnProperty.call(e[i],r)&&"data"!==r&&!Ae(t[i][r],e[i][r]))return!1;return!0}function Le(t,e,i,r,n,a){t=t||{},e=e||{};for(const s in t)Object.prototype.hasOwnProperty.call(t,s)&&(Ae(t[s],e[s])||i.push({command:a,args:[r,s,e[s],n]}));for(const s in e)Object.prototype.hasOwnProperty.call(e,s)&&!Object.prototype.hasOwnProperty.call(t,s)&&(Ae(t[s],e[s])||i.push({command:a,args:[r,s,e[s],n]}))}function Fe(t){return t.id}function Be(t,e){return t[e.id]=e,t}class Oe{constructor(t,e,i,r){this.message=(t?`${t}: `:"")+i,r&&(this.identifier=r),null!=e&&e.__line__&&(this.line=e.__line__)}}function je(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}class Ve extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class Ne{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,i]of e)this.bindings[t]=i}concat(t){return new Ne(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const Ue={kind:"null"},Ze={kind:"number"},Ge={kind:"string"},$e={kind:"boolean"},qe={kind:"color"},We={kind:"projectionDefinition"},He={kind:"object"},Xe={kind:"value"},Ye={kind:"collator"},Ke={kind:"formatted"},Je={kind:"padding"},Qe={kind:"colorArray"},ti={kind:"numberArray"},ei={kind:"resolvedImage"},ii={kind:"variableAnchorOffsetCollection"};function ri(t,e){return{kind:"array",itemType:t,N:e}}function ni(t){if("array"===t.kind){const e=ni(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const ai=[Ue,Ze,Ge,$e,qe,We,Ke,He,ri(Xe),Je,ti,Qe,ei,ii];function si(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!si(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of ai)if(!si(t,e))return null}return`Expected ${ni(t)} but found ${ni(e)} instead.`}function oi(t,e){return e.some((e=>e.kind===t.kind))}function li(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function ci(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const hi=.96422,ui=.82521,di=4/29,pi=6/29,fi=3*pi*pi,mi=pi*pi*pi,_i=Math.PI/180,gi=180/Math.PI;function yi(t){return(t%=360)<0&&(t+=360),t}function xi([t,e,i,r]){let n,a;const s=bi((.2225045*(t=vi(t))+.7168786*(e=vi(e))+.0606169*(i=vi(i)))/1);t===e&&e===i?n=a=s:(n=bi((.4360747*t+.3850649*e+.1430804*i)/hi),a=bi((.0139322*t+.0971045*e+.7141733*i)/ui));const o=116*s-16;return[o<0?0:o,500*(n-s),200*(s-a),r]}function vi(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function bi(t){return t>mi?Math.pow(t,1/3):t/fi+di}function wi([t,e,i,r]){let n=(t+16)/116,a=isNaN(e)?n:n+e/500,s=isNaN(i)?n:n-i/200;return n=1*Pi(n),a=hi*Pi(a),s=ui*Pi(s),[Ti(3.1338561*a-1.6168667*n-.4906146*s),Ti(-.9787684*a+1.9161415*n+.033454*s),Ti(.0719453*a-.2289914*n+1.4052427*s),r]}function Ti(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function Pi(t){return t>pi?t*t*t:fi*(t-di)}const Mi=Object.hasOwn||function(t,e){return Object.prototype.hasOwnProperty.call(t,e)};function Si(t,e){return Mi(t,e)?t[e]:void 0}function Ii(t){return parseInt(t.padEnd(2,t),16)/255}function Ci(t,e){return Ai(e?t/100:t,0,1)}function Ai(t,e,i){return Math.min(Math.max(e,t),i)}function Ei(t){return!t.some(Number.isNaN)}const zi={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function Di(t,e,i){return t+i*(e-t)}function ki(t,e,i){return t.map(((t,r)=>Di(t,e[r],i)))}class Ri{constructor(t,e,i,r=1,n=!0){this.r=t,this.g=e,this.b=i,this.a=r,n||(this.r*=r,this.g*=r,this.b*=r,r||this.overwriteGetter("rgb",[t,e,i,r]))}static parse(t){if(t instanceof Ri)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=Si(zi,t);if(e){const[t,i,r]=e;return[t/255,i/255,r/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let i=1;return[Ii(t.slice(i,i+=e)),Ii(t.slice(i,i+=e)),Ii(t.slice(i,i+=e)),Ii(t.slice(i,i+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,i,r,n,a,s,o,l,c,h,u,d]=e,p=[n||" ",o||" ",h].join("");if("  "===p||"  /"===p||",,"===p||",,,"===p){const t=[r,s,c].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[Ai(+i/e,0,1),Ai(+a/e,0,1),Ai(+l/e,0,1),u?Ci(+u,d):1];if(Ei(t))return t}}return}}const i=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(i){const[t,e,r,n,a,s,o,l,c]=i,h=[r||" ",a||" ",o].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const t=[+e,Ai(+n,0,100),Ai(+s,0,100),l?Ci(+l,c):1];if(Ei(t))return function([t,e,i,r]){function n(r){const n=(r+t/30)%12,a=e*Math.min(i,1-i);return i-a*Math.max(-1,Math.min(n-3,9-n,1))}return t=yi(t),e/=100,i/=100,[n(0),n(8),n(4),r]}(t)}}}(t);return e?new Ri(...e,!1):void 0}get rgb(){const{r:t,g:e,b:i,a:r}=this,n=r||1/0;return this.overwriteGetter("rgb",[t/n,e/n,i/n,r])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,i,r,n]=xi(t),a=Math.sqrt(i*i+r*r);return[Math.round(1e4*a)?yi(Math.atan2(r,i)*gi):NaN,a,e,n]}(this.rgb))}get lab(){return this.overwriteGetter("lab",xi(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,i,r]=this.rgb;return`rgba(${[t,e,i].map((t=>Math.round(255*t))).join(",")},${r})`}static interpolate(t,e,i,r="rgb"){switch(r){case"rgb":{const[r,n,a,s]=ki(t.rgb,e.rgb,i);return new Ri(r,n,a,s,!1)}case"hcl":{const[r,n,a,s]=t.hcl,[o,l,c,h]=e.hcl;let u,d;if(isNaN(r)||isNaN(o))isNaN(r)?isNaN(o)?u=NaN:(u=o,1!==a&&0!==a||(d=l)):(u=r,1!==c&&0!==c||(d=n));else{let t=o-r;o>r&&t>180?t-=360:o<r&&r-o>180&&(t+=360),u=r+i*t}const[p,f,m,_]=function([t,e,i,r]){return t=isNaN(t)?0:t*_i,wi([i,Math.cos(t)*e,Math.sin(t)*e,r])}([u,null!=d?d:Di(n,l,i),Di(a,c,i),Di(s,h,i)]);return new Ri(p,f,m,_,!1)}case"lab":{const[r,n,a,s]=wi(ki(t.lab,e.lab,i));return new Ri(r,n,a,s,!1)}}}}Ri.black=new Ri(0,0,0,1),Ri.white=new Ri(1,1,1,1),Ri.transparent=new Ri(0,0,0,0),Ri.red=new Ri(1,0,0,1);class Li{constructor(t,e,i){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Fi=["bottom","center","top"];class Bi{constructor(t,e,i,r,n,a){this.text=t,this.image=e,this.scale=i,this.fontStack=r,this.textColor=n,this.verticalAlign=a}}class Oi{constructor(t){this.sections=t}static fromString(t){return new Oi([new Bi(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Oi?t:Oi.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class ji{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof ji)return t;if("number"==typeof t)return new ji([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new ji(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new ji(ki(t.values,e.values,i))}}class Vi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Vi)return t;if("number"==typeof t)return new Vi([t]);if(Array.isArray(t)){for(const e of t)if("number"!=typeof e)return;return new Vi(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new Vi(ki(t.values,e.values,i))}}class Ni{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ni)return t;if("string"==typeof t){const e=Ri.parse(t);if(!e)return;return new Ni([e])}if(!Array.isArray(t))return;const e=[];for(const i of t){if("string"!=typeof i)return;const t=Ri.parse(i);if(!t)return;e.push(t)}return new Ni(e)}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i,r="rgb"){const n=[];if(t.values.length!=e.values.length)throw new Error(`colorArray: Arrays have mismatched length (${t.values.length} vs. ${e.values.length}), cannot interpolate.`);for(let a=0;a<t.values.length;a++)n.push(Ri.interpolate(t.values[a],e.values[a],i,r));return new Ni(n)}}class Ui extends Error{constructor(t){super(t),this.name="RuntimeError"}toJSON(){return this.message}}const Zi=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Gi{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Gi)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const i=t[e],r=t[e+1];if("string"!=typeof i||!Zi.has(i))return;if(!Array.isArray(r)||2!==r.length||"number"!=typeof r[0]||"number"!=typeof r[1])return}return new Gi(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){const r=t.values,n=e.values;if(r.length!==n.length)throw new Ui(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const a=[];for(let t=0;t<r.length;t+=2){if(r[t]!==n[t])throw new Ui(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${r[t]}, to[${t}]: ${n[t]}`);a.push(r[t]);const[e,s]=r[t+1],[o,l]=n[t+1];a.push([Di(e,o,i),Di(s,l,i)])}return new Gi(a)}}class $i{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new $i({name:t,available:!1}):null}}class qi{constructor(t,e,i){this.from=t,this.to=e,this.transition=i}static interpolate(t,e,i){return new qi(t,e,i)}static parse(t){return t instanceof qi?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new qi(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new qi(t.from,t.to,t.transition):"string"==typeof t?new qi(t,t,1):void 0}}function Wi(t,e,i,r){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[t,e,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[t,e,i,r]:[t,e,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Hi(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof qi||t instanceof Ri||t instanceof Li||t instanceof Oi||t instanceof ji||t instanceof Vi||t instanceof Ni||t instanceof Gi||t instanceof $i)return!0;if(Array.isArray(t)){for(const e of t)if(!Hi(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!Hi(t[e]))return!1;return!0}return!1}function Xi(t){if(null===t)return Ue;if("string"==typeof t)return Ge;if("boolean"==typeof t)return $e;if("number"==typeof t)return Ze;if(t instanceof Ri)return qe;if(t instanceof qi)return We;if(t instanceof Li)return Ye;if(t instanceof Oi)return Ke;if(t instanceof ji)return Je;if(t instanceof Vi)return ti;if(t instanceof Ni)return Qe;if(t instanceof Gi)return ii;if(t instanceof $i)return ei;if(Array.isArray(t)){const e=t.length;let i;for(const e of t){const t=Xi(e);if(i){if(i===t)continue;i=Xe;break}i=t}return ri(i||Xe,e)}return He}function Yi(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Ri||t instanceof qi||t instanceof Oi||t instanceof ji||t instanceof Vi||t instanceof Ni||t instanceof Gi||t instanceof $i?t.toString():JSON.stringify(t)}class Ki{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Hi(t[1]))return e.error("invalid value");const i=t[1];let r=Xi(i);const n=e.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Ki(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Ji={string:Ge,number:Ze,boolean:$e,object:He};class Qi{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i,r=1;const n=t[0];if("array"===n){let n,a;if(t.length>2){const i=t[1];if("string"!=typeof i||!(i in Ji)||"object"===i)return e.error('The item type argument of "array" must be one of string, number, boolean',1);n=Ji[i],r++}else n=Xe;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);a=t[2],r++}i=ri(n,a)}else{if(!Ji[n])throw new Error(`Types doesn't contain name = ${n}`);i=Ji[n]}const a=[];for(;r<t.length;r++){const i=e.parse(t[r],r,Xe);if(!i)return null;a.push(i)}return new Qi(i,a)}evaluate(t){for(let e=0;e<this.args.length;e++){const i=this.args[e].evaluate(t);if(!si(this.type,Xi(i)))return i;if(e===this.args.length-1)throw new Ui(`Expected value to be of type ${ni(this.type)}, but found ${ni(Xi(i))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const tr={"to-boolean":$e,"to-color":qe,"to-number":Ze,"to-string":Ge};class er{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[0];if(!tr[i])throw new Error(`Can't parse ${i} as it is not part of the known types`);if(("to-boolean"===i||"to-string"===i)&&2!==t.length)return e.error("Expected one argument.");const r=tr[i],n=[];for(let i=1;i<t.length;i++){const r=e.parse(t[i],i,Xe);if(!r)return null;n.push(r)}return new er(r,n)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,i;for(const r of this.args){if(e=r.evaluate(t),i=null,e instanceof Ri)return e;if("string"==typeof e){const i=t.parseColor(e);if(i)return i}else if(Array.isArray(e)&&(i=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Wi(e[0],e[1],e[2],e[3]),!i))return new Ri(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Ui(i||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const i of this.args){e=i.evaluate(t);const r=ji.parse(e);if(r)return r}throw new Ui(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"numberArray":{let e;for(const i of this.args){e=i.evaluate(t);const r=Vi.parse(e);if(r)return r}throw new Ui(`Could not parse numberArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"colorArray":{let e;for(const i of this.args){e=i.evaluate(t);const r=Ni.parse(e);if(r)return r}throw new Ui(`Could not parse colorArray from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const i of this.args){e=i.evaluate(t);const r=Gi.parse(e);if(r)return r}throw new Ui(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const i of this.args){if(e=i.evaluate(t),null===e)return 0;const r=Number(e);if(!isNaN(r))return r}throw new Ui(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Oi.fromString(Yi(this.args[0].evaluate(t)));case"resolvedImage":return $i.fromString(Yi(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Yi(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const ir=["Unknown","Point","LineString","Polygon"];class rr{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?ir[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache.get(t);return e||(e=Ri.parse(t),this._parseColorCache.set(t,e)),e}}class nr{constructor(t,e,i=[],r,n=new Ne,a=[]){this.registry=t,this.path=i,this.key=i.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=a,this.expectedType=r,this._isConstant=e}parse(t,e,i,r,n={}){return e?this.concat(e,i,r)._parse(t,n):this._parse(t,n)}_parse(t,e){function i(t,e,i){return"assert"===i?new Qi(e,[t]):"coerce"===i?new er(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=t[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[r];if(n){let r=n.parse(t,this);if(!r)return null;if(this.expectedType){const t=this.expectedType,n=r.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind){if("projectionDefinition"===t.kind&&["string","array"].includes(n.kind)||["color","formatted","resolvedImage"].includes(t.kind)&&["value","string"].includes(n.kind)||["padding","numberArray"].includes(t.kind)&&["value","number","array"].includes(n.kind)||"colorArray"===t.kind&&["value","string","array"].includes(n.kind)||"variableAnchorOffsetCollection"===t.kind&&["value","array"].includes(n.kind))r=i(r,t,e.typeAnnotation||"coerce");else if(this.checkSubtype(t,n))return null}else r=i(r,t,e.typeAnnotation||"assert")}if(!(r instanceof Ki)&&"resolvedImage"!==r.type.kind&&this._isConstant(r)){const t=new rr;try{r=new Ki(r.type,r.evaluate(t))}catch(t){return this.error(t.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,i){const r="number"==typeof t?this.path.concat(t):this.path,n=i?this.scope.concat(i):this.scope;return new nr(this.registry,this._isConstant,r,e||null,n,this.errors)}error(t,...e){const i=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new Ve(i,t))}checkSubtype(t,e){const i=si(t,e);return i&&this.error(i),i}}class ar{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const i=[];for(let r=1;r<t.length-1;r+=2){const n=t[r];if("string"!=typeof n)return e.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return e.error("Variable names must contain only alphanumeric characters or '_'.",r);const a=e.parse(t[r+1],r+1);if(!a)return null;i.push([n,a])}const r=e.parse(t[t.length-1],t.length-1,e.expectedType,i);return r?new ar(i,r):null}outputDefined(){return this.result.outputDefined()}}class sr{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const i=t[1];return e.scope.has(i)?new sr(i,e.scope.get(i)):e.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class or{constructor(t,e,i){this.type=t,this.index=e,this.input=i}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Ze),r=e.parse(t[2],2,ri(e.expectedType||Xe));return i&&r?new or(r.type.itemType,i,r):null}evaluate(t){const e=this.index.evaluate(t),i=this.input.evaluate(t);if(e<0)throw new Ui(`Array index out of bounds: ${e} < 0.`);if(e>=i.length)throw new Ui(`Array index out of bounds: ${e} > ${i.length-1}.`);if(e!==Math.floor(e))throw new Ui(`Array index must be an integer, but found ${e} instead.`);return i[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class lr{constructor(t,e){this.type=$e,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Xe),r=e.parse(t[2],2,Xe);return i&&r?oi(i.type,[$e,Ge,Ze,Ue,Xe])?new lr(i,r):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ni(i.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!i)return!1;if(!li(e,["boolean","string","number","null"]))throw new Ui(`Expected first argument to be of type boolean, string, number or null, but found ${ni(Xi(e))} instead.`);if(!li(i,["string","array"]))throw new Ui(`Expected second argument to be of type array or string, but found ${ni(Xi(i))} instead.`);return i.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class cr{constructor(t,e,i){this.type=Ze,this.needle=t,this.haystack=e,this.fromIndex=i}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Xe),r=e.parse(t[2],2,Xe);if(!i||!r)return null;if(!oi(i.type,[$e,Ge,Ze,Ue,Xe]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ni(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Ze);return n?new cr(i,r,n):null}return new cr(i,r)}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!li(e,["boolean","string","number","null"]))throw new Ui(`Expected first argument to be of type boolean, string, number or null, but found ${ni(Xi(e))} instead.`);let r;if(this.fromIndex&&(r=this.fromIndex.evaluate(t)),li(i,["string"])){const t=i.indexOf(e,r);return-1===t?-1:[...i.slice(0,t)].length}if(li(i,["array"]))return i.indexOf(e,r);throw new Ui(`Expected second argument to be of type array or string, but found ${ni(Xi(i))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class hr{constructor(t,e,i,r,n,a){this.inputType=t,this.type=e,this.input=i,this.cases=r,this.outputs=n,this.otherwise=a}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let i,r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n={},a=[];for(let s=2;s<t.length-1;s+=2){let o=t[s];const l=t[s+1];Array.isArray(o)||(o=[o]);const c=e.concat(s);if(0===o.length)return c.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return c.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,Xi(t)))return null}else i=Xi(t);if(void 0!==n[String(t)])return c.error("Branch labels must be unique.");n[String(t)]=a.length}const h=e.parse(l,s,r);if(!h)return null;r=r||h.type,a.push(h)}const s=e.parse(t[1],1,Xe);if(!s)return null;const o=e.parse(t[t.length-1],t.length-1,r);return o?"value"!==s.type.kind&&e.concat(1).checkSubtype(i,s.type)?null:new hr(i,r,s,n,a,o):null}evaluate(t){const e=this.input.evaluate(t);return(Xi(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class ur{constructor(t,e,i){this.type=t,this.branches=e,this.otherwise=i}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const r=[];for(let n=1;n<t.length-1;n+=2){const a=e.parse(t[n],n,$e);if(!a)return null;const s=e.parse(t[n+1],n+1,i);if(!s)return null;r.push([a,s]),i=i||s.type}const n=e.parse(t[t.length-1],t.length-1,i);if(!n)return null;if(!i)throw new Error("Can't infer output type");return new ur(i,r,n)}evaluate(t){for(const[e,i]of this.branches)if(e.evaluate(t))return i.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,i]of this.branches)t(e),t(i);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class dr{constructor(t,e,i,r){this.type=t,this.input=e,this.beginIndex=i,this.endIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 2 or 3 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Xe),r=e.parse(t[2],2,Ze);if(!i||!r)return null;if(!oi(i.type,[ri(Xe),Ge,Xe]))return e.error(`Expected first argument to be of type array or string, but found ${ni(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Ze);return n?new dr(i.type,i,r,n):null}return new dr(i.type,i,r)}evaluate(t){const e=this.input.evaluate(t),i=this.beginIndex.evaluate(t);let r;if(this.endIndex&&(r=this.endIndex.evaluate(t)),li(e,["string"]))return[...e].slice(i,r).join("");if(li(e,["array"]))return e.slice(i,r);throw new Ui(`Expected first argument to be of type array or string, but found ${ni(Xi(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function pr(t,e){const i=t.length-1;let r,n,a=0,s=i,o=0;for(;a<=s;)if(o=Math.floor((a+s)/2),r=t[o],n=t[o+1],r<=e){if(o===i||e<n)return o;a=o+1}else{if(!(r>e))throw new Ui("Input is not a number.");s=o-1}return 0}class fr{constructor(t,e,i){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const i=e.parse(t[1],1,Ze);if(!i)return null;const r=[];let n=null;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);for(let i=1;i<t.length;i+=2){const a=1===i?-1/0:t[i],s=t[i+1],o=i,l=i+1;if("number"!=typeof a)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(r.length&&r[r.length-1][0]>=a)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const c=e.parse(s,l,n);if(!c)return null;n=n||c.type,r.push([a,c])}return new fr(n,i,r)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;return r>=e[n-1]?i[n-1].evaluate(t):i[pr(e,r)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function mr(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var _r,gr,yr=function(){if(gr)return _r;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return gr=1,_r=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var a=this.sampleCurveDerivativeX(i);if(Math.abs(a)<1e-6)break;i-=n/a}var s=0,o=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?s=i:o=i,i=.5*(o-s)+s;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},_r}(),xr=mr(yr);class vr{constructor(t,e,i,r,n){this.type=t,this.operator=e,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[t,e]of n)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,i,r){let n=0;if("exponential"===t.name)n=br(e,t.base,i,r);else if("linear"===t.name)n=br(e,1,i,r);else if("cubic-bezier"===t.name){const a=t.controlPoints;n=new xr(a[0],a[1],a[2],a[3]).solve(br(e,1,i,r))}return n}static parse(t,e){let[i,r,n,...a]=t;if(!Array.isArray(r)||0===r.length)return e.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const t=r[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:t}}else{if("cubic-bezier"!==r[0])return e.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const t=r.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(n=e.parse(n,2,Ze),!n)return null;const s=[];let o=null;"interpolate-hcl"!==i&&"interpolate-lab"!==i||e.expectedType==Qe?e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType):o=qe;for(let t=0;t<a.length;t+=2){const i=a[t],r=a[t+1],n=t+3,l=t+4;if("number"!=typeof i)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(s.length&&s[s.length-1][0]>=i)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=e.parse(r,l,o);if(!c)return null;o=o||c.type,s.push([i,c])}return ci(o,Ze)||ci(o,We)||ci(o,qe)||ci(o,Je)||ci(o,ti)||ci(o,Qe)||ci(o,ii)||ci(o,ri(Ze))?new vr(o,i,r,n,s):e.error(`Type ${ni(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;if(r>=e[n-1])return i[n-1].evaluate(t);const a=pr(e,r),s=vr.interpolationFactor(this.interpolation,r,e[a],e[a+1]),o=i[a].evaluate(t),l=i[a+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return Di(o,l,s);case"color":return Ri.interpolate(o,l,s);case"padding":return ji.interpolate(o,l,s);case"colorArray":return Ni.interpolate(o,l,s);case"numberArray":return Vi.interpolate(o,l,s);case"variableAnchorOffsetCollection":return Gi.interpolate(o,l,s);case"array":return ki(o,l,s);case"projectionDefinition":return qi.interpolate(o,l,s)}case"interpolate-hcl":switch(this.type.kind){case"color":return Ri.interpolate(o,l,s,"hcl");case"colorArray":return Ni.interpolate(o,l,s,"hcl")}case"interpolate-lab":switch(this.type.kind){case"color":return Ri.interpolate(o,l,s,"lab");case"colorArray":return Ni.interpolate(o,l,s,"lab")}}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function br(t,e,i,r){const n=r-i,a=t-i;return 0===n?0:1===e?a/n:(Math.pow(e,a)-1)/(Math.pow(e,n)-1)}const wr={color:Ri.interpolate,number:Di,padding:ji.interpolate,numberArray:Vi.interpolate,colorArray:Ni.interpolate,variableAnchorOffsetCollection:Gi.interpolate,array:ki};class Tr{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i=null;const r=e.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of t.slice(1)){const t=e.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!t)return null;i=i||t.type,n.push(t)}if(!i)throw new Error("No output type");const a=r&&n.some((t=>si(r,t.type)));return new Tr(a?Xe:i,n)}evaluate(t){let e,i=null,r=0;for(const n of this.args)if(r++,i=n.evaluate(t),i&&i instanceof $i&&!i.available&&(e||(e=i.name),i=null,r===this.args.length&&(i=e)),null!==i)break;return i}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function Pr(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Mr(t,e,i,r){return 0===r.compare(e,i)}function Sr(t,e,i){const r="=="!==t&&"!="!==t;return class n{constructor(t,e,i){this.type=$e,this.lhs=t,this.rhs=e,this.collator=i,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const i=t[0];let a=e.parse(t[1],1,Xe);if(!a)return null;if(!Pr(i,a.type))return e.concat(1).error(`"${i}" comparisons are not supported for type '${ni(a.type)}'.`);let s=e.parse(t[2],2,Xe);if(!s)return null;if(!Pr(i,s.type))return e.concat(2).error(`"${i}" comparisons are not supported for type '${ni(s.type)}'.`);if(a.type.kind!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error(`Cannot compare types '${ni(a.type)}' and '${ni(s.type)}'.`);r&&("value"===a.type.kind&&"value"!==s.type.kind?a=new Qi(s.type,[a]):"value"!==a.type.kind&&"value"===s.type.kind&&(s=new Qi(a.type,[s])));let o=null;if(4===t.length){if("string"!==a.type.kind&&"string"!==s.type.kind&&"value"!==a.type.kind&&"value"!==s.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Ye),!o)return null}return new n(a,s,o)}evaluate(n){const a=this.lhs.evaluate(n),s=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const e=Xi(a),i=Xi(s);if(e.kind!==i.kind||"string"!==e.kind&&"number"!==e.kind)throw new Ui(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const t=Xi(a),i=Xi(s);if("string"!==t.kind||"string"!==i.kind)return e(n,a,s)}return this.collator?i(n,a,s,this.collator.evaluate(n)):e(n,a,s)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const Ir=Sr("==",(function(t,e,i){return e===i}),Mr),Cr=Sr("!=",(function(t,e,i){return e!==i}),(function(t,e,i,r){return!Mr(0,e,i,r)})),Ar=Sr("<",(function(t,e,i){return e<i}),(function(t,e,i,r){return r.compare(e,i)<0})),Er=Sr(">",(function(t,e,i){return e>i}),(function(t,e,i,r){return r.compare(e,i)>0})),zr=Sr("<=",(function(t,e,i){return e<=i}),(function(t,e,i,r){return r.compare(e,i)<=0})),Dr=Sr(">=",(function(t,e,i){return e>=i}),(function(t,e,i,r){return r.compare(e,i)>=0}));class kr{constructor(t,e,i){this.type=Ye,this.locale=i,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const i=t[1];if("object"!=typeof i||Array.isArray(i))return e.error("Collator options argument must be an object.");const r=e.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,$e);if(!r)return null;const n=e.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,$e);if(!n)return null;let a=null;return i.locale&&(a=e.parse(i.locale,1,Ge),!a)?null:new kr(r,n,a)}evaluate(t){return new Li(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class Rr{constructor(t,e,i,r,n){this.type=Ge,this.number=t,this.locale=e,this.currency=i,this.minFractionDigits=r,this.maxFractionDigits=n}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Ze);if(!i)return null;const r=t[2];if("object"!=typeof r||Array.isArray(r))return e.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=e.parse(r.locale,1,Ge),!n))return null;let a=null;if(r.currency&&(a=e.parse(r.currency,1,Ge),!a))return null;let s=null;if(r["min-fraction-digits"]&&(s=e.parse(r["min-fraction-digits"],1,Ze),!s))return null;let o=null;return r["max-fraction-digits"]&&(o=e.parse(r["max-fraction-digits"],1,Ze),!o)?null:new Rr(i,n,a,s,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class Lr{constructor(t){this.type=Ke,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[1];if(!Array.isArray(i)&&"object"==typeof i)return e.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=t.length-1;++i){const a=t[i];if(n&&"object"==typeof a&&!Array.isArray(a)){n=!1;let t=null;if(a["font-scale"]&&(t=e.parse(a["font-scale"],1,Ze),!t))return null;let i=null;if(a["text-font"]&&(i=e.parse(a["text-font"],1,ri(Ge)),!i))return null;let s=null;if(a["text-color"]&&(s=e.parse(a["text-color"],1,qe),!s))return null;let o=null;if(a["vertical-align"]){if("string"==typeof a["vertical-align"]&&!Fi.includes(a["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${a["vertical-align"]}' instead.`);if(o=e.parse(a["vertical-align"],1,Ge),!o)return null}const l=r[r.length-1];l.scale=t,l.font=i,l.textColor=s,l.verticalAlign=o}else{const a=e.parse(t[i],1,Xe);if(!a)return null;const s=a.type.kind;if("string"!==s&&"value"!==s&&"null"!==s&&"resolvedImage"!==s)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:a,scale:null,font:null,textColor:null,verticalAlign:null})}}return new Lr(r)}evaluate(t){return new Oi(this.sections.map((e=>{const i=e.content.evaluate(t);return Xi(i)===ei?new Bi("",i,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Bi(Yi(i),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class Fr{constructor(t){this.type=ei,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Ge);return i?new Fr(i):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),i=$i.fromString(e);return i&&t.availableImages&&(i.available=t.availableImages.indexOf(e)>-1),i}eachChild(t){t(this.input)}outputDefined(){return!1}}class Br{constructor(t){this.type=Ze,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=e.parse(t[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?e.error(`Expected argument of type string or array, but found ${ni(i.type)} instead.`):new Br(i):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Ui(`Expected value to be of type string or array, but found ${ni(Xi(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Or=8192;function jr(t,e){const i=(180+t[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,n=Math.pow(2,e.z);return[Math.round(i*n*Or),Math.round(r*n*Or)]}function Vr(t,e){const i=Math.pow(2,e.z);return[(n=(t[0]/Or+e.x)/i,360*n-180),(r=(t[1]/Or+e.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,n}function Nr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function Ur(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Zr(t,e,i){const r=t[0]-e[0],n=t[1]-e[1],a=t[0]-i[0],s=t[1]-i[1];return r*s-a*n==0&&r*a<=0&&n*s<=0}function Gr(t,e,i,r){return 0!=(n=[r[0]-i[0],r[1]-i[1]])[0]*(a=[e[0]-t[0],e[1]-t[1]])[1]-n[1]*a[0]&&!(!Yr(t,e,i,r)||!Yr(i,r,t,e));var n,a}function $r(t,e,i){for(const r of i)for(let i=0;i<r.length-1;++i)if(Gr(t,e,r[i],r[i+1]))return!0;return!1}function qr(t,e,i=!1){let r=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(Zr(t,o[e],o[e+1]))return i;(a=o[e])[1]>(n=t)[1]!=(s=o[e+1])[1]>n[1]&&n[0]<(s[0]-a[0])*(n[1]-a[1])/(s[1]-a[1])+a[0]&&(r=!r)}var n,a,s;return r}function Wr(t,e){for(const i of e)if(qr(t,i))return!0;return!1}function Hr(t,e){for(const i of t)if(!qr(i,e))return!1;for(let i=0;i<t.length-1;++i)if($r(t[i],t[i+1],e))return!1;return!0}function Xr(t,e){for(const i of e)if(Hr(t,i))return!0;return!1}function Yr(t,e,i,r){const n=r[0]-i[0],a=r[1]-i[1],s=(t[0]-i[0])*a-n*(t[1]-i[1]),o=(e[0]-i[0])*a-n*(e[1]-i[1]);return s>0&&o<0||s<0&&o>0}function Kr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const a=[];for(let r=0;r<t[n].length;r++){const s=jr(t[n][r],i);Nr(e,s),a.push(s)}r.push(a)}return r}function Jr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const a=Kr(t[n],e,i);r.push(a)}return r}function Qr(t,e,i,r){if(t[0]<i[0]||t[0]>i[2]){const e=.5*r;let n=t[0]-i[0]>e?-r:i[0]-t[0]>e?r:0;0===n&&(n=t[0]-i[2]>e?-r:i[2]-t[0]>e?r:0),t[0]+=n}Nr(e,t)}function tn(t,e,i,r){const n=Math.pow(2,r.z)*Or,a=[r.x*Or,r.y*Or],s=[];for(const r of t)for(const t of r){const r=[t.x+a[0],t.y+a[1]];Qr(r,e,i,n),s.push(r)}return s}function en(t,e,i,r){const n=Math.pow(2,r.z)*Or,a=[r.x*Or,r.y*Or],s=[];for(const i of t){const t=[];for(const r of i){const i=[r.x+a[0],r.y+a[1]];Nr(e,i),t.push(i)}s.push(t)}if(e[2]-e[0]<=n/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of s)for(const r of t)Qr(r,e,i,n)}var o;return s}class rn{constructor(t,e){this.type=$e,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Hi(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const i of e.features){const{type:e,coordinates:r}=i.geometry;"Polygon"===e&&t.push(r),"MultiPolygon"===e&&t.push(...r)}if(t.length)return new rn(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new rn(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new rn(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const a=Kr(e.coordinates,r,n),s=tn(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of s)if(!qr(t,a))return!1}if("MultiPolygon"===e.type){const a=Jr(e.coordinates,r,n),s=tn(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of s)if(!Wr(t,a))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const a=Kr(e.coordinates,r,n),s=en(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of s)if(!Hr(t,a))return!1}if("MultiPolygon"===e.type){const a=Jr(e.coordinates,r,n),s=en(t.geometry(),i,r,n);if(!Ur(i,r))return!1;for(const t of s)if(!Xr(t,a))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}class nn{constructor(t=[],e=(t,e)=>t<e?-1:t>e?1:0){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:i}=this,r=e[t];for(;t>0;){const n=t-1>>1,a=e[n];if(i(r,a)>=0)break;e[t]=a,t=n}e[t]=r}_down(t){const{data:e,compare:i}=this,r=this.length>>1,n=e[t];for(;t<r;){let r=1+(t<<1);const a=r+1;if(a<this.length&&i(e[a],e[r])<0&&(r=a),i(e[r],n)>=0)break;e[t]=e[r],t=r}e[t]=n}}function an(t,e,i=0,r=t.length-1,n=on){for(;r>i;){if(r-i>600){const a=r-i+1,s=e-i+1,o=Math.log(a),l=.5*Math.exp(2*o/3),c=.5*Math.sqrt(o*l*(a-l)/a)*(s-a/2<0?-1:1);an(t,e,Math.max(i,Math.floor(e-s*l/a+c)),Math.min(r,Math.floor(e+(a-s)*l/a+c)),n)}const a=t[e];let s=i,o=r;for(sn(t,i,e),n(t[r],a)>0&&sn(t,i,r);s<o;){for(sn(t,s,o),s++,o--;n(t[s],a)<0;)s++;for(;n(t[o],a)>0;)o--}0===n(t[i],a)?sn(t,i,o):(o++,sn(t,o,r)),o<=e&&(i=o+1),e<=o&&(r=o-1)}}function sn(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function on(t,e){return t<e?-1:t>e?1:0}function ln(t,e){if(t.length<=1)return[t];const i=[];let r,n;for(const e of t){const t=hn(e);0!==t&&(e.area=Math.abs(t),void 0===n&&(n=t<0),n===t<0?(r&&i.push(r),r=[e]):r.push(e))}if(r&&i.push(r),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(an(i[t],e,1,i[t].length-1,cn),i[t]=i[t].slice(0,e));return i}function cn(t,e){return e.area-t.area}function hn(t){let e=0;for(let i,r,n=0,a=t.length,s=a-1;n<a;s=n++)i=t[n],r=t[s],e+=(r.x-i.x)*(i.y+r.y);return e}const un=1/298.257223563,dn=un*(2-un),pn=Math.PI/180;class fn{constructor(t){const e=6378.137*pn*1e3,i=Math.cos(t*pn),r=1/(1-dn*(1-i*i)),n=Math.sqrt(r);this.kx=e*n*i,this.ky=e*n*r*(1-dn)}distance(t,e){const i=this.wrap(t[0]-e[0])*this.kx,r=(t[1]-e[1])*this.ky;return Math.sqrt(i*i+r*r)}pointOnLine(t,e){let i,r,n,a,s=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],c=t[o][1],h=this.wrap(t[o+1][0]-l)*this.kx,u=(t[o+1][1]-c)*this.ky,d=0;0===h&&0===u||(d=(this.wrap(e[0]-l)*this.kx*h+(e[1]-c)*this.ky*u)/(h*h+u*u),d>1?(l=t[o+1][0],c=t[o+1][1]):d>0&&(l+=h/this.kx*d,c+=u/this.ky*d)),h=this.wrap(e[0]-l)*this.kx,u=(e[1]-c)*this.ky;const p=h*h+u*u;p<s&&(s=p,i=l,r=c,n=o,a=d)}return{point:[i,r],index:n,t:Math.max(0,Math.min(1,a))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function mn(t,e){return e[0]-t[0]}function _n(t){return t[1]-t[0]+1}function gn(t,e){return t[1]>=t[0]&&t[1]<e}function yn(t,e){if(t[0]>t[1])return[null,null];const i=_n(t);if(e){if(2===i)return[t,null];const e=Math.floor(i/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===i)return[t,null];const r=Math.floor(i/2)-1;return[[t[0],t[0]+r],[t[0]+r+1,t[1]]]}function xn(t,e){if(!gn(e,t.length))return[1/0,1/0,-1/0,-1/0];const i=[1/0,1/0,-1/0,-1/0];for(let r=e[0];r<=e[1];++r)Nr(i,t[r]);return i}function vn(t){const e=[1/0,1/0,-1/0,-1/0];for(const i of t)for(const t of i)Nr(e,t);return e}function bn(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function wn(t,e,i){if(!bn(t)||!bn(e))return NaN;let r=0,n=0;return t[2]<e[0]&&(r=e[0]-t[2]),t[0]>e[2]&&(r=t[0]-e[2]),t[1]>e[3]&&(n=t[1]-e[3]),t[3]<e[1]&&(n=e[1]-t[3]),i.distance([0,0],[r,n])}function Tn(t,e,i){const r=i.pointOnLine(e,t);return i.distance(t,r.point)}function Pn(t,e,i,r,n){const a=Math.min(Tn(t,[i,r],n),Tn(e,[i,r],n)),s=Math.min(Tn(i,[t,e],n),Tn(r,[t,e],n));return Math.min(a,s)}function Mn(t,e,i,r,n){if(!gn(e,t.length)||!gn(r,i.length))return 1/0;let a=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],o=t[s+1];for(let t=r[0];t<r[1];++t){const r=i[t],s=i[t+1];if(Gr(e,o,r,s))return 0;a=Math.min(a,Pn(e,o,r,s,n))}}return a}function Sn(t,e,i,r,n){if(!gn(e,t.length)||!gn(r,i.length))return NaN;let a=1/0;for(let s=e[0];s<=e[1];++s)for(let e=r[0];e<=r[1];++e)if(a=Math.min(a,n.distance(t[s],i[e])),0===a)return a;return a}function In(t,e,i){if(qr(t,e,!0))return 0;let r=1/0;for(const n of e){const e=n[0],a=n[n.length-1];if(e!==a&&(r=Math.min(r,Tn(t,[a,e],i)),0===r))return r;const s=i.pointOnLine(n,t);if(r=Math.min(r,i.distance(t,s.point)),0===r)return r}return r}function Cn(t,e,i,r){if(!gn(e,t.length))return NaN;for(let r=e[0];r<=e[1];++r)if(qr(t[r],i,!0))return 0;let n=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],s=t[a+1];for(const t of i)for(let i=0,a=t.length,o=a-1;i<a;o=i++){const a=t[o],l=t[i];if(Gr(e,s,a,l))return 0;n=Math.min(n,Pn(e,s,a,l,r))}}return n}function An(t,e){for(const i of t)for(const t of i)if(qr(t,e,!0))return!0;return!1}function En(t,e,i,r=1/0){const n=vn(t),a=vn(e);if(r!==1/0&&wn(n,a,i)>=r)return r;if(Ur(n,a)){if(An(t,e))return 0}else if(An(e,t))return 0;let s=1/0;for(const r of t)for(let t=0,n=r.length,a=n-1;t<n;a=t++){const n=r[a],o=r[t];for(const t of e)for(let e=0,r=t.length,a=r-1;e<r;a=e++){const r=t[a],l=t[e];if(Gr(n,o,r,l))return 0;s=Math.min(s,Pn(n,o,r,l,i))}}return s}function zn(t,e,i,r,n,a){if(!a)return;const s=wn(xn(r,a),n,i);s<e&&t.push([s,a,[0,0]])}function Dn(t,e,i,r,n,a,s){if(!a||!s)return;const o=wn(xn(r,a),xn(n,s),i);o<e&&t.push([o,a,s])}function kn(t,e,i,r,n=1/0){let a=Math.min(r.distance(t[0],i[0][0]),n);if(0===a)return a;const s=new nn([[0,[0,t.length-1],[0,0]]],mn),o=vn(i);for(;s.length>0;){const n=s.pop();if(n[0]>=a)continue;const l=n[1],c=e?50:100;if(_n(l)<=c){if(!gn(l,t.length))return NaN;if(e){const e=Cn(t,l,i,r);if(isNaN(e)||0===e)return e;a=Math.min(a,e)}else for(let e=l[0];e<=l[1];++e){const n=In(t[e],i,r);if(a=Math.min(a,n),0===a)return 0}}else{const i=yn(l,e);zn(s,a,r,t,o,i[0]),zn(s,a,r,t,o,i[1])}}return a}function Rn(t,e,i,r,n,a=1/0){let s=Math.min(a,n.distance(t[0],i[0]));if(0===s)return s;const o=new nn([[0,[0,t.length-1],[0,i.length-1]]],mn);for(;o.length>0;){const a=o.pop();if(a[0]>=s)continue;const l=a[1],c=a[2],h=e?50:100,u=r?50:100;if(_n(l)<=h&&_n(c)<=u){if(!gn(l,t.length)&&gn(c,i.length))return NaN;let a;if(e&&r)a=Mn(t,l,i,c,n),s=Math.min(s,a);else if(e&&!r){const e=t.slice(l[0],l[1]+1);for(let t=c[0];t<=c[1];++t)if(a=Tn(i[t],e,n),s=Math.min(s,a),0===s)return s}else if(!e&&r){const e=i.slice(c[0],c[1]+1);for(let i=l[0];i<=l[1];++i)if(a=Tn(t[i],e,n),s=Math.min(s,a),0===s)return s}else a=Sn(t,l,i,c,n),s=Math.min(s,a)}else{const a=yn(l,e),h=yn(c,r);Dn(o,s,n,t,i,a[0],h[0]),Dn(o,s,n,t,i,a[0],h[1]),Dn(o,s,n,t,i,a[1],h[0]),Dn(o,s,n,t,i,a[1],h[1])}}return s}function Ln(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class Fn{constructor(t,e){this.type=Ze,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Hi(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new Fn(e,e.features.map((t=>Ln(t.geometry))).flat());if("Feature"===e.type)return new Fn(e,Ln(e.geometry));if("type"in e&&"coordinates"in e)return new Fn(e,Ln(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Vr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new fn(r[0][1]);let a=1/0;for(const t of e){switch(t.type){case"Point":a=Math.min(a,Rn(r,!1,[t.coordinates],!1,n,a));break;case"LineString":a=Math.min(a,Rn(r,!1,t.coordinates,!0,n,a));break;case"Polygon":a=Math.min(a,kn(r,!1,t.coordinates,n,a))}if(0===a)return a}return a}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Vr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new fn(r[0][1]);let a=1/0;for(const t of e){switch(t.type){case"Point":a=Math.min(a,Rn(r,!0,[t.coordinates],!1,n,a));break;case"LineString":a=Math.min(a,Rn(r,!0,t.coordinates,!0,n,a));break;case"Polygon":a=Math.min(a,kn(r,!0,t.coordinates,n,a))}if(0===a)return a}return a}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const i=t.geometry();if(0===i.length||0===i[0].length)return NaN;const r=ln(i,0).map((e=>e.map((e=>e.map((e=>Vr([e.x,e.y],t.canonical))))))),n=new fn(r[0][0][0][1]);let a=1/0;for(const t of e)for(const e of r){switch(t.type){case"Point":a=Math.min(a,kn([t.coordinates],!1,e,n,a));break;case"LineString":a=Math.min(a,kn(t.coordinates,!0,e,n,a));break;case"Polygon":a=Math.min(a,En(e,t.coordinates,n,a))}if(0===a)return a}return a}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}class Bn{constructor(t){this.type=Xe,this.key=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=t[1];return null==i?e.error("Global state property must be defined."):"string"!=typeof i?e.error(`Global state property must be string, but found ${typeof t[1]} instead.`):new Bn(i)}evaluate(t){var e;const i=null===(e=t.globals)||void 0===e?void 0:e.globalState;return i&&0!==Object.keys(i).length?Si(i,this.key):null}eachChild(){}outputDefined(){return!1}}const On={"==":Ir,"!=":Cr,">":Er,"<":Ar,">=":Dr,"<=":zr,array:Qi,at:or,boolean:Qi,case:ur,coalesce:Tr,collator:kr,format:Lr,image:Fr,in:lr,"index-of":cr,interpolate:vr,"interpolate-hcl":vr,"interpolate-lab":vr,length:Br,let:ar,literal:Ki,match:hr,number:Qi,"number-format":Rr,object:Qi,slice:dr,step:fr,string:Qi,"to-boolean":er,"to-color":er,"to-number":er,"to-string":er,var:sr,within:rn,distance:Fn,"global-state":Bn};class jn{constructor(t,e,i,r){this.name=t,this.type=e,this._evaluate=i,this.args=r}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const i=t[0],r=jn.definitions[i];if(!r)return e.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,a=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,s=a.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[r,a]of s){o=new nr(e.registry,Gn,e.path,null,e.scope);const s=[];let l=!1;for(let e=1;e<t.length;e++){const i=t[e],n=Array.isArray(r)?r[e-1]:r.type,a=o.parse(i,1+s.length,n);if(!a){l=!0;break}s.push(a)}if(!l)if(Array.isArray(r)&&r.length!==s.length)o.error(`Expected ${r.length} arguments, but found ${s.length} instead.`);else{for(let t=0;t<s.length;t++){const e=Array.isArray(r)?r[t]:r.type,i=s[t];o.concat(t+1).checkSubtype(e,i.type)}if(0===o.errors.length)return new jn(i,n,a,s)}}if(1===s.length)e.errors.push(...o.errors);else{const i=(s.length?s:a).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(ni).join(", ")})`:`(${ni(e.type)}...)`;var e})).join(" | "),r=[];for(let i=1;i<t.length;i++){const n=e.parse(t[i],1+r.length);if(!n)return null;r.push(ni(n.type))}e.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(t,e){jn.definitions=e;for(const i in e)t[i]=jn}}function Vn(t,[e,i,r,n]){e=e.evaluate(t),i=i.evaluate(t),r=r.evaluate(t);const a=n?n.evaluate(t):1,s=Wi(e,i,r,a);if(s)throw new Ui(s);return new Ri(e/255,i/255,r/255,a,!1)}function Nn(t,e){return t in e}function Un(t,e){const i=e[t];return void 0===i?null:i}function Zn(t){return{type:t}}function Gn(t){if(t instanceof sr)return Gn(t.boundExpression);if(t instanceof jn&&"error"===t.name)return!1;if(t instanceof kr)return!1;if(t instanceof rn)return!1;if(t instanceof Fn)return!1;if(t instanceof Bn)return!1;const e=t instanceof er||t instanceof Qi;let i=!0;return t.eachChild((t=>{i=e?i&&Gn(t):i&&t instanceof Ki})),!!i&&$n(t)&&Wn(t,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function $n(t){if(t instanceof jn){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof rn)return!1;if(t instanceof Fn)return!1;let e=!0;return t.eachChild((t=>{e&&!$n(t)&&(e=!1)})),e}function qn(t){if(t instanceof jn&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!qn(t)&&(e=!1)})),e}function Wn(t,e){if(t instanceof jn&&e.indexOf(t.name)>=0)return!1;let i=!0;return t.eachChild((t=>{i&&!Wn(t,e)&&(i=!1)})),i}function Hn(t){return{result:"success",value:t}}function Xn(t){return{result:"error",value:t}}function Yn(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Kn(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Jn(t){return!!t.expression&&t.expression.interpolated}function Qn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function ta(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)&&Xi(t)===He}function ea(t){return t}function ia(t,e){const i=t.stops&&"object"==typeof t.stops[0][0],r=i||!(i||void 0!==t.property),n=t.type||(Jn(e)?"exponential":"interval"),a=function(t){switch(t.type){case"color":return Ri.parse;case"padding":return ji.parse;case"numberArray":return Vi.parse;case"colorArray":return Ni.parse;default:return null}}(e);if(a&&((t=je({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],a(t[1])]))),t.default=a(t.default?t.default:e.default)),t.colorSpace&&"rgb"!==(s=t.colorSpace)&&"hcl"!==s&&"lab"!==s)throw new Error(`Unknown color space: "${t.colorSpace}"`);var s;const o=function(t){switch(t){case"exponential":return sa;case"interval":return aa;case"categorical":return na;case"identity":return oa;default:throw new Error(`Unknown function type "${t}"`)}}(n);let l,c;if("categorical"===n){l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];c=typeof t.stops[0][0]}if(i){const i={},r=[];for(let e=0;e<t.stops.length;e++){const n=t.stops[e],a=n[0].zoom;void 0===i[a]&&(i[a]={zoom:a,type:t.type,property:t.property,default:t.default,stops:[]},r.push(a)),i[a].stops.push([n[0].value,n[1]])}const n=[];for(const t of r)n.push([i[t].zoom,ia(i[t],e)]);const a={name:"linear"};return{kind:"composite",interpolationType:a,interpolationFactor:vr.interpolationFactor.bind(void 0,a),zoomStops:n.map((t=>t[0])),evaluate:({zoom:i},r)=>sa({stops:n,base:t.base},e,i).evaluate(i,r)}}if(r){const i="exponential"===n?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:vr.interpolationFactor.bind(void 0,i),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:i})=>o(t,e,i,l,c)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[t.property]:void 0;return void 0===n?ra(t.default,e.default):o(t,e,n,l,c)}}}function ra(t,e,i){return void 0!==t?t:void 0!==e?e:void 0!==i?i:void 0}function na(t,e,i,r,n){return ra(typeof i===n?r[i]:void 0,t.default,e.default)}function aa(t,e,i){if("number"!==Qn(i))return ra(t.default,e.default);const r=t.stops.length;if(1===r)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[r-1][0])return t.stops[r-1][1];const n=pr(t.stops.map((t=>t[0])),i);return t.stops[n][1]}function sa(t,e,i){const r=void 0!==t.base?t.base:1;if("number"!==Qn(i))return ra(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[n-1][0])return t.stops[n-1][1];const a=pr(t.stops.map((t=>t[0])),i),s=function(t,e,i,r){const n=r-i,a=t-i;return 0===n?0:1===e?a/n:(Math.pow(e,a)-1)/(Math.pow(e,n)-1)}(i,r,t.stops[a][0],t.stops[a+1][0]),o=t.stops[a][1],l=t.stops[a+1][1],c=wr[e.type]||ea;return"function"==typeof o.evaluate?{evaluate(...e){const i=o.evaluate.apply(void 0,e),r=l.evaluate.apply(void 0,e);if(void 0!==i&&void 0!==r)return c(i,r,s,t.colorSpace)}}:c(o,l,s,t.colorSpace)}function oa(t,e,i){switch(e.type){case"color":i=Ri.parse(i);break;case"formatted":i=Oi.fromString(i.toString());break;case"resolvedImage":i=$i.fromString(i.toString());break;case"padding":i=ji.parse(i);break;case"colorArray":i=Ni.parse(i);break;case"numberArray":i=Vi.parse(i);break;default:Qn(i)===e.type||"enum"===e.type&&e.values[i]||(i=void 0)}return ra(i,t.default,e.default)}jn.register(On,{error:[{kind:"error"},[Ge],(t,[e])=>{throw new Ui(e.evaluate(t))}],typeof:[Ge,[Xe],(t,[e])=>ni(Xi(e.evaluate(t)))],"to-rgba":[ri(Ze,4),[qe],(t,[e])=>{const[i,r,n,a]=e.evaluate(t).rgb;return[255*i,255*r,255*n,a]}],rgb:[qe,[Ze,Ze,Ze],Vn],rgba:[qe,[Ze,Ze,Ze,Ze],Vn],has:{type:$e,overloads:[[[Ge],(t,[e])=>Nn(e.evaluate(t),t.properties())],[[Ge,He],(t,[e,i])=>Nn(e.evaluate(t),i.evaluate(t))]]},get:{type:Xe,overloads:[[[Ge],(t,[e])=>Un(e.evaluate(t),t.properties())],[[Ge,He],(t,[e,i])=>Un(e.evaluate(t),i.evaluate(t))]]},"feature-state":[Xe,[Ge],(t,[e])=>Un(e.evaluate(t),t.featureState||{})],properties:[He,[],t=>t.properties()],"geometry-type":[Ge,[],t=>t.geometryType()],id:[Xe,[],t=>t.id()],zoom:[Ze,[],t=>t.globals.zoom],"heatmap-density":[Ze,[],t=>t.globals.heatmapDensity||0],elevation:[Ze,[],t=>t.globals.elevation||0],"line-progress":[Ze,[],t=>t.globals.lineProgress||0],accumulated:[Xe,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Ze,Zn(Ze),(t,e)=>{let i=0;for(const r of e)i+=r.evaluate(t);return i}],"*":[Ze,Zn(Ze),(t,e)=>{let i=1;for(const r of e)i*=r.evaluate(t);return i}],"-":{type:Ze,overloads:[[[Ze,Ze],(t,[e,i])=>e.evaluate(t)-i.evaluate(t)],[[Ze],(t,[e])=>-e.evaluate(t)]]},"/":[Ze,[Ze,Ze],(t,[e,i])=>e.evaluate(t)/i.evaluate(t)],"%":[Ze,[Ze,Ze],(t,[e,i])=>e.evaluate(t)%i.evaluate(t)],ln2:[Ze,[],()=>Math.LN2],pi:[Ze,[],()=>Math.PI],e:[Ze,[],()=>Math.E],"^":[Ze,[Ze,Ze],(t,[e,i])=>Math.pow(e.evaluate(t),i.evaluate(t))],sqrt:[Ze,[Ze],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Ze,[Ze],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Ze,[Ze],(t,[e])=>Math.log(e.evaluate(t))],log2:[Ze,[Ze],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Ze,[Ze],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Ze,[Ze],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Ze,[Ze],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Ze,[Ze],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Ze,[Ze],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Ze,[Ze],(t,[e])=>Math.atan(e.evaluate(t))],min:[Ze,Zn(Ze),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Ze,Zn(Ze),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Ze,[Ze],(t,[e])=>Math.abs(e.evaluate(t))],round:[Ze,[Ze],(t,[e])=>{const i=e.evaluate(t);return i<0?-Math.round(-i):Math.round(i)}],floor:[Ze,[Ze],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Ze,[Ze],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[$e,[Ge,Xe],(t,[e,i])=>t.properties()[e.value]===i.value],"filter-id-==":[$e,[Xe],(t,[e])=>t.id()===e.value],"filter-type-==":[$e,[Ge],(t,[e])=>t.geometryType()===e.value],"filter-<":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<r}],"filter->":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>r}],"filter-<=":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<=r}],"filter->=":[$e,[Ge,Xe],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[$e,[Xe],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>=r}],"filter-has":[$e,[Xe],(t,[e])=>e.value in t.properties()],"filter-has-id":[$e,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[$e,[ri(Ge)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[$e,[ri(Xe)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[$e,[Ge,ri(Xe)],(t,[e,i])=>i.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[$e,[Ge,ri(Xe)],(t,[e,i])=>function(t,e,i,r){for(;i<=r;){const n=i+r>>1;if(e[n]===t)return!0;e[n]>t?r=n-1:i=n+1}return!1}(t.properties()[e.value],i.value,0,i.value.length-1)],all:{type:$e,overloads:[[[$e,$e],(t,[e,i])=>e.evaluate(t)&&i.evaluate(t)],[Zn($e),(t,e)=>{for(const i of e)if(!i.evaluate(t))return!1;return!0}]]},any:{type:$e,overloads:[[[$e,$e],(t,[e,i])=>e.evaluate(t)||i.evaluate(t)],[Zn($e),(t,e)=>{for(const i of e)if(i.evaluate(t))return!0;return!1}]]},"!":[$e,[$e],(t,[e])=>!e.evaluate(t)],"is-supported-script":[$e,[Ge],(t,[e])=>{const i=t.globals&&t.globals.isSupportedScript;return!i||i(e.evaluate(t))}],upcase:[Ge,[Ge],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Ge,[Ge],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Ge,Zn(Xe),(t,e)=>e.map((e=>Yi(e.evaluate(t)))).join("")],"resolved-locale":[Ge,[Ye],(t,[e])=>e.evaluate(t).resolvedLocale()]});class la{constructor(t,e,i){this.expression=t,this._warningHistory={},this._evaluator=new rr,this._defaultValue=e?function(t){if("color"===t.type&&ta(t.default))return new Ri(0,0,0,0);switch(t.type){case"color":return Ri.parse(t.default)||null;case"padding":return ji.parse(t.default)||null;case"numberArray":return Vi.parse(t.default)||null;case"colorArray":return Ni.parse(t.default)||null;case"variableAnchorOffsetCollection":return Gi.parse(t.default)||null;case"projectionDefinition":return qi.parse(t.default)||null;default:return void 0===t.default?null:t.default}}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null,this._globalState=i}evaluateWithoutErrorHandling(t,e,i,r,n,a){return this._globalState&&(t=ga(t,this._globalState)),this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=i,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=a,this.expression.evaluate(this._evaluator)}evaluate(t,e,i,r,n,a){this._globalState&&(t=ga(t,this._globalState)),this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=a||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Ui(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function ca(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in On}function ha(t,e,i){const r=new nr(On,Gn,[],e?function(t){const e={color:qe,string:Ge,number:Ze,enum:Ge,boolean:$e,formatted:Ke,padding:Je,numberArray:ti,colorArray:Qe,projectionDefinition:We,resolvedImage:ei,variableAnchorOffsetCollection:ii};return"array"===t.type?ri(e[t.value]||Xe,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Hn(new la(n,e,i)):Xn(r.errors)}class ua{constructor(t,e,i){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!qn(e.expression),this.globalStateRefs=_a(e.expression),this._globalState=i}evaluateWithoutErrorHandling(t,e,i,r,n,a){return this._globalState&&(t=ga(t,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,a)}evaluate(t,e,i,r,n,a){return this._globalState&&(t=ga(t,this._globalState)),this._styleExpression.evaluate(t,e,i,r,n,a)}}class da{constructor(t,e,i,r,n){this.kind=t,this.zoomStops=i,this._styleExpression=e,this.isStateDependent="camera"!==t&&!qn(e.expression),this.globalStateRefs=_a(e.expression),this.interpolationType=r,this._globalState=n}evaluateWithoutErrorHandling(t,e,i,r,n,a){return this._globalState&&(t=ga(t,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,a)}evaluate(t,e,i,r,n,a){return this._globalState&&(t=ga(t,this._globalState)),this._styleExpression.evaluate(t,e,i,r,n,a)}interpolationFactor(t,e,i){return this.interpolationType?vr.interpolationFactor(this.interpolationType,t,e,i):0}}function pa(t,e,i){const r=ha(t,e,i);if("error"===r.result)return r;const n=r.value.expression,a=$n(n);if(!a&&!Yn(e))return Xn([new Ve("","data expressions not supported")]);const s=Wn(n,["zoom"]);if(!s&&!Kn(e))return Xn([new Ve("","zoom expressions not supported")]);const o=ma(n);return o||s?o instanceof Ve?Xn([o]):o instanceof vr&&!Jn(e)?Xn([new Ve("",'"interpolate" expressions cannot be used with this property')]):Hn(o?new da(a?"camera":"composite",r.value,o.labels,o instanceof vr?o.interpolation:void 0,i):new ua(a?"constant":"source",r.value,i)):Xn([new Ve("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class fa{constructor(t,e){this._parameters=t,this._specification=e,je(this,ia(this._parameters,this._specification))}static deserialize(t){return new fa(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function ma(t){let e=null;if(t instanceof ar)e=ma(t.result);else if(t instanceof Tr){for(const i of t.args)if(e=ma(i),e)break}else(t instanceof fr||t instanceof vr)&&t.input instanceof jn&&"zoom"===t.input.name&&(e=t);return e instanceof Ve||t.eachChild((t=>{const i=ma(t);i instanceof Ve?e=i:!e&&i?e=new Ve("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&i&&e!==i&&(e=new Ve("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function _a(t,e=new Set){return t instanceof Bn&&e.add(t.key),t.eachChild((t=>{_a(t,e)})),e}function ga(t,e){const{zoom:i,heatmapDensity:r,elevation:n,lineProgress:a,isSupportedScript:s,accumulated:o}=null!=t?t:{};return{zoom:i,heatmapDensity:r,elevation:n,lineProgress:a,isSupportedScript:s,accumulated:o,globalState:e}}function ya(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!ya(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const xa={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function va(t,e){if(null==t)return{filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};ya(t)||(t=Ta(t));const i=ha(t,xa,e);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,e,r)=>i.value.evaluate(t,e,{},r),needGeometry:wa(t),getGlobalStateRefs:()=>_a(i.value.expression)}}function ba(t,e){return t<e?-1:t>e?1:0}function wa(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(wa(t[e]))return!0;return!1}function Ta(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Pa(t[1],t[2],"=="):"!="===e?Ia(Pa(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Pa(t[1],t[2],e):"any"===e?(i=t.slice(1),["any"].concat(i.map(Ta))):"all"===e?["all"].concat(t.slice(1).map(Ta)):"none"===e?["all"].concat(t.slice(1).map(Ta).map(Ia)):"in"===e?Ma(t[1],t.slice(2)):"!in"===e?Ia(Ma(t[1],t.slice(2))):"has"===e?Sa(t[1]):"!has"!==e||Ia(Sa(t[1]));var i}function Pa(t,e,i){switch(t){case"$type":return[`filter-type-${i}`,e];case"$id":return[`filter-id-${i}`,e];default:return[`filter-${i}`,t,e]}}function Ma(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(ba)]]:["filter-in-small",t,["literal",e]]}}function Sa(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function Ia(t){return["!",t]}function Ca(t){const e=t.value;return e?[new Oe(t.key,e,"constants have been deprecated as of v8")]:[]}function Aa(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function Ea(t){if(Array.isArray(t))return t.map(Ea);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const i in t)e[i]=Ea(t[i]);return e}return Aa(t)}function za(t){const e=t.key,i=t.value,r=t.valueSpec||{},n=t.objectElementValidators||{},a=t.style,s=t.styleSpec,o=t.validateSpec;let l=[];const c=Qn(i);if("object"!==c)return[new Oe(e,i,`object expected, ${c} found`)];for(const t in i){const c=t.split(".")[0],h=Si(r,c)||r["*"];let u;if(Si(n,c))u=n[c];else if(Si(r,c))u=o;else if(n["*"])u=n["*"];else{if(!r["*"]){l.push(new Oe(e,i[t],`unknown property "${t}"`));continue}u=o}l=l.concat(u({key:(e?`${e}.`:e)+t,value:i[t],valueSpec:h,style:a,styleSpec:s,object:i,objectKey:t,validateSpec:o},i))}for(const t in r)n[t]||r[t].required&&void 0===r[t].default&&void 0===i[t]&&l.push(new Oe(e,i,`missing required property "${t}"`));return l}function Da(t){const e=t.value,i=t.valueSpec,r=t.style,n=t.styleSpec,a=t.key,s=t.arrayElementValidator||t.validateSpec;if("array"!==Qn(e))return[new Oe(a,e,`array expected, ${Qn(e)} found`)];if(i.length&&e.length!==i.length)return[new Oe(a,e,`array length ${i.length} expected, length ${e.length} found`)];if(i["min-length"]&&e.length<i["min-length"])return[new Oe(a,e,`array length at least ${i["min-length"]} expected, length ${e.length} found`)];let o={type:i.value,values:i.values};n.$version<7&&(o.function=i.function),"object"===Qn(i.value)&&(o=i.value);let l=[];for(let i=0;i<e.length;i++)l=l.concat(s({array:e,arrayIndex:i,value:e[i],valueSpec:o,validateSpec:t.validateSpec,style:r,styleSpec:n,key:`${a}[${i}]`}));return l}function ka(t){const e=t.key,i=t.value,r=t.valueSpec;let n=Qn(i);return"number"===n&&i!=i&&(n="NaN"),"number"!==n?[new Oe(e,i,`number expected, ${n} found`)]:"minimum"in r&&i<r.minimum?[new Oe(e,i,`${i} is less than the minimum value ${r.minimum}`)]:"maximum"in r&&i>r.maximum?[new Oe(e,i,`${i} is greater than the maximum value ${r.maximum}`)]:[]}function Ra(t){const e=t.valueSpec,i=Aa(t.value.type);let r,n,a,s={};const o="categorical"!==i&&void 0===t.value.property,l=!o,c="array"===Qn(t.value.stops)&&"array"===Qn(t.value.stops[0])&&"object"===Qn(t.value.stops[0][0]),h=za({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===i)return[new Oe(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const r=t.value;return e=e.concat(Da({key:t.key,value:r,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===Qn(r)&&0===r.length&&e.push(new Oe(t.key,r,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===i&&o&&h.push(new Oe(t.key,t.value,'missing required property "property"')),"identity"===i||t.value.stops||h.push(new Oe(t.key,t.value,'missing required property "stops"')),"exponential"===i&&t.valueSpec.expression&&!Jn(t.valueSpec)&&h.push(new Oe(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Yn(t.valueSpec)?h.push(new Oe(t.key,t.value,"property functions not supported")):o&&!Kn(t.valueSpec)&&h.push(new Oe(t.key,t.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==t.value.property||h.push(new Oe(t.key,t.value,'"property" property is required')),h;function u(t){let i=[];const r=t.value,o=t.key;if("array"!==Qn(r))return[new Oe(o,r,`array expected, ${Qn(r)} found`)];if(2!==r.length)return[new Oe(o,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==Qn(r[0]))return[new Oe(o,r,`object expected, ${Qn(r[0])} found`)];if(void 0===r[0].zoom)return[new Oe(o,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new Oe(o,r,"object stop key must have value")];if(a&&a>Aa(r[0].zoom))return[new Oe(o,r[0].zoom,"stop zoom values must appear in ascending order")];Aa(r[0].zoom)!==a&&(a=Aa(r[0].zoom),n=void 0,s={}),i=i.concat(za({key:`${o}[0]`,value:r[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:ka,value:d}}))}else i=i.concat(d({key:`${o}[0]`,value:r[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},r));return ca(Ea(r[1]))?i.concat([new Oe(`${o}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(t.validateSpec({key:`${o}[1]`,value:r[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function d(t,a){const o=Qn(t.value),l=Aa(t.value),c=null!==t.value?t.value:a;if(r){if(o!==r)return[new Oe(t.key,c,`${o} stop domain type must match previous stop domain type ${r}`)]}else r=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return[new Oe(t.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==i){let r=`number expected, ${o} found`;return Yn(e)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Oe(t.key,c,r)]}return"categorical"!==i||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===o&&void 0!==n&&l<n?[new Oe(t.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in s?[new Oe(t.key,c,"stop domain values must be unique")]:(s[l]=!0,[])):[new Oe(t.key,c,`integer expected, found ${l}`)]}}function La(t){const e=("property"===t.expressionContext?pa:ha)(Ea(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Oe(`${t.key}${e.key}`,t.value,e.message)));const i=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!i.outputDefined())return[new Oe(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!qn(i))return[new Oe(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!qn(i))return[new Oe(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Wn(i,["zoom","feature-state"]))return[new Oe(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!$n(i))return[new Oe(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Fa(t){const e=t.key,i=t.value,r=Qn(i);return"string"!==r?[new Oe(e,i,`color expected, ${r} found`)]:Ri.parse(String(i))?[]:[new Oe(e,i,`color expected, "${i}" found`)]}function Ba(t){const e=t.key,i=t.value,r=t.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(Aa(i))&&n.push(new Oe(e,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(Aa(i))&&n.push(new Oe(e,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function Oa(t){return ya(Ea(t.value))?La(je({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):ja(t)}function ja(t){const e=t.value,i=t.key;if("array"!==Qn(e))return[new Oe(i,e,`array expected, ${Qn(e)} found`)];const r=t.styleSpec;let n,a=[];if(e.length<1)return[new Oe(i,e,"filter array must have at least 1 element")];switch(a=a.concat(Ba({key:`${i}[0]`,value:e[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),Aa(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===Aa(e[1])&&a.push(new Oe(i,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&a.push(new Oe(i,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(n=Qn(e[1]),"string"!==n&&a.push(new Oe(`${i}[1]`,e[1],`string expected, ${n} found`)));for(let s=2;s<e.length;s++)n=Qn(e[s]),"$type"===Aa(e[1])?a=a.concat(Ba({key:`${i}[${s}]`,value:e[s],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&a.push(new Oe(`${i}[${s}]`,e[s],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<e.length;r++)a=a.concat(ja({key:`${i}[${r}]`,value:e[r],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":n=Qn(e[1]),2!==e.length?a.push(new Oe(i,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==n&&a.push(new Oe(`${i}[1]`,e[1],`string expected, ${n} found`))}return a}function Va(t,e){const i=t.key,r=t.validateSpec,n=t.style,a=t.styleSpec,s=t.value,o=t.objectKey,l=a[`${e}_${t.layerType}`];if(!l)return[];const c=o.match(/^(.*)-transition$/);if("paint"===e&&c&&l[c[1]]&&l[c[1]].transition)return r({key:i,value:s,valueSpec:a.transition,style:n,styleSpec:a});const h=t.valueSpec||l[o];if(!h)return[new Oe(i,s,`unknown property "${o}"`)];let u;if("string"===Qn(s)&&Yn(h)&&!h.tokens&&(u=/^{([^}]+)}$/.exec(s)))return[new Oe(i,s,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(u[1])} }\`.`)];const d=[];return"symbol"===t.layerType&&"text-font"===o&&ta(Ea(s))&&"identity"===Aa(s.type)&&d.push(new Oe(i,s,'"text-font" does not support identity functions')),d.concat(r({key:t.key,value:s,valueSpec:h,style:n,styleSpec:a,expressionContext:"property",propertyType:e,propertyKey:o}))}function Na(t){return Va(t,"paint")}function Ua(t){return Va(t,"layout")}function Za(t){let e=[];const i=t.value,r=t.key,n=t.style,a=t.styleSpec;if("object"!==Qn(i))return[new Oe(r,i,`object expected, ${Qn(i)} found`)];i.type||i.ref||e.push(new Oe(r,i,'either "type" or "ref" is required'));let s=Aa(i.type);const o=Aa(i.ref);if(i.id){const a=Aa(i.id);for(let s=0;s<t.arrayIndex;s++){const t=n.layers[s];Aa(t.id)===a&&e.push(new Oe(r,i.id,`duplicate layer id "${i.id}", previously used at line ${t.id.__line__}`))}}if("ref"in i){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in i&&e.push(new Oe(r,i[t],`"${t}" is prohibited for ref layers`))})),n.layers.forEach((e=>{Aa(e.id)===o&&(t=e)})),t?t.ref?e.push(new Oe(r,i.ref,"ref cannot reference another ref layer")):s=Aa(t.type):e.push(new Oe(r,i.ref,`ref layer "${o}" not found`))}else if("background"!==s)if(i.source){const t=n.sources&&n.sources[i.source],a=t&&Aa(t.type);t?"vector"===a&&"raster"===s?e.push(new Oe(r,i.source,`layer "${i.id}" requires a raster source`)):"raster-dem"!==a&&"hillshade"===s||"raster-dem"!==a&&"color-relief"===s?e.push(new Oe(r,i.source,`layer "${i.id}" requires a raster-dem source`)):"raster"===a&&"raster"!==s?e.push(new Oe(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==a||i["source-layer"]?"raster-dem"===a&&"hillshade"!==s&&"color-relief"!==s?e.push(new Oe(r,i.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==s||!i.paint||!i.paint["line-gradient"]||"geojson"===a&&t.lineMetrics||e.push(new Oe(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Oe(r,i,`layer "${i.id}" must specify a "source-layer"`)):e.push(new Oe(r,i.source,`source "${i.source}" not found`))}else e.push(new Oe(r,i,'missing required property "source"'));return e=e.concat(za({key:r,value:i,valueSpec:a.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${r}.type`,value:i.type,valueSpec:a.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:i,objectKey:"type"}),filter:Oa,layout:t=>za({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Ua(je({layerType:s},t))}}),paint:t=>za({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Na(je({layerType:s},t))}})}})),e}function Ga(t){const e=t.value,i=t.key,r=Qn(e);return"string"!==r?[new Oe(i,e,`string expected, ${r} found`)]:[]}const $a={promoteId:function({key:t,value:e}){if("string"===Qn(e))return Ga({key:t,value:e});{const i=[];for(const r in e)i.push(...Ga({key:`${t}.${r}`,value:e[r]}));return i}}};function qa(t){const e=t.value,i=t.key,r=t.styleSpec,n=t.style,a=t.validateSpec;if(!e.type)return[new Oe(i,e,'"type" is required')];const s=Aa(e.type);let o;switch(s){case"vector":case"raster":return o=za({key:i,value:e,valueSpec:r[`source_${s.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:$a,validateSpec:a}),o;case"raster-dem":return o=function(t){var e;const i=null!==(e=t.sourceName)&&void 0!==e?e:"",r=t.value,n=t.styleSpec,a=n.source_raster_dem,s=t.style;let o=[];const l=Qn(r);if(void 0===r)return o;if("object"!==l)return o.push(new Oe("source_raster_dem",r,`object expected, ${l} found`)),o;const c="custom"===Aa(r.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],u=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in r)!c&&h.includes(e)?o.push(new Oe(e,r[e],`In "${i}": "${e}" is only valid when "encoding" is set to "custom". ${u} encoding found`)):a[e]?o=o.concat(t.validateSpec({key:e,value:r[e],valueSpec:a[e],validateSpec:t.validateSpec,style:s,styleSpec:n})):o.push(new Oe(e,r[e],`unknown property "${e}"`));return o}({sourceName:i,value:e,style:t.style,styleSpec:r,validateSpec:a}),o;case"geojson":if(o=za({key:i,value:e,valueSpec:r.source_geojson,style:n,styleSpec:r,validateSpec:a,objectElementValidators:$a}),e.cluster)for(const t in e.clusterProperties){const[r,n]=e.clusterProperties[t],a="string"==typeof r?[r,["accumulated"],["get",t]]:r;o.push(...La({key:`${i}.${t}.map`,value:n,expressionContext:"cluster-map"})),o.push(...La({key:`${i}.${t}.reduce`,value:a,expressionContext:"cluster-reduce"}))}return o;case"video":return za({key:i,value:e,valueSpec:r.source_video,style:n,validateSpec:a,styleSpec:r});case"image":return za({key:i,value:e,valueSpec:r.source_image,style:n,validateSpec:a,styleSpec:r});case"canvas":return[new Oe(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Ba({key:`${i}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Wa(t){const e=t.value,i=t.styleSpec,r=i.light,n=t.style;let a=[];const s=Qn(e);if(void 0===e)return a;if("object"!==s)return a=a.concat([new Oe("light",e,`object expected, ${s} found`)]),a;for(const s in e){const o=s.match(/^(.*)-transition$/);a=a.concat(o&&r[o[1]]&&r[o[1]].transition?t.validateSpec({key:s,value:e[s],valueSpec:i.transition,validateSpec:t.validateSpec,style:n,styleSpec:i}):r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Oe(s,e[s],`unknown property "${s}"`)])}return a}function Ha(t){const e=t.value,i=t.styleSpec,r=i.sky,n=t.style,a=Qn(e);if(void 0===e)return[];if("object"!==a)return[new Oe("sky",e,`object expected, ${a} found`)];let s=[];for(const a in e)s=s.concat(r[a]?t.validateSpec({key:a,value:e[a],valueSpec:r[a],style:n,styleSpec:i}):[new Oe(a,e[a],`unknown property "${a}"`)]);return s}function Xa(t){const e=t.value,i=t.styleSpec,r=i.terrain,n=t.style;let a=[];const s=Qn(e);if(void 0===e)return a;if("object"!==s)return a=a.concat([new Oe("terrain",e,`object expected, ${s} found`)]),a;for(const s in e)a=a.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Oe(s,e[s],`unknown property "${s}"`)]);return a}function Ya(t){let e=[];const i=t.value,r=t.key;if(Array.isArray(i)){const n=[],a=[];for(const s in i)i[s].id&&n.includes(i[s].id)&&e.push(new Oe(r,i,`all the sprites' ids must be unique, but ${i[s].id} is duplicated`)),n.push(i[s].id),i[s].url&&a.includes(i[s].url)&&e.push(new Oe(r,i,`all the sprites' URLs must be unique, but ${i[s].url} is duplicated`)),a.push(i[s].url),e=e.concat(za({key:`${r}[${s}]`,value:i[s],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Ga({key:r,value:i})}function Ka(t){return e=t.value,Boolean(e)&&e.constructor===Object?[]:[new Oe(t.key,t.value,`object expected, ${Qn(t.value)} found`)];var e}const Ja={"*":()=>[],array:Da,boolean:function(t){const e=t.value,i=t.key,r=Qn(e);return"boolean"!==r?[new Oe(i,e,`boolean expected, ${r} found`)]:[]},number:ka,color:Fa,constants:Ca,enum:Ba,filter:Oa,function:Ra,layer:Za,object:za,source:qa,light:Wa,sky:Ha,terrain:Xa,projection:function(t){const e=t.value,i=t.styleSpec,r=i.projection,n=t.style,a=Qn(e);if(void 0===e)return[];if("object"!==a)return[new Oe("projection",e,`object expected, ${a} found`)];let s=[];for(const a in e)s=s.concat(r[a]?t.validateSpec({key:a,value:e[a],valueSpec:r[a],style:n,styleSpec:i}):[new Oe(a,e[a],`unknown property "${a}"`)]);return s},projectionDefinition:function(t){const e=t.key;let i=t.value;i=i instanceof String?i.valueOf():i;const r=Qn(i);return"array"!==r||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(i)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(i)?["array","string"].includes(r)?[]:[new Oe(e,i,`projection expected, invalid type "${r}" found`)]:[new Oe(e,i,`projection expected, invalid array ${JSON.stringify(i)} found`)]},string:Ga,formatted:function(t){return 0===Ga(t).length?[]:La(t)},resolvedImage:function(t){return 0===Ga(t).length?[]:La(t)},padding:function(t){const e=t.key,i=t.value;if("array"===Qn(i)){if(i.length<1||i.length>4)return[new Oe(e,i,`padding requires 1 to 4 values; ${i.length} values found`)];const r={type:"number"};let n=[];for(let a=0;a<i.length;a++)n=n.concat(t.validateSpec({key:`${e}[${a}]`,value:i[a],validateSpec:t.validateSpec,valueSpec:r}));return n}return ka({key:e,value:i,valueSpec:{}})},numberArray:function(t){const e=t.key,i=t.value;if("array"===Qn(i)){const r={type:"number"};if(i.length<1)return[new Oe(e,i,"array length at least 1 expected, length 0 found")];let n=[];for(let a=0;a<i.length;a++)n=n.concat(t.validateSpec({key:`${e}[${a}]`,value:i[a],validateSpec:t.validateSpec,valueSpec:r}));return n}return ka({key:e,value:i,valueSpec:{}})},colorArray:function(t){const e=t.key,i=t.value;if("array"===Qn(i)){if(i.length<1)return[new Oe(e,i,"array length at least 1 expected, length 0 found")];let t=[];for(let r=0;r<i.length;r++)t=t.concat(Fa({key:`${e}[${r}]`,value:i[r]}));return t}return Fa({key:e,value:i})},variableAnchorOffsetCollection:function(t){const e=t.key,i=t.value,r=Qn(i),n=t.styleSpec;if("array"!==r||i.length<1||i.length%2!=0)return[new Oe(e,i,"variableAnchorOffsetCollection requires a non-empty array of even length")];let a=[];for(let r=0;r<i.length;r+=2)a=a.concat(Ba({key:`${e}[${r}]`,value:i[r],valueSpec:n.layout_symbol["text-anchor"]})),a=a.concat(Da({key:`${e}[${r+1}]`,value:i[r+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:n}));return a},sprite:Ya,state:Ka};function Qa(t){const e=t.value,i=t.valueSpec,r=t.styleSpec;return t.validateSpec=Qa,i.expression&&ta(Aa(e))?Ra(t):i.expression&&ca(Ea(e))?La(t):i.type&&Ja[i.type]?Ja[i.type](t):za(je({},t,{valueSpec:i.type?r[i.type]:i}))}function ts(t){const e=t.value,i=t.key,r=Ga(t);return r.length||(-1===e.indexOf("{fontstack}")&&r.push(new Oe(i,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&r.push(new Oe(i,e,'"glyphs" url must include a "{range}" token'))),r}function es(t,e=Me){let i=[];return i=i.concat(Qa({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Qa,objectElementValidators:{glyphs:ts,"*":()=>[]}})),t.constants&&(i=i.concat(Ca({key:"constants",value:t.constants}))),rs(i)}function is(t){return function(e){return t(Object.assign({},e,{validateSpec:Qa}))}}function rs(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function ns(t){return function(...e){return rs(t.apply(this,e))}}es.source=ns(is(qa)),es.sprite=ns(is(Ya)),es.glyphs=ns(is(ts)),es.light=ns(is(Wa)),es.sky=ns(is(Ha)),es.terrain=ns(is(Xa)),es.state=ns(is(Ka)),es.layer=ns(is(Za)),es.filter=ns(is(Oa)),es.paintProperty=ns(is(Na)),es.layoutProperty=ns(is(Ua));const as=Me,ss=es,os=ss.light,ls=ss.sky,cs=ss.paintProperty,hs=ss.layoutProperty;function us(t,e){let i=!1;if(e&&e.length)for(const r of e)t.fire(new Te(new Error(r.message))),i=!0;return i}class ds{constructor(t,e,i){const r=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const n=new Int32Array(this.arrayBuffer);t=n[0],this.d=(e=n[1])+2*(i=n[2]);for(let t=0;t<this.d*this.d;t++){const e=n[3+t],i=n[3+t+1];r.push(e===i?null:n.subarray(e,i))}const a=n[3+r.length+1];this.keys=n.subarray(n[3+r.length],a),this.bboxes=n.subarray(a),this.insert=this._insertReadonly}else{this.d=e+2*i;for(let t=0;t<this.d*this.d;t++)r.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=i,this.scale=e/t,this.uid=0;const n=i/e*t;this.min=-n,this.max=t+n}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,i,r,n,a){this.cells[n].push(a)}query(t,e,i,r,n){const a=this.min,s=this.max;if(t<=a&&e<=a&&s<=i&&s<=r&&!n)return Array.prototype.slice.call(this.keys);{const a=[];return this._forEachCell(t,e,i,r,this._queryCell,a,{},n),a}}_queryCell(t,e,i,r,n,a,s,o){const l=this.cells[n];if(null!==l){const n=this.keys,c=this.bboxes;for(let h=0;h<l.length;h++){const u=l[h];if(void 0===s[u]){const l=4*u;(o?o(c[l+0],c[l+1],c[l+2],c[l+3]):t<=c[l+2]&&e<=c[l+3]&&i>=c[l+0]&&r>=c[l+1])?(s[u]=!0,a.push(n[u])):s[u]=!1}}}}_forEachCell(t,e,i,r,n,a,s,o){const l=this._convertToCellCoord(t),c=this._convertToCellCoord(e),h=this._convertToCellCoord(i),u=this._convertToCellCoord(r);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++){const c=this.d*l+d;if((!o||o(this._convertFromCellCoord(d),this._convertFromCellCoord(l),this._convertFromCellCoord(d+1),this._convertFromCellCoord(l+1)))&&n.call(this,t,e,i,r,c,a,s,o))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let i=0;for(let t=0;t<this.cells.length;t++)i+=this.cells[t].length;const r=new Int32Array(e+i+this.keys.length+this.bboxes.length);r[0]=this.extent,r[1]=this.n,r[2]=this.padding;let n=e;for(let e=0;e<t.length;e++){const i=t[e];r[3+e]=n,r.set(i,n),n+=i.length}return r[3+t.length]=n,r.set(this.keys,n),n+=this.keys.length,r[3+t.length+1]=n,r.set(this.bboxes,n),n+=this.bboxes.length,r.buffer}static serialize(t,e){const i=t.toArrayBuffer();return e&&e.push(i),{buffer:i}}static deserialize(t){return new ds(t.buffer)}}const ps={};function fs(t,e,i={}){if(ps[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ps[t]={klass:e,omit:i.omit||[],shallow:i.shallow||[]}}fs("Object",Object),fs("Set",Set),fs("TransferableGridIndex",ds),fs("Color",Ri),fs("Error",Error),fs("AJAXError",oe),fs("ResolvedImage",$i),fs("StylePropertyFunction",fa),fs("StyleExpression",la,{omit:["_evaluator"]}),fs("ZoomDependentExpression",da),fs("ZoomConstantExpression",ua),fs("CompoundExpression",jn,{omit:["_evaluate"]});for(const t in On)On[t]._classRegistryKey||fs(`Expression_${t}`,On[t]);function ms(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function _s(t){return t.$name||t.constructor._classRegistryKey}function gs(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=_s(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||ms(t)||Ot(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function ys(t,e){if(gs(t))return(ms(t)||Ot(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const i=[];for(const r of t)i.push(ys(r,e));return i}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const i=_s(t);if(!i)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!ps[i])throw new Error(`${i} is not registered.`);const{klass:r}=ps[i],n=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&n===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const r in t){if(!t.hasOwnProperty(r))continue;if(ps[i].omit.indexOf(r)>=0)continue;const a=t[r];n[r]=ps[i].shallow.indexOf(r)>=0?a:ys(a,e)}t instanceof Error&&(n.message=t.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==i&&(n.$name=i),n}function xs(t){if(gs(t))return t;if(Array.isArray(t))return t.map(xs);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=_s(t)||"Object";if(!ps[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:i}=ps[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const i of Object.keys(t)){if("$name"===i)continue;const n=t[i];r[i]=ps[e].shallow.indexOf(i)>=0?n:xs(n)}return r}class vs{constructor(){this.first=!0}update(t,e){const i=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=i,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=i,!0):(this.lastFloorZoom>i?(this.lastIntegerZoom=i+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<i&&(this.lastIntegerZoom=i,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=i,!0))}}const bs=t=>t>=12288&&t<=12351,ws=t=>t>=12448&&t<=12543,Ts=t=>t>=65280&&t<=65519;function Ps(t){for(const e of t)if(Is(e.charCodeAt(0)))return!0;return!1}function Ms(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}Ms(["Arab","Dupl","Mong","Ougr","Syrc"]);const Ss=Ms(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function Is(t){return!(746!==t&&747!==t&&(t<4352||!((t=>t>=65072&&t<=65103)(t)&&!(t>=65097&&t<=65103)||(t=>t>=13056&&t<=13311)(t)||(t=>t>=12736&&t<=12783)(t)||!(!bs(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||(t=>t>=12800&&t<=13055)(t)||(t=>t>=12272&&t<=12287)(t)||(t=>t>=12688&&t<=12703)(t)||ws(t)&&12540!==t||!(!Ts(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!(t=>t>=65104&&t<=65135)(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=65040&&t<=65055)(t)||(t=>t>=19904&&t<=19967)(t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||Ss.test(String.fromCodePoint(t)))))}const Cs=Ms(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function As(t){return Cs.test(String.fromCodePoint(t))}function Es(t,e){return!(!e&&As(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function zs(t){for(const e of t)if(As(e.charCodeAt(0)))return!0;return!1}const Ds=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(Ds.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,e){return n(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const i=t.pluginURL,r=new Promise((t=>{this.loadScriptResolve=t}));e(i);const n=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([r,n]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:i};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${i}`)}))}};class ks{constructor(t,e){this.isSupportedScript=Rs,this.zoom=t,e?(this.now=e.now||0,this.fadeDuration=e.fadeDuration||0,this.zoomHistory=e.zoomHistory||new vs,this.transition=e.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new vs,this.transition={})}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),i=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*i}:{fromScale:.5,toScale:1,t:1-(1-i)*e}}}function Rs(t){return function(t,e){for(const i of t)if(!Es(i.charCodeAt(0),e))return!1;return!0}(t,"loaded"===Ds.getRTLTextPluginStatus())}class Ls{constructor(t,e,i){this.property=t,this.value=e,this.expression=function(t,e,i){if(ta(t))return new fa(t,e);if(ca(t)){const r=pa(t,e,i);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let i=t;return"color"===e.type&&"string"==typeof t?i=Ri.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"numberArray"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"colorArray"!==e.type||"string"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?i=Gi.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(i=qi.parse(t)):i=Ni.parse(t):i=Vi.parse(t):i=ji.parse(t),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>i}}}(void 0===e?t.specification.default:e,t.specification,i)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(t,e,i){return this.property.possiblyEvaluate(this,t,e,i)}}class Fs{constructor(t,e){this.property=t,this.value=new Ls(t,void 0,e)}transitioned(t,e){return new Os(this.property,this.value,e,wt({},t.transition,this.transition),t.now)}untransitioned(){return new Os(this.property,this.value,null,{},0)}}class Bs{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues),this._globalState=e}getValue(t){return zt(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Fs(this._values[t].property,this._globalState)),this._values[t].value=new Ls(this._values[t].property,null===e?void 0:zt(e),this._globalState)}getTransition(t){return zt(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new Fs(this._values[t].property,this._globalState)),this._values[t].transition=zt(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i);const r=this.getTransition(e);void 0!==r&&(t[`${e}-transition`]=r)}return t}transitioned(t,e){const i=new js(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(t,e._values[r]);return i}untransitioned(){const t=new js(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Os{constructor(t,e,i,r,n){this.property=t,this.value=e,this.begin=n+r.delay||0,this.end=this.begin+r.duration||0,t.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(t,e,i){const r=t.now||0,n=this.value.possiblyEvaluate(t,e,i),a=this.prior;if(a){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return a.possiblyEvaluate(t,e,i);{const s=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(a.possiblyEvaluate(t,e,i),n,gt(s))}}return n}}class js{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,i){const r=new Us(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class Vs{constructor(t,e){this._properties=t,this._values=Object.create(t.defaultPropertyValues),this._globalState=e}hasValue(t){return void 0!==this._values[t].value}getValue(t){return zt(this._values[t].value)}setValue(t,e){this._values[t]=new Ls(this._values[t].property,null===e?void 0:zt(e),this._globalState)}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i)}return t}possiblyEvaluate(t,e,i){const r=new Us(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}}class Ns{constructor(t,e,i){this.property=t,this.value=e,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,i,r){return this.property.evaluate(this.value,this.parameters,t,e,i,r)}}class Us{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class Zs{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,i){const r=wr[this.specification.type];return r?r(t,e,i):t}}class Gs{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,i,r){return new Ns(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},i,r)}:t.expression,e)}interpolate(t,e,i){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Ns(this,{kind:"constant",value:void 0},t.parameters);const r=wr[this.specification.type];if(r){const n=r(t.value.value,e.value.value,i);return new Ns(this,{kind:"constant",value:n},t.parameters)}return t}evaluate(t,e,i,r,n,a){return"constant"===t.kind?t.value:t.evaluate(e,i,r,n,a)}}class $s extends Gs{possiblyEvaluate(t,e,i,r){if(void 0===t.value)return new Ns(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r),a="resolvedImage"===t.property.specification.type&&"string"!=typeof n?n.name:n,s=this._calculate(a,a,a,e);return new Ns(this,{kind:"constant",value:s},e)}if("camera"===t.expression.kind){const i=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Ns(this,{kind:"constant",value:i},e)}return new Ns(this,t.expression,e)}evaluate(t,e,i,r,n,a){if("source"===t.kind){const s=t.evaluate(e,i,r,n,a);return this._calculate(s,s,s,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},i,r),t.evaluate({zoom:Math.floor(e.zoom)},i,r),t.evaluate({zoom:Math.floor(e.zoom)+1},i,r),e):t.value}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class qs{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){if(void 0!==t.value){if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r);return this._calculate(n,n,n,e)}return this._calculate(t.expression.evaluate(new ks(Math.floor(e.zoom-1),e)),t.expression.evaluate(new ks(Math.floor(e.zoom),e)),t.expression.evaluate(new ks(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class Ws{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){return!!t.expression.evaluate(e,null,{},i,r)}interpolate(){return!1}}class Hs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const i=t[e];i.specification.overridable&&this.overridableProperties.push(e);const r=this.defaultPropertyValues[e]=new Ls(i,void 0,void 0),n=this.defaultTransitionablePropertyValues[e]=new Fs(i,void 0);this.defaultTransitioningPropertyValues[e]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=r.possiblyEvaluate({})}}}fs("DataDrivenProperty",Gs),fs("DataConstantProperty",Zs),fs("CrossFadedDataDrivenProperty",$s),fs("CrossFadedProperty",qs),fs("ColorRampProperty",Ws);const Xs="-transition";class Ys extends Pe{constructor(t,e,i){if(super(),this.id=t.id,this.type=t.type,this._globalState=i,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter,this._featureFilter=va(t.filter,i)),e.layout&&(this._unevaluatedLayout=new Vs(e.layout,i)),e.paint)){this._transitionablePaint=new Bs(e.paint,i);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Us(e.paint)}}setFilter(t){this.filter=t,this._featureFilter=va(t,this._globalState)}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}getLayoutAffectingGlobalStateRefs(){const t=new Set;if(this._unevaluatedLayout)for(const e in this._unevaluatedLayout._values){const i=this._unevaluatedLayout._values[e];for(const e of i.getGlobalStateRefs())t.add(e)}for(const e of this._featureFilter.getGlobalStateRefs())t.add(e);return t}getPaintAffectingGlobalStateRefs(){var t;const e=new globalThis.Map;if(this._transitionablePaint)for(const i in this._transitionablePaint._values){const r=this._transitionablePaint._values[i].value;for(const n of r.getGlobalStateRefs()){const a=null!==(t=e.get(n))&&void 0!==t?t:[];a.push({name:i,value:r.value}),e.set(n,a)}}return e}setLayoutProperty(t,e,i={}){null!=e&&this._validate(hs,`layers.${this.id}.layout.${t}`,t,e,i)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(Xs)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,i={}){if(null!=e&&this._validate(cs,`layers.${this.id}.paint.${t}`,t,e,i))return!1;if(t.endsWith(Xs))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const i=this._transitionablePaint._values[t],r="cross-faded-data-driven"===i.property.specification["property-type"],n=i.value.isDataDriven(),a=i.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const s=this._transitionablePaint._values[t].value;return s.isDataDriven()||n||r||this._handleOverridablePaintPropertyUpdate(t,a,s)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,i){return!1}isHidden(t,e=!1){return!!(this.minzoom&&t<(e?Math.floor(this.minzoom):this.minzoom))||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),At(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&us(this,t.call(ss,{key:e,layerType:this.type,objectKey:i,value:r,styleSpec:Me,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Ns&&Yn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}let Ks;var Js={get paint(){return Ks=Ks||new Hs({"raster-opacity":new Zs(Me.paint_raster["raster-opacity"]),"raster-hue-rotate":new Zs(Me.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Zs(Me.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Zs(Me.paint_raster["raster-brightness-max"]),"raster-saturation":new Zs(Me.paint_raster["raster-saturation"]),"raster-contrast":new Zs(Me.paint_raster["raster-contrast"]),"raster-resampling":new Zs(Me.paint_raster["raster-resampling"]),"raster-fade-duration":new Zs(Me.paint_raster["raster-fade-duration"])})}};const Qs=t=>"raster"===t.type;class to extends Ys{constructor(t,e){super(t,Js,e)}}const eo={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class io{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class ro{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function no(t,e=1){let i=0,r=0;return{members:t.map((t=>{const n=eo[t.type].BYTES_PER_ELEMENT,a=i=ao(i,Math.max(e,n)),s=t.components||1;return r=Math.max(r,n),i+=n*s,{name:t.name,type:t.type,components:s,offset:a}})),size:ao(i,Math.max(r,e)),alignment:e}}function ao(t,e){return Math.ceil(t/e)*e}class so extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.int16[r+0]=e,this.int16[r+1]=i,t}}so.prototype.bytesPerElement=4,fs("StructArrayLayout2i4",so);class oo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.int16[n+0]=e,this.int16[n+1]=i,this.int16[n+2]=r,t}}oo.prototype.bytesPerElement=6,fs("StructArrayLayout3i6",oo);class lo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const a=4*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,t}}lo.prototype.bytesPerElement=8,fs("StructArrayLayout4i8",lo);class co extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n,a)}emplace(t,e,i,r,n,a,s){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=n,this.int16[o+4]=a,this.int16[o+5]=s,t}}co.prototype.bytesPerElement=12,fs("StructArrayLayout2i4i12",co);class ho extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n,a)}emplace(t,e,i,r,n,a,s){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=i,this.uint8[l+4]=r,this.uint8[l+5]=n,this.uint8[l+6]=a,this.uint8[l+7]=s,t}}ho.prototype.bytesPerElement=8,fs("StructArrayLayout2i4ub8",ho);class uo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.float32[r+0]=e,this.float32[r+1]=i,t}}uo.prototype.bytesPerElement=8,fs("StructArrayLayout2f8",uo);class po extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a,s,o,l,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,i,r,n,a,s,o,l,c)}emplace(t,e,i,r,n,a,s,o,l,c,h){const u=10*t;return this.uint16[u+0]=e,this.uint16[u+1]=i,this.uint16[u+2]=r,this.uint16[u+3]=n,this.uint16[u+4]=a,this.uint16[u+5]=s,this.uint16[u+6]=o,this.uint16[u+7]=l,this.uint16[u+8]=c,this.uint16[u+9]=h,t}}po.prototype.bytesPerElement=20,fs("StructArrayLayout10ui20",po);class fo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a,s,o){const l=this.length;return this.resize(l+1),this.emplace(l,t,e,i,r,n,a,s,o)}emplace(t,e,i,r,n,a,s,o,l){const c=8*t;return this.uint16[c+0]=e,this.uint16[c+1]=i,this.uint16[c+2]=r,this.uint16[c+3]=n,this.uint16[c+4]=a,this.uint16[c+5]=s,this.uint16[c+6]=o,this.uint16[c+7]=l,t}}fo.prototype.bytesPerElement=16,fs("StructArrayLayout8ui16",fo);class mo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a,s,o,l,c,h,u){const d=this.length;return this.resize(d+1),this.emplace(d,t,e,i,r,n,a,s,o,l,c,h,u)}emplace(t,e,i,r,n,a,s,o,l,c,h,u,d){const p=12*t;return this.int16[p+0]=e,this.int16[p+1]=i,this.int16[p+2]=r,this.int16[p+3]=n,this.uint16[p+4]=a,this.uint16[p+5]=s,this.uint16[p+6]=o,this.uint16[p+7]=l,this.int16[p+8]=c,this.int16[p+9]=h,this.int16[p+10]=u,this.int16[p+11]=d,t}}mo.prototype.bytesPerElement=24,fs("StructArrayLayout4i4ui4i24",mo);class _o extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.float32[n+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}_o.prototype.bytesPerElement=12,fs("StructArrayLayout3f12",_o);class go extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}go.prototype.bytesPerElement=4,fs("StructArrayLayout1ul4",go);class yo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a,s,o,l){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,i,r,n,a,s,o,l)}emplace(t,e,i,r,n,a,s,o,l,c){const h=10*t,u=5*t;return this.int16[h+0]=e,this.int16[h+1]=i,this.int16[h+2]=r,this.int16[h+3]=n,this.int16[h+4]=a,this.int16[h+5]=s,this.uint32[u+3]=o,this.uint16[h+8]=l,this.uint16[h+9]=c,t}}yo.prototype.bytesPerElement=20,fs("StructArrayLayout6i1ul2ui20",yo);class xo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n,a)}emplace(t,e,i,r,n,a,s){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=n,this.int16[o+4]=a,this.int16[o+5]=s,t}}xo.prototype.bytesPerElement=12,fs("StructArrayLayout2i2i2i12",xo);class vo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,i,r,n)}emplace(t,e,i,r,n,a){const s=4*t,o=8*t;return this.float32[s+0]=e,this.float32[s+1]=i,this.float32[s+2]=r,this.int16[o+6]=n,this.int16[o+7]=a,t}}vo.prototype.bytesPerElement=16,fs("StructArrayLayout2f1f2i16",vo);class bo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n,a)}emplace(t,e,i,r,n,a,s){const o=16*t,l=4*t,c=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=i,this.float32[l+1]=r,this.float32[l+2]=n,this.int16[c+6]=a,this.int16[c+7]=s,t}}bo.prototype.bytesPerElement=16,fs("StructArrayLayout2ub2f2i16",bo);class wo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[n+0]=e,this.uint16[n+1]=i,this.uint16[n+2]=r,t}}wo.prototype.bytesPerElement=6,fs("StructArrayLayout3ui6",wo);class To extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_)}emplace(t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g){const y=24*t,x=12*t,v=48*t;return this.int16[y+0]=e,this.int16[y+1]=i,this.uint16[y+2]=r,this.uint16[y+3]=n,this.uint32[x+2]=a,this.uint32[x+3]=s,this.uint32[x+4]=o,this.uint16[y+10]=l,this.uint16[y+11]=c,this.uint16[y+12]=h,this.float32[x+7]=u,this.float32[x+8]=d,this.uint8[v+36]=p,this.uint8[v+37]=f,this.uint8[v+38]=m,this.uint32[x+10]=_,this.int16[y+22]=g,t}}To.prototype.bytesPerElement=48,fs("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",To);class Po extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g,y,x,v,b,w,T,P,M,S,I){const C=this.length;return this.resize(C+1),this.emplace(C,t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g,y,x,v,b,w,T,P,M,S,I)}emplace(t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g,y,x,v,b,w,T,P,M,S,I,C){const A=32*t,E=16*t;return this.int16[A+0]=e,this.int16[A+1]=i,this.int16[A+2]=r,this.int16[A+3]=n,this.int16[A+4]=a,this.int16[A+5]=s,this.int16[A+6]=o,this.int16[A+7]=l,this.uint16[A+8]=c,this.uint16[A+9]=h,this.uint16[A+10]=u,this.uint16[A+11]=d,this.uint16[A+12]=p,this.uint16[A+13]=f,this.uint16[A+14]=m,this.uint16[A+15]=_,this.uint16[A+16]=g,this.uint16[A+17]=y,this.uint16[A+18]=x,this.uint16[A+19]=v,this.uint16[A+20]=b,this.uint16[A+21]=w,this.uint16[A+22]=T,this.uint32[E+12]=P,this.float32[E+13]=M,this.float32[E+14]=S,this.uint16[A+30]=I,this.uint16[A+31]=C,t}}Po.prototype.bytesPerElement=64,fs("StructArrayLayout8i15ui1ul2f2ui64",Po);class Mo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Mo.prototype.bytesPerElement=4,fs("StructArrayLayout1f4",Mo);class So extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[6*t+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}So.prototype.bytesPerElement=12,fs("StructArrayLayout1ui2f12",So);class Io extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=4*t;return this.uint32[2*t+0]=e,this.uint16[n+2]=i,this.uint16[n+3]=r,t}}Io.prototype.bytesPerElement=8,fs("StructArrayLayout1ul2ui8",Io);class Co extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.uint16[r+0]=e,this.uint16[r+1]=i,t}}Co.prototype.bytesPerElement=4,fs("StructArrayLayout2ui4",Co);class Ao extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Ao.prototype.bytesPerElement=2,fs("StructArrayLayout1ui2",Ao);class Eo extends ro{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const a=4*t;return this.float32[a+0]=e,this.float32[a+1]=i,this.float32[a+2]=r,this.float32[a+3]=n,t}}Eo.prototype.bytesPerElement=16,fs("StructArrayLayout4f16",Eo);class zo extends io{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new a(this.anchorPointX,this.anchorPointY)}}zo.prototype.size=20;class Do extends yo{get(t){return new zo(this,t)}}fs("CollisionBoxArray",Do);class ko extends io{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}ko.prototype.size=48;class Ro extends To{get(t){return new ko(this,t)}}fs("PlacedSymbolArray",Ro);class Lo extends io{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Lo.prototype.size=64;class Fo extends Po{get(t){return new Lo(this,t)}}fs("SymbolInstanceArray",Fo);class Bo extends Mo{getoffsetX(t){return this.float32[1*t+0]}}fs("GlyphOffsetArray",Bo);class Oo extends oo{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}fs("SymbolLineVertexArray",Oo);class jo extends io{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}jo.prototype.size=12;class Vo extends So{get(t){return new jo(this,t)}}fs("TextAnchorOffsetArray",Vo);class No extends io{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}No.prototype.size=8;class Uo extends Io{get(t){return new No(this,t)}}fs("FeatureIndexArray",Uo);class Zo extends so{}class Go extends oo{}class $o extends lo{}class qo extends so{}class Wo extends so{}class Ho extends co{}class Xo extends ho{}class Yo extends uo{}class Ko extends po{}class Jo extends fo{}class Qo extends mo{}class tl extends _o{}class el extends go{}class il extends xo{}class rl extends vo{}class nl extends bo{}class al extends wo{}class sl extends wo{}class ol extends Co{}class ll extends Ao{}const cl=no([{name:"a_pos",components:2,type:"Int16"}],4),{members:hl}=cl;class ul{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,i,r){const n=this.segments[this.segments.length-1];return t>ul.MAX_VERTEX_ARRAY_LENGTH&&kt(`Max vertices per segment is ${ul.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${ul.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!n||n.vertexLength+t>ul.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r?this.createNewSegment(e,i,r):n}createNewSegment(t,e,i){const r={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==i&&(r.sortKey=i),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(r),r}getOrCreateLatestSegment(t,e,i){return this.prepareSegment(0,t,e,i)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,i,r){return new ul([{vertexOffset:t,primitiveOffset:e,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function dl(t,e){return 256*(t=vt(Math.floor(t),0,255))+vt(Math.floor(e),0,255)}ul.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,fs("SegmentVector",ul);const pl=no([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]),fl=no([{name:"a_dasharray_from",components:4,type:"Uint16"},{name:"a_dasharray_to",components:4,type:"Uint16"}]);var ml,_l,gl,yl={exports:{}},xl={exports:{}},vl={exports:{}},bl=function(){if(gl)return yl.exports;gl=1;var t=(ml||(ml=1,function(t){t.exports=function(t,e){var i,r,n,a,s,o,l,c;for(r=t.length-(i=3&t.length),n=e,s=3432918353,o=461845907,c=0;c<r;)l=255&t.charCodeAt(c)|(255&t.charCodeAt(++c))<<8|(255&t.charCodeAt(++c))<<16|(255&t.charCodeAt(++c))<<24,++c,n=27492+(65535&(a=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(a>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&t.charCodeAt(c+2))<<16;case 2:l^=(255&t.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(c)))*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295}return n^=t.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(xl)),xl.exports),e=(_l||(_l=1,function(t){t.exports=function(t,e){for(var i,r=t.length,n=e^r,a=0;r>=4;)i=1540483477*(65535&(i=255&t.charCodeAt(a)|(255&t.charCodeAt(++a))<<8|(255&t.charCodeAt(++a))<<16|(255&t.charCodeAt(++a))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++a;switch(r){case 3:n^=(255&t.charCodeAt(a+2))<<16;case 2:n^=(255&t.charCodeAt(a+1))<<8;case 1:n=1540483477*(65535&(n^=255&t.charCodeAt(a)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(vl)),vl.exports);return yl.exports=t,yl.exports.murmur3=t,yl.exports.murmur2=e,yl.exports}(),wl=s(bl);class Tl{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,i,r){this.ids.push(Pl(t)),this.positions.push(e,i,r)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=Pl(t);let i=0,r=this.ids.length-1;for(;i<r;){const t=i+r>>1;this.ids[t]>=e?r=t:i=t+1}const n=[];for(;this.ids[i]===e;)n.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return n}static serialize(t,e){const i=new Float64Array(t.ids),r=new Uint32Array(t.positions);return Ml(i,r,0,i.length-1),e&&e.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(t){const e=new Tl;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Pl(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:wl(String(t))}function Ml(t,e,i,r){for(;i<r;){const n=t[i+r>>1];let a=i-1,s=r+1;for(;;){do{a++}while(t[a]<n);do{s--}while(t[s]>n);if(a>=s)break;Sl(t,a,s),Sl(e,3*a,3*s),Sl(e,3*a+1,3*s+1),Sl(e,3*a+2,3*s+2)}s-i<r-s?(Ml(t,e,i,s),i=s+1):(Ml(t,e,s+1,r),r=s)}}function Sl(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}fs("FeaturePositionMap",Tl);class Il{constructor(t,e){this.gl=t.gl,this.location=e}}class Cl extends Il{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t))}}class Al extends Il{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class El extends Il{constructor(t,e){super(t,e),this.current=[0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]))}}class zl extends Il{constructor(t,e){super(t,e),this.current=[0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]))}}class Dl extends Il{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class kl extends Il{constructor(t,e){super(t,e),this.current=Ri.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}class Rl extends Il{constructor(t,e){super(t,e),this.current=new Array}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(4*t.length);for(let i=0;i<t.length;i++)e[4*i]=t[i].r,e[4*i+1]=t[i].g,e[4*i+2]=t[i].b,e[4*i+3]=t[i].a;this.gl.uniform4fv(this.location,e)}}}class Ll extends Il{constructor(t,e){super(t,e),this.current=new Array}set(t){if(t!=this.current){this.current=t;const e=new Float32Array(t);this.gl.uniform1fv(this.location,e)}}}const Fl=new Float32Array(16);class Bl extends Il{constructor(t,e){super(t,e),this.current=Fl}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}}function Ol(t){return[dl(255*t.r,255*t.g),dl(255*t.b,255*t.a)]}class jl{constructor(t,e,i){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=i}setUniform(t,e,i){t.set(i.constantOr(this.value))}getBinding(t,e,i){return"color"===this.type?new kl(t,e):new Al(t,e)}}class Vl{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setConstantDashPositions(t,e){this.dashTo=[0,t.y,t.height,t.width],this.dashFrom=[0,e.y,e.height,e.width]}setUniform(t,e,i,r){let n=null;"u_pattern_to"===r?n=this.patternTo:"u_pattern_from"===r?n=this.patternFrom:"u_dasharray_to"===r?n=this.dashTo:"u_dasharray_from"===r?n=this.dashFrom:"u_pixel_ratio_to"===r?n=this.pixelRatioTo:"u_pixel_ratio_from"===r&&(n=this.pixelRatioFrom),null!==n&&t.set(n)}getBinding(t,e,i){return"u_pattern"===i.substr(0,9)||"u_dasharray_"===i.substr(0,12)?new Dl(t,e):new Al(t,e)}}class Nl{constructor(t,e,i,r){this.expression=t,this.type=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(t,e,i){const r=this.paintVertexArray.length,n=this.expression.evaluate(new ks(0,i),e,{},i.canonical,[],i.formattedSection);this.paintVertexArray.resize(t),this._setPaintValue(r,t,n)}updatePaintArray(t,e,i,r,n){const a=this.expression.evaluate(new ks(0,n),i,r);this._setPaintValue(t,e,a)}_setPaintValue(t,e,i){if("color"===this.type){const r=Ol(i);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class Ul{constructor(t,e,i,r,n,a){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new a}populatePaintArray(t,e,i){const r=this.expression.evaluate(new ks(this.zoom,i),e,{},i.canonical,[],i.formattedSection),n=this.expression.evaluate(new ks(this.zoom+1,i),e,{},i.canonical,[],i.formattedSection),a=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(a,t,r,n)}updatePaintArray(t,e,i,r,n){const a=this.expression.evaluate(new ks(this.zoom,n),i,r),s=this.expression.evaluate(new ks(this.zoom+1,n),i,r);this._setPaintValue(t,e,a,s)}_setPaintValue(t,e,i,r){if("color"===this.type){const n=Ol(i),a=Ol(r);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,n[0],n[1],a[0],a[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const i=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,r=vt(this.expression.interpolationFactor(i,this.zoom,this.zoom+1),0,1);t.set(r)}getBinding(t,e,i){return new Al(t,e)}}class Zl{constructor(t,e,i,r,n,a){this.expression=t,this.type=e,this.useIntegerZoom=i,this.zoom=r,this.layerId=a,this.zoomInPaintVertexArray=new n,this.zoomOutPaintVertexArray=new n}populatePaintArray(t,e,i){const r=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(r,t,this.getPositionIds(e),i)}updatePaintArray(t,e,i,r,n){this._setPaintValues(t,e,this.getPositionIds(i),n)}_setPaintValues(t,e,i,r){const n=this.getPositions(r);if(!n||!i)return;const a=n[i.min],s=n[i.mid],o=n[i.max];if(a&&s&&o)for(let i=t;i<e;i++)this.emplace(this.zoomInPaintVertexArray,i,s,a),this.emplace(this.zoomOutPaintVertexArray,i,s,o)}upload(t){if(this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer){const e=this.getVertexAttributes();this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,e,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,e,this.expression.isStateDependent)}}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class Gl extends Zl{getPositions(t){return t.imagePositions}getPositionIds(t){return t.patterns&&t.patterns[this.layerId]}getVertexAttributes(){return pl.members}emplace(t,e,i,r){t.emplace(e,i.tlbr[0],i.tlbr[1],i.tlbr[2],i.tlbr[3],r.tlbr[0],r.tlbr[1],r.tlbr[2],r.tlbr[3],i.pixelRatio,r.pixelRatio)}}class $l extends Zl{getPositions(t){return t.dashPositions}getPositionIds(t){return t.dashes&&t.dashes[this.layerId]}getVertexAttributes(){return fl.members}emplace(t,e,i,r){t.emplace(e,0,i.y,i.height,i.width,0,r.y,r.height,r.width)}}class ql{constructor(t,e,i){this.binders={},this._buffers=[];const r=[];for(const n in t.paint._values){if(!i(n))continue;const a=t.paint.get(n);if(!(a instanceof Ns&&Yn(a.property.specification)))continue;const s=Hl(n,t.type),o=a.value,l=a.property.specification.type,c=a.property.useIntegerZoom,h=a.property.specification["property-type"],u="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===o.kind)this.binders[n]=u?new Vl(o.value,s):new jl(o.value,s,l),r.push(`/u_${n}`);else if("source"===o.kind||u){const i=Xl(n,l,"source");this.binders[n]=u?"line-dasharray"===n?new $l(o,l,c,e,i,t.id):new Gl(o,l,c,e,i,t.id):new Nl(o,s,l,i),r.push(`/a_${n}`)}else{const t=Xl(n,l,"composite");this.binders[n]=new Ul(o,s,l,c,e,t),r.push(`/z_${n}`)}}this.cacheKey=r.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof Nl||e instanceof Ul?e.maxValue:0}populatePaintArrays(t,e,i){for(const r in this.binders){const n=this.binders[r];(n instanceof Nl||n instanceof Ul||n instanceof Zl)&&n.populatePaintArray(t,e,i)}}setConstantPatternPositions(t,e){for(const i in this.binders){const r=this.binders[i];r instanceof Vl&&r.setConstantPatternPositions(t,e)}}setConstantDashPositions(t,e){for(const i in this.binders){const r=this.binders[i];r instanceof Vl&&r.setConstantDashPositions(t,e)}}updatePaintArrays(t,e,i,r,n){let a=!1;for(const s in t){const o=e.getPositions(s);for(const e of o){const o=i.feature(e.index);for(const i in this.binders){const l=this.binders[i];if((l instanceof Nl||l instanceof Ul||l instanceof Zl)&&!0===l.expression.isStateDependent){const c=r.paint.get(i);l.expression=c.value,l.updatePaintArray(e.start,e.end,o,t[s],n),a=!0}}}}return a}defines(){const t=[];for(const e in this.binders){const i=this.binders[e];(i instanceof jl||i instanceof Vl)&&t.push(...i.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof Nl||i instanceof Ul)for(let e=0;e<i.paintVertexAttributes.length;e++)t.push(i.paintVertexAttributes[e].name);else if(i instanceof Zl){const e=i.getVertexAttributes();for(const i of e)t.push(i.name)}}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof jl||i instanceof Vl||i instanceof Ul)for(const e of i.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const i=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof jl||n instanceof Vl||n instanceof Ul)for(const a of n.uniformNames)if(e[a]){const s=n.getBinding(t,e[a],a);i.push({name:a,property:r,binding:s})}}return i}setUniforms(t,e,i,r){for(const{name:t,property:n,binding:a}of e)this.binders[n].setUniform(a,r,i.get(n),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const i=this.binders[e];if(t&&i instanceof Zl){const e=2===t.fromScale?i.zoomInPaintVertexBuffer:i.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(i instanceof Nl||i instanceof Ul)&&i.paintVertexBuffer&&this._buffers.push(i.paintVertexBuffer)}}upload(t){for(const e in this.binders){const i=this.binders[e];(i instanceof Nl||i instanceof Ul||i instanceof Zl)&&i.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Nl||e instanceof Ul||e instanceof Zl)&&e.destroy()}}}class Wl{constructor(t,e,i=()=>!0){this.programConfigurations={};for(const r of t)this.programConfigurations[r.id]=new ql(r,e,i);this.needsUpload=!1,this._featureMap=new Tl,this._bufferOffset=0}populatePaintArrays(t,e,i,r){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(t,e,r);void 0!==e.id&&this._featureMap.add(e.id,i,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,i,r){for(const n of i)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(t,this._featureMap,e,n,r)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function Hl(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-dasharray":["dasharray_to","dasharray_from"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Xl(t,e,i){const r={color:{source:uo,composite:Eo},number:{source:Mo,composite:uo}},n=function(t){return{"line-pattern":{source:Ko,composite:Ko},"fill-pattern":{source:Ko,composite:Ko},"fill-extrusion-pattern":{source:Ko,composite:Ko},"line-dasharray":{source:Jo,composite:Jo}}[t]}(t);return n&&n[i]||r[e][i]}fs("ConstantBinder",jl),fs("CrossFadedConstantBinder",Vl),fs("SourceExpressionBinder",Nl),fs("CrossFadedPatternBinder",Gl),fs("CrossFadedDasharrayBinder",$l),fs("CompositeExpressionBinder",Ul),fs("ProgramConfiguration",ql,{omit:["_buffers"]}),fs("ProgramConfigurationSet",Wl);const Yl=Math.pow(2,14)-1,Kl=-Yl-1;function Jl(t){const e=Q/t.extent,i=t.loadGeometry();for(let t=0;t<i.length;t++){const r=i[t];for(let t=0;t<r.length;t++){const i=r[t],n=Math.round(i.x*e),a=Math.round(i.y*e);i.x=vt(n,Kl,Yl),i.y=vt(a,Kl,Yl),(n<i.x||n>i.x+1||a<i.y||a>i.y+1)&&kt("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return i}function Ql(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?Jl(t):[]}}const tc=-32768;function ec(t,e,i,r,n){t.emplaceBack(tc+8*e+r,tc+8*i+n)}class ic{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.layoutVertexArray=new qo,this.indexArray=new sl,this.segments=new ul,this.programConfigurations=new Wl(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){const r=this.layers[0],n=[];let a=null,s=!1,o="heatmap"===r.type;if("circle"===r.type){const t=r;a=t.layout.get("circle-sort-key"),s=!a.isConstant(),o=o||"map"===t.paint.get("circle-pitch-alignment")}const l=o?e.subdivisionGranularity.circle:1;for(const{feature:e,id:r,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ql(e,t);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),c,i))continue;const h=s?a.evaluate(c,{},i):void 0,u={id:r,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?c.geometry:Jl(e),patterns:{},sortKey:h};n.push(u)}s&&n.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of n){const{geometry:n,index:a,sourceLayerIndex:s}=r,o=t[a].feature;this.addFeature(r,n,a,i,l),e.featureIndex.insert(o,n,a,s,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,hl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,i,r,n=1){let a;switch(n){case 1:a=[0,7];break;case 3:a=[0,2,5,7];break;case 5:a=[0,1,3,4,6,7];break;case 7:a=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${n}; valid values are 1, 3, 5, 7.`)}const s=a.length;for(const i of e)for(const e of i){const i=e.x,r=e.y;if(i<0||i>=Q||r<0||r>=Q)continue;const n=this.segments.prepareSegment(s*s,this.layoutVertexArray,this.indexArray,t.sortKey),o=n.vertexLength;for(let t=0;t<s;t++)for(let e=0;e<s;e++)ec(this.layoutVertexArray,i,r,a[e],a[t]);for(let t=0;t<s-1;t++)for(let e=0;e<s-1;e++){const i=o+t*s+e,r=o+(t+1)*s+e;this.indexArray.emplaceBack(i,r+1,i+1),this.indexArray.emplaceBack(i,r,r+1)}n.vertexLength+=s*s,n.primitiveLength+=(s-1)*(s-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:{},canonical:r})}}function rc(t,e){for(let i=0;i<t.length;i++)if(dc(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(dc(t,e[i]))return!0;return!!oc(t,e)}function nc(t,e,i){return!!dc(t,e)||!!cc(e,t,i)}function ac(t,e){if(1===t.length)return uc(e,t[0]);for(let i=0;i<e.length;i++){const r=e[i];for(let e=0;e<r.length;e++)if(dc(t,r[e]))return!0}for(let i=0;i<t.length;i++)if(uc(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(oc(t,e[i]))return!0;return!1}function sc(t,e,i){if(t.length>1){if(oc(t,e))return!0;for(let r=0;r<e.length;r++)if(cc(e[r],t,i))return!0}for(let r=0;r<t.length;r++)if(cc(t[r],e,i))return!0;return!1}function oc(t,e){if(0===t.length||0===e.length)return!1;for(let i=0;i<t.length-1;i++){const r=t[i],n=t[i+1];for(let t=0;t<e.length-1;t++)if(lc(r,n,e[t],e[t+1]))return!0}return!1}function lc(t,e,i,r){return Rt(t,i,r)!==Rt(e,i,r)&&Rt(t,e,i)!==Rt(t,e,r)}function cc(t,e,i){const r=i*i;if(1===e.length)return t.distSqr(e[0])<r;for(let i=1;i<e.length;i++)if(hc(t,e[i-1],e[i])<r)return!0;return!1}function hc(t,e,i){const r=e.distSqr(i);if(0===r)return t.distSqr(e);const n=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/r;return t.distSqr(n<0?e:n>1?i:i.sub(e)._mult(n)._add(e))}function uc(t,e){let i,r,n,a=!1;for(let s=0;s<t.length;s++){i=t[s];for(let t=0,s=i.length-1;t<i.length;s=t++)r=i[t],n=i[s],r.y>e.y!=n.y>e.y&&e.x<(n.x-r.x)*(e.y-r.y)/(n.y-r.y)+r.x&&(a=!a)}return a}function dc(t,e){let i=!1;for(let r=0,n=t.length-1;r<t.length;n=r++){const a=t[r],s=t[n];a.y>e.y!=s.y>e.y&&e.x<(s.x-a.x)*(e.y-a.y)/(s.y-a.y)+a.x&&(i=!i)}return i}function pc(t,e,i){const r=i[0],n=i[2];if(t.x<r.x&&e.x<r.x||t.x>n.x&&e.x>n.x||t.y<r.y&&e.y<r.y||t.y>n.y&&e.y>n.y)return!1;const a=Rt(t,e,i[0]);return a!==Rt(t,e,i[1])||a!==Rt(t,e,i[2])||a!==Rt(t,e,i[3])}function fc(t,e,i){const r=e.paint.get(t).value;return"constant"===r.kind?r.value:i.programConfigurations.get(e.id).getMaxValue(t)}function mc(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function _c(t,e,i,r,n){if(!e[0]&&!e[1])return t;const s=a.convert(e)._mult(n);"viewport"===i&&s._rotate(-r);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(s));return o}function gc({queryGeometry:t,size:e},i){return nc(t,i,e)}function yc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n},a){return nc(t,a,e*(i.projectTileCoordinates(a.x,a.y,r,n).signedDistanceFromCamera/i.cameraToCenterDistance))}function xc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n},a){const s=i.projectTileCoordinates(a.x,a.y,r,n).signedDistanceFromCamera,o=e*(i.cameraToCenterDistance/s);return nc(t,wc(a,i,r,n),o)}function vc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n},a){return nc(t,wc(a,i,r,n),e)}function bc({queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n,pitchAlignment:a="map",pitchScale:s="map"},o){const l="map"===a?"map"===s?gc:yc:"map"===s?xc:vc,c={queryGeometry:t,size:e,transform:i,unwrappedTileID:r,getElevation:n};for(const t of o)for(const e of t)if(l(c,e))return!0;return!1}function wc(t,e,i,r){const n=e.projectTileCoordinates(t.x,t.y,i,r).point;return new a((.5*n.x+.5)*e.width,(.5*-n.y+.5)*e.height)}let Tc,Pc;fs("CircleBucket",ic,{omit:["layers"]});var Mc={get paint(){return Pc=Pc||new Hs({"circle-radius":new Gs(Me.paint_circle["circle-radius"]),"circle-color":new Gs(Me.paint_circle["circle-color"]),"circle-blur":new Gs(Me.paint_circle["circle-blur"]),"circle-opacity":new Gs(Me.paint_circle["circle-opacity"]),"circle-translate":new Zs(Me.paint_circle["circle-translate"]),"circle-translate-anchor":new Zs(Me.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Zs(Me.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Zs(Me.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Gs(Me.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Gs(Me.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Gs(Me.paint_circle["circle-stroke-opacity"])})},get layout(){return Tc=Tc||new Hs({"circle-sort-key":new Gs(Me.layout_circle["circle-sort-key"])})}};class Sc extends Ys{constructor(t,e){super(t,Mc,e)}createBucket(t){return new ic(t)}queryRadius(t){const e=t;return fc("circle-radius",this,e)+fc("circle-stroke-width",this,e)+mc(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:a,unwrappedTileID:s,getElevation:o}){const l=_c(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-n.bearingInRadians,a),c=this.paint.get("circle-radius").evaluate(e,i)+this.paint.get("circle-stroke-width").evaluate(e,i),h=this.paint.get("circle-pitch-scale"),u=this.paint.get("circle-pitch-alignment");let d,p;return"map"===u?(d=l,p=c*a):(d=function(t,e,i,r){return t.map((t=>wc(t,e,i,r)))}(l,n,s,o),p=c),bc({queryGeometry:d,size:p,transform:n,unwrappedTileID:s,getElevation:o,pitchAlignment:u,pitchScale:h},r)}}class Ic extends ic{}let Cc;fs("HeatmapBucket",Ic,{omit:["layers"]});var Ac={get paint(){return Cc=Cc||new Hs({"heatmap-radius":new Gs(Me.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Gs(Me.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Zs(Me.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Ws(Me.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Zs(Me.paint_heatmap["heatmap-opacity"])})}};function Ec(t,{width:e,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==e*i*r)throw new RangeError(`mismatched image size. expected: ${n.length} but got: ${e*i*r}`)}else n=new Uint8Array(e*i*r);return t.width=e,t.height=i,t.data=n,t}function zc(t,{width:e,height:i},r){if(e===t.width&&i===t.height)return;const n=Ec({},{width:e,height:i},r);Dc(t,n,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,i)},r),t.width=e,t.height=i,t.data=n.data}function Dc(t,e,i,r,n,a){if(0===n.width||0===n.height)return e;if(n.width>t.width||n.height>t.height||i.x>t.width-n.width||i.y>t.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>e.width||n.height>e.height||r.x>e.width-n.width||r.y>e.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const s=t.data,o=e.data;if(s===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<n.height;l++){const c=((i.y+l)*t.width+i.x)*a,h=((r.y+l)*e.width+r.x)*a;for(let t=0;t<n.width*a;t++)o[h+t]=s[c+t]}return e}class kc{constructor(t,e){Ec(this,t,1,e)}resize(t){zc(this,t,1)}clone(){return new kc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){Dc(t,e,i,r,n,1)}}class Rc{constructor(t,e){Ec(this,t,4,e)}resize(t){zc(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new Rc({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){Dc(t,e,i,r,n,4)}setPixel(t,e,i){const r=4*(t*this.width+e);this.data[r+0]=Math.round(255*i.r/i.a),this.data[r+1]=Math.round(255*i.g/i.a),this.data[r+2]=Math.round(255*i.b/i.a),this.data[r+3]=Math.round(255*i.a)}}function Lc(t){const e={},i=t.resolution||256,r=t.clips?t.clips.length:1,n=t.image||new Rc({width:i,height:r});if(Math.log(i)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${i}`);const a=(r,a,s)=>{e[t.evaluationKey]=s;const o=t.expression.evaluate(e);n.setPixel(r/4/i,a/4,o)};if(t.clips)for(let e=0,n=0;e<r;++e,n+=4*i)for(let r=0,s=0;r<i;r++,s+=4){const o=r/(i-1),{start:l,end:c}=t.clips[e];a(n,s,l*(1-o)+c*o)}else for(let t=0,e=0;t<i;t++,e+=4)a(0,e,t/(i-1));return n}fs("AlphaImage",kc),fs("RGBAImage",Rc);const Fc="big-fb";class Bc extends Ys{createBucket(t){return new Ic(t)}constructor(t,e){super(t,Ac,e),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=Lc({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(Fc)&&this.heatmapFbos.delete(Fc)}queryRadius(t){return fc("heatmap-radius",this,t)}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:a,unwrappedTileID:s,getElevation:o}){return bc({queryGeometry:t,size:this.paint.get("heatmap-radius").evaluate(e,i)*a,transform:n,unwrappedTileID:s,getElevation:o},r)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Oc;var jc={get paint(){return Oc=Oc||new Hs({"hillshade-illumination-direction":new Zs(Me.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new Zs(Me.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new Zs(Me.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Zs(Me.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Zs(Me.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Zs(Me.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Zs(Me.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new Zs(Me.paint_hillshade["hillshade-method"])})}};class Vc extends Ys{constructor(t,e){super(t,jc,e),this.recalculate({zoom:0,zoomHistory:{}},void 0)}getIlluminationProperties(){let t=this.paint.get("hillshade-illumination-direction").values,e=this.paint.get("hillshade-illumination-altitude").values,i=this.paint.get("hillshade-highlight-color").values,r=this.paint.get("hillshade-shadow-color").values;const n=Math.max(t.length,e.length,i.length,r.length);t=t.concat(Array(n-t.length).fill(t.at(-1))),e=e.concat(Array(n-e.length).fill(e.at(-1))),i=i.concat(Array(n-i.length).fill(i.at(-1))),r=r.concat(Array(n-r.length).fill(r.at(-1)));const a=e.map(Nt);return{directionRadians:t.map(Nt),altitudeRadians:a,shadowColor:r,highlightColor:i}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let Nc;var Uc={get paint(){return Nc=Nc||new Hs({"color-relief-opacity":new Zs(Me["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new Ws(Me["paint_color-relief"]["color-relief-color"])})}};class Zc{constructor(t,e,i,r){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,r)}update(t,e,i){const{width:r,height:n}=t,a=!(this.size&&this.size[0]===r&&this.size[1]===n||i),{context:s}=this,{gl:o}=s;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),s.pixelStoreUnpackFlipY.set(!1),s.pixelStoreUnpack.set(1),s.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),a)this.size=[r,n],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Ot(t)?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,r,n,0,this.format,o.UNSIGNED_BYTE,t.data);else{const{x:e,y:a}=i||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Ot(t)?o.texSubImage2D(o.TEXTURE_2D,0,e,a,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,a,r,n,o.RGBA,o.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D),s.pixelStoreUnpackFlipY.setDefault(),s.pixelStoreUnpack.setDefault(),s.pixelStoreUnpackPremultiplyAlpha.setDefault()}bind(t,e,i){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),i!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=n.LINEAR),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}function Gc(t,e){const i=e[0],r=e[1],n=e[2],a=e[3],s=Math.min(i,r,n),o=Math.round((t+a)/s);return{r:Math.floor(o*s/i)%256,g:Math.floor(o*s/r)%256,b:Math.floor(o*s/n)%256}}fs("DEMData",class{constructor(t,e,i,r=1,n=1,a=1,s=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(i&&!["mapbox","terrarium","custom"].includes(i))return void kt(`"${i}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),i){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=r,this.greenFactor=n,this.blueFactor=a,this.baseShift=s;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const i=this.get(t,e);i>this.max&&(this.max=i),i<this.min&&(this.min=i)}}get(t,e){const i=new Uint8Array(this.data.buffer),r=4*this._idx(t,e);return this.unpack(i[r],i[r+1],i[r+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,i){return t*this.redFactor+e*this.greenFactor+i*this.blueFactor-this.baseShift}pack(t){return Gc(t,this.getUnpackVector())}getPixels(){return new Rc({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,i){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let r=e*this.dim,n=e*this.dim+this.dim,a=i*this.dim,s=i*this.dim+this.dim;switch(e){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:a=s-1;break;case 1:s=a+1}const o=-e*this.dim,l=-i*this.dim;for(let e=a;e<s;e++)for(let i=r;i<n;i++)this.data[this._idx(i,e)]=t.data[this._idx(i+o,e+l)]}});class $c extends Ys{constructor(t,e){super(t,Uc,e)}_createColorRamp(t){const e={elevationStops:[],colorStops:[]},i=this._transitionablePaint._values["color-relief-color"].value.expression;if(i instanceof ua&&i._styleExpression.expression instanceof vr){this.colorRampExpression=i;const t=i._styleExpression.expression;e.elevationStops=t.labels,e.colorStops=[];for(const i of e.elevationStops)e.colorStops.push(t.evaluate({globals:{elevation:i}}))}if(e.elevationStops.length<1&&(e.elevationStops=[0],e.colorStops=[Ri.transparent]),e.elevationStops.length<2&&(e.elevationStops.push(e.elevationStops[0]+1),e.colorStops.push(e.colorStops[0])),e.elevationStops.length<=t)return e;const r={elevationStops:[],colorStops:[]},n=(e.elevationStops.length-1)/(t-1);for(let t=0;t<e.elevationStops.length-.5;t+=n)r.elevationStops.push(e.elevationStops[Math.round(t)]),r.colorStops.push(e.colorStops[Math.round(t)]);return kt(`Too many colors in specification of ${this.id} color-relief layer, may not render properly. Max possible colors: ${t}, provided: ${e.elevationStops.length}`),r}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(t,e,i){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const r=this._createColorRamp(e),n=new Rc({width:r.colorStops.length,height:1}),a=new Rc({width:r.colorStops.length,height:1});for(let t=0;t<r.elevationStops.length;t++){const e=Gc(r.elevationStops[t],i);a.setPixel(0,t,new Ri(e.r/255,e.g/255,e.b/255,1)),n.setPixel(0,t,r.colorStops[t])}return this.colorRampTextures={elevationTexture:new Zc(t,a,t.gl.RGBA),colorTexture:new Zc(t,n,t.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return"none"!==this.visibility&&!!this.colorRampTextures}}const qc=no([{name:"a_pos",components:2,type:"Int16"}],4),{members:Wc}=qc;function Hc(t,e,i){const r=i.patternDependencies;let n=!1;for(const i of e){const e=i.paint.get(`${t}-pattern`);e.isConstant()||(n=!0);const a=e.constantOr(null);a&&(n=!0,r[a.to]=!0,r[a.from]=!0)}return n}function Xc(t,e,i,r,n){const{zoom:a}=r,s=n.patternDependencies;for(const r of e){const e=r.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:a-1},i,{},n.availableImages),o=e.evaluate({zoom:a},i,{},n.availableImages),l=e.evaluate({zoom:a+1},i,{},n.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,i.patterns[r.id]={min:t,mid:o,max:l}}}return i}function Yc(t,e,i,r,n){let a;if(n===function(t,e,i,r){let n=0;for(let a=e,s=i-r;a<i;a+=r)n+=(t[s]-t[a])*(t[a+1]+t[s+1]),s=a;return n}(t,e,i,r)>0)for(let n=e;n<i;n+=r)a=yh(n/r|0,t[n],t[n+1],a);else for(let n=i-r;n>=e;n-=r)a=yh(n/r|0,t[n],t[n+1],a);return a&&dh(a,a.next)&&(xh(a),a=a.next),a}function Kc(t,e){if(!t)return t;e||(e=t);let i,r=t;do{if(i=!1,r.steiner||!dh(r,r.next)&&0!==uh(r.prev,r,r.next))r=r.next;else{if(xh(r),r=e=r.prev,r===r.next)break;i=!0}}while(i||r!==e);return e}function Jc(t,e,i,r,n,a,s){if(!t)return;!s&&a&&function(t,e,i,r){let n=t;do{0===n.z&&(n.z=sh(n.x,n.y,e,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){let e,i=1;do{let r,n=t;t=null;let a=null;for(e=0;n;){e++;let s=n,o=0;for(let t=0;t<i&&(o++,s=s.nextZ,s);t++);let l=i;for(;o>0||l>0&&s;)0!==o&&(0===l||!s||n.z<=s.z)?(r=n,n=n.nextZ,o--):(r=s,s=s.nextZ,l--),a?a.nextZ=r:t=r,r.prevZ=a,a=r;n=s}a.nextZ=null,i*=2}while(e>1)}(n)}(t,r,n,a);let o=t;for(;t.prev!==t.next;){const l=t.prev,c=t.next;if(a?th(t,r,n,a):Qc(t))e.push(l.i,t.i,c.i),xh(t),t=c.next,o=c.next;else if((t=c)===o){s?1===s?Jc(t=eh(Kc(t),e),e,i,r,n,a,2):2===s&&ih(t,e,i,r,n,a):Jc(Kc(t),e,i,r,n,a,1);break}}}function Qc(t){const e=t.prev,i=t,r=t.next;if(uh(e,i,r)>=0)return!1;const n=e.x,a=i.x,s=r.x,o=e.y,l=i.y,c=r.y,h=Math.min(n,a,s),u=Math.min(o,l,c),d=Math.max(n,a,s),p=Math.max(o,l,c);let f=r.next;for(;f!==e;){if(f.x>=h&&f.x<=d&&f.y>=u&&f.y<=p&&ch(n,o,a,l,s,c,f.x,f.y)&&uh(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function th(t,e,i,r){const n=t.prev,a=t,s=t.next;if(uh(n,a,s)>=0)return!1;const o=n.x,l=a.x,c=s.x,h=n.y,u=a.y,d=s.y,p=Math.min(o,l,c),f=Math.min(h,u,d),m=Math.max(o,l,c),_=Math.max(h,u,d),g=sh(p,f,e,i,r),y=sh(m,_,e,i,r);let x=t.prevZ,v=t.nextZ;for(;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==s&&ch(o,h,l,u,c,d,x.x,x.y)&&uh(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==s&&ch(o,h,l,u,c,d,v.x,v.y)&&uh(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==s&&ch(o,h,l,u,c,d,x.x,x.y)&&uh(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==s&&ch(o,h,l,u,c,d,v.x,v.y)&&uh(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function eh(t,e){let i=t;do{const r=i.prev,n=i.next.next;!dh(r,n)&&ph(r,i,i.next,n)&&_h(r,n)&&_h(n,r)&&(e.push(r.i,i.i,n.i),xh(i),xh(i.next),i=t=n),i=i.next}while(i!==t);return Kc(i)}function ih(t,e,i,r,n,a){let s=t;do{let t=s.next.next;for(;t!==s.prev;){if(s.i!==t.i&&hh(s,t)){let o=gh(s,t);return s=Kc(s,s.next),o=Kc(o,o.next),Jc(s,e,i,r,n,a,0),void Jc(o,e,i,r,n,a,0)}t=t.next}s=s.next}while(s!==t)}function rh(t,e){let i=t.x-e.x;return 0===i&&(i=t.y-e.y,0===i)&&(i=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),i}function nh(t,e){const i=function(t,e){let i=e;const r=t.x,n=t.y;let a,s=-1/0;if(dh(t,i))return i;do{if(dh(t,i.next))return i.next;if(n<=i.y&&n>=i.next.y&&i.next.y!==i.y){const t=i.x+(n-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(t<=r&&t>s&&(s=t,a=i.x<i.next.x?i:i.next,t===r))return a}i=i.next}while(i!==e);if(!a)return null;const o=a,l=a.x,c=a.y;let h=1/0;i=a;do{if(r>=i.x&&i.x>=l&&r!==i.x&&lh(n<c?r:s,n,l,c,n<c?s:r,n,i.x,i.y)){const e=Math.abs(n-i.y)/(r-i.x);_h(i,t)&&(e<h||e===h&&(i.x>a.x||i.x===a.x&&ah(a,i)))&&(a=i,h=e)}i=i.next}while(i!==o);return a}(t,e);if(!i)return e;const r=gh(i,t);return Kc(r,r.next),Kc(i,i.next)}function ah(t,e){return uh(t.prev,t,e.prev)<0&&uh(e.next,t,t.next)<0}function sh(t,e,i,r,n){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-i)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function oh(t){let e=t,i=t;do{(e.x<i.x||e.x===i.x&&e.y<i.y)&&(i=e),e=e.next}while(e!==t);return i}function lh(t,e,i,r,n,a,s,o){return(n-s)*(e-o)>=(t-s)*(a-o)&&(t-s)*(r-o)>=(i-s)*(e-o)&&(i-s)*(a-o)>=(n-s)*(r-o)}function ch(t,e,i,r,n,a,s,o){return!(t===s&&e===o)&&lh(t,e,i,r,n,a,s,o)}function hh(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&ph(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}(t,e)&&(_h(t,e)&&_h(e,t)&&function(t,e){let i=t,r=!1;const n=(t.x+e.x)/2,a=(t.y+e.y)/2;do{i.y>a!=i.next.y>a&&i.next.y!==i.y&&n<(i.next.x-i.x)*(a-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}(t,e)&&(uh(t.prev,t,e.prev)||uh(t,e.prev,e))||dh(t,e)&&uh(t.prev,t,t.next)>0&&uh(e.prev,e,e.next)>0)}function uh(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function dh(t,e){return t.x===e.x&&t.y===e.y}function ph(t,e,i,r){const n=mh(uh(t,e,i)),a=mh(uh(t,e,r)),s=mh(uh(i,r,t)),o=mh(uh(i,r,e));return n!==a&&s!==o||!(0!==n||!fh(t,i,e))||!(0!==a||!fh(t,r,e))||!(0!==s||!fh(i,t,r))||!(0!==o||!fh(i,e,r))}function fh(t,e,i){return e.x<=Math.max(t.x,i.x)&&e.x>=Math.min(t.x,i.x)&&e.y<=Math.max(t.y,i.y)&&e.y>=Math.min(t.y,i.y)}function mh(t){return t>0?1:t<0?-1:0}function _h(t,e){return uh(t.prev,t,t.next)<0?uh(t,e,t.next)>=0&&uh(t,t.prev,e)>=0:uh(t,e,t.prev)<0||uh(t,t.next,e)<0}function gh(t,e){const i=vh(t.i,t.x,t.y),r=vh(e.i,e.x,e.y),n=t.next,a=e.prev;return t.next=e,e.prev=t,i.next=n,n.prev=i,r.next=i,i.prev=r,a.next=r,r.prev=a,r}function yh(t,e,i,r){const n=vh(t,e,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function xh(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function vh(t,e,i){return{i:t,x:e,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class bh{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class wh{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}wh.noSubdivision=new wh({fill:new bh(0,0),line:new bh(0,0),tile:new bh(0,0),stencil:new bh(0,0),circle:1}),fs("SubdivisionGranularityExpression",bh),fs("SubdivisionGranularitySetting",wh);const Th=-32768,Ph=32767;class Mh{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=Q/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|e+32768}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const i=0|Math.round(t),r=0|Math.round(e),n=this._getKey(i,r);if(this._vertexDictionary.has(n))return this._vertexDictionary.get(n);const a=this._vertexBuffer.length/2;return this._vertexDictionary.set(n,a),this._vertexBuffer.push(i,r),a}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const i=[];for(let r=0;r<e.length;r+=3){const n=e[r],a=e[r+1],s=e[r+2],o=t[2*n],l=t[2*n+1];(t[2*a]-o)*(t[2*s+1]-l)-(t[2*a+1]-l)*(t[2*s]-o)>0?(i.push(n),i.push(s),i.push(a)):(i.push(n),i.push(a),i.push(s))}return i}(this._vertexBuffer,t);const e=[],i=t.length;for(let r=0;r<i;r+=3){const i=[t[r+0],t[r+1],t[r+2]],n=[this._vertexBuffer[2*t[r+0]+0],this._vertexBuffer[2*t[r+0]+1],this._vertexBuffer[2*t[r+1]+0],this._vertexBuffer[2*t[r+1]+1],this._vertexBuffer[2*t[r+2]+0],this._vertexBuffer[2*t[r+2]+1]];let a=1/0,s=1/0,o=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=n[2*t],i=n[2*t+1];a=Math.min(a,e),o=Math.max(o,e),s=Math.min(s,i),l=Math.max(l,i)}if(a===o||s===l)continue;const c=Math.floor(a/this._granularityCellSize),h=Math.ceil(o/this._granularityCellSize),u=Math.floor(s/this._granularityCellSize),d=Math.ceil(l/this._granularityCellSize);if(c!==h||u!==d)for(let t=u;t<d;t++){const r=this._scanlineGenerateVertexRingForCellRow(t,n,i);Ch(this._vertexBuffer,r,e)}else e.push(...i)}return e}_scanlineGenerateVertexRingForCellRow(t,e,i){const r=t*this._granularityCellSize,n=r+this._granularityCellSize,a=[];for(let t=0;t<3;t++){const s=e[2*t],o=e[2*t+1],l=e[2*(t+1)%6],c=e[(2*(t+1)+1)%6],h=e[2*(t+2)%6],u=e[(2*(t+2)+1)%6],d=l-s,p=c-o,f=0===d,m=0===p,_=(r-o)/p,g=(n-o)/p,y=Math.min(_,g),x=Math.max(_,g);if(!m&&(y>=1||x<=0)||m&&(o<r||o>n)){c>=r&&c<=n&&a.push(i[(t+1)%3]);continue}!m&&y>0&&a.push(this._vertexToIndex(s+d*y,o+p*y));const v=s+d*Math.max(y,0),b=s+d*Math.min(x,1);f||this._generateIntraEdgeVertices(a,s,o,l,c,v,b),!m&&x<1&&a.push(this._vertexToIndex(s+d*x,o+p*x)),(m||c>=r&&c<=n)&&a.push(i[(t+1)%3]),!m&&(c<=r||c>=n)&&this._generateInterEdgeVertices(a,s,o,l,c,h,u,b,r,n)}return a}_generateIntraEdgeVertices(t,e,i,r,n,a,s){const o=r-e,l=n-i,c=0===l,h=c?Math.min(e,r):Math.min(a,s),u=c?Math.max(e,r):Math.max(a,s),d=Math.floor(h/this._granularityCellSize)+1,p=Math.ceil(u/this._granularityCellSize)-1;if(c?e<r:a<s)for(let r=d;r<=p;r++){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/o))}else for(let r=p;r>=d;r--){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/o))}}_generateInterEdgeVertices(t,e,i,r,n,a,s,o,l,c){const h=n-i,u=a-r,d=s-n,p=(l-n)/d,f=(c-n)/d,m=Math.min(p,f),_=Math.max(p,f),g=r+u*m;let y=Math.floor(Math.min(g,o)/this._granularityCellSize)+1,x=Math.ceil(Math.max(g,o)/this._granularityCellSize)-1,v=o<g;const b=0===d;if(b&&(s===l||s===c))return;if(b||m>=1||_<=0){const t=i-s,r=a+(e-a)*Math.min((l-s)/t,(c-s)/t);y=Math.floor(Math.min(r,o)/this._granularityCellSize)+1,x=Math.ceil(Math.max(r,o)/this._granularityCellSize)-1,v=o<r}const w=h>0?c:l;if(v)for(let e=y;e<=x;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,w));else for(let e=x;e>=y;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,w))}_generateOutline(t){const e=[];for(const i of t){const t=Ih(i,this._granularity,!0),r=this._pointArrayToIndices(t),n=[];for(let t=1;t<r.length;t++)n.push(r[t-1]),n.push(r[t]);e.push(n)}return e}_handlePoles(t){let e=!1,i=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(i=!0)),(e||i)&&this._fillPoles(t,e,i)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const i=t[e+1];i===Th&&(t[e+1]=-32767),i===Ph&&(t[e+1]=32766)}}_generatePoleQuad(t,e,i,r,n,a){r>n!=(a===Th)?(t.push(e),t.push(i),t.push(this._vertexToIndex(r,a)),t.push(i),t.push(this._vertexToIndex(n,a)),t.push(this._vertexToIndex(r,a))):(t.push(i),t.push(e),t.push(this._vertexToIndex(r,a)),t.push(this._vertexToIndex(n,a)),t.push(i),t.push(this._vertexToIndex(r,a)))}_fillPoles(t,e,i){const r=this._vertexBuffer,n=Q,a=t.length;for(let s=2;s<a;s+=3){const a=t[s-2],o=t[s-1],l=t[s],c=r[2*a],h=r[2*a+1],u=r[2*o],d=r[2*o+1],p=r[2*l],f=r[2*l+1];e&&(0===h&&0===d&&this._generatePoleQuad(t,a,o,c,u,Th),0===d&&0===f&&this._generatePoleQuad(t,o,l,u,p,Th),0===f&&0===h&&this._generatePoleQuad(t,l,a,p,c,Th)),i&&(h===n&&d===n&&this._generatePoleQuad(t,a,o,c,u,Ph),d===n&&f===n&&this._generatePoleQuad(t,o,l,u,p,Ph),f===n&&h===n&&this._generatePoleQuad(t,l,a,p,c,Ph))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:i,holeIndices:r}=function(t){const e=[],i=[];for(const r of t)if(0!==r.length){r!==t[0]&&e.push(i.length/2);for(let t=0;t<r.length;t++)i.push(r[t].x),i.push(r[t].y)}return{flattened:i,holeIndices:e}}(t);let n;this._initializeVertices(i);try{const t=function(t,e,i=2){const r=e&&e.length,n=r?e[0]*i:t.length;let a=Yc(t,0,n,i,!0);const s=[];if(!a||a.next===a.prev)return s;let o,l,c;if(r&&(a=function(t,e,i,r){const n=[];for(let i=0,a=e.length;i<a;i++){const s=Yc(t,e[i]*r,i<a-1?e[i+1]*r:t.length,r,!1);s===s.next&&(s.steiner=!0),n.push(oh(s))}n.sort(rh);for(let t=0;t<n.length;t++)i=nh(n[t],i);return i}(t,e,a,i)),t.length>80*i){o=t[0],l=t[1];let e=o,r=l;for(let a=i;a<n;a+=i){const i=t[a],n=t[a+1];i<o&&(o=i),n<l&&(l=n),i>e&&(e=i),n>r&&(r=n)}c=Math.max(e-o,r-l),c=0!==c?32767/c:0}return Jc(a,s,i,o,l,c,0),s}(i,r),e=this._convertIndices(i,t);n=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let a=[];return e&&(a=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(n),{verticesFlattened:this._vertexBuffer,indicesTriangles:n,indicesLineList:a}}_convertIndices(t,e){const i=[];for(let r=0;r<e.length;r++)i.push(this._vertexToIndex(t[2*e[r]],t[2*e[r]+1]));return i}_pointArrayToIndices(t){const e=[];for(let i=0;i<t.length;i++){const r=t[i];e.push(this._vertexToIndex(r.x,r.y))}return e}}function Sh(t,e,i,r=!0){return new Mh(i,e).subdividePolygonInternal(t,r)}function Ih(t,e,i=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const r=t[0],n=t[t.length-1],s=i&&(r.x!==n.x||r.y!==n.y);if(e<2)return s?[...t,t[0]]:[...t];const o=Math.floor(Q/e),l=[];l.push(new a(t[0].x,t[0].y));const c=t.length,h=s?c:c-1;for(let e=0;e<h;e++){const i=t[e],r=e<c-1?t[e+1]:t[0],n=i.x,s=i.y,h=r.x,u=r.y,d=n!==h,p=s!==u;if(!d&&!p)continue;const f=h-n,m=u-s,_=Math.abs(f),g=Math.abs(m);let y=n,x=s;for(;;){const t=f>0?(Math.floor(y/o)+1)*o:(Math.ceil(y/o)-1)*o,e=m>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,i=Math.abs(y-t),r=Math.abs(x-e),n=Math.abs(y-h),s=Math.abs(x-u),c=d?i/_:Number.POSITIVE_INFINITY,v=p?r/g:Number.POSITIVE_INFINITY;if((n<=i||!d)&&(s<=r||!p))break;if(c<v&&d||!p){y=t,x+=m*c;const e=new a(y,Math.round(x));l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e)}else{y+=f*v,x=e;const t=new a(Math.round(y),x);l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t)}}const v=new a(h,u);l[l.length-1].x===v.x&&l[l.length-1].y===v.y||l.push(v)}return l}function Ch(t,e,i){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let r=0,n=t[2*e[0]];for(let i=1;i<e.length;i++){const a=t[2*e[i]];a<n&&(n=a,r=i)}const a=e.length;let s=r,o=(s+1)%a;for(;;){const r=s-1>=0?s-1:a-1,n=(o+1)%a,l=t[2*e[r]],c=t[2*e[n]],h=t[2*e[s]],u=t[2*e[s]+1],d=t[2*e[o]+1];let p=!1;if(l<c)p=!0;else if(l>c)p=!1;else{const i=d-u,a=-(t[2*e[o]]-h),s=u<d?1:-1;((l-h)*i+(t[2*e[r]+1]-u)*a)*s>((c-h)*i+(t[2*e[n]+1]-u)*a)*s&&(p=!0)}if(p){const t=e[r],n=e[s],l=e[o];t!==n&&t!==l&&n!==l&&i.push(l,n,t),s--,s<0&&(s=a-1)}else{const t=e[n],r=e[s],l=e[o];t!==r&&t!==l&&r!==l&&i.push(l,r,t),o++,o>=a&&(o=0)}if(r===n)break}}function Ah(t,e,i,r,n,a,s,o,l){const c=n.length/2,h=s&&o&&l;if(c<ul.MAX_VERTEX_ARRAY_LENGTH){const u=e.prepareSegment(c,i,r),d=u.vertexLength;for(let t=0;t<a.length;t+=3)r.emplaceBack(d+a[t],d+a[t+1],d+a[t+2]);let p,f;u.vertexLength+=c,u.primitiveLength+=a.length/3,h&&(f=s.prepareSegment(c,i,o),p=f.vertexLength,f.vertexLength+=c);for(let e=0;e<n.length;e+=2)t(n[e],n[e+1]);if(h)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)o.emplaceBack(p+e[t-1],p+e[t]);f.primitiveLength+=e.length/2}}else!function(t,e,i,r,n,a){const s=[];for(let t=0;t<r.length/2;t++)s.push(-1);const o={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=2;u<n.length;u+=3){const d=n[u-2],p=n[u-1],f=n[u];let m=s[d]<l,_=s[p]<l,g=s[f]<l;c.vertexLength+((m?1:0)+(_?1:0)+(g?1:0))>ul.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=o.count,m=!0,_=!0,g=!0,h=0);const y=Eh(s,r,a,o,d,m,c),x=Eh(s,r,a,o,p,_,c),v=Eh(s,r,a,o,f,g,c);i.emplaceBack(h+y-l,h+x-l,h+v-l),c.primitiveLength++}}(e,i,r,n,a,t),h&&function(t,e,i,r,n,a){const s=[];for(let t=0;t<r.length/2;t++)s.push(-1);const o={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=0;u<n.length;u++){const d=n[u];for(let p=1;p<n[u].length;p+=2){const n=d[p-1],u=d[p];let f=s[n]<l,m=s[u]<l;c.vertexLength+((f?1:0)+(m?1:0))>ul.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=o.count,f=!0,m=!0,h=0);const _=Eh(s,r,a,o,n,f,c),g=Eh(s,r,a,o,u,m,c);i.emplaceBack(h+_-l,h+g-l),c.primitiveLength++}}}(s,i,o,n,l,t),e.forceNewSegmentOnNextPrepare(),null==s||s.forceNewSegmentOnNextPrepare()}function Eh(t,e,i,r,n,a,s){if(a){const a=r.count;return i(e[2*n],e[2*n+1]),t[n]=r.count,r.count++,s.vertexLength++,a}return t[n]}class zh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.patternFeatures=[],this.layoutVertexArray=new Wo,this.indexArray=new sl,this.indexArray2=new ol,this.programConfigurations=new Wl(t.layers,t.zoom),this.segments=new ul,this.segments2=new ul,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasDependencies=Hc("fill",this.layers,e);const r=this.layers[0].layout.get("fill-sort-key"),n=!r.isConstant(),a=[];for(const{feature:s,id:o,index:l,sourceLayerIndex:c}of t){const t=this.layers[0]._featureFilter.needGeometry,h=Ql(s,t);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),h,i))continue;const u=n?r.evaluate(h,{},i,e.availableImages):void 0,d={id:o,properties:s.properties,type:s.type,sourceLayerIndex:c,index:l,geometry:t?h.geometry:Jl(s),patterns:{},sortKey:u};a.push(d)}n&&a.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of a){const{geometry:n,index:a,sourceLayerIndex:s}=r;if(this.hasDependencies){const t=Xc("fill",this.layers,r,{zoom:this.zoom},e);this.patternFeatures.push(t)}else this.addFeature(r,n,a,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[a].feature,n,a,s,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Wc),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,i,r,n,a){for(const t of ln(e,500)){const e=Sh(t,r,a.fill.getGranularityForZoomLevel(r.z)),i=this.layoutVertexArray;Ah(((t,e)=>{i.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:n,canonical:r})}}let Dh,kh;fs("FillBucket",zh,{omit:["layers","patternFeatures"]});var Rh={get paint(){return kh=kh||new Hs({"fill-antialias":new Zs(Me.paint_fill["fill-antialias"]),"fill-opacity":new Gs(Me.paint_fill["fill-opacity"]),"fill-color":new Gs(Me.paint_fill["fill-color"]),"fill-outline-color":new Gs(Me.paint_fill["fill-outline-color"]),"fill-translate":new Zs(Me.paint_fill["fill-translate"]),"fill-translate-anchor":new Zs(Me.paint_fill["fill-translate-anchor"]),"fill-pattern":new $s(Me.paint_fill["fill-pattern"])})},get layout(){return Dh=Dh||new Hs({"fill-sort-key":new Gs(Me.layout_fill["fill-sort-key"])})}};class Lh extends Ys{constructor(t,e){super(t,Rh,e)}recalculate(t,e){super.recalculate(t,e);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new zh(t)}queryRadius(){return mc(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:i,pixelsToTileUnits:r}){return ac(_c(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-i.bearingInRadians,r),e)}isTileClipped(){return!0}}const Fh=no([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Bh=no([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Oh}=Fh;class jh{constructor(t,e,i,r,n){this.properties={},this.extent=i,this.type=0,this.id=void 0,this._pbf=t,this._geometry=-1,this._keys=r,this._values=n,t.readFields(Vh,this,e)}loadGeometry(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos,i=[];let r,n=1,s=0,o=0,l=0;for(;t.pos<e;){if(s<=0){const e=t.readVarint();n=7&e,s=e>>3}if(s--,1===n||2===n)o+=t.readSVarint(),l+=t.readSVarint(),1===n&&(r&&i.push(r),r=[]),r&&r.push(new a(o,l));else{if(7!==n)throw new Error(`unknown command ${n}`);r&&r.push(r[0].clone())}}return r&&i.push(r),i}bbox(){const t=this._pbf;t.pos=this._geometry;const e=t.readVarint()+t.pos;let i=1,r=0,n=0,a=0,s=1/0,o=-1/0,l=1/0,c=-1/0;for(;t.pos<e;){if(r<=0){const e=t.readVarint();i=7&e,r=e>>3}if(r--,1===i||2===i)n+=t.readSVarint(),a+=t.readSVarint(),n<s&&(s=n),n>o&&(o=n),a<l&&(l=a),a>c&&(c=a);else if(7!==i)throw new Error(`unknown command ${i}`)}return[s,l,o,c]}toGeoJSON(t,e,i){const r=this.extent*Math.pow(2,i),n=this.extent*t,a=this.extent*e,s=this.loadGeometry();function o(t){return[360*(t.x+n)/r-180,360/Math.PI*Math.atan(Math.exp((1-2*(t.y+a)/r)*Math.PI))-90]}function l(t){return t.map(o)}let c;if(1===this.type){const t=[];for(const e of s)t.push(e[0]);const e=l(t);c=1===t.length?{type:"Point",coordinates:e[0]}:{type:"MultiPoint",coordinates:e}}else if(2===this.type){const t=s.map(l);c=1===t.length?{type:"LineString",coordinates:t[0]}:{type:"MultiLineString",coordinates:t}}else{if(3!==this.type)throw new Error("unknown feature type");{const t=function(t){const e=t.length;if(e<=1)return[t];const i=[];let r,n;for(let a=0;a<e;a++){const e=Nh(t[a]);0!==e&&(void 0===n&&(n=e<0),n===e<0?(r&&i.push(r),r=[t[a]]):r&&r.push(t[a]))}return r&&i.push(r),i}(s),e=[];for(const i of t)e.push(i.map(l));c=1===e.length?{type:"Polygon",coordinates:e[0]}:{type:"MultiPolygon",coordinates:e}}}const h={type:"Feature",geometry:c,properties:this.properties};return null!=this.id&&(h.id=this.id),h}}function Vh(t,e,i){1===t?e.id=i.readVarint():2===t?function(t,e){const i=t.readVarint()+t.pos;for(;t.pos<i;){const i=e._keys[t.readVarint()],r=e._values[t.readVarint()];e.properties[i]=r}}(i,e):3===t?e.type=i.readVarint():4===t&&(e._geometry=i.pos)}function Nh(t){let e=0;for(let i,r,n=0,a=t.length,s=a-1;n<a;s=n++)i=t[n],r=t[s],e+=(r.x-i.x)*(i.y+r.y);return e}jh.types=["Unknown","Point","LineString","Polygon"];class Uh{constructor(t,e){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(Zh,this,e),this.length=this._features.length}feature(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];const e=this._pbf.readVarint()+this._pbf.pos;return new jh(this._pbf,e,this.extent,this._keys,this._values)}}function Zh(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){let e=null;const i=t.readVarint()+t.pos;for(;t.pos<i;){const i=t.readVarint()>>3;e=1===i?t.readString():2===i?t.readFloat():3===i?t.readDouble():4===i?t.readVarint64():5===i?t.readVarint():6===i?t.readSVarint():7===i?t.readBoolean():null}if(null==e)throw new Error("unknown feature value");return e}(i))}class Gh{constructor(t,e){this.layers=t.readFields($h,{},e)}}function $h(t,e,i){if(3===t){const t=new Uh(i,i.readVarint()+i.pos);t.length&&(e[t.name]=t)}}const qh=Math.pow(2,13);function Wh(t,e,i,r,n,a,s,o){t.emplaceBack(e,i,2*Math.floor(r*qh)+s,n*qh*2,a*qh*2,Math.round(o))}class Hh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.layoutVertexArray=new Ho,this.centroidVertexArray=new Zo,this.indexArray=new sl,this.programConfigurations=new Wl(t.layers,t.zoom),this.segments=new ul,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.features=[],this.hasDependencies=Hc("fill-extrusion",this.layers,e);for(const{feature:r,id:n,index:a,sourceLayerIndex:s}of t){const t=this.layers[0]._featureFilter.needGeometry,o=Ql(r,t);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),o,i))continue;const l={id:n,sourceLayerIndex:s,index:a,geometry:t?o.geometry:Jl(r),properties:r.properties,type:r.type,patterns:{}};this.hasDependencies?this.features.push(Xc("fill-extrusion",this.layers,l,{zoom:this.zoom},e)):this.addFeature(l,l.geometry,a,i,{},e.subdivisionGranularity),e.featureIndex.insert(r,l.geometry,a,s,this.index,!0)}}addFeatures(t,e,i){for(const r of this.features){const{geometry:n}=r;this.addFeature(r,n,r.index,e,i,t.subdivisionGranularity)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i})}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Oh),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Bh.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,i,r,n,a){for(const i of ln(e,500)){const e={x:0,y:0,sampleCount:0},n=this.layoutVertexArray.length;this.processPolygon(e,r,t,i,a);const s=this.layoutVertexArray.length-n,o=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<s;t++)this.centroidVertexArray.emplaceBack(o,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:n,canonical:r})}processPolygon(t,e,i,r,n){if(r.length<1)return;if(Kh(r[0]))return;for(const e of r)0!==e.length&&Xh(t,e);const a={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},s=n.fill.getGranularityForZoomLevel(e.z),o="Polygon"===jh.types[i.type];for(const t of r){if(0===t.length)continue;if(Kh(t))continue;const e=Ih(t,s,o);this._generateSideFaces(e,a)}if(!o)return;const l=Sh(r,e,s,!1),c=this.layoutVertexArray;Ah(((t,e)=>{Wh(c,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(t,e){let i=0;for(let r=1;r<t.length;r++){const n=t[r],a=t[r-1];if(Yh(n,a))continue;e.segment.vertexLength+4>ul.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const s=n.sub(a)._perp()._unit(),o=a.dist(n);i+o>32768&&(i=0),Wh(this.layoutVertexArray,n.x,n.y,s.x,s.y,0,0,i),Wh(this.layoutVertexArray,n.x,n.y,s.x,s.y,0,1,i),i+=o,Wh(this.layoutVertexArray,a.x,a.y,s.x,s.y,0,0,i),Wh(this.layoutVertexArray,a.x,a.y,s.x,s.y,0,1,i);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function Xh(t,e){for(let i=0;i<e.length;i++){const r=e[i];i===e.length-1&&e[0].x===r.x&&e[0].y===r.y||(t.x+=r.x,t.y+=r.y,t.sampleCount++)}}function Yh(t,e){return t.x===e.x&&(t.x<0||t.x>Q)||t.y===e.y&&(t.y<0||t.y>Q)}function Kh(t){return t.every((t=>t.x<0))||t.every((t=>t.x>Q))||t.every((t=>t.y<0))||t.every((t=>t.y>Q))}let Jh;fs("FillExtrusionBucket",Hh,{omit:["layers","features"]});var Qh={get paint(){return Jh=Jh||new Hs({"fill-extrusion-opacity":new Zs(Me["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Gs(Me["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Zs(Me["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Zs(Me["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new $s(Me["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Gs(Me["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Gs(Me["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Zs(Me["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class tu extends Ys{constructor(t,e){super(t,Qh,e)}createBucket(t){return new Hh(t)}queryRadius(){return mc(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,pixelPosMatrix:o}){const l=_c(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-n.bearingInRadians,s),c=this.paint.get("fill-extrusion-height").evaluate(e,i),h=this.paint.get("fill-extrusion-base").evaluate(e,i),u=function(t,e){const i=[];for(const r of t){const t=[r.x,r.y,0,1];G(t,t,e),i.push(new a(t[0]/t[3],t[1]/t[3]))}return i}(l,o),d=function(t,e,i,r){const n=[],s=[],o=r[8]*e,l=r[9]*e,c=r[10]*e,h=r[11]*e,u=r[8]*i,d=r[9]*i,p=r[10]*i,f=r[11]*i;for(const e of t){const t=[],i=[];for(const n of e){const e=n.x,s=n.y,m=r[0]*e+r[4]*s+r[12],_=r[1]*e+r[5]*s+r[13],g=r[2]*e+r[6]*s+r[14],y=r[3]*e+r[7]*s+r[15],x=g+c,v=y+h,b=m+u,w=_+d,T=g+p,P=y+f,M=new a((m+o)/v,(_+l)/v);M.z=x/v,t.push(M);const S=new a(b/P,w/P);S.z=T/P,i.push(S)}n.push(t),s.push(i)}return[n,s]}(r,h,c,o);return function(t,e,i){let r=1/0;ac(i,e)&&(r=iu(i,e[0]));for(let n=0;n<e.length;n++){const a=e[n],s=t[n];for(let t=0;t<a.length-1;t++){const e=a[t],n=[e,a[t+1],s[t+1],s[t],e];rc(i,n)&&(r=Math.min(r,iu(i,n)))}}return r!==1/0&&r}(d[0],d[1],u)}}function eu(t,e){return t.x*e.x+t.y*e.y}function iu(t,e){if(1===t.length){let i=0;const r=e[i++];let n;for(;!n||r.equals(n);)if(n=e[i++],!n)return 1/0;for(;i<e.length;i++){const a=e[i],s=t[0],o=n.sub(r),l=a.sub(r),c=s.sub(r),h=eu(o,o),u=eu(o,l),d=eu(l,l),p=eu(c,o),f=eu(c,l),m=h*d-u*u,_=(d*p-u*f)/m,g=(h*f-u*p)/m,y=r.z*(1-_-g)+n.z*_+a.z*g;if(isFinite(y))return y}return 1/0}{let t=1/0;for(const i of e)t=Math.min(t,i.z);return t}}const ru=no([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:nu}=ru,au=no([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:su}=au,ou=Math.cos(Math.PI/180*37.5),lu=Math.pow(2,14)/.5;class cu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasDependencies=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new Xo,this.layoutVertexArray2=new Yo,this.indexArray=new sl,this.programConfigurations=new Wl(t.layers,t.zoom),this.segments=new ul,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasDependencies=Hc("line",this.layers,e)||this.hasLineDasharray(this.layers);const r=this.layers[0].layout.get("line-sort-key"),n=!r.isConstant(),a=[];for(const{feature:e,id:s,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ql(e,t);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),c,i))continue;const h=n?r.evaluate(c,{},i):void 0,u={id:s,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?c.geometry:Jl(e),patterns:{},dashes:{},sortKey:h};a.push(u)}n&&a.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of a){const{geometry:n,index:a,sourceLayerIndex:s}=r;this.hasDependencies?(Hc("line",this.layers,e)?Xc("line",this.layers,r,{zoom:this.zoom},e):this.hasLineDasharray(this.layers)&&this.addLineDashDependencies(this.layers,r,this.zoom,e),this.patternFeatures.push(r)):this.addFeature(r,n,a,i,{},{},e.subdivisionGranularity),e.featureIndex.insert(t[a].feature,n,a,s,this.index)}}update(t,e,i,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,{imagePositions:i,dashPositions:r})}addFeatures(t,e,i,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,i,r,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,su)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,nu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,i,r,n,a,s){const o=this.layers[0].layout,l=o.get("line-join").evaluate(t,{}),c=o.get("line-cap"),h=o.get("line-miter-limit"),u=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const i of e)this.addLine(i,t,l,c,h,u,r,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{imagePositions:n,dashPositions:a,canonical:r})}addLine(t,e,i,r,n,a,s,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=Ih(t,s?o.line.getGranularityForZoomLevel(s.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===jh.types[e.type];let c=t.length;for(;c>=2&&t[c-1].equals(t[c-2]);)c--;let h=0;for(;h<c-1&&t[h].equals(t[h+1]);)h++;if(c<(l?3:2))return;"bevel"===i&&(n=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,d=this.segments.prepareSegment(10*c,this.layoutVertexArray,this.indexArray);let p,f,m,_,g;this.e1=this.e2=-1,l&&(p=t[c-2],g=t[h].sub(p)._unit()._perp());for(let e=h;e<c;e++){if(m=e===c-1?l?t[h+1]:void 0:t[e+1],m&&t[e].equals(m))continue;g&&(_=g),p&&(f=p),p=t[e],g=m?m.sub(p)._unit()._perp():_,_=_||g;let s=_.add(g);0===s.x&&0===s.y||s._unit();const o=_.x*g.x+_.y*g.y,y=s.x*g.x+s.y*g.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<ou&&f&&m,w=_.x*g.y-_.y*g.x>0;if(b&&e>h){const t=p.dist(f);if(t>2*u){const e=p.sub(p.sub(f)._mult(u/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,_,0,0,d),f=e}}const T=f&&m;let P=T?i:l?"butt":r;if(T&&"round"===P&&(x<a?P="miter":x<=2&&(P="fakeround")),"miter"===P&&x>n&&(P="bevel"),"bevel"===P&&(x>2&&(P="flipbevel"),x<n&&(P="miter")),f&&this.updateDistance(f,p),"miter"===P)s._mult(x),this.addCurrentVertex(p,s,0,0,d);else if("flipbevel"===P){if(x>100)s=g.mult(-1);else{const t=x*_.add(g).mag()/_.sub(g).mag();s._perp()._mult(t*(w?-1:1))}this.addCurrentVertex(p,s,0,0,d),this.addCurrentVertex(p,s.mult(-1),0,0,d)}else if("bevel"===P||"fakeround"===P){const t=-Math.sqrt(x*x-1),e=w?t:0,i=w?0:t;if(f&&this.addCurrentVertex(p,_,e,i,d),"fakeround"===P){const t=Math.round(180*v/Math.PI/20);for(let e=1;e<t;e++){let i=e/t;if(.5!==i){const t=i-.5;i+=i*t*(i-1)*((1.0904+o*(o*(3.55645-1.43519*o)-3.2452))*t*t+(.848013+o*(.215638*o-1.06021)))}const r=g.sub(_)._mult(i)._add(_)._unit()._mult(w?-1:1);this.addHalfVertex(p,r.x,r.y,!1,w,0,d)}}m&&this.addCurrentVertex(p,g,-e,-i,d)}else if("butt"===P)this.addCurrentVertex(p,s,0,0,d);else if("square"===P){const t=f?1:-1;this.addCurrentVertex(p,s,t,t,d)}else"round"===P&&(f&&(this.addCurrentVertex(p,_,0,0,d),this.addCurrentVertex(p,_,1,1,d,!0)),m&&(this.addCurrentVertex(p,g,-1,-1,d,!0),this.addCurrentVertex(p,g,0,0,d)));if(b&&e<c-1){const t=p.dist(m);if(t>2*u){const e=p.add(m.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,g,0,0,d),p=e}}}}addCurrentVertex(t,e,i,r,n,a=!1){const s=e.y*r-e.x,o=-e.y-e.x*r;this.addHalfVertex(t,e.x+e.y*i,e.y-e.x*i,a,!1,i,n),this.addHalfVertex(t,s,o,a,!0,-r,n),this.distance>lu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,i,r,n,a))}addHalfVertex({x:t,y:e},i,r,n,a,s,o){const l=.5*(this.lineClips?this.scaledDistance*(lu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(n?1:0),(e<<1)+(a?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===s?0:s<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,c,this.e2),o.primitiveLength++),a?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}hasLineDasharray(t){for(const e of t){const t=e.paint.get("line-dasharray");if(t&&!t.isConstant())return!0}return!1}addLineDashDependencies(t,e,i,r){for(const n of t){const t=n.paint.get("line-dasharray");if(!t||"constant"===t.value.kind)continue;const a="round"===n.layout.get("line-cap"),s={dasharray:t.value.evaluate({zoom:i-1},e,{}),round:a},o={dasharray:t.value.evaluate({zoom:i},e,{}),round:a},l={dasharray:t.value.evaluate({zoom:i+1},e,{}),round:a},c=`${s.dasharray.join(",")},${s.round}`,h=`${o.dasharray.join(",")},${o.round}`,u=`${l.dasharray.join(",")},${l.round}`;r.dashDependencies[c]=s,r.dashDependencies[h]=o,r.dashDependencies[u]=l,e.dashes[n.id]={min:c,mid:h,max:u}}}}let hu,uu;fs("LineBucket",cu,{omit:["layers","patternFeatures"]});var du={get paint(){return uu=uu||new Hs({"line-opacity":new Gs(Me.paint_line["line-opacity"]),"line-color":new Gs(Me.paint_line["line-color"]),"line-translate":new Zs(Me.paint_line["line-translate"]),"line-translate-anchor":new Zs(Me.paint_line["line-translate-anchor"]),"line-width":new Gs(Me.paint_line["line-width"]),"line-gap-width":new Gs(Me.paint_line["line-gap-width"]),"line-offset":new Gs(Me.paint_line["line-offset"]),"line-blur":new Gs(Me.paint_line["line-blur"]),"line-dasharray":new $s(Me.paint_line["line-dasharray"]),"line-pattern":new $s(Me.paint_line["line-pattern"]),"line-gradient":new Ws(Me.paint_line["line-gradient"])})},get layout(){return hu=hu||new Hs({"line-cap":new Zs(Me.layout_line["line-cap"]),"line-join":new Gs(Me.layout_line["line-join"]),"line-miter-limit":new Zs(Me.layout_line["line-miter-limit"]),"line-round-limit":new Zs(Me.layout_line["line-round-limit"]),"line-sort-key":new Gs(Me.layout_line["line-sort-key"])})}};class pu extends Gs{possiblyEvaluate(t,e){return e=new ks(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,i,r){return e=wt({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,i,r)}}let fu;class mu extends Ys{constructor(t,e){super(t,du,e),this.gradientVersion=0,fu||(fu=new pu(du.paint.properties["line-width"].specification),fu.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof fr,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=fu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new cu(t)}queryRadius(t){const e=t,i=_u(fc("line-width",this,e),fc("line-gap-width",this,e)),r=fc("line-offset",this,e);return i/2+Math.abs(r)+mc(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s}){const o=_c(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-n.bearingInRadians,s),l=s/2*_u(this.paint.get("line-width").evaluate(e,i),this.paint.get("line-gap-width").evaluate(e,i)),c=this.paint.get("line-offset").evaluate(e,i);return c&&(r=function(t,e){const i=[];for(let r=0;r<t.length;r++){const n=t[r],s=[];for(let t=0;t<n.length;t++){const i=n[t-1],r=n[t],o=n[t+1],l=0===t?new a(0,0):r.sub(i)._unit()._perp(),c=t===n.length-1?new a(0,0):o.sub(r)._unit()._perp(),h=l._add(c)._unit(),u=h.x*c.x+h.y*c.y;0!==u&&h._mult(1/u),s.push(h._mult(e)._add(r))}i.push(s)}return i}(r,c*s)),function(t,e,i){for(let r=0;r<e.length;r++){const n=e[r];if(t.length>=3)for(let e=0;e<n.length;e++)if(dc(t,n[e]))return!0;if(sc(t,n,i))return!0}return!1}(o,r,l)}isTileClipped(){return!0}}function _u(t,e){return e>0?e+2*t:t}const gu=no([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),yu=no([{name:"a_projected_pos",components:3,type:"Float32"}],4);no([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const xu=no([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);no([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const vu=no([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),bu=no([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function wu(t,e,i){return t.sections.forEach((t=>{t.text=function(t,e,i){const r=e.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?t=t.toLocaleUpperCase():"lowercase"===r&&(t=t.toLocaleLowerCase()),Ds.applyArabicShaping&&(t=Ds.applyArabicShaping(t)),t}(t.text,e,i)})),t}no([{name:"triangle",components:3,type:"Uint16"}]),no([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),no([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),no([{type:"Float32",name:"offsetX"}]),no([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),no([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const Tu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"},Pu=4294967296,Mu=1/Pu,Su="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class Iu{constructor(t=new Uint8Array(16)){this.buf=ArrayBuffer.isView(t)?t:new Uint8Array(t),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length}readFields(t,e,i=this.length){for(;this.pos<i;){const i=this.readVarint(),r=i>>3,n=this.pos;this.type=7&i,t(r,e,this),this.pos===n&&this.skip(i)}return e}readMessage(t,e){return this.readFields(t,e,this.readVarint()+this.pos)}readFixed32(){const t=this.dataView.getUint32(this.pos,!0);return this.pos+=4,t}readSFixed32(){const t=this.dataView.getInt32(this.pos,!0);return this.pos+=4,t}readFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*Pu;return this.pos+=8,t}readSFixed64(){const t=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*Pu;return this.pos+=8,t}readFloat(){const t=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,t}readDouble(){const t=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,t}readVarint(t){const e=this.buf;let i,r;return r=e[this.pos++],i=127&r,r<128?i:(r=e[this.pos++],i|=(127&r)<<7,r<128?i:(r=e[this.pos++],i|=(127&r)<<14,r<128?i:(r=e[this.pos++],i|=(127&r)<<21,r<128?i:(r=e[this.pos],i|=(15&r)<<28,function(t,e,i){const r=i.buf;let n,a;if(a=r[i.pos++],n=(112&a)>>4,a<128)return Cu(t,n,e);if(a=r[i.pos++],n|=(127&a)<<3,a<128)return Cu(t,n,e);if(a=r[i.pos++],n|=(127&a)<<10,a<128)return Cu(t,n,e);if(a=r[i.pos++],n|=(127&a)<<17,a<128)return Cu(t,n,e);if(a=r[i.pos++],n|=(127&a)<<24,a<128)return Cu(t,n,e);if(a=r[i.pos++],n|=(1&a)<<31,a<128)return Cu(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(i,t,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const t=this.readVarint();return t%2==1?(t+1)/-2:t/2}readBoolean(){return Boolean(this.readVarint())}readString(){const t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Su?Su.decode(this.buf.subarray(e,t)):function(t,e,i){let r="",n=e;for(;n<i;){const e=t[n];let a,s,o,l=null,c=e>239?4:e>223?3:e>191?2:1;if(n+c>i)break;1===c?e<128&&(l=e):2===c?(a=t[n+1],128==(192&a)&&(l=(31&e)<<6|63&a,l<=127&&(l=null))):3===c?(a=t[n+1],s=t[n+2],128==(192&a)&&128==(192&s)&&(l=(15&e)<<12|(63&a)<<6|63&s,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===c&&(a=t[n+1],s=t[n+2],o=t[n+3],128==(192&a)&&128==(192&s)&&128==(192&o)&&(l=(15&e)<<18|(63&a)<<12|(63&s)<<6|63&o,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,c=1):l>65535&&(l-=65536,r+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),r+=String.fromCharCode(l),n+=c}return r}(this.buf,e,t)}readBytes(){const t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e}readPackedVarint(t=[],e){const i=this.readPackedEnd();for(;this.pos<i;)t.push(this.readVarint(e));return t}readPackedSVarint(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSVarint());return t}readPackedBoolean(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readBoolean());return t}readPackedFloat(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFloat());return t}readPackedDouble(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readDouble());return t}readPackedFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed32());return t}readPackedSFixed32(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed32());return t}readPackedFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readFixed64());return t}readPackedSFixed64(t=[]){const e=this.readPackedEnd();for(;this.pos<e;)t.push(this.readSFixed64());return t}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(t){const e=7&t;if(0===e)for(;this.buf[this.pos++]>127;);else if(2===e)this.pos=this.readVarint()+this.pos;else if(5===e)this.pos+=4;else{if(1!==e)throw new Error(`Unimplemented type: ${e}`);this.pos+=8}}writeTag(t,e){this.writeVarint(t<<3|e)}realloc(t){let e=this.length||16;for(;e<this.pos+t;)e*=2;if(e!==this.length){const t=new Uint8Array(e);t.set(this.buf),this.buf=t,this.dataView=new DataView(t.buffer),this.length=e}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4}writeSFixed32(t){this.realloc(4),this.dataView.setInt32(this.pos,t,!0),this.pos+=4}writeFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*Mu),!0),this.pos+=8}writeSFixed64(t){this.realloc(8),this.dataView.setInt32(this.pos,-1&t,!0),this.dataView.setInt32(this.pos+4,Math.floor(t*Mu),!0),this.pos+=8}writeVarint(t){(t=+t||0)>268435455||t<0?function(t,e){let i,r;if(t>=0?(i=t%4294967296|0,r=t/4294967296|0):(i=~(-t%4294967296),r=~(-t/4294967296),4294967295^i?i=i+1|0:(i=0,r=r+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,i.buf[i.pos]=127&(t>>>=7)}(i,0,e),function(t,e){const i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(r,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))}writeSVarint(t){this.writeVarint(t<0?2*-t-1:2*t)}writeBoolean(t){this.writeVarint(+t)}writeString(t){t=String(t),this.realloc(4*t.length),this.pos++;const e=this.pos;this.pos=function(t,e,i){for(let r,n,a=0;a<e.length;a++){if(r=e.charCodeAt(a),r>55295&&r<57344){if(!n){r>56319||a+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):n=r;continue}if(r<56320){t[i++]=239,t[i++]=191,t[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(t[i++]=239,t[i++]=191,t[i++]=189,n=null);r<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(r<65536?t[i++]=r>>12|224:(t[i++]=r>>18|240,t[i++]=r>>12&63|128),t[i++]=r>>6&63|128),t[i++]=63&r|128)}return i}(this.buf,t,this.pos);const i=this.pos-e;i>=128&&Au(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i}writeFloat(t){this.realloc(4),this.dataView.setFloat32(this.pos,t,!0),this.pos+=4}writeDouble(t){this.realloc(8),this.dataView.setFloat64(this.pos,t,!0),this.pos+=8}writeBytes(t){const e=t.length;this.writeVarint(e),this.realloc(e);for(let i=0;i<e;i++)this.buf[this.pos++]=t[i]}writeRawMessage(t,e){this.pos++;const i=this.pos;t(e,this);const r=this.pos-i;r>=128&&Au(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r}writeMessage(t,e,i){this.writeTag(t,2),this.writeRawMessage(e,i)}writePackedVarint(t,e){e.length&&this.writeMessage(t,Eu,e)}writePackedSVarint(t,e){e.length&&this.writeMessage(t,zu,e)}writePackedBoolean(t,e){e.length&&this.writeMessage(t,Ru,e)}writePackedFloat(t,e){e.length&&this.writeMessage(t,Du,e)}writePackedDouble(t,e){e.length&&this.writeMessage(t,ku,e)}writePackedFixed32(t,e){e.length&&this.writeMessage(t,Lu,e)}writePackedSFixed32(t,e){e.length&&this.writeMessage(t,Fu,e)}writePackedFixed64(t,e){e.length&&this.writeMessage(t,Bu,e)}writePackedSFixed64(t,e){e.length&&this.writeMessage(t,Ou,e)}writeBytesField(t,e){this.writeTag(t,2),this.writeBytes(e)}writeFixed32Field(t,e){this.writeTag(t,5),this.writeFixed32(e)}writeSFixed32Field(t,e){this.writeTag(t,5),this.writeSFixed32(e)}writeFixed64Field(t,e){this.writeTag(t,1),this.writeFixed64(e)}writeSFixed64Field(t,e){this.writeTag(t,1),this.writeSFixed64(e)}writeVarintField(t,e){this.writeTag(t,0),this.writeVarint(e)}writeSVarintField(t,e){this.writeTag(t,0),this.writeSVarint(e)}writeStringField(t,e){this.writeTag(t,2),this.writeString(e)}writeFloatField(t,e){this.writeTag(t,5),this.writeFloat(e)}writeDoubleField(t,e){this.writeTag(t,1),this.writeDouble(e)}writeBooleanField(t,e){this.writeVarintField(t,+e)}}function Cu(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Au(t,e,i){const r=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));i.realloc(r);for(let e=i.pos-1;e>=t;e--)i.buf[e+r]=i.buf[e]}function Eu(t,e){for(let i=0;i<t.length;i++)e.writeVarint(t[i])}function zu(t,e){for(let i=0;i<t.length;i++)e.writeSVarint(t[i])}function Du(t,e){for(let i=0;i<t.length;i++)e.writeFloat(t[i])}function ku(t,e){for(let i=0;i<t.length;i++)e.writeDouble(t[i])}function Ru(t,e){for(let i=0;i<t.length;i++)e.writeBoolean(t[i])}function Lu(t,e){for(let i=0;i<t.length;i++)e.writeFixed32(t[i])}function Fu(t,e){for(let i=0;i<t.length;i++)e.writeSFixed32(t[i])}function Bu(t,e){for(let i=0;i<t.length;i++)e.writeFixed64(t[i])}function Ou(t,e){for(let i=0;i<t.length;i++)e.writeSFixed64(t[i])}function ju(t,e,i){1===t&&i.readMessage(Vu,e)}function Vu(t,e,i){if(3===t){const{id:t,bitmap:r,width:n,height:a,left:s,top:o,advance:l}=i.readMessage(Nu,{});e.push({id:t,bitmap:new kc({width:n+6,height:a+6},r),metrics:{width:n,height:a,left:s,top:o,advance:l}})}}function Nu(t,e,i){1===t?e.id=i.readVarint():2===t?e.bitmap=i.readBytes():3===t?e.width=i.readVarint():4===t?e.height=i.readVarint():5===t?e.left=i.readSVarint():6===t?e.top=i.readSVarint():7===t&&(e.advance=i.readVarint())}function Uu(t){let e=0,i=0;for(const r of t)e+=r.w*r.h,i=Math.max(i,r.w);t.sort(((t,e)=>e.h-t.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),i),h:1/0}];let n=0,a=0;for(const e of t)for(let t=r.length-1;t>=0;t--){const i=r[t];if(!(e.w>i.w||e.h>i.h)){if(e.x=i.x,e.y=i.y,a=Math.max(a,e.y+e.h),n=Math.max(n,e.x+e.w),e.w===i.w&&e.h===i.h){const e=r.pop();e&&t<r.length&&(r[t]=e)}else e.h===i.h?(i.x+=e.w,i.w-=e.w):e.w===i.w?(i.y+=e.h,i.h-=e.h):(r.push({x:i.x+e.w,y:i.y,w:i.w-e.w,h:e.h}),i.y+=e.h,i.h-=e.h);break}}return{w:n,h:a,fill:e/(n*a)||0}}class Zu{constructor(t,{pixelRatio:e,version:i,stretchX:r,stretchY:n,content:a,textFitWidth:s,textFitHeight:o}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=r,this.stretchY=n,this.content=a,this.version=i,this.textFitWidth=s,this.textFitHeight=o}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}var Gu;function $u(t){let e=.5,i=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:e,verticalAlign:i}}function qu(t,e){const{expression:i}=e;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new ks(t+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:r}=i;let n=0;for(;n<e.length&&e[n]<=t;)n++;n=Math.max(0,n-1);let a=n;for(;a<e.length&&e[a]<t+1;)a++;a=Math.min(e.length-1,a);const s=e[n],o=e[a];return"composite"===i.kind?{kind:"composite",minZoom:s,maxZoom:o,interpolationType:r}:{kind:"camera",minZoom:s,maxZoom:o,minSize:i.evaluate(new ks(s)),maxSize:i.evaluate(new ks(o)),interpolationType:r}}}function Wu(t,{uSize:e,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===t.kind?r/128:"composite"===t.kind?wr.number(r/128,n/128,i):e}function Hu(t,e){let i=0,r=0;if("constant"===t.kind)r=t.layoutSize;else if("source"!==t.kind){const{interpolationType:n,minZoom:a,maxZoom:s}=t,o=n?vt(vr.interpolationFactor(n,e,a,s),0,1):0;"camera"===t.kind?r=wr.number(t.minSize,t.maxSize,o):i=o}return{uSizeT:i,uSize:r}}function Xu(t,e,i){let r="never";const n=t.get(e);return n?r=n:t.get(i)&&(r="always"),r}fs("ImagePosition",Zu),fs("ImageAtlas",class{constructor(t,e){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(t,i,n),this.addImages(e,r,n);const{w:a,h:s}=Uu(n),o=new Rc({width:a||1,height:s||1});for(const e in t){const r=t[e],n=i[e].paddedRect;Rc.copy(r.data,o,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const t in e){const i=e[t],n=r[t].paddedRect,a=n.x+1,s=n.y+1,l=i.data.width,c=i.data.height;Rc.copy(i.data,o,{x:0,y:0},{x:a,y:s},i.data),Rc.copy(i.data,o,{x:0,y:c-1},{x:a,y:s-1},{width:l,height:1}),Rc.copy(i.data,o,{x:0,y:0},{x:a,y:s+c},{width:l,height:1}),Rc.copy(i.data,o,{x:l-1,y:0},{x:a-1,y:s},{width:1,height:c}),Rc.copy(i.data,o,{x:0,y:0},{x:a+l,y:s},{width:1,height:c})}this.image=o,this.iconPositions=i,this.patternPositions=r}addImages(t,e,i){for(const r in t){const n=t[r],a={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(a),e[r]=new Zu(a,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in t.updatedImages)this.patchUpdatedImage(this.iconPositions[i],t.getImage(i),e),this.patchUpdatedImage(this.patternPositions[i],t.getImage(i),e)}patchUpdatedImage(t,e,i){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[r,n]=t.tl;i.update(e.data,void 0,{x:r,y:n})}}),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(Gu||(Gu={}));const Yu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Ku(t,e,i,r,n,a,s,o,l,c,h,u,d){const p=o?Math.min(32640,Math.round(o[0])):0,f=o?Math.min(32640,Math.round(o[1])):0;t.emplaceBack(e,i,Math.round(32*r),Math.round(32*n),a,s,(p<<1)+(l?1:0),f,16*c,16*h,256*u,256*d)}function Ju(t,e,i){t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i)}function Qu(t){for(const e of t.sections)if(zs(e.text))return!0;return!1}class td{constructor(t){this.layoutVertexArray=new Qo,this.indexArray=new sl,this.programConfigurations=t,this.segments=new ul,this.dynamicLayoutVertexArray=new tl,this.opacityVertexArray=new el,this.hasVisibleVertices=!1,this.placedSymbolArray=new Ro}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,gu.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,yu.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Yu,!0),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}fs("SymbolBuffers",td);class ed{constructor(t,e,i){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new i,this.segments=new ul,this.collisionVertexArray=new nl}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,xu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}fs("CollisionBuffers",ed);class id{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=Bt(globalThis)?Math.min(t.overscaling,128):t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasDependencies=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=qu(this.zoom,e["text-size"]),this.iconSizeData=qu(this.zoom,e["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap="never"!==Xu(i,"text-overlap","text-allow-overlap")||"never"!==Xu(i,"icon-overlap","icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&!r.isConstant(),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===i.get("symbol-placement")&&(this.writingModes=i.get("text-writing-mode").map((t=>Gu[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new td(new Wl(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new td(new Wl(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Bo,this.lineVertexArray=new Oo,this.symbolInstances=new Fo,this.textAnchorOffsets=new Vo}calculateGlyphDependencies(t,e,i,r,n){for(let a=0;a<t.length;a++)if(e[t.charCodeAt(a)]=!0,(i||r)&&n){const i=Tu[t.charAt(a)];i&&(e[i.charCodeAt(0)]=!0)}}populate(t,e,i){const r=this.layers[0],n=r.layout,a=n.get("text-font"),s=n.get("text-field"),o=n.get("icon-image"),l=("constant"!==s.value.kind||s.value.value instanceof Oi&&!s.value.value.isEmpty()||s.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==o.value.kind||!!o.value.value||Object.keys(o.parameters).length>0,h=n.get("symbol-sort-key");if(this.features=[],!l&&!c)return;const u=e.iconDependencies,d=e.glyphDependencies,p=e.availableImages,f=new ks(this.zoom);for(const{feature:e,id:s,index:o,sourceLayerIndex:m}of t){const t=r._featureFilter.needGeometry,_=Ql(e,t);if(!r._featureFilter.filter(f,_,i))continue;let g,y;if(t||(_.geometry=Jl(e)),l){const t=r.getValueAndResolveTokens("text-field",_,i,p),e=Oi.factory(t),n=this.hasRTLText=this.hasRTLText||Qu(e);(!n||"unavailable"===Ds.getRTLTextPluginStatus()||n&&Ds.isParsed())&&(g=wu(e,r,_))}if(c){const t=r.getValueAndResolveTokens("icon-image",_,i,p);y=t instanceof $i?t:$i.fromString(t)}if(!g&&!y)continue;const x=this.sortFeaturesByKey?h.evaluate(_,{},i):void 0;if(this.features.push({id:s,text:g,icon:y,index:o,sourceLayerIndex:m,geometry:_.geometry,properties:e.properties,type:jh.types[e.type],sortKey:x}),y&&(u[y.name]=!0),g){const t=a.evaluate(_,{},i).join(","),e="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Gu.vertical)>=0;for(const i of g.sections)if(i.image)u[i.image.name]=!0;else{const r=Ps(g.toString()),n=i.fontStack||t,a=d[n]=d[n]||{};this.calculateGlyphDependencies(i.text,a,e,this.allowVerticalPlacement,r)}}}"line"===n.get("symbol-placement")&&(this.features=function(t){const e={},i={},r=[];let n=0;function a(e){r.push(t[e]),n++}function s(t,e,n){const a=i[t];return delete i[t],i[e]=a,r[a].geometry[0].pop(),r[a].geometry[0]=r[a].geometry[0].concat(n[0]),a}function o(t,i,n){const a=e[i];return delete e[i],e[t]=a,r[a].geometry[0].shift(),r[a].geometry[0]=n[0].concat(r[a].geometry[0]),a}function l(t,e,i){const r=i?e[0][e[0].length-1]:e[0][0];return`${t}:${r.x}:${r.y}`}for(let c=0;c<t.length;c++){const h=t[c],u=h.geometry,d=h.text?h.text.toString():null;if(!d){a(c);continue}const p=l(d,u),f=l(d,u,!0);if(p in i&&f in e&&i[p]!==e[f]){const t=o(p,f,u),n=s(p,f,r[t].geometry);delete e[p],delete i[f],i[l(d,r[n].geometry,!0)]=n,r[t].geometry=null}else p in i?s(p,f,u):f in e?o(p,f,u):(a(c),e[p]=n-1,i[f]=n-1)}return r.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,i){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:i}),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,{imagePositions:i}))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const i=this.lineVertexArray.length;if(void 0!==t.segment){let i=t.dist(e[t.segment+1]),r=t.dist(e[t.segment]);const n={};for(let r=t.segment+1;r<e.length;r++)n[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r<e.length-1&&(i+=e[r+1].dist(e[r]));for(let i=t.segment||0;i>=0;i--)n[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i>0&&(r+=e[i-1].dist(e[i]));for(let t=0;t<e.length;t++){const e=n[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(t,e,i,r,n,a,s,o,l,c,h,u){const d=t.indexArray,p=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,p,d,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,_=f.vertexLength,g=this.allowVerticalPlacement&&s===Gu.vertical?Math.PI/2:0,y=a.text&&a.text.sections;for(let r=0;r<e.length;r++){const{tl:n,tr:s,bl:l,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:_,minFontScaleX:x,minFontScaleY:v,glyphOffset:b,isSDF:w,sectionIndex:T}=e[r],P=f.vertexLength,M=b[1];Ku(p,o.x,o.y,n.x,M+n.y,h.x,h.y,i,w,m.x,m.y,x,v),Ku(p,o.x,o.y,s.x,M+s.y,h.x+h.w,h.y,i,w,_.x,m.y,x,v),Ku(p,o.x,o.y,l.x,M+l.y,h.x,h.y+h.h,i,w,m.x,_.y,x,v),Ku(p,o.x,o.y,c.x,M+c.y,h.x+h.w,h.y+h.h,i,w,_.x,_.y,x,v),Ju(t.dynamicLayoutVertexArray,o,g),d.emplaceBack(P,P+2,P+1),d.emplaceBack(P+1,P+2,P+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(b[0]),r!==e.length-1&&T===e[r+1].sectionIndex||t.programConfigurations.populatePaintArrays(p.length,a,a.index,{imagePositions:{},canonical:u,formattedSection:y&&y[T]})}t.placedSymbolArray.emplaceBack(o.x,o.y,m,this.glyphOffsetArray.length-m,_,l,c,o.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],s,0,!1,0,h)}_addCollisionDebugVertex(t,e,i,r,n,a){return e.emplaceBack(0,0),t.emplaceBack(i.x,i.y,r,n,Math.round(a.x),Math.round(a.y))}addCollisionDebugVertices(t,e,i,r,n,s,o){const l=n.segments.prepareSegment(4,n.layoutVertexArray,n.indexArray),c=l.vertexLength,h=n.layoutVertexArray,u=n.collisionVertexArray,d=o.anchorX,p=o.anchorY;this._addCollisionDebugVertex(h,u,s,d,p,new a(t,e)),this._addCollisionDebugVertex(h,u,s,d,p,new a(i,e)),this._addCollisionDebugVertex(h,u,s,d,p,new a(i,r)),this._addCollisionDebugVertex(h,u,s,d,p,new a(t,r)),l.vertexLength+=4;const f=n.indexArray;f.emplaceBack(c,c+1),f.emplaceBack(c+1,c+2),f.emplaceBack(c+2,c+3),f.emplaceBack(c+3,c),l.primitiveLength+=4}addDebugCollisionBoxes(t,e,i,r){for(let n=t;n<e;n++){const t=this.collisionBoxArray.get(n);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,r?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,i)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new ed(il,vu.members,ol),this.iconCollisionBox=new ed(il,vu.members,ol);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,i,r,n,a,s,o,l){const c={};for(let r=e;r<i;r++){const e=t.get(r);c.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},c.textFeatureIndex=e.featureIndex;break}for(let e=r;e<n;e++){const i=t.get(e);c.verticalTextBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalTextFeatureIndex=i.featureIndex;break}for(let e=a;e<s;e++){const i=t.get(e);c.iconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.iconFeatureIndex=i.featureIndex;break}for(let e=o;e<l;e++){const i=t.get(e);c.verticalIconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalIconFeatureIndex=i.featureIndex;break}return c}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const i=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const i=t.placedSymbolArray.get(e),r=i.vertexStartIndex+4*i.numGlyphs;for(let e=i.vertexStartIndex;e<r;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),i=Math.cos(t),r=[],n=[],a=[];for(let t=0;t<this.symbolInstances.length;++t){a.push(t);const s=this.symbolInstances.get(t);r.push(0|Math.round(e*s.anchorX+i*s.anchorY)),n.push(s.featureIndex)}return a.sort(((t,e)=>r[t]-r[e]||n[e]-n[t])),a}addToSortKeyRanges(t,e){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===e?i.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,i)=>{t>=0&&i.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let rd,nd;fs("SymbolBucket",id,{omit:["layers","collisionBoxArray","features","compareText"]}),id.MAX_GLYPHS=65535,id.addDynamicAttributes=Ju;var ad={get paint(){return nd=nd||new Hs({"icon-opacity":new Gs(Me.paint_symbol["icon-opacity"]),"icon-color":new Gs(Me.paint_symbol["icon-color"]),"icon-halo-color":new Gs(Me.paint_symbol["icon-halo-color"]),"icon-halo-width":new Gs(Me.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Gs(Me.paint_symbol["icon-halo-blur"]),"icon-translate":new Zs(Me.paint_symbol["icon-translate"]),"icon-translate-anchor":new Zs(Me.paint_symbol["icon-translate-anchor"]),"text-opacity":new Gs(Me.paint_symbol["text-opacity"]),"text-color":new Gs(Me.paint_symbol["text-color"],{runtimeType:qe,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Gs(Me.paint_symbol["text-halo-color"]),"text-halo-width":new Gs(Me.paint_symbol["text-halo-width"]),"text-halo-blur":new Gs(Me.paint_symbol["text-halo-blur"]),"text-translate":new Zs(Me.paint_symbol["text-translate"]),"text-translate-anchor":new Zs(Me.paint_symbol["text-translate-anchor"])})},get layout(){return rd=rd||new Hs({"symbol-placement":new Zs(Me.layout_symbol["symbol-placement"]),"symbol-spacing":new Zs(Me.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Zs(Me.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Gs(Me.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Zs(Me.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Zs(Me.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Zs(Me.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Zs(Me.layout_symbol["icon-ignore-placement"]),"icon-optional":new Zs(Me.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Zs(Me.layout_symbol["icon-rotation-alignment"]),"icon-size":new Gs(Me.layout_symbol["icon-size"]),"icon-text-fit":new Zs(Me.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Zs(Me.layout_symbol["icon-text-fit-padding"]),"icon-image":new Gs(Me.layout_symbol["icon-image"]),"icon-rotate":new Gs(Me.layout_symbol["icon-rotate"]),"icon-padding":new Gs(Me.layout_symbol["icon-padding"]),"icon-keep-upright":new Zs(Me.layout_symbol["icon-keep-upright"]),"icon-offset":new Gs(Me.layout_symbol["icon-offset"]),"icon-anchor":new Gs(Me.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Zs(Me.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Zs(Me.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Zs(Me.layout_symbol["text-rotation-alignment"]),"text-field":new Gs(Me.layout_symbol["text-field"]),"text-font":new Gs(Me.layout_symbol["text-font"]),"text-size":new Gs(Me.layout_symbol["text-size"]),"text-max-width":new Gs(Me.layout_symbol["text-max-width"]),"text-line-height":new Zs(Me.layout_symbol["text-line-height"]),"text-letter-spacing":new Gs(Me.layout_symbol["text-letter-spacing"]),"text-justify":new Gs(Me.layout_symbol["text-justify"]),"text-radial-offset":new Gs(Me.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Zs(Me.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new Gs(Me.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new Gs(Me.layout_symbol["text-anchor"]),"text-max-angle":new Zs(Me.layout_symbol["text-max-angle"]),"text-writing-mode":new Zs(Me.layout_symbol["text-writing-mode"]),"text-rotate":new Gs(Me.layout_symbol["text-rotate"]),"text-padding":new Zs(Me.layout_symbol["text-padding"]),"text-keep-upright":new Zs(Me.layout_symbol["text-keep-upright"]),"text-transform":new Gs(Me.layout_symbol["text-transform"]),"text-offset":new Gs(Me.layout_symbol["text-offset"]),"text-allow-overlap":new Zs(Me.layout_symbol["text-allow-overlap"]),"text-overlap":new Zs(Me.layout_symbol["text-overlap"]),"text-ignore-placement":new Zs(Me.layout_symbol["text-ignore-placement"]),"text-optional":new Zs(Me.layout_symbol["text-optional"])})}};class sd{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:Ue,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}fs("FormatSectionOverride",sd,{omit:["defaultValue"]});class od extends Ys{constructor(t,e){super(t,ad,e)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const i of t)e.indexOf(i)<0&&e.push(i);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,i,r){const n=this.layout.get(t).evaluate(e,{},i,r),a=this._unevaluatedLayout._values[t];return a.isDataDriven()||ca(a.value)||!n?n:function(t,e){return e.replace(/{([^{}]+)}/g,((e,i)=>t&&i in t?String(t[i]):""))}(e.properties,n)}createBucket(t){return new id(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of ad.paint.overridableProperties){if(!od.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),i=new sd(e),r=new la(i,e.property.specification);let n=null;n="constant"===e.value.kind||"source"===e.value.kind?new ua("source",r):new da("composite",r,e.value.zoomStops),this.paint._values[t]=new Ns(e.property,n,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,i){return!(!this.layout||e.isDataDriven()||i.isDataDriven())&&od.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const i=t.get("text-field"),r=ad.paint.properties[e];let n=!1;const a=t=>{for(const e of t)if(r.overrides&&r.overrides.hasOverride(e))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Oi)a(i.value.value.sections);else if("source"===i.value.kind||"composite"===i.value.kind){const t=e=>{n||(e instanceof Ki&&Xi(e.value)===Ke?a(e.value.sections):e instanceof Lr?a(e.sections):e.eachChild(t))},e=i.value;e._styleExpression&&t(e._styleExpression.expression)}return n}}let ld;var cd={get paint(){return ld=ld||new Hs({"background-color":new Zs(Me.paint_background["background-color"]),"background-pattern":new qs(Me.paint_background["background-pattern"]),"background-opacity":new Zs(Me.paint_background["background-opacity"])})}};class hd extends Ys{constructor(t,e){super(t,cd,e)}}class ud extends Ys{constructor(t,e){super(t,{},e),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function dd(t,e){if("custom"===t.type)return new ud(t,e);switch(t.type){case"background":return new hd(t,e);case"circle":return new Sc(t,e);case"color-relief":return new $c(t,e);case"fill":return new Lh(t,e);case"fill-extrusion":return new tu(t,e);case"heatmap":return new Bc(t,e);case"hillshade":return new Vc(t,e);case"line":return new mu(t,e);case"raster":return new to(t,e);case"symbol":return new od(t,e)}}function pd(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:r,url:n}of t){const t=`${r}${n}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:r,url:n}))}}return e}function fd(t,e,i){try{const r=new URL(t);return r.pathname+=`${e}${i}`,r.toString()}catch(e){throw new Error(`Invalid sprite URL "${t}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function md(t){const{userImage:e}=t;return!!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class _d extends Pe{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new Rc({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[]}}getImage(t){const e=this.images[t];if(e&&!e.data&&e.spriteData){const t=e.spriteData;e.data=new Rc({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),e.spriteData=null}return e}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e)}_validate(t,e){let i=!0;const r=e.data||e.spriteData;return this._validateStretch(e.stretchX,r&&r.width)||(this.fire(new Te(new Error(`Image "${t}" has invalid "stretchX" value`))),i=!1),this._validateStretch(e.stretchY,r&&r.height)||(this.fire(new Te(new Error(`Image "${t}" has invalid "stretchY" value`))),i=!1),this._validateContent(e.content,e)||(this.fire(new Te(new Error(`Image "${t}" has invalid "content" value`))),i=!1),i}_validateStretch(t,e){if(!t)return!0;let i=0;for(const r of t){if(r[0]<i||r[1]<r[0]||e<r[1])return!1;i=r[1]}return!0}_validateContent(t,e){if(!t)return!0;if(4!==t.length)return!1;const i=e.spriteData,r=i&&i.width||e.data.width,n=i&&i.height||e.data.height;return!(t[0]<0||r<t[0]||t[1]<0||n<t[1]||t[2]<0||r<t[2]||t[3]<0||n<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const r=this.getImage(t);if(i&&(r.data.width!==e.data.width||r.data.height!==e.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=r.version+1,this.images[t]=e,this.updatedImages[t]=!0}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let r=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(r=!1);this.isLoaded()||r?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e})}))}_getImagesForIds(t){const e={};for(const i of t){let t=this.getImage(i);t||(this.fire(new we("styleimagemissing",{id:i})),t=this.getImage(i)),t?e[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,textFitWidth:t.textFitWidth,textFitHeight:t.textFitHeight,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:kt(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}return e}getPixelSize(){const{width:t,height:e}=this.atlasImage;return{width:t,height:e}}getPattern(t){const e=this.patterns[t],i=this.getImage(t);if(!i)return null;if(e&&e.position.version===i.version)return e.position;if(e)e.position.version=i.version;else{const e={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new Zu(e,i);this.patterns[t]={bin:e,position:r}}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Zc(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE)}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:e,h:i}=Uu(t),r=this.atlasImage;r.resize({width:e||1,height:i||1});for(const t in this.patterns){const{bin:e}=this.patterns[t],i=e.x+1,n=e.y+1,a=this.getImage(t).data,s=a.width,o=a.height;Rc.copy(a,r,{x:0,y:0},{x:i,y:n},{width:s,height:o}),Rc.copy(a,r,{x:0,y:o-1},{x:i,y:n-1},{width:s,height:1}),Rc.copy(a,r,{x:0,y:0},{x:i,y:n+o},{width:s,height:1}),Rc.copy(a,r,{x:s-1,y:0},{x:i-1,y:n},{width:1,height:o}),Rc.copy(a,r,{x:0,y:0},{x:i+s,y:n},{width:1,height:o})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.getImage(e);t||kt(`Image with ID: "${e}" was not found`),md(t)&&this.updateImage(e,t)}}}const gd=1e20;function yd(t,e,i,r,n,a,s,o,l){for(let c=e;c<e+r;c++)xd(t,i*a+c,a,n,s,o,l);for(let c=i;c<i+n;c++)xd(t,c*a+e,1,r,s,o,l)}function xd(t,e,i,r,n,a,s){a[0]=0,s[0]=-gd,s[1]=gd,n[0]=t[e];for(let o=1,l=0,c=0;o<r;o++){n[o]=t[e+o*i];const r=o*o;do{const t=a[l];c=(n[o]-n[t]+r-t*t)/(o-t)/2}while(c<=s[l]&&--l>-1);l++,a[l]=o,s[l]=c,s[l+1]=gd}for(let o=0,l=0;o<r;o++){for(;s[l+1]<o;)l++;const r=a[l],c=o-r;t[e+o*i]=n[r]+c*c}}const vd=as.layout_symbol["text-font"].default.join(",");class bd{constructor(t,e,i){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={},this.lang=i}setURL(t){this.url=t}getGlyphs(t){return n(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const r of t[i])e.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(e),r={};for(const{stack:t,id:e,glyph:n}of i)r[t]||(r[t]={}),r[t][e]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics};return r}))}_getAndCacheGlyphsPromise(t,e){return n(this,void 0,void 0,(function*(){let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{}});let r=i.glyphs[e];return void 0!==r?{stack:t,id:e,glyph:r}:!this.url||this._charUsesLocalIdeographFontFamily(e)?(r=i.glyphs[e]=this._drawGlyph(i,t,e),{stack:t,id:e,glyph:r}):yield this._downloadAndCacheRangePromise(t,e)}))}_downloadAndCacheRangePromise(t,e){return n(this,void 0,void 0,(function*(){const i=Math.floor(e/256);if(256*i>65535)throw new Error("glyphs > 65535 not supported");const r=this.entries[t];if(r.ranges[i])return{stack:t,id:e,glyph:null};if(!r.requests[i]){const e=bd.loadGlyphRange(t,i,this.url,this.requestManager);r.requests[i]=e}try{const n=yield r.requests[i];for(const t in n)r.glyphs[+t]=n[+t];return r.ranges[i]=!0,{stack:t,id:e,glyph:n[e]||null}}catch(n){const a=r.glyphs[e]=this._drawGlyph(r,t,e);return this._warnOnMissingGlyphRange(a,i,e,n),{stack:t,id:e,glyph:a}}}))}_warnOnMissingGlyphRange(t,e,i,r){const n=256*e;kt(`Unable to load glyph range ${e}, ${n}-${n+255}. Rendering codepoint U+${i.toString(16).padStart(4,"0").toUpperCase()} locally instead. ${r}`)}_charUsesLocalIdeographFontFamily(t){return!!this.localIdeographFontFamily&&(/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(t))||(e=t)>=19968&&e<=40959||(t=>t>=44032&&t<=55215)(t)||(t=>t>=12352&&t<=12447)(t)||ws(t)||bs(t)||Ts(t));var e}_drawGlyph(t,e,i){const r=e===vd&&""!==this.localIdeographFontFamily&&this._charUsesLocalIdeographFontFamily(i),n=r?"ideographTinySDF":"tinySDF";t[n]||(t[n]=this._createTinySDF(r?this.localIdeographFontFamily:e));const a=t[n].draw(String.fromCharCode(i));return{id:i,bitmap:new kc({width:a.width||60,height:a.height||60},a.data),metrics:{width:a.glyphWidth/2||24,height:a.glyphHeight/2||24,left:a.glyphLeft/2+.5||0,top:a.glyphTop/2-27.5||-8,advance:a.glyphAdvance/2||24,isDoubleResolution:!0}}}_createTinySDF(t){const e=t?t.split(","):[];e.push("sans-serif");const i=e.map((t=>/[-\w]+/.test(t)?t:`'${CSS.escape(t)}'`)).join(",");return new bd.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:i,fontWeight:this._fontWeight(e[0]),fontStyle:this._fontStyle(e[0]),lang:this.lang})}_fontStyle(t){return/italic/i.test(t)?"italic":/oblique/i.test(t)?"oblique":"normal"}_fontWeight(t){const e={thin:100,hairline:100,"extra light":200,"ultra light":200,light:300,normal:400,regular:400,medium:500,semibold:600,demibold:600,bold:700,"extra bold":800,"ultra bold":800,black:900,heavy:900,"extra black":950,"ultra black":950};let i;for(const[r,n]of Object.entries(e))new RegExp(`\\b${r}\\b`,"i").test(t)&&(i=`${n}`);return i}}bd.loadGlyphRange=function(t,e,i,r){return n(this,void 0,void 0,(function*(){const n=256*e,a=n+255,s=r.transformRequest(i.replace("{fontstack}",t).replace("{range}",`${n}-${a}`),"Glyphs"),o=yield(l=s,c=new AbortController,ce(wt(l,{type:"arrayBuffer"}),c));var l,c;if(!o||!o.data)throw new Error(`Could not load glyph range. range: ${e}, ${n}-${a}`);const h={};for(const t of new Iu(o.data).readFields(ju,[]))h[t.id]=t;return h}))},bd.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:a="normal",fontStyle:s="normal",lang:o=null}={}){this.buffer=e,this.cutoff=r,this.radius=i,this.lang=o;const l=this.size=t+4*e,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${s} ${a} ${t}px ${n}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l)}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:a}=this.ctx.measureText(t),s=Math.ceil(i),o=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(a-n))),l=Math.min(this.size-this.buffer,s+Math.ceil(r)),c=o+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),p={data:d,width:c,height:h,glyphWidth:o,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:e};if(0===o||0===l)return p;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;this.lang&&(f.lang=this.lang),f.clearRect(m,m,o,l),f.fillText(t,m,m+s);const y=f.getImageData(m,m,o,l);g.fill(gd,0,u),_.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<o;e++){const i=y.data[4*(t*o+e)+3]/255;if(0===i)continue;const r=(t+m)*c+e+m;if(1===i)g[r]=0,_[r]=gd;else{const t=.5-i;g[r]=t>0?t*t:0,_[r]=t<0?t*t:0}}yd(g,0,0,c,h,c,this.f,this.v,this.z),yd(_,m,m,o,l,c,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(_[t]);d[t]=Math.round(255-255*(e/this.radius+this.cutoff))}return p}};class wd{constructor(){this.specification=Me.light.position}possiblyEvaluate(t,e){return function([t,e,i]){return e+=90,e*=Math.PI/180,i*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(i),y:t*Math.sin(e)*Math.sin(i),z:t*Math.cos(i)}}(t.expression.evaluate(e))}interpolate(t,e,i){return{x:wr.number(t.x,e.x,i),y:wr.number(t.y,e.y,i),z:wr.number(t.z,e.z,i)}}}let Td;class Pd extends Pe{constructor(t){super(),Td=Td||new Hs({anchor:new Zs(Me.light.anchor),position:new wd,color:new Zs(Me.light.color),intensity:new Zs(Me.light.intensity)}),this._transitionable=new Bs(Td,void 0),this.setLight(t),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(t,e={}){if(!this._validate(os,t,e))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i){return(!i||!1!==i.validate)&&us(this,t.call(ss,{value:e,style:{glyphs:!0,sprite:!0},styleSpec:Me}))}}const Md=new Hs({"sky-color":new Zs(Me.sky["sky-color"]),"horizon-color":new Zs(Me.sky["horizon-color"]),"fog-color":new Zs(Me.sky["fog-color"]),"fog-ground-blend":new Zs(Me.sky["fog-ground-blend"]),"horizon-fog-blend":new Zs(Me.sky["horizon-fog-blend"]),"sky-horizon-blend":new Zs(Me.sky["sky-horizon-blend"]),"atmosphere-blend":new Zs(Me.sky["atmosphere-blend"])});class Sd extends Pe{constructor(t){super(),this._transitionable=new Bs(Md,void 0),this.setSky(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new ks(0))}setSky(t,e={}){if(!this._validate(ls,t,e)){t||(t={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}}getSky(){return this._transitionable.serialize()}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i={}){return!1!==(null==i?void 0:i.validate)&&us(this,t.call(ss,wt({value:e,style:{glyphs:!0,sprite:!0},styleSpec:Me})))}calculateFogBlendOpacity(t){return t<60?0:t<70?(t-60)/10:1}}class Id{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={}}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const r=[];let n=t.length%2==1?-t[t.length-1]*i:0,a=t[0]*i,s=!0;r.push({left:n,right:a,isDash:s,zeroLength:0===t[0]});let o=t[0];for(let e=1;e<t.length;e++){s=!s;const l=t[e];n=o*i,o+=l,a=o*i,r.push({left:n,right:a,isDash:s,zeroLength:0===l})}return r}addRoundDash(t,e,i){const r=e/2;for(let e=-i;e<=i;e++){const n=this.width*(this.nextRow+i+e);let a=0,s=t[a];for(let o=0;o<this.width;o++){o/s.right>1&&(s=t[++a]);const l=Math.abs(o-s.left),c=Math.abs(o-s.right),h=Math.min(l,c);let u;const d=e/i*(r+1);if(s.isDash){const t=r-Math.abs(d);u=Math.sqrt(h*h+t*t)}else u=r-Math.sqrt(h*h+d*d);this.data[n+o]=Math.max(0,Math.min(255,u+128))}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],r=t[e+1];i.zeroLength?t.splice(e,1):r&&r.isDash===i.isDash&&(r.left=i.left,t.splice(e,1))}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const r=this.width*this.nextRow;let n=0,a=t[n];for(let e=0;e<this.width;e++){e/a.right>1&&(a=t[++n]);const i=Math.abs(e-a.left),s=Math.abs(e-a.right),o=Math.min(i,s);this.data[r+e]=Math.max(0,Math.min(255,(a.isDash?o:-o)+128))}}addDash(t,e){const i=e?7:0,r=2*i+1;if(this.nextRow+r>this.height)return kt("LineAtlas out of space"),null;let n=0;for(let e=0;e<t.length;e++)n+=t[e];if(0!==n){const r=this.width/n,a=this.getDashRanges(t,this.width,r);e?this.addRoundDash(a,r,i):this.addRegularDash(a)}const a={y:this.nextRow+i,height:2*i,width:n};return this.nextRow+=r,this.dirty=!0,a}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data))}}class Cd{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const Ad={once:!0};class Ed{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Cd((()=>this.process())),this.subscription=Vt(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=Lt(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((i,r)=>{const n=Math.round(1e18*Math.random()).toString(36).substring(0,10),a=e?Vt(e.signal,"abort",(()=>{null==a||a.unsubscribe(),delete this.resolveRejects[n];const e={id:n,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),Ad):null;this.resolveRejects[n]={resolve:t=>{null==a||a.unsubscribe(),i(t)},reject:t=>{null==a||a.unsubscribe(),r(t)}};const s=[],o=Object.assign(Object.assign({},t),{id:n,sourceMapId:this.mapId,origin:location.origin,data:ys(t.data,s)});this.target.postMessage(o,{transfer:s})}))}receive(t){const e=t.data,i=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[i];const t=this.abortControllers[i];return delete this.abortControllers[i],void(t&&t.abort())}if(Lt(self)||e.mustQueue)return this.tasks[i]=e,this.taskQueue.push(i),void this.invoker.trigger();this.processTask(i,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(t,e){return n(this,void 0,void 0,(function*(){if("<response>"===e.type){const i=this.resolveRejects[t];if(delete this.resolveRejects[t],!i)return;return void(e.error?i.reject(xs(e.error)):i.resolve(xs(e.data)))}if(!this.messageHandlers[e.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${e.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const i=xs(e.data),r=new AbortController;this.abortControllers[t]=r;try{const n=yield this.messageHandlers[e.type](e.sourceMapId,i,r);this.completeTask(t,null,n)}catch(e){this.completeTask(t,e)}}))}completeTask(t,e,i){const r=[];delete this.abortControllers[t];const n={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?ys(e):null,data:ys(i,r)};this.target.postMessage(n,{transfer:r})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}const zd="maplibre_preloaded_worker_pool";class Dd{constructor(){this.active={}}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<Dd.workerCount;)this.workers.push(new Worker(ne.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[zd]}numActive(){return Object.keys(this.active).length}}const kd=Math.floor(te.hardwareConcurrency/2);let Rd,Ld;function Fd(){return Rd||(Rd=new Dd),Rd}Dd.workerCount=Bt(globalThis)?Math.max(Math.min(kd,3),1):1;class Bd{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e;const i=this.workerPool.acquire(e);for(let t=0;t<i.length;t++){const r=new Ed(i[t],e);r.name=`Worker ${t}`,this.actors.push(r)}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove()})),this.actors=[],t&&this.workerPool.release(this.id)}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e)}}function Od(){return Ld||(Ld=new Bd(Fd(),se),Ld.registerMessageHandler("GR",((t,e,i)=>ce(e,i)))),Ld}function jd(t,e){const i=_();return b(i,i,[1,1,0]),w(i,i,[.5*t.width,.5*t.height,1]),t.calculatePosMatrix?v(i,i,t.calculatePosMatrix(e.toUnwrapped())):i}function Vd(t,e,i,r,n,a,s){var o;const l=function(t,e,i){if(t)for(const r of t){const t=e[r];if(t&&t.source===i&&"fill-extrusion"===t.type)return!0}else for(const t in e){const r=e[t];if(r.source===i&&"fill-extrusion"===r.type)return!0}return!1}(null!==(o=null==n?void 0:n.layers)&&void 0!==o?o:null,e,t.id),c=a.maxPitchScaleFactor(),h=t.tilesIn(r,c,l);h.sort(Nd);const u=[];for(const r of h)u.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(e,i,t.getState(),r.queryGeometry,r.cameraQueryGeometry,r.scale,n,a,c,jd(a,r.tileID),s?(t,e)=>s(r.tileID,t,e):void 0)});return function(t,e){for(const i in t)for(const r of t[i])Ud(r,e);return t}(function(t){const e={},i={};for(const r of t){const t=r.queryResults,n=r.wrappedTileID,a=i[n]=i[n]||{};for(const i in t){const r=t[i],n=a[i]=a[i]||{},s=e[i]=e[i]||[];for(const t of r)n[t.featureIndex]||(n[t.featureIndex]=!0,s.push(t))}}return e}(u),t)}function Nd(t,e){const i=t.tileID,r=e.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function Ud(t,e){const i=t.feature,r=e.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r}function Zd(t,e,i){return n(this,void 0,void 0,(function*(){let r=t;if(t.url?r=(yield he(e.transformRequest(t.url,"Source"),i)).data:yield te.frameAsync(i),!r)return null;const n=Tt(wt(r,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in r&&r.vector_layers&&(n.vectorLayerIds=r.vector_layers.map((t=>t.id))),n}))}const Gd=6371008.8;class $d{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new $d(bt(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,i=this.lat*e,r=t.lat*e,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((t.lng-this.lng)*e);return Gd*Math.acos(Math.min(n,1))}static convert(t){if(t instanceof $d)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new $d(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new $d(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class qd{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])))}setNorthEast(t){return this._ne=t instanceof $d?new $d(t.lng,t.lat):$d.convert(t),this}setSouthWest(t){return this._sw=t instanceof $d?new $d(t.lng,t.lat):$d.convert(t),this}extend(t){const e=this._sw,i=this._ne;let r,n;if(t instanceof $d)r=t,n=t;else{if(!(t instanceof qd))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(qd.convert(t)):this.extend($d.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend($d.convert(t)):this;if(r=t._sw,n=t._ne,!r||!n)return this}return e||i?(e.lng=Math.min(r.lng,e.lng),e.lat=Math.min(r.lat,e.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new $d(r.lng,r.lat),this._ne=new $d(n.lng,n.lat)),this}getCenter(){return new $d((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new $d(this.getWest(),this.getNorth())}getSouthEast(){return new $d(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(t){const{lng:e,lat:i}=$d.convert(t);let r=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}intersects(t){if((t=qd.convert(t)).getNorth()<this.getSouth()||t.getSouth()>this.getNorth())return!1;const e=bt(this.getWest(),-180,180),i=bt(this.getEast(),-180,180),r=bt(t.getWest(),-180,180),n=bt(t.getEast(),-180,180),a=e>i,s=r>n;return!(!a||!s)||(a?n>=e||r<=i:s?i>=r||e<=n:!(r>i||n<e))}static convert(t){return t instanceof qd?t:t?new qd(t):t}static fromLngLat(t,e=0){const i=360*e/40075017,r=i/Math.cos(Math.PI/180*t.lat);return new qd(new $d(t.lng-r,t.lat-i),new $d(t.lng+r,t.lat+i))}adjustAntiMeridian(){const t=new $d(this._sw.lng,this._sw.lat),e=new $d(this._ne.lng,this._ne.lat);return new qd(t,t.lng>e.lng?new $d(e.lng+360,e.lat):e)}}const Wd=2*Math.PI*Gd;function Hd(t){return Wd*Math.cos(t*Math.PI/180)}function Xd(t){return(180+t)/360}function Yd(t){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Kd(t,e){return t/Hd(e)}function Jd(t){return 360*t-180}function Qd(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function tp(t,e){return t*Hd(Qd(e))}class ep{constructor(t,e,i=0){this.x=+t,this.y=+e,this.z=+i}static fromLngLat(t,e=0){const i=$d.convert(t);return new ep(Xd(i.lng),Yd(i.lat),Kd(e,i.lat))}toLngLat(){return new $d(Jd(this.x),Qd(this.y))}toAltitude(){return tp(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Wd*(t=Qd(this.y),1/Math.cos(t*Math.PI/180));var t}}class ip{constructor(t,e,i){this.bounds=qd.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const e=Math.pow(2,t.z),i=Math.floor(Xd(this.bounds.getWest())*e),r=Math.floor(Yd(this.bounds.getNorth())*e),n=Math.ceil(Xd(this.bounds.getEast())*e),a=Math.ceil(Yd(this.bounds.getSouth())*e);return t.x>=i&&t.x<n&&t.y>=r&&t.y<a}}class rp extends Pe{constructor(t,e,i,r){if(super(),this.id=t,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,wt(this,Tt(e,["url","scheme","tileSize","promoteId"])),this._options=wt({type:"vector"},e),this._collectResourceTiming=e.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r)}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new we("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield Zd(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.tileManagers[this.id].clearTiles(),t&&(wt(this,t),t.bounds&&(this.tileBounds=new ip(t.bounds,this.minzoom,this.maxzoom)),this.fire(new we("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new we("data",{dataType:"source",sourceDataType:"content"})))}catch(t){this._tileJSONRequest=null,this._loaded=!0,this.fire(new Te(t))}}))}loaded(){return this._loaded}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load()}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load()}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}serialize(){return wt({},this._options)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,"Tile"),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i}}))}else t.actor=this.dispatcher.getActor(),r="LT";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:r,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e)}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null)}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject)}}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"AT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}hasTransition(){return!1}}class np extends Pe{constructor(t,e,i,r){super(),this.id=t,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=wt({type:"raster"},e),wt(this,Tt(e,["url","scheme","tileSize"]))}load(){return n(this,arguments,void 0,(function*(t=!1){this._loaded=!1,this.fire(new we("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield Zd(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,e&&(wt(this,e),e.bounds&&(this.tileBounds=new ip(e.bounds,this.minzoom,this.maxzoom)),this.fire(new we("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new we("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:t})))}catch(t){this._tileJSONRequest=null,this._loaded=!0,this.fire(new Te(t))}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load()}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load(!0)}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}serialize(){return wt({},this._options)}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield ye.getImage(this.map._requestManager.transformRequest(e,"Tile"),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,r=e.gl,n=i.data;t.texture=this.map.painter.getTileTexture(n.width),t.texture?t.texture.update(n,{useMipmap:!0}):(t.texture=new Zc(e,n,r.RGBA,{useMipmap:!0}),t.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),t.state="loaded"}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController)}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture)}))}hasTransition(){return!1}}function ap(t,e,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[t*r-2*Math.PI*6378137/2,e*r-2*Math.PI*6378137/2]}class sp{constructor(t,e,i){if(!function(t,e,i){return!(t<0||t>25||i<0||i>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,i))throw new Error(`x=${e}, y=${i}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=i,this.key=cp(0,t,t,e,i)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,i){const r=(a=this.y,s=this.z,o=ap(256*(n=this.x),256*(a=Math.pow(2,s)-a-1),s),l=ap(256*(n+1),256*(a+1),s),o[0]+","+o[1]+","+l[0]+","+l[1]);var n,a,s,o,l;const c=function(t,e,i){let r,n="";for(let a=t;a>0;a--)r=1<<a-1,n+=(e&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===i?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,r)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new a((t.x*e-this.x)*Q,(t.y*e-this.y)*Q)}toString(){return`${this.z}/${this.x}/${this.y}`}}class op{constructor(t,e){this.wrap=t,this.canonical=e,this.key=cp(t,e.z,e.z,e.x,e.y)}}class lp{constructor(t,e,i,r,n){if(this.terrainRttPosMatrix32f=null,t<i)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${i}`);this.overscaledZ=t,this.wrap=e,this.canonical=new sp(i,+r,+n),this.key=cp(e,t,i,r,n)}clone(){return new lp(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new lp(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new lp(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}isOverscaled(){return this.overscaledZ>this.canonical.z}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const i=this.canonical.z-t;return t>this.canonical.z?cp(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):cp(this.wrap*+e,t,t,this.canonical.x>>i,this.canonical.y>>i)}isChildOf(t){if(t.wrap!==this.wrap)return!1;if(this.overscaledZ-t.overscaledZ<=0)return!1;if(0===t.overscaledZ)return this.overscaledZ>0;const e=this.canonical.z-t.canonical.z;return!(e<0)&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new lp(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new lp(e,this.wrap,e,i,r),new lp(e,this.wrap,e,i+1,r),new lp(e,this.wrap,e,i,r+1),new lp(e,this.wrap,e,i+1,r+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new lp(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new lp(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new op(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new ep(t.x-this.wrap,t.y))}}function cp(t,e,i,r,n){(t*=2)<0&&(t=-1*t-1);const a=1<<i;return(a*a*t+a*n+r).toString(36)+i.toString(36)+e.toString(36)}fs("CanonicalTileID",sp),fs("OverscaledTileID",lp,{omit:["terrainRttPosMatrix32f"]});class hp extends np{constructor(t,e,i,r){super(t,e,i,r),this.type="raster-dem",this.maxzoom=22,this._options=wt({type:"raster-dem"},e),this.encoding=e.encoding||"mapbox",this.redFactor=e.redFactor,this.greenFactor=e.greenFactor,this.blueFactor=e.blueFactor,this.baseShift=e.baseShift}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i=this.map._requestManager.transformRequest(e,"Tile");t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const e=yield ye.getImage(i,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(e&&e.data){const i=e.data;this.map._refreshExpiredTiles&&(e.cacheControl||e.expires)&&t.setExpiryData({cacheControl:e.cacheControl,expires:e.expires});const r=Ot(i)&&u()?i:yield this.readImageNow(i),n={type:this.type,uid:t.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"LDT",data:n});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded"}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return n(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&function(){if(null==h&&(h=!1,u())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let i=0;i<t*t;i++){const r=4*i;e.fillStyle=`rgb(${r},${r+1},${r+2})`,e.fillRect(i%t,Math.floor(i/t),1,1)}const i=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&i[e]!==e){h=!0;break}}}return h||!1}()){const e=t.width+2,i=t.height+2;try{return new Rc({width:e,height:i},yield function(t,e,i,r,a){return n(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const i=null==e?void 0:e.format;if(!i||!i.startsWith("BGR")&&!i.startsWith("RGB"))throw new Error(`Unrecognized format ${i}`);const n=i.startsWith("BGR"),s=new Uint8ClampedArray(r*a*4);if(yield e.copyTo(s,function(t,e,i,r,n){const a=4*Math.max(1,0),s=(Math.max(0,-1)- -1)*r*4+a,o=4*r,l=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:l,y:c,width:Math.min(t.width,-1+r)-l,height:Math.min(t.height,-1+n)-c},layout:[{offset:s,stride:o}]}}(t,0,0,r,a)),n)for(let t=0;t<s.length;t+=4){const e=s[t];s[t]=s[t+2],s[t+2]=e}return s}finally{e.close()}}))}(t,0,0,e,i))}catch(t){}}return te.getImageData(t,1)}))}_getNeighboringTiles(t){const e=t.canonical,i=Math.pow(2,e.z),r=(e.x-1+i)%i,n=0===e.x?t.wrap-1:t.wrap,a=(e.x+1+i)%i,s=e.x+1===i?t.wrap+1:t.wrap,o={};return o[new lp(t.overscaledZ,n,e.z,r,e.y).key]={backfilled:!1},o[new lp(t.overscaledZ,s,e.z,a,e.y).key]={backfilled:!1},e.y>0&&(o[new lp(t.overscaledZ,n,e.z,r,e.y-1).key]={backfilled:!1},o[new lp(t.overscaledZ,t.wrap,e.z,e.x,e.y-1).key]={backfilled:!1},o[new lp(t.overscaledZ,s,e.z,a,e.y-1).key]={backfilled:!1}),e.y+1<i&&(o[new lp(t.overscaledZ,n,e.z,r,e.y+1).key]={backfilled:!1},o[new lp(t.overscaledZ,t.wrap,e.z,e.x,e.y+1).key]={backfilled:!1},o[new lp(t.overscaledZ,s,e.z,a,e.y+1).key]={backfilled:!1}),o}unloadTile(t){return n(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"RDT",data:{type:this.type,uid:t.uid,source:this.id}}))}))}}function up(t){return"GeometryCollection"===t.type?t.geometries.map((t=>t.coordinates)).flat(1/0):t.coordinates.flat(1/0)}function dp(t){const e=new qd;let i;switch(t.type){case"FeatureCollection":i=t.features.map((t=>up(t.geometry))).flat(1/0);break;case"Feature":i=up(t.geometry);break;default:i=up(t)}if(0==i.length)return e;for(let t=0;t<i.length-1;t+=2)e.extend([i[t],i[t+1]]);return e}class pp extends Pe{constructor(t,e,i,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:e.data},this.actor=i.getActor(),this.setEventedParent(r),this._data=e.data,this._options=wt({},e),this._collectResourceTiming=e.collectResourceTiming,void 0!==e.maxzoom&&(this.maxzoom=e.maxzoom),e.type&&(this.type=e.type),e.attribution&&(this.attribution=e.attribution),this.promoteId=e.promoteId,void 0!==e.clusterMaxZoom&&this.maxzoom<=e.clusterMaxZoom&&kt(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${e.clusterMaxZoom}".`),this.workerOptions=wt({source:this.id,cluster:e.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==e.buffer?e.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==e.tolerance?e.tolerance:.375),extent:Q,maxZoom:this.maxzoom,lineMetrics:e.lineMetrics||!1,generateId:e.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(e.clusterMaxZoom),minPoints:Math.max(2,e.clusterMinPoints||2),extent:Q,radius:this._pixelsToTileUnits(e.clusterRadius||50),log:!1,generateId:e.generateId||!1},clusterProperties:e.clusterProperties,filter:e.filter},e.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId)}_hasPendingWorkerUpdate(){return void 0!==this._pendingWorkerUpdate.data||void 0!==this._pendingWorkerUpdate.diff||this._pendingWorkerUpdate.optionsChanged}_pixelsToTileUnits(t){return t*(Q/this.tileSize)}_getClusterMaxZoom(t){const e=t?Math.round(t):this.maxzoom-1;return Number.isInteger(t)||void 0===t||kt(`Integer expected for option 'clusterMaxZoom': provided value "${t}" rounded to "${e}"`),e}load(){return n(this,void 0,void 0,(function*(){yield this._updateWorkerData()}))}onAdd(t){this.map=t,this.load()}setData(t){return this._data=t,this._pendingWorkerUpdate={data:t},this._updateWorkerData(),this}updateData(t){return this._pendingWorkerUpdate.diff=function(t,e){var i,r,n,a,s;if(!t)return null!=e?e:{};if(!e)return t;let o=Object.assign({},t);if(e.removeAll&&(o={removeAll:!0}),e.remove){const r=new Set(e.remove);o.add&&(o.add=o.add.filter((t=>!r.has(t.id)))),o.update&&(o.update=o.update.filter((t=>!r.has(t.id))));const n=new Set((null!==(i=t.add)&&void 0!==i?i:[]).map((t=>t.id)));e.remove=e.remove.filter((t=>!n.has(t)))}if(e.remove){const t=new Set(o.remove?o.remove.concat(e.remove):e.remove);o.remove=Array.from(t.values())}if(e.add){const t=o.add?o.add.concat(e.add):e.add,i=new Map(t.map((t=>[t.id,t])));o.add=Array.from(i.values())}if(e.update){const t=new Map(null===(r=o.update)||void 0===r?void 0:r.map((t=>[t.id,t])));for(const i of e.update){const e=null!==(n=t.get(i.id))&&void 0!==n?n:{id:i.id};i.newGeometry&&(e.newGeometry=i.newGeometry),i.addOrUpdateProperties&&(e.addOrUpdateProperties=(null!==(a=e.addOrUpdateProperties)&&void 0!==a?a:[]).concat(i.addOrUpdateProperties)),i.removeProperties&&(e.removeProperties=(null!==(s=e.removeProperties)&&void 0!==s?s:[]).concat(i.removeProperties)),i.removeAllProperties&&(e.removeAllProperties=!0),t.set(i.id,e)}o.update=Array.from(t.values())}return o.remove&&o.add&&(o.remove=o.remove.filter((t=>-1===o.add.findIndex((e=>e.id===t))))),o}(this._pendingWorkerUpdate.diff,t),this._updateWorkerData(),this}getData(){return n(this,void 0,void 0,(function*(){const t=wt({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:t})}))}getBounds(){return n(this,void 0,void 0,(function*(){return dp(yield this.getData())}))}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(t.clusterRadius)),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(t.clusterMaxZoom)),this._pendingWorkerUpdate.optionsChanged=!0,this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(){return n(this,void 0,void 0,(function*(){if(this._isUpdatingWorker)return;if(!this._hasPendingWorkerUpdate())return void kt(`No pending worker updates for GeoJSONSource ${this.id}.`);const{data:t,diff:e}=this._pendingWorkerUpdate,i=wt({type:this.type},this.workerOptions);t?("string"==typeof t?(i.request=this.map._requestManager.transformRequest(te.resolveURL(t),"Source"),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(t),this._pendingWorkerUpdate.data=void 0):e&&(i.dataDiff=e,this._pendingWorkerUpdate.diff=void 0),this._pendingWorkerUpdate.optionsChanged=void 0,this._isUpdatingWorker=!0,this.fire(new we("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"LD",data:i});if(this._isUpdatingWorker=!1,this._removed||t.abandoned)return void this.fire(new we("dataabort",{dataType:"source"}));this._data=t.data;let r=null;t.resourceTiming&&t.resourceTiming[this.id]&&(r=t.resourceTiming[this.id].slice(0));const n={dataType:"source"};this._collectResourceTiming&&r&&r.length>0&&wt(n,{resourceTiming:r}),this.fire(new we("data",Object.assign(Object.assign({},n),{sourceDataType:"metadata"}))),this.fire(new we("data",Object.assign(Object.assign({},n),{sourceDataType:"content",shouldReloadTileOptions:this._getShouldReloadTileOptions(e)})))}catch(t){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new we("dataabort",{dataType:"source"}));this.fire(new Te(t))}finally{this._hasPendingWorkerUpdate()&&this._updateWorkerData()}}))}_getShouldReloadTileOptions(t){if(!t||t.removeAll)return;const{add:e=[],update:i=[],remove:r=[]}=t||{},n=new Set([...i.map((t=>t.id)),...r]);return{nextBounds:[...i.map((t=>t.newGeometry)),...e.map((t=>t.geometry))].map((t=>dp(t))),prevIds:n}}shouldReloadTile(t,{nextBounds:e,prevIds:i}){const r=t.latestFeatureIndex.loadVTLayers();for(let e=0;e<t.latestFeatureIndex.featureIndexArray.length;e++){const n=t.latestFeatureIndex.featureIndexArray.get(e),a=r._geojsonTileLayer.feature(n.featureIndex);if(i.has(a.id))return!0}const{buffer:n,extent:a}=this.workerOptions.geojsonVtOptions,s=function({x:t,y:e,z:i},r=0){const n=Jd((t-r)/Math.pow(2,i)),a=Qd((e+1+r)/Math.pow(2,i)),s=Jd((t+1+r)/Math.pow(2,i)),o=Qd((e-r)/Math.pow(2,i));return new qd([n,a],[s,o])}(t.tileID.canonical,n/a);for(const t of e)if(s.intersects(t))return!0;return!1}loaded(){return!this._isUpdatingWorker&&!this._hasPendingWorkerUpdate()}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.actor?"RT":"LT";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};t.abortController=new AbortController;const r=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(r,this.map.painter,"RT"===e)}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}})}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}})}serialize(){return wt({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}}class fp{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0}extend(t){return this.minX=Math.min(this.minX,t.x),this.minY=Math.min(this.minY,t.y),this.maxX=Math.max(this.maxX,t.x),this.maxY=Math.max(this.maxY,t.y),this}expandBy(t){return this.minX-=t,this.minY-=t,this.maxX+=t,this.maxY+=t,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(t){return this.expandBy(-t)}map(t){const e=new fp;return e.extend(t(new a(this.minX,this.minY))),e.extend(t(new a(this.maxX,this.minY))),e.extend(t(new a(this.minX,this.maxY))),e.extend(t(new a(this.maxX,this.maxY))),e}static fromPoints(t){const e=new fp;for(const i of t)e.extend(i);return e}contains(t){return t.x>=this.minX&&t.x<=this.maxX&&t.y>=this.minY&&t.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(t){return!this.empty()&&!t.empty()&&t.minX>=this.minX&&t.maxX<=this.maxX&&t.minY>=this.minY&&t.maxY<=this.maxY}intersects(t){return!this.empty()&&!t.empty()&&t.minX<=this.maxX&&t.maxX>=this.minX&&t.minY<=this.maxY&&t.maxY>=this.minY}}class mp extends Pe{constructor(t,e,i,r){super(),this.flippedWindingOrder=!1,this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=e}load(t){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new we("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield ye.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading())}catch(t){this._request=null,this._loaded=!0,this.fire(new Te(t))}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new we("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(t){this.map=t,this.load()}onRemove(){this._request&&(this._request.abort(),this._request=null)}setCoordinates(t){this.coordinates=t;const e=t.map(ep.fromLngLat);var i;return this.tileID=function(t){const e=fp.fromPoints(t),i=e.width(),r=e.height(),n=Math.max(i,r),a=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),s=Math.pow(2,a);return new sp(a,Math.floor((e.minX+e.maxX)/2*s),Math.floor((e.minY+e.maxY)/2*s))}(e),this.terrainTileRanges=this._getOverlappingTileRanges(e),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=e.map((t=>this.tileID.getTilePoint(t)._round())),this.flippedWindingOrder=((i=this.tileCoords)[1].x-i[0].x)*(i[2].y-i[0].y)-(i[1].y-i[0].y)*(i[2].x-i[0].x)<0,this.fire(new we("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,e=t.gl;this.texture||(this.texture=new Zc(t,this.image,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new we("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}loadTile(t){return n(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored"}))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}_getOverlappingTileRanges(t){const{minX:e,minY:i,maxX:r,maxY:n}=fp.fromPoints(t),a={};for(let t=0;t<=25;t++){const s=Math.pow(2,t),o=Math.floor(e*s),l=Math.floor(i*s),c=Math.floor(r*s),h=Math.floor(n*s);a[t]={minTileX:o,minTileY:l,maxTileX:c,maxTileY:h}}return a}}class _p extends mp{constructor(t,e,i,r){super(t,e,i,r),this.roundZoom=!0,this.type="video",this.options=e}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,"Source").url);try{const t=yield(t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((i=>{e.onloadstart=()=>{i(e)};for(const i of t){const t=window.document.createElement("source");ue(i)||(e.crossOrigin="Anonymous"),t.src=i,e.appendChild(t)}}))})(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading()}catch(t){this.fire(new Te(t))}}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(t){if(this.video){const e=this.video.seekable;t<e.start(0)||t>e.end(0)?this.fire(new Te(new Oe(`sources.${this.id}`,null,`Playback for this video can be set only between the ${e.start(0)} and ${e.end(0)}-second mark.`))):this.video.currentTime=t}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,e=t.gl;this.texture?this.video.paused||(this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE),e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,this.video)):(this.texture=new Zc(t,this.video,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new we("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class gp extends mp{constructor(t,e,i,r){super(t,e,i,r),e.coordinates?Array.isArray(e.coordinates)&&4===e.coordinates.length&&!e.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new Te(new Oe(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new Te(new Oe(`sources.${t}`,null,'missing required property "coordinates"'))),e.animate&&"boolean"!=typeof e.animate&&this.fire(new Te(new Oe(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),e.canvas?"string"==typeof e.canvas||e.canvas instanceof HTMLCanvasElement||this.fire(new Te(new Oe(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new Te(new Oe(`sources.${t}`,null,'missing required property "canvas"'))),this.options=e,this.animate=void 0===e.animate||e.animate}load(){return n(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new Te(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const e=this.map.painter.context,i=e.gl;this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Zc(e,this.canvas,i.RGBA,{premultiply:!0});let r=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,r=!0)}r&&this.fire(new we("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of[this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return!0;return!1}}const yp={},xp=t=>{switch(t){case"geojson":return pp;case"image":return mp;case"raster":return np;case"raster-dem":return hp;case"vector":return rp;case"video":return _p;case"canvas":return gp}return yp[t]};class vp{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const i=t[e];this._stringToNumber[i]=e,this._numberToString[e]=i}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class bp{constructor(t,e,i,r,n){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=i,t._y=r,this.properties=t.properties,this.id=n}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}function wp(t,e,i,r,n){return Ct(t,((t,a)=>{const s=e instanceof Us?e.get(a):null;return s&&s.evaluate?s.evaluate(i,r,n):s}))}function Tp(t,e){return e-t}fs("FeatureIndex",class{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ds(Q,16,0),this.grid3D=new ds(Q,16,0),this.featureIndexArray=new Uo,this.promoteId=e}insert(t,e,i,r,n,a){const s=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n);const o=a?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const i=e[t],r=[1/0,1/0,-1/0,-1/0];for(let t=0;t<i.length;t++){const e=i[t];r[0]=Math.min(r[0],e.x),r[1]=Math.min(r[1],e.y),r[2]=Math.max(r[2],e.x),r[3]=Math.max(r[3],e.y)}r[0]<Q&&r[1]<Q&&r[2]>=0&&r[3]>=0&&o.insert(s,r[0],r[1],r[2],r[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Gh(new Iu(this.rawTileData)).layers,this.sourceLayerCoder=new vp(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,i,r){this.loadVTLayers();const n=t.params,s=Q/t.tileSize/t.scale,o=va(n.filter,n.globalState),l=t.queryGeometry,c=t.queryPadding*s,h=fp.fromPoints(l),u=this.grid.query(h.minX-c,h.minY-c,h.maxX+c,h.maxY+c),d=fp.fromPoints(t.cameraQueryGeometry).expandBy(c),p=this.grid3D.query(d.minX,d.minY,d.maxX,d.maxY,((e,i,r,n)=>function(t,e,i,r,n){for(const a of t)if(e<=a.x&&i<=a.y&&r>=a.x&&n>=a.y)return!0;const s=[new a(e,i),new a(e,n),new a(r,n),new a(r,i)];if(t.length>2)for(const e of s)if(dc(t,e))return!0;for(let e=0;e<t.length-1;e++)if(pc(t[e],t[e+1],s))return!0;return!1}(t.cameraQueryGeometry,e-c,i-c,r+c,n+c)));for(const t of p)u.push(t);u.sort(Tp);const f={};let m;for(let a=0;a<u.length;a++){const c=u[a];if(c===m)continue;m=c;const h=this.featureIndexArray.get(c);let d=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,o,n.layers,n.availableImages,e,i,r,((e,i,r)=>(d||(d=Jl(e)),i.queryIntersectsFeature({queryGeometry:l,feature:e,featureState:r,geometry:d,zoom:this.z,transform:t.transform,pixelsToTileUnits:s,pixelPosMatrix:t.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:t.getElevation}))))}return f}loadMatchingFeature(t,e,i,r,n,a,s,o,l,c,h){const u=this.bucketLayerIDs[e];if(a&&!u.some((t=>a.has(t))))return;const d=this.sourceLayerCoder.decode(i),p=this.vtLayers[d].feature(r);if(n.needGeometry){const t=Ql(p,!0);if(!n.filter(new ks(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!n.filter(new ks(this.tileID.overscaledZ),p))return;const f=this.getId(p,d);for(let e=0;e<u.length;e++){const i=u[e];if(a&&!a.has(i))continue;const n=o[i];if(!n)continue;let d={};f&&c&&(d=c.getState(n.sourceLayer||"_geojsonTileLayer",f));const m=wt({},l[i]);m.paint=wp(m.paint,n.paint,p,d,s),m.layout=wp(m.layout,n.layout,p,d,s);const _=!h||h(p,n,d);if(!_)continue;const g=new bp(p,this.z,this.x,this.y,f);g.layer=m;let y=t[i];void 0===y&&(y=t[i]=[]),y.push({featureIndex:r,feature:g,intersectionZ:_})}}lookupSymbolFeatures(t,e,i,r,n,a,s,o){const l={};this.loadVTLayers();const c=va(n.filterSpec,n.globalState);for(const n of t)this.loadMatchingFeature(l,i,r,n,c,a,s,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const i of e)if(t===i)return!0;return!1}getId(t,e){var i;let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r)),void 0===r&&(null===(i=t.properties)||void 0===i?void 0:i.cluster)&&this.promoteId&&(r=Number(t.properties.cluster_id))),r}},{omit:["rawTileData","sourceLayerCoder"]});const Pp="RTLPluginLoaded";class Mp extends Pe{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Od()}_syncState(t){return this.status=t,this.dispatcher.broadcast("SRPS",{pluginStatus:t,pluginURL:this.url}).catch((t=>{throw this.status="error",t}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null}setRTLTextPlugin(t){return n(this,arguments,void 0,(function*(t,e=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=te.resolveURL(t),!this.url)throw new Error(`requested url ${t} is invalid`);if("unavailable"===this.status){if(!e)return this._requestImport();this.status="deferred",this._syncState(this.status)}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return n(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new we(Pp))}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport()}}let Sp=null;function Ip(){return Sp||(Sp=new Mp),Sp}var Cp,Ap;!function(t){t[t.Base=0]="Base",t[t.Parent=1]="Parent"}(Cp||(Cp={})),function(t){t[t.Departing=0]="Departing",t[t.Incoming=1]="Incoming"}(Ap||(Ap={}));class Ep{constructor(t,e){this.timeAdded=0,this.fadeEndTime=0,this.fadeOpacity=1,this.tileID=t,this.uid=Mt(),this.uses=0,this.tileSize=e,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading"}isRenderable(t){return this.hasData()&&(!this.fadeEndTime||this.fadeOpacity>0)&&(t||!this.holdingForSymbolFade())}setCrossFadeLogic({fadingRole:t,fadingDirection:e,fadingParentID:i,fadeEndTime:r}){this.resetFadeLogic(),this.fadingRole=t,this.fadingDirection=e,this.fadingParentID=i,this.fadeEndTime=r}setSelfFadeLogic(t){this.resetFadeLogic(),this.selfFading=!0,this.fadeEndTime=t}resetFadeLogic(){this.fadingRole=null,this.fadingDirection=null,this.fadingParentID=null,this.selfFading=!1,this.timeAdded=ie(),this.fadeEndTime=0,this.fadeOpacity=1}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null}loadVectorData(t,e,i){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const r of t){const t=r.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){r.layers=t,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=r}}return i}(t.buckets,null==e?void 0:e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof id){if(this.hasSymbolBuckets=!0,!i)break;e.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof id&&e.hasRTLText){this.hasRTLText=!0,Ip().lazyLoad();break}}this.queryPadding=0;for(const t in this.buckets){const i=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(i))}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage),this.dashPositions=t.dashPositions}else this.collisionBoxArray=new Do}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.dashPositions&&(this.dashPositions=null),this.latestFeatureIndex=null,this.state="unloaded"}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t)}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Zc(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Zc(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null)}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture)}queryRenderedFeatures(t,e,i,r,n,a,s,o,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:n,scale:a,tileSize:this.tileSize,pixelPosMatrix:c,transform:o,params:s,queryPadding:this.queryPadding*l,getElevation:h},t,e,i):{}}querySourceFeatures(t,e){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=e&&e.sourceLayer?e.sourceLayer:"",a=r._geojsonTileLayer||r[n];if(!a)return;const s=va(null==e?void 0:e.filter,null==e?void 0:e.globalState),{z:o,x:l,y:c}=this.tileID.canonical,h={z:o,x:l,y:c};for(let e=0;e<a.length;e++){const r=a.feature(e);if(s.needGeometry){const t=Ql(r,!0);if(!s.filter(new ks(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!s.filter(new ks(this.tileID.overscaledZ),r))continue;const u=i.getId(r,n),d=new bp(r,o,l,c,u);d.tile=h,t.push(d)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,i,r,n)=>{const a=r||n;return e[i]=!a||a.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t}return e}(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"])}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let i=!1;if(this.expirationTime>t)i=!1;else if(e)if(this.expirationTime<e)i=!0;else{const r=this.expirationTime-e;r?this.expirationTime=t+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!e.style.hasLayer(r))continue;const n=this.buckets[r],a=n.layers[0].sourceLayer||"_geojsonTileLayer",s=i[a],o=t[a];if(!s||!o||0===Object.keys(o).length)continue;n.update(o,s,this.imageAtlas&&this.imageAtlas.patternPositions||{},this.dashPositions||{});const l=e&&e.style&&e.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)))}}holdingForSymbolFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<ie()}clearSymbolFadeHold(){this.symbolFadeHoldUntil=void 0}setSymbolHoldDuration(t){this.symbolFadeHoldUntil=ie()+t}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return!0}return!1}}class zp{constructor(t,e){this.max=t,this.onRemove=e,this.reset()}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const r=t.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:e,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(t,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,r=void 0===e?0:this.data[i].indexOf(e),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}filter(t){const e=[];for(const i in this.data)for(const r of this.data[i])t(r.value)||e.push(r);for(const t of e)this.remove(t.value.tileID,t)}}class Dp{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(t,e,i){const r=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][r]=this.stateChanges[t][r]||{},wt(this.stateChanges[t][r],i),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==r&&(this.deletedStates[t][e]=null)}else if(this.deletedStates[t]&&null===this.deletedStates[t][r]){this.deletedStates[t][r]={};for(const e in this.state[t][r])i[e]||(this.deletedStates[t][r][e]=null)}else for(const e in i)this.deletedStates[t]&&this.deletedStates[t][r]&&null===this.deletedStates[t][r][e]&&delete this.deletedStates[t][r][e]}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const r=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][r]&&(this.deletedStates[t][r]=this.deletedStates[t][r]||{},this.deletedStates[t][r][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][r])for(i in this.deletedStates[t][r]={},this.stateChanges[t][r])this.deletedStates[t][r][i]=null;else this.deletedStates[t][r]=null;else this.deletedStates[t]=null}getState(t,e){const i=String(e),r=wt({},(this.state[t]||{})[i],(this.stateChanges[t]||{})[i]);if(null===this.deletedStates[t])return{};if(this.deletedStates[t]){const i=this.deletedStates[t][e];if(null===i)return{};for(const t in i)delete r[t]}return r}initializeTileState(t,e){t.setFeatureState(this.state,e)}coalesceChanges(t,e){const i={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const i in this.stateChanges[t])this.state[t][i]||(this.state[t][i]={}),wt(this.state[t][i],this.stateChanges[t][i]),e[i]=this.state[t][i];i[t]=e}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const i in this.state[t])e[i]={},this.state[t][i]={};else for(const i in this.deletedStates[t]){if(null===this.deletedStates[t][i])this.state[t][i]={};else for(const e of Object.keys(this.deletedStates[t][i]))delete this.state[t][i][e];e[i]=this.state[t][i]}i[t]=i[t]||{},wt(i[t],e)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in t)t[r].setFeatureState(i,e)}}const kp=89.25;function Rp(t,e){const i=vt(e.lat,-85.051129,qt);return new a(Xd(e.lng)*t,Yd(i)*t)}function Lp(t,e){return new ep(e.x/t,e.y/t).toLngLat()}function Fp(t){return t.cameraToCenterDistance*Math.min(.85*Math.tan(Nt(90-t.pitch)),Math.tan(Nt(kp-t.pitch)))}function Bp(t,e){const i=t.canonical,r=e/St(i.z),n=i.x+Math.pow(2,i.z)*t.wrap,a=y(new Float64Array(16));return b(a,a,[n*r,i.y*r,0]),w(a,a,[r/Q,r/Q,1]),a}function Op(t,e,i,r,n){const a=ep.fromLngLat(t,e),s=n*Kd(1,t.lat),o=s*Math.cos(Nt(i)),l=Math.sqrt(s*s-o*o),c=l*Math.sin(Nt(-r)),h=l*Math.cos(Nt(-r));return new ep(a.x+c,a.y+h,a.z+o)}function jp(t,e,i){const r=e.intersectsFrustum(t);if(!i||0===r)return r;const n=e.intersectsPlane(i);return 0===n?0:2===r&&2===n?2:1}function Vp(t,e,i){let r=0;const n=(i-e)/10;for(let a=0;a<10;a++)r+=n*Math.pow(Math.cos(e+(a+.5)/10*(i-e)),t);return r}function Np(t,e){return function(i,r,n,a,s){const o=2*((t-1)/It(Math.cos(Nt(kp-s))/Math.cos(Nt(kp)))-1),l=Math.acos(n/a),c=2*Vp(o-1,0,Nt(s/2)),h=Math.min(Nt(kp),l+Nt(s/2)),u=Vp(o-1,Math.min(h,l-Nt(s/2)),h),d=Math.atan(r/n);let p=i;return p+=It(a/Math.hypot(r,n)/Math.max(.5,Math.cos(Nt(s/2)))),p+=o*It(Math.cos(d))/2,p-=It(Math.max(1,u/c/e))/2,p}}const Up=Np(9.314,3);function Zp(t,e){const i=(e.roundZoom?Math.round:Math.floor)(t.zoom+It(t.tileSize/e.tileSize));return Math.max(0,i)}function Gp(t,e){const i=t.getCameraFrustum(),r=t.getClippingPlane(),n=t.screenPointToMercatorCoordinate(t.getCameraPoint()),a=ep.fromLngLat(t.center,t.elevation);n.z=a.z+Math.cos(t.pitchInRadians)*t.cameraToCenterDistance/t.worldSize;const s=t.getCoveringTilesDetailsProvider(),o=s.allowVariableZoom(t,e),l=Zp(t,e),c=e.minzoom||0,h=void 0!==e.maxzoom?e.maxzoom:t.maxZoom,u=Math.min(Math.max(0,l),h),d=Math.pow(2,u),p=[d*n.x,d*n.y,0],f=[d*a.x,d*a.y,0],m=Math.hypot(a.x-n.x,a.y-n.y),_=Math.abs(a.z-n.z),g=Math.hypot(m,_),y=t=>({zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),x=[],v=[];if(t.renderWorldCopies&&s.allowWorldCopies())for(let t=1;t<=3;t++)x.push(y(-t)),x.push(y(t));for(x.push(y(0));x.length>0;){const d=x.pop(),m=d.x,y=d.y;let b=d.fullyVisible;const w={x:m,y:y,z:d.zoom},T=s.getTileBoundingVolume(w,d.wrap,t.elevation,e);if(!b){const t=jp(i,T,r);if(0===t)continue;b=2===t}const P=s.distanceToTile2d(n.x,n.y,w,T);let M=l;o&&(M=(e.calculateTileZoom||Up)(t.zoom+It(t.tileSize/e.tileSize),P,_,g,t.fov)),M=(e.roundZoom?Math.round:Math.floor)(M),M=Math.max(0,M);const S=Math.min(M,h);if(d.wrap=s.getWrap(a,w,d.wrap),d.zoom>=S){if(d.zoom<c)continue;const t=u-d.zoom,i=p[0]-.5-(m<<t),r=p[1]-.5-(y<<t),n=e.reparseOverscaled?Math.max(d.zoom,M):d.zoom;v.push({tileID:new lp(d.zoom===h?n:d.zoom,d.wrap,d.zoom,m,y),distanceSq:J([f[0]-.5-m,f[1]-.5-y]),tileDistanceToCamera:Math.sqrt(i*i+r*r)})}else for(let t=0;t<4;t++)x.push({zoom:d.zoom+1,x:(m<<1)+t%2,y:(y<<1)+(t>>1),wrap:d.wrap,fullyVisible:b})}return v.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}const $p=fp.fromPoints([new a(0,0),new a(Q,Q)]);class qp extends Pe{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>this._dataHandler(t))),this.on("dataloading",(()=>{this._sourceErrored=!1})),this.on("error",(()=>{this._sourceErrored=this._source.loaded()})),this._source=((t,e,i,r)=>{const n=new(xp(e.type))(t,e,i,r);if(n.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${n.id}`);return n})(t,e,i,this),this._tiles={},this._cache=new zp(0,(t=>this._unloadTile(t))),this._timers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._rasterFadeDuration=0,this._maxFadingAncestorLevels=5,this._state=new Dp,this._didEmitContent=!1,this._updated=!1}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t)}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t)}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return!0;if(!this._updated)return!1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}return!0}getSource(){return this._source}getState(){return this._state}pause(){this._paused=!0}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain)}_loadTile(t,e,i){return n(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,e,i)}catch(e){t.state="errored",404!==e.status?this._source.fire(new Te(e,{tile:t})):this.update(this.transform,this.terrain)}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t)}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new we("dataabort",{tile:t,coord:t.tileID,dataType:"source"}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager)}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(Wp).map((t=>t.key))}getRenderableIds(t){const e=[];for(const i in this._tiles)this._isIdRenderable(i,t)&&e.push(this._tiles[i]);return t?e.sort(((t,e)=>{const i=t.tileID,r=e.tileID,n=new a(i.canonical.x,i.canonical.y)._rotate(-this.transform.bearingInRadians),s=new a(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians);return i.overscaledZ-r.overscaledZ||s.y-n.y||s.x-n.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(Wp).map((t=>t.key))}hasRenderableParent(t){const e=t.overscaledZ-1;if(e>=this._source.minzoom){const i=this.getLoadedTile(t.scaledTo(e));if(i)return this._isIdRenderable(i.tileID.key)}return!1}_isIdRenderable(t,e=!1){var i;return null===(i=this._tiles[t])||void 0===i?void 0:i.isRenderable(e)}reload(t,e=void 0){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const i in this._tiles)e&&this._source.shouldReloadTile&&!this._source.shouldReloadTile(this._tiles[i],e)||(t?this._reloadTile(i,"expired"):"errored"!==this._tiles[i].state&&this._reloadTile(i,"reloading"))}}_reloadTile(t,e){return n(this,void 0,void 0,(function*(){const i=this._tiles[t];i&&("loading"!==i.state&&(i.state=e),yield this._loadTile(i,t,e))}))}_tileLoaded(t,e,i){t.timeAdded=ie(),t.selfFading&&(t.fadeEndTime=t.timeAdded+this._rasterFadeDuration),"expired"===i&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new we("data",{dataType:"source",tile:t,coord:t.tileID}))}_backfillDEM(t){const e=this.getRenderableIds();for(let r=0;r<e.length;r++){const n=e[r];if(t.neighboringTiles&&t.neighboringTiles[n]){const e=this.getTileByID(n);i(t,e),i(e,t)}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const r=e.tileID.canonical.y-t.tileID.canonical.y,n=Math.pow(2,t.tileID.canonical.z),a=e.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+n)?i+=n:1===Math.abs(i-n)&&(i-=n)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,r),t.neighboringTiles&&t.neighboringTiles[a]&&(t.neighboringTiles[a].backfilled=!0)))}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e){const i=Object.values(t),r=this._getLoadedDescendents(i),n={};for(const t of i){const i=r[t.key];if(!(null==i?void 0:i.length)){n[t.key]=t;continue}const a=t.overscaledZ+qp.maxUnderzooming,s=i.filter((t=>t.tileID.overscaledZ<=a));if(!s.length){n[t.key]=t;continue}const o=Math.min(...s.map((t=>t.tileID.overscaledZ))),l=s.filter((t=>t.tileID.overscaledZ===o)).map((t=>t.tileID));for(const t of l)e[t.key]=t;this._areDescendentsComplete(l,o,t.overscaledZ)||(n[t.key]=t)}return n}_getLoadedDescendents(t){var e;const i={};for(const r in this._tiles){const n=this._tiles[r];if(n.hasData())for(const r of t)n.tileID.isChildOf(r)&&(i[e=r.key]||(i[e]=[])).push(n)}return i}_areDescendentsComplete(t,e,i){return 1===t.length&&t[0].isOverscaled()?t[0].overscaledZ===e:Math.pow(4,e-i)===t.length}getLoadedTile(t){const e=this._tiles[t.key];return(null==e?void 0:e.hasData())?e:null}updateCacheSize(t){const e=Math.ceil(t.width/this._source.tileSize)+1,i=Math.ceil(t.height/this._source.tileSize)+1,r=Math.floor(e*i*(null===this._maxTileCacheZoomLevels?ne.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n)}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),t[r.tileID.key]=r}this._tiles=t,this._resetTileReloadTimers()}}update(t,e){if(!this._sourceLoaded||this._paused)return;let i;this.transform=t,this.terrain=e,this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new lp(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(i=Gp(t,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:e,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(i=i.filter((t=>this._source.hasTile(t))))):i=[],this.usedForTerrain&&(i=this._addTerrainIdealTiles(i));const r=0===i.length&&!this._updated&&this._didEmitContent;this._updated=!0,r&&this.fire(new we("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const n=Zp(t,this._source),a=this._updateRetainedTiles(i,n),s=Hp(this._source.type);s&&this._rasterFadeDuration>0&&!e&&this._updateFadingTiles(i,a),s?this._cleanUpRasterTiles(a):this._cleanUpVectorTiles(a)}_cleanUpRasterTiles(t){for(const e in this._tiles)t[e]||this._removeTile(e)}_cleanUpVectorTiles(t){for(const e in this._tiles){const i=this._tiles[e];t[e]?i.clearSymbolFadeHold():i.hasSymbolBuckets?i.holdingForSymbolFade()?i.symbolFadeFinished()&&this._removeTile(e):i.setSymbolHoldDuration(this.map._fadeDuration):this._removeTile(e)}}_addTerrainIdealTiles(t){const e=[];for(const i of t)if(i.canonical.z>this._source.minzoom){const t=i.scaledTo(i.canonical.z-1);e.push(t);const r=i.scaledTo(Math.max(this._source.minzoom,Math.min(i.canonical.z,5)));e.push(r)}return t.concat(e)}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForSymbolFade()&&this._removeTile(t)}_updateRetainedTiles(t,e){var i;const r={},n={},a=Math.max(e-qp.maxOverzooming,this._source.minzoom);let s={};for(const e of t){const t=this._addTile(e);r[e.key]=e,t.hasData()||(s[e.key]=e)}s=this._retainLoadedChildren(s,r);for(const t in s){const e=s[t];let o=this._tiles[t],l=null==o?void 0:o.wasRequested();for(let t=e.overscaledZ-1;t>=a;--t){const a=e.scaledTo(t);if(n[a.key])break;if(n[a.key]=!0,o=this.getTile(a),!o&&l&&(o=this._addTile(a)),o){const t=o.hasData();if((t||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||l)&&(r[a.key]=a),l=o.wasRequested(),t)break}}}return r}_updateFadingTiles(t,e){const i=ie(),r=function(t){if(!t.length)return new Set;const e=Math.max(...t.map((t=>t.canonical.z)));let i=1/0,r=-1/0,n=1/0,a=-1/0;const s=[];for(const o of t){const{x:t,y:l,z:c}=o.canonical,h=Math.pow(2,e-c),u=t*h,d=l*h;s.push({id:o,x:u,y:d}),u<i&&(i=u),u>r&&(r=u),d<n&&(n=d),d>a&&(a=d)}const o=new Set;for(const t of s)t.x!==i&&t.x!==r&&t.y!==n&&t.y!==a||o.add(t.id);return o}(t);for(const n of t){const t=this._tiles[n.key];t.fadingDirection!==Ap.Departing&&0!==t.fadeOpacity||t.resetFadeLogic(),this._updateFadingAncestor(t,e,i)||this._updateFadingDescendents(t,e,i)||this._updateFadingEdge(t,r,i)||t.resetFadeLogic()}}_updateFadingAncestor(t,e,i){if(!t.hasData())return!1;const{tileID:r,fadingRole:n,fadingDirection:a,fadingParentID:s}=t;if(n===Cp.Base&&a===Ap.Incoming&&s)return e[s.key]=s,!0;const o=Math.max(r.overscaledZ-this._maxFadingAncestorLevels,this._source.minzoom);for(let n=r.overscaledZ-1;n>=o;n--){const a=r.scaledTo(n),s=this.getLoadedTile(a);if(s)return t.setCrossFadeLogic({fadingRole:Cp.Base,fadingDirection:Ap.Incoming,fadingParentID:s.tileID,fadeEndTime:i+this._rasterFadeDuration}),s.setCrossFadeLogic({fadingRole:Cp.Parent,fadingDirection:Ap.Departing,fadeEndTime:i+this._rasterFadeDuration}),e[a.key]=a,!0}return!1}_updateFadingDescendents(t,e,i){if(!t.hasData())return!1;const r=t.tileID.children(this._source.maxzoom);let n=this._updateFadingChildren(t,r,e,i);if(n)return!0;for(const a of r){const r=a.children(this._source.maxzoom);this._updateFadingChildren(t,r,e,i)&&(n=!0)}return n}_updateFadingChildren(t,e,i,r){if(e[0].overscaledZ>=this._source.maxzoom)return!1;let n=!1;for(const a of e){const e=this.getLoadedTile(a);if(!e)continue;const{fadingRole:s,fadingDirection:o,fadingParentID:l}=e;s===Cp.Base&&o===Ap.Departing&&l||(e.setCrossFadeLogic({fadingRole:Cp.Base,fadingDirection:Ap.Departing,fadingParentID:t.tileID,fadeEndTime:r+this._rasterFadeDuration}),t.setCrossFadeLogic({fadingRole:Cp.Parent,fadingDirection:Ap.Incoming,fadeEndTime:r+this._rasterFadeDuration})),i[a.key]=a,n=!0}return n}_updateFadingEdge(t,e,i){const r=t.tileID;return!!t.selfFading||!t.hasData()&&!!e.has(r)&&(t.setSelfFadeLogic(i+this._rasterFadeDuration),!0)}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(e.resetFadeLogic(),this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null));const i=e;return e||(e=new Ep(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(e,t.key,e.state)),e.uses++,this._tiles[t.key]=e,i||this._source.fire(new we("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e}_setTileReloadTimer(t,e){this._clearTileReloadTimer(t);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t]}),i))}_clearTileReloadTimer(t){const e=this._timers[t];e&&(clearTimeout(e),delete this._timers[t])}_resetTileReloadTimers(){for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t])}refreshTiles(t){for(const e in this._tiles)(this._isIdRenderable(e)||"errored"==this._tiles[e].state)&&t.some((t=>t.equals(this._tiles[e].tileID.canonical)))&&this._reloadTile(e,"expired")}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._clearTileReloadTimer(t),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))))}_dataHandler(t){"source"===t.dataType&&("metadata"!==t.sourceDataType?"content"===t.sourceDataType&&this._sourceLoaded&&!this._paused&&(this.reload(t.sourceDataChanged,t.shouldReloadTileOptions),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0):this._sourceLoaded=!0)}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset()}tilesIn(t,e,i){const r=[],n=this.transform;if(!n)return r;const a=n.getCoveringTilesDetailsProvider().allowWorldCopies(),s=i?n.getCameraQueryGeometry(t):t,o=t=>n.screenPointToMercatorCoordinate(t,this.terrain),l=this.transformBbox(t,o,!a),c=this.transformBbox(s,o,!a),h=this.getIds(),u=fp.fromPoints(c);for(let t=0;t<h.length;t++){const i=this._tiles[h[t]];if(i.holdingForSymbolFade())continue;const s=a?[i.tileID]:[i.tileID.unwrapTo(-1),i.tileID.unwrapTo(0)],o=Math.pow(2,n.zoom-i.tileID.overscaledZ),d=e*i.queryPadding*Q/i.tileSize/o;for(const t of s){const e=u.map((e=>t.getTilePoint(new ep(e.x,e.y))));if(e.expandBy(d),e.intersects($p)){const e=l.map((e=>t.getTilePoint(e))),n=c.map((e=>t.getTilePoint(e)));r.push({tile:i,tileID:a?t:t.unwrapTo(0),queryGeometry:e,cameraQueryGeometry:n,scale:o})}}}return r}transformBbox(t,e,i){let r=t.map(e);if(i){const i=fp.fromPoints(t);i.shrinkBy(.001*Math.min(i.width(),i.height()));const n=i.map(e);fp.fromPoints(r).covers(n)||(r=r.map((t=>t.x>.5?new ep(t.x-1,t.y,t.z):t)))}return r}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));return this.transform&&this.transform.populateCache(e),e}hasTransition(){if(this._source.hasTransition())return!0;if(Hp(this._source.type)&&this._rasterFadeDuration>0){const t=ie();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return!0}return!1}setRasterFadeDuration(t){this._rasterFadeDuration=t}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i)}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i)}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const r=this._tiles[t];r&&r.setDependencies(e,i)}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)))}}function Wp(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),r=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||r-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Hp(t){return"raster"===t||"image"===t||"video"===t}qp.maxOverzooming=10,qp.maxUnderzooming=3;class Xp{constructor(t,e){this.reset(t,e)}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(t){if(1===this.points.length)return this.points[0];t=vt(t,0,1);let e=1,i=this._distances[e];const r=t*this.paddedLength+this.padding;for(;i<r&&e<this._distances.length;)i=this._distances[++e];const n=e-1,a=this._distances[n],s=i-a,o=s>0?(r-a)/s:0;return this.points[n].mult(1-o).add(this.points[e].mult(o))}}function Yp(t,e){let i=!0;return"always"===t||"never"!==t&&"never"!==e||(i=!1),i}class Kp{constructor(t,e,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(t,e,i,r){this._forEachCell(e-r,i-r,e+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(r)}_insertBoxCell(t,e,i,r,n,a){this.boxCells[n].push(a)}_insertCircleCell(t,e,i,r,n,a){this.circleCells[n].push(a)}_query(t,e,i,r,n,a,s){if(i<0||t>this.width||r<0||e>this.height)return[];const o=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=r){if(n)return[{key:null,x1:t,y1:e,x2:i,y2:r}];for(let t=0;t<this.boxKeys.length;t++)o.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],r=this.circles[3*t+2];o.push({key:this.circleKeys[t],x1:e-r,y1:i-r,x2:e+r,y2:i+r})}}else this._forEachCell(t,e,i,r,this._queryCell,o,{hitTest:n,overlapMode:a,seenUids:{box:{},circle:{}}},s);return o}query(t,e,i,r){return this._query(t,e,i,r,!1,null)}hitTest(t,e,i,r,n,a){return this._query(t,e,i,r,!0,n,a).length>0}hitTestCircle(t,e,i,r,n){const a=t-i,s=t+i,o=e-i,l=e+i;if(s<0||a>this.width||l<0||o>this.height)return!1;const c=[];return this._forEachCell(a,o,s,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},n),c.length>0}_queryCell(t,e,i,r,n,a,s,o){const{seenUids:l,hitTest:c,overlapMode:h}=s,u=this.boxCells[n];if(null!==u){const n=this.bboxes;for(const s of u)if(!l.box[s]){l.box[s]=!0;const u=4*s,d=this.boxKeys[s];if(t<=n[u+2]&&e<=n[u+3]&&i>=n[u+0]&&r>=n[u+1]&&(!o||o(d))&&(!c||!Yp(h,d.overlapMode))&&(a.push({key:d,x1:n[u],y1:n[u+1],x2:n[u+2],y2:n[u+3]}),c))return!0}}const d=this.circleCells[n];if(null!==d){const n=this.circles;for(const s of d)if(!l.circle[s]){l.circle[s]=!0;const u=3*s,d=this.circleKeys[s];if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],t,e,i,r)&&(!o||o(d))&&(!c||!Yp(h,d.overlapMode))){const t=n[u],e=n[u+1],i=n[u+2];if(a.push({key:d,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),c)return!0}}}return!1}_queryCellCircle(t,e,i,r,n,a,s,o){const{circle:l,seenUids:c,overlapMode:h}=s,u=this.boxCells[n];if(null!==u){const t=this.bboxes;for(const e of u)if(!c.box[e]){c.box[e]=!0;const i=4*e,r=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!o||o(r))&&!Yp(h,r.overlapMode))return a.push(!0),!0}}const d=this.circleCells[n];if(null!==d){const t=this.circles;for(const e of d)if(!c.circle[e]){c.circle[e]=!0;const i=3*e,r=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!o||o(r))&&!Yp(h,r.overlapMode))return a.push(!0),!0}}}_forEachCell(t,e,i,r,n,a,s,o){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(n.call(this,t,e,i,r,this.xCellCount*l+d,a,s,o))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,r,n,a){const s=r-t,o=n-e,l=i+a;return l*l>s*s+o*o}_circleAndRectCollide(t,e,i,r,n,a,s){const o=(a-r)/2,l=Math.abs(t-(r+o));if(l>o+i)return!1;const c=(s-n)/2,h=Math.abs(e-(n+c));if(h>c+i)return!1;if(l<=o||h<=c)return!0;const u=l-o,d=h-c;return u*u+d*d<=i*i}}function Jp(t,e,i){const r=_();if(!t){const{vecSouth:t,vecEast:i}=tf(e),u=f();u[0]=i[0],u[1]=i[1],u[2]=t[0],u[3]=t[1],n=u,(h=(s=(a=u)[0])*(c=a[3])-(l=a[2])*(o=a[1]))&&(n[0]=c*(h=1/h),n[1]=-o*h,n[2]=-l*h,n[3]=s*h),r[0]=u[0],r[1]=u[1],r[4]=u[2],r[5]=u[3]}var n,a,s,o,l,c,h;return w(r,r,[1/i,1/i,1]),r}function Qp(t,e,i,r){if(t){const t=_();if(!e){const{vecSouth:e,vecEast:r}=tf(i);t[0]=r[0],t[1]=r[1],t[4]=e[0],t[5]=e[1]}return w(t,t,[r,r,1]),t}return i.pixelsToClipSpaceMatrix}function tf(t){const e=Math.cos(t.rollInRadians),i=Math.sin(t.rollInRadians),r=Math.cos(t.pitchInRadians),n=Math.cos(t.bearingInRadians),a=Math.sin(t.bearingInRadians),s=W();s[0]=-n*r*i-a*e,s[1]=-a*r*i+n*e;const o=Y(s);o<1e-9?K(s):X(s,s,1/o);const l=W();l[0]=n*r*e-a*i,l[1]=a*r*e+n*i;const c=Y(l);return c<1e-9?K(l):X(l,l,1/c),{vecEast:l,vecSouth:s}}function ef(t,e,i,r){let n;r?(n=[t,e,r(t,e),1],G(n,n,i)):(n=[t,e,0,1],xf(n,n,i));const s=n[3];return{point:new a(n[0]/s,n[1]/s),signedDistanceFromCamera:s,isOccluded:!1}}function rf(t,e){return.5+t/e*.5}function nf(t,e){return t.x>=-e[0]&&t.x<=e[0]&&t.y>=-e[1]&&t.y<=e[1]}function af(t,e,i,r,n,s,o,l,c,h,u,d,p){const f=i?t.textSizeData:t.iconSizeData,m=Hu(f,e.transform.zoom),_=[256/e.width*2+1,256/e.height*2+1],g=i?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;g.clear();const y=t.lineVertexArray,x=i?t.text.placedSymbolArray:t.icon.placedSymbolArray,v=e.transform.width/e.transform.height;let b=!1;for(let i=0;i<x.length;i++){const w=x.get(i);if(w.hidden||w.writingMode===Gu.vertical&&!b){yf(w.numGlyphs,g);continue}b=!1;const T=new a(w.anchorX,w.anchorY),P={getElevation:p,pitchedLabelPlaneMatrix:r,lineVertexArray:y,pitchWithMap:s,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:e.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:d},M=pf(w.anchorX,w.anchorY,P);if(!nf(M.point,_)){yf(w.numGlyphs,g);continue}const S=rf(e.transform.cameraToCenterDistance,M.signedDistanceFromCamera),I=Wu(f,m,w),C=s?I*e.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/S:I*S,A=lf({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:C,flip:!1,keepUpright:o,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:l});b=A.useVertical,(A.notEnoughRoom||b||A.needsFlipping&&lf({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:C,flip:!0,keepUpright:o,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:l}).notEnoughRoom)&&yf(w.numGlyphs,g)}i?t.text.dynamicLayoutVertexBuffer.updateData(g):t.icon.dynamicLayoutVertexBuffer.updateData(g)}function sf(t,e,i,r,n,a,s,o){const l=a.glyphStartIndex+a.numGlyphs,c=a.lineStartIndex,h=a.lineStartIndex+a.lineLength,u=e.getoffsetX(a.glyphStartIndex),d=e.getoffsetX(l-1),p=_f(t*u,i,r,n,a.segment,c,h,o,s);if(!p)return null;const f=_f(t*d,i,r,n,a.segment,c,h,o,s);return f?o.projectionCache.anyProjectionOccluded?null:{first:p,last:f}:null}function of(t,e,i,r){return t===Gu.horizontal&&Math.abs(i.y-e.y)>Math.abs(i.x-e.x)*r?{useVertical:!0}:(t===Gu.vertical?e.y<i.y:e.x>i.x)?{needsFlipping:!0}:null}function lf(t){const{projectionContext:e,pitchedLabelPlaneMatrixInverse:i,symbol:r,fontSize:n,flip:s,keepUpright:o,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=t,d=n/24,p=r.lineOffsetX*d,f=r.lineOffsetY*d;let m;if(r.numGlyphs>1){const t=r.glyphStartIndex+r.numGlyphs,n=r.lineStartIndex,a=r.lineStartIndex+r.lineLength,c=sf(d,l,p,f,s,r,u,e);if(!c)return{notEnoughRoom:!0};const _=df(c.first.point.x,c.first.point.y,e,i),g=df(c.last.point.x,c.last.point.y,e,i);if(o&&!s){const t=of(r.writingMode,_,g,h);if(t)return t}m=[c.first];for(let i=r.glyphStartIndex+1;i<t-1;i++){const t=_f(d*l.getoffsetX(i),p,f,s,r.segment,n,a,e,u);if(!t)return{notEnoughRoom:!0};m.push(t)}m.push(c.last)}else{if(o&&!s){const t=uf(e.tileAnchorPoint.x,e.tileAnchorPoint.y,e).point,n=r.lineStartIndex+r.segment+1,s=new a(e.lineVertexArray.getx(n),e.lineVertexArray.gety(n)),o=uf(s.x,s.y,e),l=o.signedDistanceFromCamera>0?o.point:cf(e.tileAnchorPoint,s,t,1,e),c=df(t.x,t.y,e,i),u=df(l.x,l.y,e,i),d=of(r.writingMode,c,u,h);if(d)return d}const t=_f(d*l.getoffsetX(r.glyphStartIndex),p,f,s,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,e,u);if(!t||e.projectionCache.anyProjectionOccluded)return{notEnoughRoom:!0};m=[t]}for(const t of m)Ju(c,t.point,t.angle);return{}}function cf(t,e,i,r,n){const a=t.add(t.sub(e)._unit()),s=uf(a.x,a.y,n).point,o=i.sub(s);return i.add(o._mult(r/o.mag()))}function hf(t,e,i){const r=e.projectionCache;if(r.projections[t])return r.projections[t];const n=new a(e.lineVertexArray.getx(t),e.lineVertexArray.gety(t)),s=uf(n.x,n.y,e);if(s.signedDistanceFromCamera>0)return r.projections[t]=s.point,r.anyProjectionOccluded=r.anyProjectionOccluded||s.isOccluded,s.point;const o=t-i.direction;return cf(0===i.distanceFromAnchor?e.tileAnchorPoint:new a(e.lineVertexArray.getx(o),e.lineVertexArray.gety(o)),n,i.previousVertex,i.absOffsetX-i.distanceFromAnchor+1,e)}function uf(t,e,i){const r=t+i.translation[0],n=e+i.translation[1];let a;return i.pitchWithMap?(a=ef(r,n,i.pitchedLabelPlaneMatrix,i.getElevation),a.isOccluded=!1):(a=i.transform.projectTileCoordinates(r,n,i.unwrappedTileID,i.getElevation),a.point.x=(.5*a.point.x+.5)*i.width,a.point.y=(.5*-a.point.y+.5)*i.height),a}function df(t,e,i,r){if(i.pitchWithMap){const n=[t,e,0,1];return G(n,n,r),i.transform.projectTileCoordinates(n[0]/n[3],n[1]/n[3],i.unwrappedTileID,i.getElevation).point}return{x:t/i.width*2-1,y:1-e/i.height*2}}function pf(t,e,i){return i.transform.projectTileCoordinates(t,e,i.unwrappedTileID,i.getElevation)}function ff(t,e,i){return t._unit()._perp()._mult(e*i)}function mf(t,e,i,r,n,s,o,l,c){if(l.projectionCache.offsets[t])return l.projectionCache.offsets[t];const h=i.add(e);if(t+c.direction<r||t+c.direction>=n)return l.projectionCache.offsets[t]=h,h;const u=hf(t+c.direction,l,c),d=ff(u.sub(i),o,c.direction),p=i.add(d),f=u.add(d);return l.projectionCache.offsets[t]=function(t,e,i,r){const n=e.y-t.y,s=e.x-t.x,o=r.y-i.y,l=r.x-i.x,c=o*s-l*n;if(0===c)return null;const h=(l*(t.y-i.y)-o*(t.x-i.x))/c;return new a(t.x+h*s,t.y+h*n)}(s,h,p,f)||h,l.projectionCache.offsets[t]}function _f(t,e,i,r,n,a,s,o,l){const c=r?t-e:t+e;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let d,p=h>0?a+n:a+n+1;o.projectionCache.cachedAnchorPoint?d=o.projectionCache.cachedAnchorPoint:(d=uf(o.tileAnchorPoint.x,o.tileAnchorPoint.y,o).point,o.projectionCache.cachedAnchorPoint=d);let f,m,_=d,g=d,y=0,x=0;const v=Math.abs(c),b=[];let w;for(;y+x<=v;){if(p+=h,p<a||p>=s)return null;y+=x,g=_,m=f;const t={absOffsetX:v,direction:h,distanceFromAnchor:y,previousVertex:g};if(_=hf(p,o,t),0===i)b.push(g),w=_.sub(g);else{let e;const r=_.sub(g);e=0===r.mag()?ff(hf(p+h,o,t).sub(_),i,h):ff(r,i,h),m||(m=g.add(e)),f=mf(p,e,_,a,s,m,i,o,t),b.push(m),w=f.sub(m)}x=w.mag()}const T=w._mult((v-y)/x)._add(m||g),P=u+Math.atan2(_.y-g.y,_.x-g.x);return b.push(T),{point:T,angle:l?P:0,path:b}}const gf=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function yf(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(gf,3*t)}}function xf(t,e,i){const r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t[3]=i[3]*r+i[7]*n+i[15],t}const vf=100;class bf{constructor(t,e=new Kp(t.width+200,t.height+200,25),i=new Kp(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchFactor=Math.cos(t.pitch*Math.PI/180)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+vf,this.screenBottomBoundary=t.height+vf,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6}placeCollisionBox(t,e,i,r,n,a,s,o,l,c,h,u){const d=this.projectAndGetPerspectiveRatio(t.anchorPointX+o[0],t.anchorPointY+o[1],n,c,u),p=i*d.perspectiveRatio;let f;if(a||s)f=this._projectCollisionBox(t,p,r,n,a,s,o,d,c,h,u);else{const e=d.x+(h?h.x*p:0),i=d.y+(h?h.y*p:0);f={allPointsOccluded:!1,box:[e+t.x1*p,i+t.y1*p,e+t.x2*p,i+t.y2*p]}}const[m,_,g,y]=f.box,x=a?f.allPointsOccluded:d.isOccluded;let v=x;return v||(v=d.perspectiveRatio<this.perspectiveRatioCutoff),v||(v=!this.isInsideGrid(m,_,g,y)),v||"always"!==e&&this.grid.hitTest(m,_,g,y,e,l)?{box:[m,_,g,y],placeable:!1,offscreen:!1,occluded:x}:{box:[m,_,g,y],placeable:!0,offscreen:this.isOffscreen(m,_,g,y),occluded:x}}placeCollisionCircles(t,e,i,r,n,s,o,l,c,h,u,d,p,f){const m=[],_=new a(e.anchorX,e.anchorY),g=this.getPerspectiveRatio(_.x,_.y,s,f),y=(c?n*this.transform.getPitchedTextCorrection(e.anchorX,e.anchorY,s)/g:n*g)/24,x={getElevation:f,pitchedLabelPlaneMatrix:o,lineVertexArray:i,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:_,unwrappedTileID:s,width:this.transform.width,height:this.transform.height,translation:p},v=sf(y,r,e.lineOffsetX*y,e.lineOffsetY*y,!1,e,!1,x);let b=!1,w=!1,T=!0;if(v){const e=.5*u*g+d,i=new a(-100,-100),r=new a(this.screenRightBoundary,this.screenBottomBoundary),n=new Xp,s=v.first,o=v.last;let p=[];for(let t=s.path.length-1;t>=1;t--)p.push(s.path[t]);for(let t=1;t<o.path.length;t++)p.push(o.path[t]);const f=2.5*e;if(c){const t=this.projectPathToScreenSpace(p,x);p=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point))}let _=[];if(p.length>0){const t=p[0].clone(),e=p[0].clone();for(let i=1;i<p.length;i++)t.x=Math.min(t.x,p[i].x),t.y=Math.min(t.y,p[i].y),e.x=Math.max(e.x,p[i].x),e.y=Math.max(e.y,p[i].y);_=t.x>=i.x&&e.x<=r.x&&t.y>=i.y&&e.y<=r.y?[p]:e.x<i.x||t.x>r.x||e.y<i.y||t.y>r.y?[]:function(t,e,i,r,n){const s=[];for(let o=0;o<t.length;o++){const l=t[o];let c;for(let t=0;t<l.length-1;t++){let o=l[t],h=l[t+1];o.x<e&&h.x<e||(o.x<e?o=new a(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x<e&&(h=new a(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y<i&&h.y<i||(o.y<i?o=new a(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round():h.y<i&&(h=new a(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round()),o.x>=r&&h.x>=r||(o.x>=r?o=new a(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x>=r&&(h=new a(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y>=n&&h.y>=n||(o.y>=n?o=new a(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round():h.y>=n&&(h=new a(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round()),c&&o.equals(c[c.length-1])||(c=[o],s.push(c)),c.push(h)))))}}return s}([p],i.x,i.y,r.x,r.y)}for(const i of _){n.reset(i,.25*e);let r=0;r=n.length<=.5*e?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const a=i/Math.max(r-1,1),s=n.lerp(a),o=s.x+vf,c=s.y+vf;m.push(o,c,e,0);const u=o-e,d=c-e,p=o+e,f=c+e;if(T=T&&this.isOffscreen(u,d,p,f),w=w||this.isInsideGrid(u,d,p,f),"always"!==t&&this.grid.hitTestCircle(o,c,e,t,h)&&(b=!0,!l))return{circles:[],offscreen:!1,collisionDetected:b}}}}return{circles:!l&&b||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:b}}projectPathToScreenSpace(t,e){const i=function(t,e){const i=_();return x(i,e.pitchedLabelPlaneMatrix),t.map((t=>{const r=ef(t.x,t.y,i,e.getElevation),n=e.transform.projectTileCoordinates(r.point.x,r.point.y,e.unwrappedTileID,e.getElevation);return n.point.x=(.5*n.point.x+.5)*e.width,n.point.y=(.5*-n.point.y+.5)*e.height,n}))}(t,e);return function(t){let e=0,i=0,r=0,n=0;for(let a=0;a<t.length;a++)t[a].isOccluded?(r=a+1,n=0):(n++,n>i&&(i=n,e=r));return t.slice(e,e+i)}(i)}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const e=[],i=new fp;for(const r of t){const t=new a(r.x+vf,r.y+vf);i.extend(t),e.push(t)}const{minX:r,minY:n,maxX:s,maxY:o}=i,l=this.grid.query(r,n,s,o).concat(this.ignoredGrid.query(r,n,s,o)),c={},h={};for(const t of l){const i=t.key;void 0===c[i.bucketInstanceId]&&(c[i.bucketInstanceId]={}),c[i.bucketInstanceId][i.featureIndex]||rc(e,[new a(t.x1,t.y1),new a(t.x2,t.y1),new a(t.x2,t.y2),new a(t.x1,t.y2)])&&(c[i.bucketInstanceId][i.featureIndex]=!0,void 0===h[i.bucketInstanceId]&&(h[i.bucketInstanceId]=[]),h[i.bucketInstanceId].push(i.featureIndex))}return h}insertCollisionBox(t,e,i,r,n,a){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:n,collisionGroupID:a,overlapMode:e},t[0],t[1],t[2],t[3])}insertCollisionCircles(t,e,i,r,n,a){const s=i?this.ignoredGrid:this.grid,o={bucketInstanceId:r,featureIndex:n,collisionGroupID:a,overlapMode:e};for(let e=0;e<t.length;e+=4)s.insertCircle(o,t[e],t[e+1],t[e+2])}projectAndGetPerspectiveRatio(t,e,i,r,n){if(n){let i;r?(i=[t,e,r(t,e),1],G(i,i,n)):(i=[t,e,0,1],xf(i,i,n));const a=i[3];return{x:(i[0]/a+1)/2*this.transform.width+vf,y:(-i[1]/a+1)/2*this.transform.height+vf,perspectiveRatio:.5+this.transform.cameraToCenterDistance/a*.5,isOccluded:!1,signedDistanceFromCamera:a}}{const n=this.transform.projectTileCoordinates(t,e,i,r);return{x:(n.point.x+1)/2*this.transform.width+vf,y:(1-n.point.y)/2*this.transform.height+vf,perspectiveRatio:.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5,isOccluded:n.isOccluded,signedDistanceFromCamera:n.signedDistanceFromCamera}}}getPerspectiveRatio(t,e,i,r){const n=this.transform.projectTileCoordinates(t,e,i,r);return.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5}isOffscreen(t,e,i,r){return i<vf||t>=this.screenRightBoundary||r<vf||e>this.screenBottomBoundary}isInsideGrid(t,e,i,r){return i>=0&&t<this.gridRightBoundary&&r>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=y([]);return b(t,t,[-100,-100,0]),t}_projectCollisionBox(t,e,i,r,n,s,o,l,c,h,u){let d=1,p=0,f=0,m=1;const _=t.anchorPointX+o[0],g=t.anchorPointY+o[1];if(s&&!n){const t=this.projectAndGetPerspectiveRatio(_+1,g,r,c,u),e=t.x-l.x,i=Math.atan((t.y-l.y)/e)+(e<0?Math.PI:0),n=Math.sin(i),a=Math.cos(i);d=a,p=n,f=-n,m=a}else if(!s&&n){const t=tf(this.transform);d=t.vecEast[0],p=t.vecEast[1],f=t.vecSouth[0],m=t.vecSouth[1]}let y=l.x,x=l.y,v=e;n&&(y=_,x=g,v=Math.pow(2,-(this.transform.zoom-i.overscaledZ)),v*=this.transform.getPitchedTextCorrection(_,g,r),h||(v*=vt(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(y+=d*h.x*v+f*h.y*v,x+=p*h.x*v+m*h.y*v);const b=t.x1*v,w=t.x2*v,T=(b+w)/2,P=t.y1*v,M=t.y2*v,S=(P+M)/2,I=[{offsetX:b,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:S},{offsetX:w,offsetY:M},{offsetX:T,offsetY:M},{offsetX:b,offsetY:M},{offsetX:b,offsetY:S}];let C=[];for(const{offsetX:t,offsetY:e}of I)C.push(new a(y+d*t+f*e,x+p*t+m*e));let A=!1;if(n){const t=C.map((t=>this.projectAndGetPerspectiveRatio(t.x,t.y,r,c,u)));A=t.some((t=>!t.isOccluded)),C=t.map((t=>new a(t.x,t.y)))}else A=!0;return{box:_t(C),allPointsOccluded:!A}}}class wf extends a{constructor(t,e,i,r){super(t,e),this.angle=i,void 0!==r&&(this.segment=r)}clone(){return new wf(this.x,this.y,this.angle,this.segment)}}var Tf;fs("Anchor",wf),function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(Tf||(Tf={}));class Pf{constructor(t,e,i,r){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class Mf{constructor(t,e,i,r,n){this.text=new Pf(t?t.text:null,e,i,n),this.icon=new Pf(t?t.icon:null,e,r,n)}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Sf{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i}}class If{constructor(t,e,i,r,n){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class Cf{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={}}get(t){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e}}return this.collisionGroups[t]}}function Af(t,e,i,r,n){const{horizontalAlign:s,verticalAlign:o}=$u(t);return new a(-(s-.5)*e+r[0]*n,-(o-.5)*i+r[1]*n)}class Ef{constructor(t,e,i,r,n){this.transform=t.clone(),this.terrain=e,this.collisionIndex=new bf(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new Cf(r),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=n,n&&(n.prevPlacement=void 0),this.placedOrientations={}}_getTerrainElevationFunc(t){const e=this.terrain;return e?(i,r)=>e.getElevation(t,i,r):null}getBucketParts(t,e,i,r){const n=i.getBucket(e),a=i.latestFeatureIndex;if(!n||!a||e.id!==n.layerIds[0])return;const s=i.collisionBoxArray,o=n.layers[0].layout,l=n.layers[0].paint,c=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),h=i.tileSize/Q,u=i.tileID.toUnwrapped(),d="map"===o.get("text-rotation-alignment"),p=tt(i,1,this.transform.zoom),f=st(this.collisionIndex.transform,i,l.get("text-translate"),l.get("text-translate-anchor")),m=st(this.collisionIndex.transform,i,l.get("icon-translate"),l.get("icon-translate-anchor")),_=Jp(d,this.transform,p);this.retainedQueryData[n.bucketInstanceId]=new If(n.bucketInstanceId,a,n.sourceLayerIndex,n.index,i.tileID);const g={bucket:n,layout:o,translationText:f,translationIcon:m,unwrappedTileID:u,pitchedLabelPlaneMatrix:_,scale:c,textPixelRatio:h,holdingForFade:i.holdingForSymbolFade(),collisionBoxArray:s,partiallyEvaluatedTextSize:Hu(n.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=e;t.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:g})}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:g})}attemptAnchorPlacement(t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g,y,x){const v=Tf[t.textAnchor],b=[t.textOffset0,t.textOffset1],w=Af(v,i,r,b,n),T=this.collisionIndex.placeCollisionBox(e,u,o,l,c,s,a,m,h.predicate,y,w,x);if((!g||this.collisionIndex.placeCollisionBox(g,u,o,l,c,s,a,_,h.predicate,y,w,x).placeable)&&T.placeable){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[d.crossTileID]&&this.prevPlacement.placements[d.crossTileID]&&this.prevPlacement.placements[d.crossTileID].text&&(t=this.prevPlacement.variableOffsets[d.crossTileID].anchor),0===d.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[d.crossTileID]={textOffset:b,width:i,height:r,anchor:v,textBoxScale:n,prevAnchor:t},this.markUsedJustification(p,v,d,f),p.allowVerticalPlacement&&(this.markUsedOrientation(p,f,d),this.placedOrientations[d.crossTileID]=f),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,e,i){const{bucket:r,layout:n,translationText:a,translationIcon:s,unwrappedTileID:o,pitchedLabelPlaneMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:d,collisionGroup:p}=t.parameters,f=n.get("text-optional"),m=n.get("icon-optional"),_=Xu(n,"text-overlap","text-allow-overlap"),g="always"===_,y=Xu(n,"icon-overlap","icon-allow-overlap"),x="always"===y,v="map"===n.get("text-rotation-alignment"),b="map"===n.get("text-pitch-alignment"),w="none"!==n.get("icon-text-fit"),T="viewport-y"===n.get("symbol-z-order"),P=g&&(x||!r.hasIconData()||m),M=x&&(g||!r.hasTextData()||f);!r.collisionArrays&&u&&r.deserializeCollisionBoxes(u);const S=this.retainedQueryData[r.bucketInstanceId].tileID,I=this._getTerrainElevationFunc(S),C=this.transform.getFastPathSimpleProjectionMatrix(S),A=(t,u,x)=>{var T,A;if(e[t.crossTileID])return;if(h)return void(this.placements[t.crossTileID]=new Sf(!1,!1,!1));let E=!1,z=!1,D=!0,k=null,R={box:null,placeable:!1,offscreen:null,occluded:!1},L={placeable:!1},F=null,B=null,O=null,j=0,V=0,N=0;u.textFeatureIndex?j=u.textFeatureIndex:t.useRuntimeCollisionCircles&&(j=t.featureIndex),u.verticalTextFeatureIndex&&(V=u.verticalTextFeatureIndex);const U=u.textBox;if(U){const e=e=>{let i=Gu.horizontal;if(r.allowVerticalPlacement&&!e&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,i=e,this.markUsedOrientation(r,i,t))}return i},n=(e,i)=>{if(r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&u.verticalTextBox){for(const t of r.writingModes)if(t===Gu.vertical?(R=i(),L=R):R=e(),R&&R.placeable)break}else R=e()},l=t.textAnchorOffsetStartIndex,h=t.textAnchorOffsetEndIndex;if(h===l){const i=(e,i)=>{const n=this.collisionIndex.placeCollisionBox(e,_,c,S,o,b,v,a,p.predicate,I,void 0,C);return n&&n.placeable&&(this.markUsedOrientation(r,i,t),this.placedOrientations[t.crossTileID]=i),n};n((()=>i(U,Gu.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&e?i(e,Gu.vertical):{box:null,offscreen:null}})),e(R&&R.placeable)}else{let d=Tf[null===(A=null===(T=this.prevPlacement)||void 0===T?void 0:T.variableOffsets[t.crossTileID])||void 0===A?void 0:A.anchor];const f=(e,n,u)=>{const f=e.x2-e.x1,m=e.y2-e.y1,g=t.textBoxScale,x=w&&"never"===y?n:null;let T=null,P="never"===_?1:2,M="never";d&&P++;for(let i=0;i<P;i++){for(let i=l;i<h;i++){const n=r.textAnchorOffsets.get(i);if(d&&n.textAnchor!==d)continue;const l=this.attemptAnchorPlacement(n,e,f,m,g,v,b,c,S,o,p,M,t,r,u,a,s,x,I);if(l&&(T=l.placedGlyphBoxes,T&&T.placeable))return E=!0,k=l.shift,T}d?d=null:M=_}return i&&!T&&(T={box:this.collisionIndex.placeCollisionBox(U,"always",c,S,o,b,v,a,p.predicate,I,void 0,C).box,offscreen:!1,placeable:!1,occluded:!1}),T};n((()=>f(U,u.iconBox,Gu.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&(!R||!R.placeable)&&t.numVerticalGlyphVertices>0&&e?f(e,u.verticalIconBox,Gu.vertical):{box:null,occluded:!0,offscreen:null}})),R&&(E=R.placeable,D=R.offscreen);const m=e(R&&R.placeable);if(!E&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(r,e.anchor,t,m))}}}if(F=R,E=F&&F.placeable,D=F&&F.offscreen,t.useRuntimeCollisionCircles&&t.centerJustifiedTextSymbolIndex>=0){const e=r.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),s=Wu(r.textSizeData,d,e),c=n.get("text-padding");B=this.collisionIndex.placeCollisionCircles(_,e,r.lineVertexArray,r.glyphOffsetArray,s,o,l,i,b,p.predicate,t.collisionCircleDiameter,c,a,I),B.circles.length&&B.collisionDetected&&!i&&kt("Collisions detected, but collision boxes are not shown"),E=g||B.circles.length>0&&!B.collisionDetected,D=D&&B.offscreen}if(u.iconFeatureIndex&&(N=u.iconFeatureIndex),u.iconBox){const t=t=>this.collisionIndex.placeCollisionBox(t,y,c,S,o,b,v,s,p.predicate,I,w&&k?k:void 0,C);L&&L.placeable&&u.verticalIconBox?(O=t(u.verticalIconBox),z=O.placeable):(O=t(u.iconBox),z=O.placeable),D=D&&O.offscreen}const Z=f||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=m||0===t.numIconVertices;Z||G?G?Z||(z=z&&E):E=z&&E:z=E=z&&E;const $=z&&O.placeable;if(E&&F.placeable&&this.collisionIndex.insertCollisionBox(F.box,_,n.get("text-ignore-placement"),r.bucketInstanceId,L&&L.placeable&&V?V:j,p.ID),$&&this.collisionIndex.insertCollisionBox(O.box,y,n.get("icon-ignore-placement"),r.bucketInstanceId,N,p.ID),B&&E&&this.collisionIndex.insertCollisionCircles(B.circles,_,n.get("text-ignore-placement"),r.bucketInstanceId,j,p.ID),i&&this.storeCollisionData(r.bucketInstanceId,x,u,F,O,B),0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new Sf((E||P)&&!(null==F?void 0:F.occluded),(z||M)&&!(null==O?void 0:O.occluded),D||r.justReloaded),e[t.crossTileID]=!0};if(T){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let t=e.length-1;t>=0;--t){const i=e[t];A(r.symbolInstances.get(i),r.collisionArrays[i],i)}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)A(r.symbolInstances.get(e),r.collisionArrays[e],e);r.justReloaded=!1}storeCollisionData(t,e,i,r,n,a){if(i.textBox||i.iconBox){let a,s;this.collisionBoxArrays.has(t)?a=this.collisionBoxArrays.get(t):(a=new Map,this.collisionBoxArrays.set(t,a)),a.has(e)?s=a.get(e):(s={text:null,icon:null},a.set(e,s)),i.textBox&&(s.text=r.box),i.iconBox&&(s.icon=n.box)}if(a){let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=[]);for(let t=0;t<a.circles.length;t+=4)e.push(a.circles[t+0]-vf),e.push(a.circles[t+1]-vf),e.push(a.circles[t+2]),e.push(a.collisionDetected?1:0)}}markUsedJustification(t,e,i,r){let n;n=r===Gu.vertical?i.verticalPlacedTextSymbolIndex:{left:i.leftJustifiedTextSymbolIndex,center:i.centerJustifiedTextSymbolIndex,right:i.rightJustifiedTextSymbolIndex}[function(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(e)];const a=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex,i.verticalPlacedTextSymbolIndex];for(const e of a)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=n>=0&&e!==n?0:i.crossTileID)}markUsedOrientation(t,e,i){const r=e===Gu.horizontal||e===Gu.horizontalOnly?e:0,n=e===Gu.vertical?e:0,a=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex];for(const e of a)t.text.placedSymbolArray.get(e).placedOrientation=r;i.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(i.verticalPlacedTextSymbolIndex).placedOrientation=n)}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const r=e?e.symbolFadeChange(t):1,n=e?e.opacities:{},a=e?e.variableOffsets:{},s=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],a=n[t];a?(this.opacities[t]=new Mf(a,r,e.text,e.icon),i=i||e.text!==a.text.placed||e.icon!==a.icon.placed):(this.opacities[t]=new Mf(null,r,e.text,e.icon,e.skipFade),i=i||e.text||e.icon)}for(const t in n){const e=n[t];if(!this.opacities[t]){const n=new Mf(e,r,!1,!1);n.isHidden()||(this.opacities[t]=n,i=i||e.text.placed||e.icon.placed)}}for(const t in a)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=a[t]);for(const t in s)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=s[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t)}updateLayerOpacities(t,e){const i={};for(const r of e){const e=r.getBucket(t);e&&r.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,r.tileID,i,r.collisionBoxArray)}}updateBucketOpacities(t,e,i,r){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const n=t.layers[0],s=n.layout,o=new Mf(null,0,!1,!1,!0),l=s.get("text-allow-overlap"),c=s.get("icon-allow-overlap"),h=n._unevaluatedLayout.hasValue("text-variable-anchor")||n._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===s.get("text-rotation-alignment"),d="map"===s.get("text-pitch-alignment"),p="none"!==s.get("icon-text-fit"),f=new Mf(null,0,l&&(c||!t.hasIconData()||s.get("icon-optional")),c&&(l||!t.hasTextData()||s.get("text-optional")),!0);!t.collisionArrays&&r&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(r);const m=(t,e,i)=>{for(let r=0;r<e/4;r++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==Vf},_=this.collisionBoxArrays.get(t.bucketInstanceId);for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:s,crossTileID:l}=r;let c=this.opacities[l];i[l]?c=o:c||(c=f,this.opacities[l]=c),i[l]=!0;const g=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],x=y===Gu.vertical,v=y===Gu.horizontal||y===Gu.horizontalOnly;if(n>0||s>0){const e=jf(c.text);m(t.text,n,x?Vf:e),m(t.text,s,v?Vf:e);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||x?1:0)})),r.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const a=this.variableOffsets[r.crossTileID];a&&this.markUsedJustification(t,a.anchor,r,y);const o=this.placedOrientations[r.crossTileID];o&&(this.markUsedJustification(t,"left",r,o),this.markUsedOrientation(t,o,r))}if(g){const e=jf(c.icon),i=!(p&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(t.icon,r.numIconVertices,i?e:Vf),t.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(t.icon,r.numVerticalIconVertices,i?Vf:e),t.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden())}const b=_&&_.has(e)?_.get(e):{text:null,icon:null};if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[e];if(i){let e=new a(0,0);if(i.textBox||i.verticalTextBox){let r=!0;if(h){const t=this.variableOffsets[l];t?(e=Af(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),u&&e._rotate(d?-this.transform.bearingInRadians:this.transform.bearingInRadians)):r=!1}if(i.textBox||i.verticalTextBox){let n;i.textBox&&(n=x),i.verticalTextBox&&(n=v),zf(t.textCollisionBox.collisionVertexArray,c.text.placed,!r||n,b.text,e.x,e.y)}}if(i.iconBox||i.verticalIconBox){const r=Boolean(!v&&i.verticalIconBox);let n;i.iconBox&&(n=r),i.verticalIconBox&&(n=!r),zf(t.iconCollisionBox.collisionVertexArray,c.icon.placed,n,b.icon,p?e.x:0,p?e.y:0)}}}}if(t.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);t.bucketInstanceId in this.collisionCircleArrays&&(t.collisionCircleArray=this.collisionCircleArrays[t.bucketInstanceId],delete this.collisionCircleArrays[t.bucketInstanceId])}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0}}function zf(t,e,i,r,n,a){r&&0!==r.length||(r=[0,0,0,0]);const s=r[0]-vf,o=r[1]-vf,l=r[2]-vf,c=r[3]-vf;t.emplaceBack(e?1:0,i?1:0,n||0,a||0,s,o),t.emplaceBack(e?1:0,i?1:0,n||0,a||0,l,o),t.emplaceBack(e?1:0,i?1:0,n||0,a||0,l,c),t.emplaceBack(e?1:0,i?1:0,n||0,a||0,s,c)}const Df=Math.pow(2,25),kf=Math.pow(2,24),Rf=Math.pow(2,17),Lf=Math.pow(2,16),Ff=Math.pow(2,9),Bf=Math.pow(2,8),Of=Math.pow(2,1);function jf(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*Df+e*kf+i*Rf+e*Lf+i*Ff+e*Bf+i*Of+e}const Vf=0;class Nf{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[]}continuePlacement(t,e,i,r,n){const a=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(a,r,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,a.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<a.length;)if(e.placeLayerBucketPart(a[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,n())return!0;return!1}}class Uf{constructor(t,e,i,r,n,a,s,o){this.placement=new Ef(t,e,a,s,o),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=n,this._done=!1}isDone(){return this._done}continuePlacement(t,e,i){const r=ie(),n=()=>!this._forceFullPlacement&&ie()-r>2;for(;this._currentPlacementIndex>=0;){const r=e[t[this._currentPlacementIndex]],a=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=a)&&(!r.maxzoom||r.maxzoom>a)){if(this._inProgressLayer||(this._inProgressLayer=new Nf(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,n))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(t){return this.placement.commit(t),this.placement}}const Zf=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Gf{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,i]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=Zf[15&i];if(!n)throw new Error("Unrecognized array type.");const[a]=new Uint16Array(t,2,1),[s]=new Uint32Array(t,4,1);return new Gf(s,a,n,t)}constructor(t,e=64,i=Float64Array,r){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=i,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const n=Zf.indexOf(this.ArrayType),a=2*t*this.ArrayType.BYTES_PER_ELEMENT,s=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-s%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+s+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+a+s+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+s+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=t,this.coords[this._pos++]=e,i}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return $f(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:a,nodeSize:s}=this,o=[0,n.length-1,0],l=[];for(;o.length;){const c=o.pop()||0,h=o.pop()||0,u=o.pop()||0;if(h-u<=s){for(let s=u;s<=h;s++){const o=a[2*s],c=a[2*s+1];o>=t&&o<=i&&c>=e&&c<=r&&l.push(n[s])}continue}const d=u+h>>1,p=a[2*d],f=a[2*d+1];p>=t&&p<=i&&f>=e&&f<=r&&l.push(n[d]),(0===c?t<=p:e<=f)&&(o.push(u),o.push(d-1),o.push(1-c)),(0===c?i>=p:r>=f)&&(o.push(d+1),o.push(h),o.push(1-c))}return l}within(t,e,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:a}=this,s=[0,r.length-1,0],o=[],l=i*i;for(;s.length;){const c=s.pop()||0,h=s.pop()||0,u=s.pop()||0;if(h-u<=a){for(let i=u;i<=h;i++)Xf(n[2*i],n[2*i+1],t,e)<=l&&o.push(r[i]);continue}const d=u+h>>1,p=n[2*d],f=n[2*d+1];Xf(p,f,t,e)<=l&&o.push(r[d]),(0===c?t-i<=p:e-i<=f)&&(s.push(u),s.push(d-1),s.push(1-c)),(0===c?t+i>=p:e+i>=f)&&(s.push(d+1),s.push(h),s.push(1-c))}return o}}function $f(t,e,i,r,n,a){if(n-r<=i)return;const s=r+n>>1;qf(t,e,s,r,n,a),$f(t,e,i,r,s-1,1-a),$f(t,e,i,s+1,n,1-a)}function qf(t,e,i,r,n,a){for(;n>r;){if(n-r>600){const s=n-r+1,o=i-r+1,l=Math.log(s),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(s-c)/s)*(o-s/2<0?-1:1);qf(t,e,i,Math.max(r,Math.floor(i-o*c/s+h)),Math.min(n,Math.floor(i+(s-o)*c/s+h)),a)}const s=e[2*i+a];let o=r,l=n;for(Wf(t,e,r,i),e[2*n+a]>s&&Wf(t,e,r,n);o<l;){for(Wf(t,e,o,l),o++,l--;e[2*o+a]<s;)o++;for(;e[2*l+a]>s;)l--}e[2*r+a]===s?Wf(t,e,r,l):(l++,Wf(t,e,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function Wf(t,e,i,r){Hf(t,i,r),Hf(e,2*i,2*r),Hf(e,2*i+1,2*r+1)}function Hf(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function Xf(t,e,i,r){const n=t-i,a=e-r;return n*n+a*a}const Yf=.03125;class Kf{constructor(t,e,i){this.tileID=t,this.bucketInstanceId=i,this._symbolsByKey={};const r=new Map;for(let t=0;t<e.length;t++){const i=e.get(t),n=i.key,a=r.get(n);a?a.push(i):r.set(n,[i])}for(const[t,e]of r){const i={positions:e.map((t=>({x:Math.floor(t.anchorX*Yf),y:Math.floor(t.anchorY*Yf)}))),crossTileIDs:e.map((t=>t.crossTileID))};if(i.positions.length>128){const t=new Gf(i.positions.length,16,Uint16Array);for(const{x:e,y:r}of i.positions)t.add(e,r);t.finish(),delete i.positions,i.index=t}this._symbolsByKey[t]=i}}getScaledCoordinates(t,e){const{x:i,y:r,z:n}=this.tileID.canonical,{x:a,y:s,z:o}=e.canonical,l=Yf/Math.pow(2,o-n),c=(s*Q+t.anchorY)*l,h=r*Q*Yf;return{x:Math.floor((a*Q+t.anchorX)*l-i*Q*Yf),y:Math.floor(c-h)}}findMatches(t,e,i){const r=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let n=0;n<t.length;n++){const a=t.get(n);if(a.crossTileID)continue;const s=this._symbolsByKey[a.key];if(!s)continue;const o=this.getScaledCoordinates(a,e);if(s.index){const t=s.index.range(o.x-r,o.y-r,o.x+r,o.y+r).sort();for(const e of t){const t=s.crossTileIDs[e];if(!i[t]){i[t]=!0,a.crossTileID=t;break}}}else if(s.positions)for(let t=0;t<s.positions.length;t++){const e=s.positions[t],n=s.crossTileIDs[t];if(Math.abs(e.x-o.x)<=r&&Math.abs(e.y-o.y)<=r&&!i[n]){i[n]=!0,a.crossTileID=n;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class Jf{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class Qf{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],r={};for(const t in i){const n=i[t];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),r[n.tileID.key]=n}this.indexes[t]=r}this.lng=t}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key])}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const r=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in n){const a=n[i];a.tileID.isChildOf(t)&&a.findMatches(e.symbolInstances,t,r)}else{const a=n[t.scaledTo(Number(i)).key];a&&a.findMatches(e.symbolInstances,t,r)}}for(let t=0;t<e.symbolInstances.length;t++){const n=e.symbolInstances.get(t);n.crossTileID||(n.crossTileID=i.generate(),r[n.crossTileID]=!0)}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new Kf(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e]}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)t[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],e=!0)}return e}}class tm{constructor(){this.layerIndexes={},this.crossTileIDs=new Jf,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(t,e,i){let r=this.layerIndexes[t.id];void 0===r&&(r=this.layerIndexes[t.id]=new Qf);let n=!1;const a={};r.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,e,this.crossTileIDs)&&(n=!0),a[e.bucketInstanceId]=!0)}return r.removeStaleBuckets(a)&&(n=!0),n}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t]}}var em="void main() {fragColor=vec4(1.0);}";const im={prelude:rm("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:rm("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:rm("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:rm("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:rm("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:rm("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:rm(em,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:rm("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:rm("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:rm("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:rm("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:rm("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:rm("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:rm(em,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:rm("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:rm("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:rm("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:rm("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:rm("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:rm("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:rm("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:rm("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:rm("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:rm("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:rm("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:rm("uniform lowp float u_device_pixel_ratio;uniform lowp float u_lineatlas_width;uniform sampler2D u_image;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0/u_device_pixel_ratio)/min(dasharray_from.w,dasharray_to.w);alpha*=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),lineGradientSDF:rm("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform sampler2D u_image_dash;uniform float u_mix;uniform lowp float u_lineatlas_width;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);float sdfdist_a=texture(u_image_dash,v_tex_a).a;float sdfdist_b=texture(u_image_dash,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0)/min(dasharray_from.w,dasharray_to.w);float dash_alpha=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*dash_alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;out vec2 v_tex_a;out vec2 v_tex_b;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;float texel_height=1.0/u_image_height;float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),raster:rm("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:rm("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:rm("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:rm("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:rm("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:rm("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:rm("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:rm("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:rm("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:rm("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function rm(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=e.match(/in ([\w]+) ([\w]+)/g),n=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),a=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=a?a.concat(n):n,o={};return{fragmentSource:t=t.replace(i,((t,e,i,r,n)=>(o[n]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nin ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = u_${n};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,r,n)=>{const a="float"===r?"vec2":"vec4",s=n.match(/color/)?"color":a;return o[n]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${a} a_${n};\nout ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${s}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${a} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = unpack_mix_${s}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`})),staticAttributes:r,staticUniforms:s}}class nm{constructor(t,e,i){this.vertexBuffer=t,this.indexBuffer=e,this.segments=i}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null}}var am=no([{name:"a_pos",type:"Int16",components:2}]);const sm="#define PROJECTION_MERCATOR",om="mercator";class lm{constructor(){this._cachedMesh=null}get name(){return"mercator"}get useSubdivision(){return!1}get shaderVariantName(){return om}get shaderDefine(){return sm}get shaderPreludeCode(){return im.projectionMercator}get vertexShaderPreludeCode(){return im.projectionMercator.vertexSource}get subdivisionGranularity(){return wh.noSubdivision}get useGlobeControls(){return!1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(t){}getMeshFromTileID(t,e,i,r,n){if(this._cachedMesh)return this._cachedMesh;const a=new Zo;a.emplaceBack(0,0),a.emplaceBack(Q,0),a.emplaceBack(0,Q),a.emplaceBack(Q,Q);const s=t.createVertexBuffer(a,am.members),o=ul.simpleSegment(0,0,4,2),l=new sl;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3);const c=t.createIndexBuffer(l);return this._cachedMesh=new nm(s,c,o),this._cachedMesh}recalculate(){}hasTransition(){return!1}setErrorQueryLatitudeDegrees(t){}}class cm{constructor(t=0,e=0,i=0,r=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=r}interpolate(t,e,i){return null!=e.top&&null!=t.top&&(this.top=wr.number(t.top,e.top,i)),null!=e.bottom&&null!=t.bottom&&(this.bottom=wr.number(t.bottom,e.bottom,i)),null!=e.left&&null!=t.left&&(this.left=wr.number(t.left,e.left,i)),null!=e.right&&null!=t.right&&(this.right=wr.number(t.right,e.right,i)),this}getCenter(t,e){return new a(vt((this.left+t-this.right)/2,0,t),vt((this.top+e-this.bottom)/2,0,e))}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new cm(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function hm(t,e){if(!t.renderWorldCopies||t.lngRange)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0}function um(t){return Math.max(0,Math.floor(t))}class dm{constructor(t,e){var i;this._callbacks=t,this._tileSize=512,this._renderWorldCopies=void 0===(null==e?void 0:e.renderWorldCopies)||!!(null==e?void 0:e.renderWorldCopies),this._minZoom=(null==e?void 0:e.minZoom)||0,this._maxZoom=(null==e?void 0:e.maxZoom)||22,this._minPitch=null==(null==e?void 0:e.minPitch)?0:null==e?void 0:e.minPitch,this._maxPitch=null==(null==e?void 0:e.maxPitch)?60:null==e?void 0:e.maxPitch,this._constrain=null!==(i=null==e?void 0:e.constrain)&&void 0!==i?i:this._callbacks.constrain,this.setMaxBounds(),this._width=0,this._height=0,this._center=new $d(0,0),this._elevation=0,this._zoom=0,this._tileZoom=um(this._zoom),this._scale=St(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new cm,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0}apply(t,e,i){this._latRange=t.latRange,this._lngRange=t.lngRange,this._width=t.width,this._height=t.height,this._center=t.center,this._elevation=t.elevation,this._minElevationForCurrentTile=t.minElevationForCurrentTile,this._zoom=t.zoom,this._tileZoom=um(this._zoom),this._scale=St(this._zoom),this._bearingInRadians=t.bearingInRadians,this._fovInRadians=t.fovInRadians,this._pitchInRadians=t.pitchInRadians,this._rollInRadians=t.rollInRadians,this._unmodified=t.unmodified,this._edgeInsets=new cm(t.padding.top,t.padding.bottom,t.padding.left,t.padding.right),this._minZoom=t.minZoom,this._maxZoom=t.maxZoom,this._minPitch=t.minPitch,this._maxPitch=t.maxPitch,this._renderWorldCopies=t.renderWorldCopies,this._cameraToCenterDistance=t.cameraToCenterDistance,this._nearZ=t.nearZ,this._farZ=t.farZ,this._autoCalculateNearFarZ=!i&&t.autoCalculateNearFarZ,e&&this.constrainInternal(),this._calcMatrices()}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(t){this._minElevationForCurrentTile=t}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(t){this._minZoom!==t&&(this._minZoom=t,this.setZoom(this.constrain(this._center,this.zoom).zoom))}get maxZoom(){return this._maxZoom}setMaxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.setZoom(this.constrain(this._center,this.zoom).zoom))}get minPitch(){return this._minPitch}setMinPitch(t){this._minPitch!==t&&(this._minPitch=t,this.setPitch(Math.max(this.pitch,t)))}get maxPitch(){return this._maxPitch}setMaxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.setPitch(Math.min(this.pitch,t)))}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t}get constrain(){return this._constrain}setConstrain(t){t||(t=this._callbacks.constrain),this._constrain=t,this.constrainInternal(),this._calcMatrices()}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new a(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(t){const e=bt(t,-180,180)*Math.PI/180;var i,r,n,a,s,o,l,c,h;this._bearingInRadians!==e&&(this._unmodified=!1,this._bearingInRadians=e,this._calcMatrices(),this._rotationMatrix=f(),i=this._rotationMatrix,n=-this._bearingInRadians,a=(r=this._rotationMatrix)[0],s=r[1],o=r[2],l=r[3],c=Math.sin(n),h=Math.cos(n),i[0]=a*h+o*c,i[1]=s*h+l*c,i[2]=a*-c+o*h,i[3]=s*-c+l*h)}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(t){const e=vt(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==e&&(this._unmodified=!1,this._pitchInRadians=e,this._calcMatrices())}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(t){const e=t/180*Math.PI;this._rollInRadians!==e&&(this._unmodified=!1,this._rollInRadians=e,this._calcMatrices())}get fovInRadians(){return this._fovInRadians}get fov(){return Ut(this._fovInRadians)}setFov(t){t=vt(t,.1,150),this.fov!==t&&(this._unmodified=!1,this._fovInRadians=Nt(t),this._calcMatrices())}get zoom(){return this._zoom}setZoom(t){const e=this.constrain(this._center,t).zoom;this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this._tileZoom=Math.max(0,Math.floor(e)),this._scale=St(e),this.constrainInternal(),this._calcMatrices())}get center(){return this._center}setCenter(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this.constrainInternal(),this._calcMatrices())}get elevation(){return this._elevation}setElevation(t){t!==this._elevation&&(this._elevation=t,this.constrainInternal(),this._calcMatrices())}get padding(){return this._edgeInsets.toJSON()}setPadding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices())}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(t,e){this._autoCalculateNearFarZ=!1,this._nearZ=t,this._farZ=e,this._calcMatrices()}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices()}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this.constrainInternal(),this._calcMatrices()}resize(t,e,i=!0){this._width=t,this._height=e,i&&this.constrainInternal(),this._calcMatrices()}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new qd([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(t){t?(this._lngRange=[t.getWest(),t.getEast()],this._latRange=[t.getSouth(),t.getNorth()],this.constrainInternal()):(this._lngRange=null,this._latRange=[-85.051129,qt])}getCameraQueryGeometry(t,e){if(1===e.length)return[e[0],t];{const{minX:i,minY:r,maxX:n,maxY:s}=fp.fromPoints(e).extend(t);return[new a(i,r),new a(n,r),new a(n,s),new a(i,s),new a(i,r)]}}constrainInternal(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const t=this._unmodified,{center:e,zoom:i}=this.constrain(this.center,this.zoom);this.setCenter(e),this.setZoom(i),this._unmodified=t,this._constraining=!1}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let t=y(new Float64Array(16));w(t,t,[this._width/2,-this._height/2,1]),b(t,t,[1,-1,0]),this._clipSpaceToPixelsMatrix=t,t=y(new Float64Array(16)),w(t,t,[1,-1,1]),b(t,t,[-1,-1,0]),w(t,t,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=t,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height}this._callbacks.calcMatrices()}calculateCenterFromCameraLngLatAlt(t,e,i,r){const n=void 0!==i?i:this.bearing,a=r=void 0!==r?r:this.pitch,s=ep.fromLngLat(t,e),o=-Math.cos(Nt(a)),l=Math.sin(Nt(a)),c=l*Math.sin(Nt(n)),h=-l*Math.cos(Nt(n));let u=this.elevation;const d=e-u;let p;o*d>=0||Math.abs(o)<.1?(p=1e4,u=e+p*o):p=-d/o;let f,m,_=tp(1,s.y),g=0;do{if(g+=1,g>10)break;m=p/_,f=new ep(s.x+c*m,s.y+h*m),_=1/f.meterInMercatorCoordinateUnits()}while(Math.abs(p-m*_)>1e-12);return{center:f.toLngLat(),elevation:u,zoom:It(this.height/2/Math.tan(this.fovInRadians/2)/m/this.tileSize)}}recalculateZoomAndCenter(t){if(this.elevation-t==0)return;const e=Kd(1,this.center.lat)*this.worldSize,i=this.cameraToCenterDistance/e,r=ep.fromLngLat(this.center,this.elevation),n=Op(this.center,this.elevation,this.pitch,this.bearing,i);this._elevation=t;const a=this.calculateCenterFromCameraLngLatAlt(n.toLngLat(),tp(n.z,r.y),this.bearing,this.pitch);this._elevation=a.elevation,this._center=a.center,this.setZoom(a.zoom)}getCameraPoint(){const t=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new a(t*Math.sin(this.rollInRadians),t*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const t=Kd(1,this.center.lat)*this.worldSize;return Op(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/t).toLngLat()}getMercatorTileCoordinates(t){if(!t)return[0,0,1,1];const e=t.canonical.z>=0?1<<t.canonical.z:Math.pow(2,t.canonical.z);return[t.canonical.x/e,t.canonical.y/e,1/e/Q,1/e/Q]}}class pm{constructor(t,e){this.min=t,this.max=e,this.center=k([],D([],this.min,this.max),.5)}quadrant(t){const e=[t%2==0,t<2],i=A(this.min),r=A(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],r[t]=e[t]?this.center[t]:this.max[t];return r[2]=this.max[2],new pm(i,r)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersectsFrustum(t){let e=!0;for(let i=0;i<t.planes.length;i++){const r=this.intersectsPlane(t.planes[i]);if(0===r)return 0;1===r&&(e=!1)}return e?2:t.aabb.min[0]>this.max[0]||t.aabb.min[1]>this.max[1]||t.aabb.min[2]>this.max[2]||t.aabb.max[0]<this.min[0]||t.aabb.max[1]<this.min[1]||t.aabb.max[2]<this.min[2]?0:1}intersectsPlane(t){let e=t[3],i=t[3];for(let r=0;r<3;r++)t[r]>0?(e+=t[r]*this.min[r],i+=t[r]*this.max[r]):(i+=t[r]*this.min[r],e+=t[r]*this.max[r]);return e>=0?2:i<0?0:1}}class fm{distanceToTile2d(t,e,i,r){const n=r.distanceX([t,e]),a=r.distanceY([t,e]);return Math.hypot(n,a)}getWrap(t,e,i){return i}getTileBoundingVolume(t,e,i,r){var n,a;let s=0,o=0;if(null==r?void 0:r.terrain){const l=new lp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);s=null!==(n=c.minElevation)&&void 0!==n?n:Math.min(0,i),o=null!==(a=c.maxElevation)&&void 0!==a?a:Math.max(0,i)}const l=1<<t.z;return new pm([e+t.x/l,t.y/l,s],[e+(t.x+1)/l,(t.y+1)/l,o])}allowVariableZoom(t,e){const i=vt(78.5-t.fov*(Math.abs(Math.cos(t.rollInRadians))*t.height+Math.abs(Math.sin(t.rollInRadians))*t.width)/t.height/2,0,60);return!!e.terrain||t.pitch>i}allowWorldCopies(){return!0}prepareNextFrame(){}}class mm{constructor(t,e,i){this.points=t,this.planes=e,this.aabb=i}static fromInvProjectionMatrix(t,e=1,i=0,r,n){const a=n?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],s=Math.pow(2,i),o=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>function(t,e,i,r){const n=G([],t,e),a=1/n[3]/i*r;return function(t,e,i){return t[0]=e[0]*i[0],t[1]=e[1]*i[1],t[2]=e[2]*i[2],t[3]=e[3]*i[3],t}(n,n,[a,a,1/n[3],a])}(i,t,e,s)));r&&function(t,e,i,r){const n=r?4:0,a=r?0:4;let s=0;const o=[],l=[];for(let e=0;e<4;e++){const i=U([],t[e+a],t[e+n]),r=E(i);k(i,i,1/r),o.push(r),l.push(i)}for(let e=0;e<4;e++){const r=ct(t[e+n],l[e],i);s=null!==r&&r>=0?Math.max(s,r):Math.max(s,o[e])}const c=function(t,e){const i=[0,0,0,0];return R(i,F([],U([],t[e[0]],t[e[1]]),U([],t[e[2]],t[e[1]]))),i[3]=-L(i,t[e[0]]),i}(t,e),h=function(t,e){const i=Z(t),r=((s=[])[0]=(o=t)[0]*(l=1/i),s[1]=o[1]*l,s[2]=o[2]*l,s[3]=o[3]*l,s),n=U([],e,k([],r,L(e,r))),a=Z(n);var s,o,l;if(a>0){const t=Math.sqrt(1-r[3]*r[3]);return ot(e,D([],k([],r,-r[3]),k([],n,t/a)))}return null}(i,c);if(null!==h){const t=h/L(l[0],c);s=Math.min(s,t)}for(let e=0;e<4;e++){const i=Math.min(s,o[e]);t[e+a]=[t[e+n][0]+l[e][0]*i,t[e+n][1]+l[e][1]*i,t[e+n][2]+l[e][2]*i,1]}}(o,a[0],r,n);const l=a.map((t=>{const e=R([],F([],U([],o[t[0]],o[t[1]]),U([],o[t[2]],o[t[1]]))),i=-L(e,o[t[1]]);return e.concat(i)})),c=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],h=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const t of o)for(let e=0;e<3;e++)c[e]=Math.min(c[e],t[e]),h[e]=Math.max(h[e],t[e]);return new mm(o,l,new pm(c,h))}}class _m{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}setConstrain(t){this._helper.setConstrain(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrain(){return this._helper.constrain}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t,e){}constructor(t){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this.defaultConstrain=(t,e)=>{e=vt(+e,this.minZoom,this.maxZoom);const i={center:new $d(t.lng,t.lat),zoom:e};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const t=180-1e-10;r=[-t,t]}const n=this.tileSize*St(i.zoom);let s=0,o=n,l=0,c=n,h=0,u=0;const{x:d,y:p}=this.size;if(this._helper._latRange){const t=this._helper._latRange;s=Yd(t[1])*n,o=Yd(t[0])*n,o-s<p&&(h=p/(o-s))}r&&(l=bt(Xd(r[0])*n,0,n),c=bt(Xd(r[1])*n,0,n),c<l&&(c+=n),c-l<d&&(u=d/(c-l)));const{x:f,y:m}=Rp(n,t);let _,g;const y=Math.max(u||0,h||0);if(y){const t=new a(u?(c+l)/2:f,h?(o+s)/2:m);return i.center=Lp(n,t).wrap(),i.zoom+=It(y),i}if(this._helper._latRange){const t=p/2;m-t<s&&(g=s+t),m+t>o&&(g=o-t)}if(r){const t=(l+c)/2;let e=f;this._helper._renderWorldCopies&&(e=bt(f,t-n/2,t+n/2));const i=d/2;e-i<l&&(_=l+i),e+i>c&&(_=c-i)}if(void 0!==_||void 0!==g){const t=new a(null!=_?_:f,null!=g?g:m);i.center=Lp(n,t).wrap()}return i},this._helper=new dm({calcMatrices:()=>{this._calcMatrices()},constrain:(t,e)=>this.defaultConstrain(t,e)},t),this._coveringTilesDetailsProvider=new fm}clone(){const t=new _m;return t.apply(this),t}apply(t,e,i){this._helper.apply(t,e,i)}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(t){const e=[new op(0,t)];if(this._helper._renderWorldCopies){const i=this.screenPointToMercatorCoordinate(new a(0,0)),r=this.screenPointToMercatorCoordinate(new a(this._helper._width,0)),n=this.screenPointToMercatorCoordinate(new a(this._helper._width,this._helper._height)),s=this.screenPointToMercatorCoordinate(new a(0,this._helper._height)),o=Math.floor(Math.min(i.x,r.x,n.x,s.x)),l=Math.floor(Math.max(i.x,r.x,n.x,s.x)),c=1;for(let i=o-c;i<=l+c;i++)0!==i&&e.push(new op(i,t))}return e}getCameraFrustum(){return mm.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){const e=this.screenPointToLocation(this.centerPoint,t),i=t?t.getElevationForLngLatZoom(e,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i)}setLocationAtPoint(t,e){const i=Kd(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(e,i),n=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,i),a=ep.fromLngLat(t),s=new ep(a.x-(r.x-n.x),a.y-(r.y-n.y));this.setCenter(null==s?void 0:s.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap())}locationToScreenPoint(t,e){return e?this.coordinatePoint(ep.fromLngLat(t),e.getElevationForLngLatZoom(t,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(ep.fromLngLat(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(t)}screenPointToMercatorCoordinateAtZ(t,e){const i=e||0,r=[t.x,t.y,0,1],n=[t.x,t.y,1,1];G(r,r,this._pixelMatrixInverse),G(n,n,this._pixelMatrixInverse);const a=r[3],s=n[3],o=r[1]/a,l=n[1]/s,c=r[2]/a,h=n[2]/s,u=c===h?0:(i-c)/(h-c);return new ep(wr.number(r[0]/a,n[0]/s,u)/this.worldSize,wr.number(o,l,u)/this.worldSize,i)}coordinatePoint(t,e=0,i=this._pixelMatrix){const r=[t.x*this.worldSize,t.y*this.worldSize,e,1];return G(r,r,i),new a(r[0]/r[3],r[1]/r[3])}getBounds(){const t=Math.max(0,this._helper._height/2-Fp(this));return(new qd).extend(this.screenPointToLocation(new a(0,t))).extend(this.screenPointToLocation(new a(this._helper._width,t))).extend(this.screenPointToLocation(new a(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new a(0,this._helper._height)))}isPointOnMapSurface(t,e){return e?null!=e.pointCoordinate(t):t.y>this.height/2-Fp(this)}calculatePosMatrix(t,e=!1,i){var r;const n=null!==(r=t.key)&&void 0!==r?r:cp(t.wrap,t.canonical.z,t.canonical.z,t.canonical.x,t.canonical.y),a=e?this._alignedPosMatrixCache:this._posMatrixCache;if(a.has(n)){const t=a.get(n);return i?t.f32:t.f64}const s=Bp(t,this.worldSize);v(s,e?this._alignedProjMatrix:this._viewProjMatrix,s);const o={f64:s,f32:new Float32Array(s)};return a.set(n,o),i?o.f32:o.f64}calculateFogMatrix(t){const e=t.key,i=this._fogMatrixCacheF32;if(i.has(e))return i.get(e);const r=Bp(t,this.worldSize);return v(r,this._fogMatrix,r),i.set(e,new Float32Array(r)),i.get(e)}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}_calculateNearFarZIfNeeded(t,e,i){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),n=t-r*this._helper._pixelPerMeter/Math.cos(e),a=r<0?n:t,s=Math.PI/2+this.pitchInRadians,o=Nt(this.fov)*(Math.abs(Math.cos(Nt(this.roll)))*this.height+Math.abs(Math.sin(Nt(this.roll)))*this.width)/this.height*(.5+i.y/this.height),l=Math.sin(o)*a/Math.sin(vt(Math.PI-s-o,.01,Math.PI-.01)),c=Fp(this),h=Math.atan(c/this._helper.cameraToCenterDistance),u=Nt(.75),d=h>u?2*h*(.5+i.y/(2*c)):u,p=Math.sin(d)*a/Math.sin(vt(Math.PI-s-d,.01,Math.PI-.01)),f=Math.min(l,p);this._helper._farZ=1.01*(Math.cos(Math.PI/2-e)*f+a),this._helper._nearZ=this._helper._height/50}_calcMatrices(){if(!this._helper._height)return;const t=this.centerOffset,e=Rp(this.worldSize,this.center),i=e.x,r=e.y;this._helper._pixelPerMeter=Kd(1,this.center.lat)*this.worldSize;const n=Nt(Math.min(this.pitch,kp)),a=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(n));let s;this._calculateNearFarZIfNeeded(a,n,t),s=new Float64Array(16),S(s,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),x(this._invProjMatrix,s),s[8]=2*-t.x/this._helper._width,s[9]=2*t.y/this._helper._height,this._projectionMatrix=g(s),w(s,s,[1,-1,1]),b(s,s,[0,0,-this._helper.cameraToCenterDistance]),M(s,s,-this.rollInRadians),T(s,s,this.pitchInRadians),M(s,s,-this.bearingInRadians),b(s,s,[-i,-r,0]),this._mercatorMatrix=w([],s,[this.worldSize,this.worldSize,this.worldSize]),w(s,s,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=v(new Float64Array(16),this.clipSpaceToPixelsMatrix,s),b(s,s,[0,0,-this.elevation]),this._viewProjMatrix=s,this._invViewProjMatrix=x([],s);const o=[0,0,-1,1];G(o,o,this._invViewProjMatrix),this._cameraPosition=[o[0]/o[3],o[1]/o[3],o[2]/o[3]],this._fogMatrix=new Float64Array(16),S(this._fogMatrix,this.fovInRadians,this.width/this.height,a,this._helper._farZ),this._fogMatrix[8]=2*-t.x/this.width,this._fogMatrix[9]=2*t.y/this.height,w(this._fogMatrix,this._fogMatrix,[1,-1,1]),b(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),M(this._fogMatrix,this._fogMatrix,-this.rollInRadians),T(this._fogMatrix,this._fogMatrix,this.pitchInRadians),M(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),b(this._fogMatrix,this._fogMatrix,[-i,-r,0]),w(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),b(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=v(new Float64Array(16),this.clipSpaceToPixelsMatrix,s);const l=this._helper._width%2/2,c=this._helper._height%2/2,h=Math.cos(this.bearingInRadians),u=Math.sin(-this.bearingInRadians),d=i-Math.round(i)+h*l+u*c,p=r-Math.round(r)+h*c+u*l,f=new Float64Array(s);if(b(f,f,[d>.5?d-1:d,p>.5?p-1:p,0]),this._alignedProjMatrix=f,s=x(new Float64Array(16),this._pixelMatrix),!s)throw new Error("failed to invert matrix");this._pixelMatrixInverse=s,this._clearMatrixCaches()}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear()}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const t=this.screenPointToMercatorCoordinate(new a(0,0)),e=[t.x*this.worldSize,t.y*this.worldSize,0,1];return G(e,e,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const t=Kd(1,this.center.lat)*this.worldSize;return Op(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/t).toLngLat()}lngLatToCameraDepth(t,e){const i=ep.fromLngLat(t),r=[i.x*this.worldSize,i.y*this.worldSize,e,1];return G(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(t){const{overscaledTileID:e,aligned:i,applyTerrainMatrix:r}=t,n=this._helper.getMercatorTileCoordinates(e),a=e?this.calculatePosMatrix(e,i,!0):null;let s;return s=e&&e.terrainRttPosMatrix32f&&r?e.terrainRttPosMatrix32f:a||at(),{mainMatrix:s,tileMercatorCoords:n,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:s}}isLocationOccluded(t){return!1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(t,e,i){return 1}transformLightDirection(t){return A(t)}getRayDirectionFromPixel(t){throw new Error("Not implemented.")}projectTileCoordinates(t,e,i,r){const n=this.calculatePosMatrix(i);let s;r?(s=[t,e,r(t,e),1],G(s,s,n)):(s=[t,e,0,1],xf(s,s,n));const o=s[3];return{point:new a(s[0]/o,s[1]/o),signedDistanceFromCamera:o,isOccluded:!1}}populateCache(t){for(const e of t)this.calculatePosMatrix(e)}getMatrixForModel(t,e){const i=ep.fromLngLat(t,e),r=i.meterInMercatorCoordinateUnits(),n=nt();return b(n,n,[i.x,i.y,i.z]),M(n,n,Math.PI),T(n,n,Math.PI/2),w(n,n,[-r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=new lp(0,0,0,0,0),i=this.getProjectionData({overscaledTileID:e,applyGlobeMatrix:t}),r=Bp(e,this.worldSize);v(r,this._viewProjMatrix,r),i.tileMercatorCoords=[0,0,1,1];const n=[Q,Q,this.worldSize/this._helper.pixelsPerMeter],a=rt();return w(a,r,n),i.fallbackMatrix=a,i.mainMatrix=a,i}getFastPathSimpleProjectionMatrix(t){return this.calculatePosMatrix(t)}}function gm(){kt("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}function ym(t){if(t.useSlerp)if(t.k<1){const e=$t(t.startEulerAngles.roll,t.startEulerAngles.pitch,t.startEulerAngles.bearing),i=$t(t.endEulerAngles.roll,t.endEulerAngles.pitch,t.endEulerAngles.bearing),r=new Float64Array(4);!function(t,e,i,r){var n,a,s,o,l,c=e[0],h=e[1],u=e[2],p=e[3],f=i[0],m=i[1],_=i[2],g=i[3];(a=c*f+h*m+u*_+p*g)<0&&(a=-a,f=-f,m=-m,_=-_,g=-g),1-a>d?(n=Math.acos(a),s=Math.sin(n),o=Math.sin((1-r)*n)/s,l=Math.sin(r*n)/s):(o=1-r,l=r),t[0]=o*c+l*f,t[1]=o*h+l*m,t[2]=o*u+l*_,t[3]=o*p+l*g}(r,e,i,t.k);const n=function(t){const e=new Float64Array(9);var i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g,y,x;u=(n=(r=t)[0])*(l=n+n),d=(a=r[1])*l,f=(s=r[2])*l,m=s*(c=a+a),g=(o=r[3])*l,y=o*c,x=o*(h=s+s),(i=e)[0]=1-(p=a*c)-(_=s*h),i[3]=d-x,i[6]=f+y,i[1]=d+x,i[4]=1-u-_,i[7]=m-g,i[2]=f-y,i[5]=m+g,i[8]=1-u-p;const v=Ut(-Math.asin(vt(e[2],-1,1)));let b,w;return Math.hypot(e[5],e[8])<.001?(b=0,w=-Ut(Math.atan2(e[3],e[4]))):(b=Ut(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),w=Ut(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:b,pitch:v+90,bearing:w}}(r);t.tr.setRoll(n.roll),t.tr.setPitch(n.pitch),t.tr.setBearing(n.bearing)}else t.tr.setRoll(t.endEulerAngles.roll),t.tr.setPitch(t.endEulerAngles.pitch),t.tr.setBearing(t.endEulerAngles.bearing);else t.tr.setRoll(wr.number(t.startEulerAngles.roll,t.endEulerAngles.roll,t.k)),t.tr.setPitch(wr.number(t.startEulerAngles.pitch,t.endEulerAngles.pitch,t.k)),t.tr.setBearing(wr.number(t.startEulerAngles.bearing,t.endEulerAngles.bearing,t.k))}function xm(t,e,i,r,n){const s=n.padding,o=Rp(n.worldSize,i.getNorthWest()),l=Rp(n.worldSize,i.getNorthEast()),c=Rp(n.worldSize,i.getSouthEast()),h=Rp(n.worldSize,i.getSouthWest()),u=Nt(-r),d=o.rotate(u),p=l.rotate(u),f=c.rotate(u),m=h.rotate(u),_=new a(Math.max(d.x,p.x,m.x,f.x),Math.max(d.y,p.y,m.y,f.y)),g=new a(Math.min(d.x,p.x,m.x,f.x),Math.min(d.y,p.y,m.y,f.y)),y=_.sub(g),x=(n.width-(s.left+s.right+e.left+e.right))/y.x,v=(n.height-(s.top+s.bottom+e.top+e.bottom))/y.y;if(v<0||x<0)return void gm();const b=Math.min(It(n.scale*Math.min(x,v)),t.maxZoom),w=a.convert(t.offset),T=new a((e.left-e.right)/2,(e.top-e.bottom)/2).rotate(Nt(r)),P=w.add(T).mult(n.scale/St(b));return{center:Lp(n.worldSize,o.add(c).div(2).sub(P)),zoom:b,bearing:r}}class vm{get useGlobeControls(){return!1}handlePanInertia(t,e){const i=t.mag(),r=Math.abs(Fp(e));return{easingOffset:t.mult(Math.min(.75*r/i,1)),easingCenter:e.center}}handleMapControlsRollPitchBearingZoom(t,e){t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta),t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta)}handleMapControlsPan(t,e,i){t.around.distSqr(e.centerPoint)<.01||e.setLocationAtPoint(i,t.around)}cameraForBoxAndBearing(t,e,i,r,n){return xm(t,e,i,r,n)}handleJumpToCenterZoom(t,e){t.zoom!==(void 0!==e.zoom?+e.zoom:t.zoom)&&t.setZoom(+e.zoom),void 0!==e.center&&t.setCenter($d.convert(e.center))}handleEaseTo(t,e){const i=t.zoom,r=t.padding,n={roll:t.roll,pitch:t.pitch,bearing:t.bearing},a={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},s=void 0!==e.zoom,o=!t.isPaddingEqual(e.padding);let l=!1;const c=s?+e.zoom:t.zoom;let h=t.centerPoint.add(e.offsetAsPoint);const u=t.screenPointToLocation(h),{center:d,zoom:p}=t.constrain($d.convert(e.center||u),null!=c?c:i);hm(t,d);const f=Rp(t.worldSize,u),m=Rp(t.worldSize,d).sub(f),_=St(p-i);return l=p!==i,{easeFunc:s=>{if(l&&t.setZoom(wr.number(i,p,s)),Zt(n,a)||ym({startEulerAngles:n,endEulerAngles:a,tr:t,k:s,useSlerp:n.roll!=a.roll}),o&&(t.interpolatePadding(r,e.padding,s),h=t.centerPoint.add(e.offsetAsPoint)),e.around)t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=St(t.zoom-i),r=p>i?Math.min(2,_):Math.max(.5,_),n=Math.pow(r,1-s),a=Lp(t.worldSize,f.add(m.mult(s*n)).mult(e));t.setLocationAtPoint(t.renderWorldCopies?a.wrap():a,h)}},isZooming:l,elevationCenter:d}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.zoom,n=t.constrain($d.convert(e.center||e.locationAtOffset),i?+e.zoom:r),a=n.center,s=n.zoom;hm(t,a);const o=Rp(t.worldSize,e.locationAtOffset),l=Rp(t.worldSize,a).sub(o),c=l.mag(),h=St(s-r);let u;if(void 0!==e.minZoom){const i=Math.min(+e.minZoom,r,s);u=St(t.constrain(a,i).zoom-r)}return{easeFunc:(e,i,n,c)=>{t.setZoom(1===e?s:r+It(i));const h=1===e?a:Lp(t.worldSize,o.add(l.mult(n)).mult(i));t.setLocationAtPoint(t.renderWorldCopies?h.wrap():h,c)},scaleOfZoom:h,targetCenter:a,scaleOfMinZoom:u,pixelPathLength:c}}}class bm{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i}}bm.Replace=[1,0],bm.disabled=new bm(bm.Replace,Ri.transparent,[!1,!1,!1,!1]),bm.unblended=new bm(bm.Replace,Ri.transparent,[!0,!0,!0,!0]),bm.alphaBlended=new bm([1,771],Ri.transparent,[!0,!0,!0,!0]);const wm=2305;class Tm{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i}}Tm.disabled=new Tm(!1,1029,wm),Tm.backCCW=new Tm(!0,1029,wm),Tm.frontCCW=new Tm(!0,1028,wm);class Pm{constructor(t,e,i){this.func=t,this.mask=e,this.range=i}}Pm.ReadOnly=!1,Pm.ReadWrite=!0,Pm.disabled=new Pm(519,Pm.ReadOnly,[0,1]);const Mm=7680;class Sm{constructor(t,e,i,r,n,a){this.test=t,this.ref=e,this.mask=i,this.fail=r,this.depthFail=n,this.pass=a}}Sm.disabled=new Sm({func:519,mask:0},0,0,Mm,Mm,Mm);const Im=new WeakMap;function Cm(t){var e;if(Im.has(t))return Im.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return Im.set(t,i),i}}class Am{get awaitingQuery(){return!!this._readbackQueue}constructor(t){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=t;const e=t.context,i=e.gl;this._texFormat=i.RGBA,this._texType=i.UNSIGNED_BYTE;const r=new Zo;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const n=new sl;n.emplaceBack(0,1,2),this._fullscreenTriangle=new nm(e.createVertexBuffer(r,am.members),e.createIndexBuffer(n),ul.simpleSegment(0,0,r.length,n.length)),this._resultBuffer=new Uint8Array(4),e.activeTexture.set(i.TEXTURE1);const a=i.createTexture();i.bindTexture(i.TEXTURE_2D,a),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST),i.texImage2D(i.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=e.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(a),Cm(i)&&(this._pbo=i.createBuffer(),i.bindBuffer(i.PIXEL_PACK_BUFFER,this._pbo),i.bufferData(i.PIXEL_PACK_BUFFER,4,i.STREAM_READ),i.bindBuffer(i.PIXEL_PACK_BUFFER,null))}destroy(){const t=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),t.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null}updateErrorLoop(t,e){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(t,e),this._updateCount++,this._measuredError}_bindFramebuffer(){const t=this._cachedRenderContext.context,e=t.gl;t.activeTexture.set(e.TEXTURE1),e.bindTexture(e.TEXTURE_2D,this._fbo.colorAttachment.get()),t.bindFramebuffer.set(this._fbo.framebuffer)}_renderErrorTexture(t,e){const i=this._cachedRenderContext.context,r=i.gl;if(this._bindFramebuffer(),i.viewport.set([0,0,this._texWidth,this._texHeight]),i.clear({color:Ri.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(i,r.TRIANGLES,Pm.disabled,Sm.disabled,bm.unblended,Tm.disabled,((t,e)=>({u_input:t,u_output_expected:e}))(t,e),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&Cm(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const t=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:t}}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null}}_tryReadback(){const t=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&Cm(t)){const e=t.clientWaitSync(this._readbackQueue.sync,0,0);if(e===t.WAIT_FAILED)return kt("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(e===t.TIMEOUT_EXPIRED)return;t.bindBuffer(t.PIXEL_PACK_BUFFER,this._pbo),t.getBufferSubData(t.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),t.bindBuffer(t.PIXEL_PACK_BUFFER,null)}else this._bindFramebuffer(),t.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=Am._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount}static _parseRGBA8float(t){let e=0;return e+=t[0]/256,e+=t[1]/65536,e+=t[2]/16777216,t[3]<127&&(e=-e),e/128}}function Em(t,e){const i=void 0!==t.granularity?Math.max(t.granularity,1):1,r=i+(t.generateBorders?2:0),n=i+(t.extendToNorthPole||t.generateBorders?1:0)+(t.extendToSouthPole||t.generateBorders?1:0),a=r+1,s=n+1,o=t.generateBorders?-1:0,l=t.generateBorders||t.extendToNorthPole?-1:0,c=i+(t.generateBorders?1:0),h=i+(t.generateBorders||t.extendToSouthPole?1:0),u=a*s,d=r*n*6,p=a*s>65536;if(p&&"16bit"===e)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const f=p||"32bit"===e,m=new Int16Array(2*u);let _=0;for(let e=l;e<=h;e++)for(let r=o;r<=c;r++){let n=r/i*Q;-1===r&&(n=-64),r===i+1&&(n=8256);let a=e/i*Q;-1===e&&(a=t.extendToNorthPole?Th:-64),e===i+1&&(a=t.extendToSouthPole?Ph:8256),m[_++]=n,m[_++]=a}const g=f?new Uint32Array(d):new Uint16Array(d);let y=0;for(let t=0;t<n;t++)for(let e=0;e<r;e++){const i=e+1+t*a,r=e+(t+1)*a,n=e+1+(t+1)*a;g[y++]=e+t*a,g[y++]=r,g[y++]=i,g[y++]=i,g[y++]=r,g[y++]=n}return{vertices:m.buffer.slice(0),indices:g.buffer.slice(0),uses32bitIndices:f}}const zm=new wh({fill:new bh(128,2),line:new bh(512,0),tile:new bh(128,32),stencil:new bh(128,1),circle:3});class Dm{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3}get name(){return"vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return!0}get shaderVariantName(){return"globe"}get shaderDefine(){return"#define GLOBE"}get shaderPreludeCode(){return im.projectionGlobe}get vertexShaderPreludeCode(){return im.projectionMercator.vertexSource}get subdivisionGranularity(){return zm}get useGlobeControls(){return!0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy()}updateGPUdependent(t){this._errorMeasurement||(this._errorMeasurement=new Am(t));const e=Yd(this._errorQueryLatitudeDegrees),i=2*Math.atan(Math.exp(Math.PI-e*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(e,i),n=ie();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=n);const a=Math.min(Math.max((n-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=mt(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,gt(a))}_getMeshKey(t){return`${t.granularity.toString(36)}_${t.generateBorders?"b":""}${t.extendToNorthPole?"n":""}${t.extendToSouthPole?"s":""}`}getMeshFromTileID(t,e,i,r,n){const a=("stencil"===n?zm.stencil:zm.tile).getGranularityForZoomLevel(e.z);return this._getMesh(t,{granularity:a,generateBorders:i,extendToNorthPole:0===e.y&&r,extendToSouthPole:e.y===(1<<e.z)-1&&r})}_getMesh(t,e){const i=this._getMeshKey(e);if(i in this._tileMeshCache)return this._tileMeshCache[i];const r=function(t,e){const i=Em(e,"16bit"),r=Zo.deserialize({arrayBuffer:i.vertices,length:i.vertices.byteLength/2/2}),n=sl.deserialize({arrayBuffer:i.indices,length:i.indices.byteLength/2/3});return new nm(t.createVertexBuffer(r,am.members),t.createIndexBuffer(n),ul.simpleSegment(0,0,r.length,n.length))}(t,e);return this._tileMeshCache[i]=r,r}recalculate(t){}hasTransition(){const t=ie();let e=!1;return e=e||(t-this._errorMeasurementLastChangeTime)/1e3<.7,e=e||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,e}setErrorQueryLatitudeDegrees(t){this._errorQueryLatitudeDegrees=t}}const km=new Hs({type:new Zs(Me.projection.type)});class Rm extends Pe{constructor(t){super(),this._transitionable=new Bs(km,void 0),this.setProjection(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new ks(0)),this._mercatorProjection=new lm,this._verticalPerspectiveProjection=new Dm}get transitionState(){const t=this.properties.get("type");if("string"==typeof t&&"mercator"===t)return 0;if("string"==typeof t&&"vertical-perspective"===t)return 1;if(t instanceof qi){if("vertical-perspective"===t.from&&"mercator"===t.to)return 1-t.transition;if("mercator"===t.from&&"vertical-perspective"===t.to)return t.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return"globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy()}updateGPUdependent(t){this._mercatorProjection.updateGPUdependent(t),this._verticalPerspectiveProjection.updateGPUdependent(t)}getMeshFromTileID(t,e,i,r,n){return this.currentProjection.getMeshFromTileID(t,e,i,r,n)}setProjection(t){this._transitionable.setValue("type",(null==t?void 0:t.type)||"mercator")}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}setErrorQueryLatitudeDegrees(t){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(t),this._mercatorProjection.setErrorQueryLatitudeDegrees(t)}}function Lm(t){const e=Om(t.worldSize,t.center.lat);return 2*Math.PI*e}function Fm(t,e,i,r,n){const a=1/(1<<n),s=e/Q*a+r*a,o=pt((t/Q*a+i*a)*Math.PI*2+Math.PI,2*Math.PI),l=2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI,c=Math.cos(l),h=new Float64Array(3);return h[0]=Math.sin(o)*c,h[1]=Math.sin(l),h[2]=Math.cos(o)*c,h}function Bm(t){return function(t,e){const i=Math.cos(e),r=new Float64Array(3);return r[0]=Math.sin(t)*i,r[1]=Math.sin(e),r[2]=Math.cos(t)*i,r}(t.lng*Math.PI/180,t.lat*Math.PI/180)}function Om(t,e){return t/(2*Math.PI)/Math.cos(e*Math.PI/180)}function jm(t){const e=Math.asin(t[1])/Math.PI*180,i=Math.sqrt(t[0]*t[0]+t[2]*t[2]);if(i>1e-6){const r=t[0]/i,n=Math.acos(t[2]/i),a=(r>0?n:-n)/Math.PI*180;return new $d(bt(a,-180,180),e)}return new $d(0,e)}function Vm(t){return Math.cos(t*Math.PI/180)}function Nm(t,e){const i=Vm(t);return It(Vm(e)/i)}function Um(t,e){const i=t.rotate(e.bearingInRadians),r=e.zoom+Nm(e.center.lat,0),n=mt(1/Vm(e.center.lat),1/Vm(Math.min(Math.abs(e.center.lat),60)),ft(r,7,3,0,1)),a=360/Lm({worldSize:e.worldSize,center:{lat:e.center.lat}});return new $d(e.center.lng-i.x*a*n,vt(e.center.lat+i.y*a,-85.051129,qt))}function Zm(t){const e=.5*t,i=Math.sin(e),r=Math.cos(e);return Math.log(i+r)-Math.log(r-i)}function Gm(t,e,i,r){const n=t.lat+i*r;if(Math.abs(i)>1){const a=(Math.sign(t.lat+i)!==Math.sign(t.lat)?-Math.abs(t.lat):Math.abs(t.lat))*Math.PI/180,s=Math.abs(t.lat+i)*Math.PI/180,o=Zm(a+r*(s-a)),l=Zm(a),c=Zm(s);return new $d(t.lng+e*((o-l)/(c-l)),n)}return new $d(t.lng+e*r,n)}class $m{constructor(t){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=t}swapBuffers(){if(!this._hadAnyChanges)return;const t=this._cachePrevious;this._cachePrevious=this._cache,this._cache=t,this._cache.clear(),this._hadAnyChanges=!1}getTileBoundingVolume(t,e,i,r){const n=`${t.z}_${t.x}_${t.y}_${(null==r?void 0:r.terrain)?"t":""}`,a=this._cache.get(n);if(a)return a;const s=this._cachePrevious.get(n);if(s)return this._cache.set(n,s),s;const o=this._boundingVolumeFactory(t,e,i,r);return this._cache.set(n,o),this._hadAnyChanges=!0,o}}class qm{constructor(t,e,i,r){this.min=i,this.max=r,this.points=t,this.planes=e}static fromAabb(t,e){const i=[];for(let r=0;r<8;r++)i.push([1&~r?t[0]:e[0],1==(r>>1&1)?e[1]:t[1],1==(r>>2&1)?e[2]:t[2]]);return new qm(i,[[-1,0,0,e[0]],[1,0,0,-t[0]],[0,-1,0,e[1]],[0,1,0,-t[1]],[0,0,-1,e[2]],[0,0,1,-t[2]]],t,e)}static fromCenterSizeAngles(t,e,i){const r=q([],i[0],i[1],i[2]),n=B([],[e[0],0,0],r),a=B([],[0,e[1],0],r),s=B([],[0,0,e[2]],r),o=[...t],l=[...t];for(let e=0;e<8;e++)for(let i=0;i<3;i++){const r=t[i]+n[i]*(1&~e?-1:1)+a[i]*(1==(e>>1&1)?1:-1)+s[i]*(1==(e>>2&1)?1:-1);o[i]=Math.min(o[i],r),l[i]=Math.max(l[i],r)}const c=[];for(let e=0;e<8;e++){const i=[...t];D(i,i,k([],n,1&~e?-1:1)),D(i,i,k([],a,1==(e>>1&1)?1:-1)),D(i,i,k([],s,1==(e>>2&1)?1:-1)),c.push(i)}return new qm(c,[[...n,-L(n,c[0])],[...a,-L(a,c[0])],[...s,-L(s,c[0])],[-n[0],-n[1],-n[2],-L(n,c[7])],[-a[0],-a[1],-a[2],-L(a,c[7])],[-s[0],-s[1],-s[2],-L(s,c[7])]],o,l)}intersectsFrustum(t){let e=!0;const i=this.points.length,r=this.planes.length,n=t.planes.length,a=t.points.length;for(let r=0;r<n;r++){const n=t.planes[r];let a=0;for(let t=0;t<i;t++){const e=this.points[t];n[0]*e[0]+n[1]*e[1]+n[2]*e[2]+n[3]>=0&&a++}if(0===a)return 0;a<i&&(e=!1)}if(e)return 2;for(let e=0;e<r;e++){const i=this.planes[e];let r=0;for(let e=0;e<a;e++){const n=t.points[e];i[0]*n[0]+i[1]*n[1]+i[2]*n[2]+i[3]>=0&&r++}if(0===r)return 0}return 1}intersectsPlane(t){const e=this.points.length;let i=0;for(let r=0;r<e;r++){const e=this.points[r];t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0&&i++}return i===e?2:0===i?0:1}}function Wm(t,e,i){const r=t-e;return r<0?-r:Math.max(0,r-i)}function Hm(t,e,i,r,n){const a=t-i;let s;return s=a<0?Math.min(-a,1+a-n):a>1?Math.min(Math.max(a-n,0),1-a):0,Math.max(s,Wm(e,r,n))}class Xm{constructor(){this._boundingVolumeCache=new $m(this._computeTileBoundingVolume)}prepareNextFrame(){this._boundingVolumeCache.swapBuffers()}distanceToTile2d(t,e,i,r){const n=1<<i.z,a=1/n,s=i.x/n,o=i.y/n;let l=2;return l=Math.min(l,Hm(t,e,s,o,a)),l=Math.min(l,Hm(t,e,s+.5,-o-a,a)),l=Math.min(l,Hm(t,e,s+.5,2-o-a,a)),l}getWrap(t,e,i){const r=1<<e.z,n=1/r,a=e.x/r,s=Wm(t.x,a,n),o=Wm(t.x,a-1,n),l=Wm(t.x,a+1,n),c=Math.min(s,o,l);return c===l?1:c===o?-1:0}allowVariableZoom(t,e){return Zp(t,e)>4}allowWorldCopies(){return!1}getTileBoundingVolume(t,e,i,r){return this._boundingVolumeCache.getTileBoundingVolume(t,e,i,r)}_computeTileBoundingVolume(t,e,i,r){var n,a;let s=0,o=0;if(null==r?void 0:r.terrain){const l=new lp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);s=null!==(n=c.minElevation)&&void 0!==n?n:Math.min(0,i),o=null!==(a=c.maxElevation)&&void 0!==a?a:Math.max(0,i)}if(s/=Gd,o/=Gd,s+=1,o+=1,t.z<=0)return qm.fromAabb([-o,-o,-o],[o,o,o]);if(1===t.z)return qm.fromAabb([0===t.x?-o:0,0===t.y?0:-o,-o],[0===t.x?0:o,0===t.y?o:0,o]);{const e=[Fm(0,0,t.x,t.y,t.z),Fm(Q,0,t.x,t.y,t.z),Fm(Q,Q,t.x,t.y,t.z),Fm(0,Q,t.x,t.y,t.z)],i=[];for(const t of e)i.push(k([],t,o));if(o!==s)for(const t of e)i.push(k([],t,s));0===t.y&&i.push([0,1,0]),t.y===(1<<t.z)-1&&i.push([0,-1,0]);const r=[1,1,1],n=[-1,-1,-1];for(const t of i)for(let e=0;e<3;e++)r[e]=Math.min(r[e],t[e]),n[e]=Math.max(n[e],t[e]);const a=Fm(4096,4096,t.x,t.y,t.z),l=F([],[0,1,0],a);R(l,l);const c=F([],a,l);R(c,c);const h=F([],e[2],e[1]);R(h,h);const u=F([],e[0],e[3]);R(u,u),i.push(k([],a,o)),t.y>=(1<<t.z)/2&&i.push(k([],Fm(4096,0,t.x,t.y,t.z),o)),t.y<(1<<t.z)/2&&i.push(k([],Fm(4096,Q,t.x,t.y,t.z),o));const d=Ym(a,i),p=Ym(c,i),f=[-a[0],-a[1],-a[2],d.max],m=[a[0],a[1],a[2],-d.min],_=[-c[0],-c[1],-c[2],p.max],g=[c[0],c[1],c[2],-p.min],y=[...h,0],x=[...u,0],v=[];return 0===t.y?v.push(lt(x,y,f),lt(x,y,m)):v.push(lt(_,y,f),lt(_,y,m),lt(_,x,f),lt(_,x,m)),t.y===(1<<t.z)-1?v.push(lt(x,y,f),lt(x,y,m)):v.push(lt(g,y,f),lt(g,y,m),lt(g,x,f),lt(g,x,m)),new qm(v,[f,m,_,g,y,x],r,n)}}}function Ym(t,e){let i=1/0,r=-1/0;for(const n of e){const e=L(t,n);i=Math.min(i,e),r=Math.max(r,e)}return{min:i,max:r}}class Km{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e){this._helper.resize(t,e)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}setConstrain(t){this._helper.setConstrain(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get constrain(){return this._helper.constrain}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t){}constructor(t){this._cachedClippingPlane=et(),this._projectionMatrix=nt(),this._globeViewProjMatrix32f=at(),this._globeViewProjMatrixNoCorrection=nt(),this._globeViewProjMatrixNoCorrectionInverted=nt(),this._globeProjMatrixInverted=nt(),this._cameraPosition=it(),this._globeLatitudeErrorCorrectionRadians=0,this.defaultConstrain=(t,e)=>{const i=vt(t.lat,-85.051129,qt),r=vt(+e,this.minZoom+Nm(0,i),this.maxZoom);return{center:new $d(t.lng,i),zoom:r}},this._helper=new dm({calcMatrices:()=>{this._calcMatrices()},constrain:(t,e)=>this.defaultConstrain(t,e)},t),this._coveringTilesDetailsProvider=new Xm}clone(){const t=new Km;return t.apply(this),t}apply(t,e){this._globeLatitudeErrorCorrectionRadians=e||0,this._helper.apply(t)}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const t=it();return t[0]=this._cameraPosition[0],t[1]=this._cameraPosition[1],t[2]=this._cameraPosition[2],t}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(t){const{overscaledTileID:e,applyGlobeMatrix:i}=t,r=this._helper.getMercatorTileCoordinates(e);return{mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:r,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(t){const e=this.pitchInRadians,i=this.cameraToCenterDistance/t,r=Math.sin(e)*i,n=Math.cos(e)*i+1,a=1/Math.sqrt(r*r+n*n)*1;let s=-r,o=n;const l=Math.sqrt(s*s+o*o);s/=l,o/=l;const c=[0,s,o];V(c,c,[0,0,0],-this.bearingInRadians),O(c,c,[0,0,0],-1*this.center.lat*Math.PI/180),j(c,c,[0,0,0],this.center.lng*Math.PI/180);const h=1/E(c);return k(c,c,h),[...c,-a*h]}isLocationOccluded(t){return!this.isSurfacePointVisible(Bm(t))}transformLightDirection(t){const e=this._helper._center.lng*Math.PI/180,i=this._helper._center.lat*Math.PI/180,r=Math.cos(i),n=[Math.sin(e)*r,Math.sin(i),Math.cos(e)*r],a=[n[2],0,-n[0]],s=[0,0,0];F(s,a,n),R(a,a),R(s,s);const o=[0,0,0];return R(o,[a[0]*t[0]+s[0]*t[1]+n[0]*t[2],a[1]*t[0]+s[1]*t[1]+n[1]*t[2],a[2]*t[0]+s[2]*t[1]+n[2]*t[2]]),o}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(t,e,i){const r=function(t,e,i){const r=1/(1<<i.z);return new ep(t/Q*r+i.x*r,e/Q*r+i.y*r)}(t,e,i.canonical),n=(a=r.y,[pt(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-a*Math.PI*2))-.5*Math.PI]);var a;return this.getCircleRadiusCorrection()/Math.cos(n[1])}projectTileCoordinates(t,e,i,r){const n=i.canonical,s=Fm(t,e,n.x,n.y,n.z),o=1+(r?r(t,e):0)/Gd,l=[s[0]*o,s[1]*o,s[2]*o,1];G(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*s[0]+c[1]*s[1]+c[2]*s[2]+c[3]<0;return{point:new a(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const t=Om(this.worldSize,this.center.lat),e=rt(),i=rt();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*t),S(e,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;e[8]=2*-r.x/this._helper._width,e[9]=2*r.y/this._helper._height,this._projectionMatrix=g(e),this._globeProjMatrixInverted=rt(),x(this._globeProjMatrixInverted,e),b(e,e,[0,0,-this.cameraToCenterDistance]),M(e,e,this.rollInRadians),T(e,e,-this.pitchInRadians),M(e,e,this.bearingInRadians),b(e,e,[0,0,-t]);const n=it();n[0]=t,n[1]=t,n[2]=t,T(i,e,this.center.lat*Math.PI/180),P(i,i,-this.center.lng*Math.PI/180),w(i,i,n),this._globeViewProjMatrixNoCorrection=i,T(e,e,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),P(e,e,-this.center.lng*Math.PI/180),w(e,e,n),this._globeViewProjMatrix32f=new Float32Array(e),this._globeViewProjMatrixNoCorrectionInverted=rt(),x(this._globeViewProjMatrixNoCorrectionInverted,i);const a=it();this._cameraPosition=it(),this._cameraPosition[2]=this.cameraToCenterDistance/t,V(this._cameraPosition,this._cameraPosition,a,-this.rollInRadians),O(this._cameraPosition,this._cameraPosition,a,this.pitchInRadians),V(this._cameraPosition,this._cameraPosition,a,-this.bearingInRadians),D(this._cameraPosition,this._cameraPosition,[0,0,1]),O(this._cameraPosition,this._cameraPosition,a,-this.center.lat*Math.PI/180),j(this._cameraPosition,this._cameraPosition,a,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(t);const s=g(this._globeViewProjMatrixNoCorrectionInverted);w(s,s,[1,1,-1]),this._cachedFrustum=mm.fromInvProjectionMatrix(s,1,0,this._cachedClippingPlane,!0)}calculateFogMatrix(t){kt("calculateFogMatrix is not supported on globe projection.");const e=rt();return y(e),e}getVisibleUnwrappedCoordinates(t){return[new op(0,t)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){t&&kt("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0)}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){if(!this._globeViewProjMatrixNoCorrection)return 1;const i=Bm(t);k(i,i,1+e/Gd);const r=et();return G(r,[i[0],i[1],i[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(t){}getBounds(){const t=.5*this.width,e=.5*this.height,i=[new a(0,0),new a(t,0),new a(this.width,0),new a(this.width,e),new a(this.width,this.height),new a(t,this.height),new a(0,this.height),new a(0,e)],r=[];for(const t of i)r.push(this.unprojectScreenPoint(t));let n=0,s=0,o=0,l=0;const c=this.center;for(const t of r){const e=ut(c.lng,t.lng),i=ut(c.lat,t.lat);e<s&&(s=e),e>n&&(n=e),i<l&&(l=i),i>o&&(o=i)}const h=[c.lng+s,c.lat+l,c.lng+n,c.lat+o];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new qd(h)}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){const i=Bm(this.unprojectScreenPoint(e)),r=Bm(t),n=it();var a;(a=n)[0]=0,a[1]=0,a[2]=0;const s=it();j(s,i,n,-this.center.lng*Math.PI/180),O(s,s,n,this.center.lat*Math.PI/180);const o=r[0]*r[0]+r[2]*r[2],l=s[0]*s[0];if(o<l)return;const c=Math.sqrt(o-l),h=-c,u=ht(r[0],r[2],s[0],c),d=ht(r[0],r[2],s[0],h),p=it();j(p,r,n,-u);const f=ht(p[1],p[2],s[1],s[2]),m=it();j(m,r,n,-d);const _=ht(m[1],m[2],s[1],s[2]),g=.5*Math.PI,y=f>=-g&&f<=g,x=_>=-g&&_<=g;let v,b;if(y&&x){const t=this.center.lng*Math.PI/180,e=this.center.lat*Math.PI/180;dt(u,t)+dt(f,e)<dt(d,t)+dt(_,e)?(v=u,b=f):(v=d,b=_)}else if(y)v=u,b=f;else{if(!x)return;v=d,b=_}const w=v/Math.PI*180,T=b/Math.PI*180,P=this.center.lat;this.setCenter(new $d(w,vt(T,-90,90))),this.setZoom(this.zoom+Nm(P,this.center.lat))}locationToScreenPoint(t,e){const i=Bm(t);return e&&k(i,i,1+e.getElevationForLngLatZoom(t,this._helper._tileZoom)/Gd),this._projectSurfacePointToScreen(i)}_projectSurfacePointToScreen(t){const e=et();return G(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],new a((.5*e[0]+.5)*this.width,(.5*-e[1]+.5)*this.height)}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(i)return i}return ep.fromLngLat(this.unprojectScreenPoint(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(t,e){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(t);return!!this.rayPlanetIntersection(i,r)}getRayDirectionFromPixel(t){const e=et();e[0]=t.x/this.width*2-1,e[1]=-1*(t.y/this.height*2-1),e[2]=1,e[3]=1,G(e,e,this._globeViewProjMatrixNoCorrectionInverted),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3];const i=it();i[0]=e[0]-this._cameraPosition[0],i[1]=e[1]-this._cameraPosition[1],i[2]=e[2]-this._cameraPosition[2];const r=it();return R(r,i),r}isSurfacePointVisible(t){const e=this._cachedClippingPlane;return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0}isSurfacePointOnScreen(t){if(!this.isSurfacePointVisible(t))return!1;const e=et();return G(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3],e[0]>-1&&e[0]<1&&e[1]>-1&&e[1]<1&&e[2]>-1&&e[2]<1}rayPlanetIntersection(t,e){const i=L(t,e),r=it(),n=it();k(n,e,i),U(r,t,n);const a=1-L(r,r);if(a<0)return null;const s=L(t,t)-1,o=-i+(i<0?1:-1)*Math.sqrt(a),l=s/o,c=o;return{tMin:Math.min(l,c),tMax:Math.max(l,c)}}unprojectScreenPoint(t){const e=this._cameraPosition,i=this.getRayDirectionFromPixel(t),r=this.rayPlanetIntersection(e,i);if(r){const t=it();D(t,e,[i[0]*r.tMin,i[1]*r.tMin,i[2]*r.tMin]);const n=it();return R(n,t),jm(n)}const n=this._cachedClippingPlane,a=n[0]*i[0]+n[1]*i[1]+n[2]*i[2],s=-ot(n,e)/a,o=it();if(s>0)D(o,e,[i[0]*s,i[1]*s,i[2]*s]);else{const t=it();D(t,e,[2*i[0],2*i[1],2*i[2]]);const r=ot(this._cachedClippingPlane,t);U(o,t,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r])}const l=function(t){const e=it();return e[0]=t[0]*-t[3],e[1]=t[1]*-t[3],e[2]=t[2]*-t[3],{center:e,radius:Math.sqrt(1-t[3]*t[3])}}(n),c=function(t,e,i){const r=it();U(r,i,t);const n=it();return function(t,e,i,r){t[0]=e[0]+i[0]*r,t[1]=e[1]+i[1]*r,t[2]=e[2]+i[2]*r}(n,t,r,e/Z(r)),n}(l.center,l.radius,o);return jm(c)}getMatrixForModel(t,e){const i=$d.convert(t),r=1/Gd,n=nt();return P(n,n,i.lng/180*Math.PI),T(n,n,-i.lat/180*Math.PI),b(n,n,[0,0,1+e/Gd]),T(n,n,.5*Math.PI),w(n,n,[r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=this.getProjectionData({overscaledTileID:new lp(0,0,0,0,0),applyGlobeMatrix:t});return e.tileMercatorCoords=[0,0,1,1],e}getFastPathSimpleProjectionMatrix(t){}}class Jm{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}setConstrain(t){this._helper.setConstrain(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrain(){return this._helper.constrain}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(t,e){this._globeness=t,this._globeLatitudeErrorCorrectionRadians=e,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame()}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(t){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this.defaultConstrain=(t,e)=>this.currentTransform.defaultConstrain(t,e),this._helper=new dm({calcMatrices:()=>{this._calcMatrices()},constrain:(t,e)=>this.defaultConstrain(t,e)},t),this._globeness=1,this._mercatorTransform=new _m,this._verticalPerspectiveTransform=new Km}clone(){const t=new Jm;return t._globeness=this._globeness,t._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,t.apply(this),t}apply(t){this._helper.apply(t),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians)}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(t){const e=this._mercatorTransform.getProjectionData(t),i=this._verticalPerspectiveTransform.getProjectionData(t);return{mainMatrix:this.isGlobeRendering?i.mainMatrix:e.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:t.applyGlobeMatrix?this._globeness:0,fallbackMatrix:e.fallbackMatrix}}isLocationOccluded(t){return this.currentTransform.isLocationOccluded(t)}transformLightDirection(t){return this.currentTransform.transformLightDirection(t)}getPixelScale(){return mt(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return mt(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(t,e,i){return mt(this._mercatorTransform.getPitchedTextCorrection(t,e,i),this._verticalPerspectiveTransform.getPitchedTextCorrection(t,e,i),this._globeness)}projectTileCoordinates(t,e,i,r){return this.currentTransform.projectTileCoordinates(t,e,i,r)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ)}calculateFogMatrix(t){return this.currentTransform.calculateFogMatrix(t)}getVisibleUnwrappedCoordinates(t){return this.currentTransform.getVisibleUnwrappedCoordinates(t)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(t){this._mercatorTransform.recalculateZoomAndCenter(t),this._verticalPerspectiveTransform.recalculateZoomAndCenter(t)}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){return this.currentTransform.lngLatToCameraDepth(t,e)}populateCache(t){this._mercatorTransform.populateCache(t),this._verticalPerspectiveTransform.populateCache(t)}getBounds(){return this.currentTransform.getBounds()}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(t,e),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(t,e),this.apply(this._verticalPerspectiveTransform)}locationToScreenPoint(t,e){return this.currentTransform.locationToScreenPoint(t,e)}screenPointToMercatorCoordinate(t,e){return this.currentTransform.screenPointToMercatorCoordinate(t,e)}screenPointToLocation(t,e){return this.currentTransform.screenPointToLocation(t,e)}isPointOnMapSurface(t,e){return this.currentTransform.isPointOnMapSurface(t,e)}getRayDirectionFromPixel(t){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(t)}getMatrixForModel(t,e){return this.currentTransform.getMatrixForModel(t,e)}getProjectionDataForCustomLayer(t=!0){const e=this._mercatorTransform.getProjectionDataForCustomLayer(t);if(!this.isGlobeRendering)return e;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(t);return i.fallbackMatrix=e.mainMatrix,i}getFastPathSimpleProjectionMatrix(t){return this.currentTransform.getFastPathSimpleProjectionMatrix(t)}}class Qm{get useGlobeControls(){return!0}handlePanInertia(t,e){const i=Um(t,e);return Math.abs(i.lng-e.center.lng)>180&&(i.lng=e.center.lng+179.5*Math.sign(i.lng-e.center.lng)),{easingCenter:i,easingOffset:new a(0,0)}}handleMapControlsRollPitchBearingZoom(t,e){const i=t.around,r=e.screenPointToLocation(i);t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta);const n=e.zoom;t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta);const a=e.zoom-n;if(0===a)return;const s=ut(e.center.lng,r.lng),o=s/(Math.abs(s/180)+1),l=ut(e.center.lat,r.lat),c=e.getRayDirectionFromPixel(i),h=e.cameraPosition,u=-1*L(h,c),d=it();D(d,h,[c[0]*u,c[1]*u,c[2]*u]);const p=E(d)-1,f=Math.exp(.5*-Math.max(p-.3,0)),m=Om(e.worldSize,e.center.lat)/Math.min(e.width,e.height),_=ft(m,.9,.5,1,.25),g=(1-St(-a))*Math.min(f,_),y=e.center.lat,x=e.zoom,v=new $d(e.center.lng+o*g,vt(e.center.lat+l*g,-85.051129,qt));e.setLocationAtPoint(r,i);const b=e.center,w=ft(Math.abs(s),45,85,0,1),T=ft(m,.75,.35,0,1),P=Math.pow(Math.max(w,T),.25),M=ut(b.lng,v.lng),S=ut(b.lat,v.lat);e.setCenter(new $d(b.lng+M*P,b.lat+S*P).wrap()),e.setZoom(x+Nm(y,e.center.lat))}handleMapControlsPan(t,e,i){if(!t.panDelta)return;const r=e.center.lat,n=e.zoom;e.setCenter(Um(t.panDelta,e).wrap()),e.setZoom(n+Nm(r,e.center.lat))}cameraForBoxAndBearing(t,e,i,r,n){const a=xm(t,e,i,r,n),s=e.left/n.width*2-1,o=(n.width-e.right)/n.width*2-1,l=e.top/n.height*-2+1,c=(n.height-e.bottom)/n.height*-2+1,h=ut(i.getWest(),i.getEast())<0,u=h?i.getEast():i.getWest(),d=h?i.getWest():i.getEast(),p=Math.max(i.getNorth(),i.getSouth()),f=Math.min(i.getNorth(),i.getSouth()),m=u+.5*ut(u,d),_=p+.5*ut(p,f),g=n.clone();g.setCenter(a.center),g.setBearing(a.bearing),g.setPitch(0),g.setRoll(0),g.setZoom(a.zoom);const y=g.modelViewProjectionMatrix,x=[Bm(i.getNorthWest()),Bm(i.getNorthEast()),Bm(i.getSouthWest()),Bm(i.getSouthEast()),Bm(new $d(d,_)),Bm(new $d(u,_)),Bm(new $d(m,p)),Bm(new $d(m,f))],v=Bm(a.center);let b=Number.POSITIVE_INFINITY;for(const t of x)s<0&&(b=Qm.getLesserNonNegativeNonNull(b,Qm.solveVectorScale(t,v,y,"x",s))),o>0&&(b=Qm.getLesserNonNegativeNonNull(b,Qm.solveVectorScale(t,v,y,"x",o))),l>0&&(b=Qm.getLesserNonNegativeNonNull(b,Qm.solveVectorScale(t,v,y,"y",l))),c<0&&(b=Qm.getLesserNonNegativeNonNull(b,Qm.solveVectorScale(t,v,y,"y",c)));if(Number.isFinite(b)&&0!==b)return a.zoom=g.zoom+It(b),a;gm()}handleJumpToCenterZoom(t,e){const i=t.center.lat,r=t.constrain(e.center?$d.convert(e.center):t.center,t.zoom).center;t.setCenter(r.wrap());const n=void 0!==e.zoom?+e.zoom:t.zoom+Nm(i,r.lat);t.zoom!==n&&t.setZoom(n)}handleEaseTo(t,e){const i=t.zoom,r=t.center,n=t.padding,s={roll:t.roll,pitch:t.pitch,bearing:t.bearing},o={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},l=void 0!==e.zoom,c=!t.isPaddingEqual(e.padding);let h=!1;const u=e.center?$d.convert(e.center):r,d=t.constrain(u,i).center;hm(t,d);const p=t.clone();p.setCenter(d),p.setZoom(l?+e.zoom:i+Nm(r.lat,u.lat)),p.setBearing(e.bearing);const f=new a(vt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),vt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));p.setLocationAtPoint(d,f);const m=(e.offset&&e.offsetAsPoint.mag())>0?p.center:d,_=l?+e.zoom:i+Nm(r.lat,m.lat),g=i+Nm(r.lat,0),y=_+Nm(m.lat,0),x=ut(r.lng,m.lng),v=ut(r.lat,m.lat),b=St(y-g);return h=_!==i,{easeFunc:i=>{if(Zt(s,o)||ym({startEulerAngles:s,endEulerAngles:o,tr:t,k:i,useSlerp:s.roll!=o.roll}),c&&t.interpolatePadding(n,e.padding,i),e.around)kt("Easing around a point is not supported under globe projection."),t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=y>g?Math.min(2,b):Math.max(.5,b),n=Math.pow(e,1-i),a=Gm(r,x,v,i*n);t.setCenter(a.wrap())}if(h){const e=wr.number(g,y,i)+Nm(0,t.center.lat);t.setZoom(e)}},isZooming:h,elevationCenter:m}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.center,n=t.zoom,s=t.padding,o=!t.isPaddingEqual(e.padding),l=t.constrain($d.convert(e.center||e.locationAtOffset),n).center,c=i?+e.zoom:t.zoom+Nm(t.center.lat,l.lat),h=t.clone();h.setCenter(l),h.setZoom(c),h.setBearing(e.bearing);const u=new a(vt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),vt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));h.setLocationAtPoint(l,u);const d=h.center;hm(t,d);const p=function(t,e,i){const r=L(Bm(e),Bm(i)),n=Math.acos(r),a=Lm(t);return n/(2*Math.PI)*a}(t,r,d),f=n+Nm(r.lat,0),m=c+Nm(d.lat,0),_=St(m-f);let g;if("number"==typeof e.minZoom){const i=+e.minZoom+Nm(d.lat,0),r=Math.min(i,f,m)+Nm(0,d.lat);g=St(t.constrain(d,r).zoom+Nm(d.lat,0)-f)}const y=ut(r.lng,d.lng),x=ut(r.lat,d.lat);return{easeFunc:(i,n,a,l)=>{const h=Gm(r,y,x,a);o&&t.interpolatePadding(s,e.padding,i);const u=1===i?d:h;t.setCenter(u.wrap());const p=f+It(n);t.setZoom(1===i?c:p+Nm(0,u.lat))},scaleOfZoom:_,targetCenter:d,scaleOfMinZoom:g,pixelPathLength:p}}static solveVectorScale(t,e,i,r,n){const a="x"===r?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],s=[i[3],i[7],i[11],i[15]],o=t[0]*a[0]+t[1]*a[1]+t[2]*a[2],l=t[0]*s[0]+t[1]*s[1]+t[2]*s[2],c=e[0]*a[0]+e[1]*a[1]+e[2]*a[2],h=e[0]*s[0]+e[1]*s[1]+e[2]*s[2];return c+n*l===o+n*h||s[3]*(o-c)+a[3]*(h-l)+o*h==c*l?null:(c+a[3]-n*h-n*s[3])/(c-o-n*h+n*l)}static getLesserNonNegativeNonNull(t,e){return null!==e&&e>=0&&e<t?e:t}}class t_{constructor(t){this._globe=t,this._mercatorCameraHelper=new vm,this._verticalPerspectiveCameraHelper=new Qm}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(t,e){return this.currentHelper.handlePanInertia(t,e)}handleMapControlsRollPitchBearingZoom(t,e){return this.currentHelper.handleMapControlsRollPitchBearingZoom(t,e)}handleMapControlsPan(t,e,i){this.currentHelper.handleMapControlsPan(t,e,i)}cameraForBoxAndBearing(t,e,i,r,n){return this.currentHelper.cameraForBoxAndBearing(t,e,i,r,n)}handleJumpToCenterZoom(t,e){this.currentHelper.handleJumpToCenterZoom(t,e)}handleEaseTo(t,e){return this.currentHelper.handleEaseTo(t,e)}handleFlyTo(t,e){return this.currentHelper.handleFlyTo(t,e)}}const e_=(t,e)=>us(t,e&&e.filter((t=>"source.canvas"!==t.identifier))),i_=function(){const t={},e=Me.$version;for(const i in Me.$root){const r=Me.$root[i];if(r.required){let n=null;n="version"===i?e:"array"===r.type?[]:{},null!=n&&(t[i]=n)}}return t}();class r_ extends Pe{constructor(t,e={}){var i,r;super(),this._rtlPluginLoaded=()=>{for(const t in this.tileManagers){const e=this.tileManagers[t].getSource().type;"vector"!==e&&"geojson"!==e||this.tileManagers[t].reload()}},this.map=t,this.dispatcher=new Bd(Fd(),t._getMapId()),this.dispatcher.registerMessageHandler("GG",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("GI",((t,e)=>this.getImages(t,e))),this.dispatcher.registerMessageHandler("GDA",((t,e)=>this.getDashes(t,e))),this.imageManager=new _d,this.imageManager.setEventedParent(this);const n=(null===(i=t._container)||void 0===i?void 0:i.lang)||"undefined"!=typeof document&&(null===(r=document.documentElement)||void 0===r?void 0:r.lang)||void 0;this.glyphManager=new bd(t._requestManager,e.localIdeographFontFamily,n),this.lineAtlas=new Id(256,512),this.crossTileSymbolIndex=new tm,this._spritesImagesIds={},this._layers={},this._order=[],this.tileManagers={},this.zoomHistory=new vs,this._loaded=!1,this._availableImages=[],this._globalState={},this._resetUpdates(),this.dispatcher.broadcast("SR",le()),Ip().on(Pp,this._rtlPluginLoaded),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.tileManagers[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e)}}))}setGlobalStateProperty(t,e){var i,r,n;this._checkLoaded();const a=null===e?null!==(n=null===(r=null===(i=this.stylesheet.state)||void 0===i?void 0:i[t])||void 0===r?void 0:r.default)&&void 0!==n?n:null:e;if(Et(a,this._globalState[t]))return this;this._globalState[t]=a,this._applyGlobalStateChanges([t])}getGlobalState(){return this._globalState}setGlobalState(t){this._checkLoaded();const e=[];for(const i in t)!Et(this._globalState[i],t[i].default)&&(e.push(i),this._globalState[i]=t[i].default);this._applyGlobalStateChanges(e)}_applyGlobalStateChanges(t){if(0===t.length)return;const e=new Set,i={};for(const r of t){i[r]=this._globalState[r];for(const t in this._layers){const i=this._layers[t],n=i.getLayoutAffectingGlobalStateRefs(),a=i.getPaintAffectingGlobalStateRefs();if(n.has(r)&&e.add(i.source),a.has(r))for(const{name:t,value:e}of a.get(r))this._updatePaintProperty(i,t,e)}}this.dispatcher.broadcast("UGS",i);for(const t in this.tileManagers)e.has(t)&&(this._reloadSource(t),this._changed=!0)}loadURL(t,e={},i){this.fire(new we("dataloading",{dataType:"style"})),e.validate="boolean"!=typeof e.validate||e.validate;const r=this.map._requestManager.transformRequest(t,"Style");this._loadStyleRequest=new AbortController;const n=this._loadStyleRequest;he(r,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,e,i)})).catch((t=>{this._loadStyleRequest=null,t&&!n.signal.aborted&&this.fire(new Te(t))}))}loadJSON(t,e={},i){this.fire(new we("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,te.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,e.validate=!1!==e.validate,this._load(t,e,i)})).catch((()=>{}))}loadEmpty(){this.fire(new we("dataloading",{dataType:"style"})),this._load(i_,{validate:!1})}_load(t,e,i){var r,n;let a=e.transformStyle?e.transformStyle(i,t):t;if(!e.validate||!e_(this,ss(a))){a=Object.assign({},a),this._loaded=!0,this.stylesheet=a;for(const t in a.sources)this.addSource(t,a.sources[t],{validate:!1});a.sprite?this._loadSprite(a.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(a.glyphs),this._createLayers(),this.light=new Pd(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new Sd(this.stylesheet.sky),this.map.setTerrain(null!==(n=this.stylesheet.terrain)&&void 0!==n?n:null),this.fire(new we("data",{dataType:"style"})),this.fire(new we("style.load"))}}_createLayers(){var t,e,i;const r=Ce(this.stylesheet.layers);this.setGlobalState(null!==(t=this.stylesheet.state)&&void 0!==t?t:null),this.dispatcher.broadcast("SL",r),this._order=r.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const t of r){const r=dd(t,this._globalState);if(r.setEventedParent(this,{layer:{id:t.id}}),this._layers[t.id]=r,Qs(r)&&this.tileManagers[r.source]){const n=null!==(i=null===(e=t.paint)||void 0===e?void 0:e["raster-fade-duration"])&&void 0!==i?i:r.paint.get("raster-fade-duration");this.tileManagers[r.source].setRasterFadeDuration(n)}}}_loadSprite(t,e=!1,i=void 0){let r;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,e,i,r){return n(this,void 0,void 0,(function*(){const a=pd(t),s=i>1?"@2x":"",o={},l={};for(const{id:t,url:i}of a){const n=e.transformRequest(fd(i,s,".json"),"SpriteJSON");o[t]=he(n,r);const a=e.transformRequest(fd(i,s,".png"),"SpriteImage");l[t]=ye.getImage(a,r)}return yield Promise.all([...Object.values(o),...Object.values(l)]),function(t,e){return n(this,void 0,void 0,(function*(){const i={};for(const r in t){i[r]={};const n=te.getImageCanvasContext((yield e[r]).data),a=(yield t[r]).data;for(const t in a){const{width:e,height:s,x:o,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:p,textFitWidth:f,textFitHeight:m}=a[t];i[r][t]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:p,textFitWidth:f,textFitHeight:m,spriteData:{width:e,height:s,x:o,y:l,context:n}}}}return i}))}(o,l)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const i in t){this._spritesImagesIds[i]=[];const r=this._spritesImagesIds[i]?this._spritesImagesIds[i].filter((e=>!(e in t))):[];for(const t of r)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const r in t[i]){const n="default"===i?r:`${i}:${r}`;this._spritesImagesIds[i].push(n),n in this.imageManager.images?this.imageManager.updateImage(n,t[i][r],!1):this.imageManager.addImage(n,t[i][r]),e&&(this._changedImages[n]=!0)}}})).catch((t=>{this._spriteRequest=null,r=t,this.fire(new Te(r))})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),e&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"})),i&&i(r)}))}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"}))}_validateLayer(t){const e=this.tileManagers[t.source];if(!e)return;const i=t.sourceLayer;if(!i)return;const r=e.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(i))&&this.fire(new Te(new Error(`Source layer "${i}" does not exist on source "${r.id}" as specified by style layer "${t.id}".`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const t in this.tileManagers)if(!this.tileManagers[t].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeByIds(t,e=!1){const i=this._serializedAllLayers();if(!t||0===t.length)return Object.values(e?zt(i):i);const r=[];for(const n of t)if(i[n]){const t=e?zt(i[n]):i[n];r.push(t)}return r}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize())}return t}hasTransitions(){var t,e,i;if(null===(t=this.light)||void 0===t?void 0:t.hasTransition())return!0;if(null===(e=this.sky)||void 0===e?void 0:e.hasTransition())return!0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return!0;for(const t in this.tileManagers)if(this.tileManagers[t].hasTransition())return!0;for(const t in this._layers)if(this._layers[t].hasTransition())return!0;return!1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const e=this._changed;if(e){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else{if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t)}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.sky.updateTransitions(t),this._resetUpdates()}const i={};for(const t in this.tileManagers){const e=this.tileManagers[t];i[t]=e.used,e.used=!1}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.tileManagers[i.source].used=!0)}for(const t in i){const e=this.tileManagers[t];!!i[t]!=!!e.used&&e.fire(new we("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}))}this.light.recalculate(t),this.sky.recalculate(t),this.projection.recalculate(t),this.z=t.zoom,e&&this.fire(new we("data",{dataType:"style"}))}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.tileManagers)this.tileManagers[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={}}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.tileManagers)this.tileManagers[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(t,!1),removedIds:e})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1}setState(t,e={}){var i;this._checkLoaded();const r=this.serialize();if(t=e.transformStyle?e.transformStyle(r,t):t,(null===(i=e.validate)||void 0===i||i)&&e_(this,ss(t)))return!1;(t=zt(t)).layers=Ce(t.layers);const n=function(t,e){if(!t)return[{command:"setStyle",args:[e]}];let i=[];try{if(!Ae(t.version,e.version))return[{command:"setStyle",args:[e]}];Ae(t.center,e.center)||i.push({command:"setCenter",args:[e.center]}),Ae(t.state,e.state)||i.push({command:"setGlobalState",args:[e.state]}),Ae(t.centerAltitude,e.centerAltitude)||i.push({command:"setCenterAltitude",args:[e.centerAltitude]}),Ae(t.zoom,e.zoom)||i.push({command:"setZoom",args:[e.zoom]}),Ae(t.bearing,e.bearing)||i.push({command:"setBearing",args:[e.bearing]}),Ae(t.pitch,e.pitch)||i.push({command:"setPitch",args:[e.pitch]}),Ae(t.roll,e.roll)||i.push({command:"setRoll",args:[e.roll]}),Ae(t.sprite,e.sprite)||i.push({command:"setSprite",args:[e.sprite]}),Ae(t.glyphs,e.glyphs)||i.push({command:"setGlyphs",args:[e.glyphs]}),Ae(t.transition,e.transition)||i.push({command:"setTransition",args:[e.transition]}),Ae(t.light,e.light)||i.push({command:"setLight",args:[e.light]}),Ae(t.terrain,e.terrain)||i.push({command:"setTerrain",args:[e.terrain]}),Ae(t.sky,e.sky)||i.push({command:"setSky",args:[e.sky]}),Ae(t.projection,e.projection)||i.push({command:"setProjection",args:[e.projection]});const r={},n=[];!function(t,e,i,r){let n;for(n in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,n)&&(Object.prototype.hasOwnProperty.call(e,n)||De(n,i,r));for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&(Object.prototype.hasOwnProperty.call(t,n)?Ae(t[n],e[n])||("geojson"===t[n].type&&"geojson"===e[n].type&&Re(t,e,n)?Ee(i,{command:"setGeoJSONSourceData",args:[n,e[n].data]}):ke(n,e,i,r)):ze(n,e,i))}(t.sources,e.sources,n,r);const a=[];t.layers&&t.layers.forEach((t=>{"source"in t&&r[t.source]?i.push({command:"removeLayer",args:[t.id]}):a.push(t)})),i=i.concat(n),function(t,e,i){e=e||[];const r=(t=t||[]).map(Fe),n=e.map(Fe),a=t.reduce(Be,{}),s=e.reduce(Be,{}),o=r.slice(),l=Object.create(null);let c,h,u,d,p;for(let t=0,e=0;t<r.length;t++)c=r[t],Object.prototype.hasOwnProperty.call(s,c)?e++:(Ee(i,{command:"removeLayer",args:[c]}),o.splice(o.indexOf(c,e),1));for(let t=0,e=0;t<n.length;t++)c=n[n.length-1-t],o[o.length-1-t]!==c&&(Object.prototype.hasOwnProperty.call(a,c)?(Ee(i,{command:"removeLayer",args:[c]}),o.splice(o.lastIndexOf(c,o.length-e),1)):e++,d=o[o.length-t],Ee(i,{command:"addLayer",args:[s[c],d]}),o.splice(o.length-t,0,c),l[c]=!0);for(let t=0;t<n.length;t++)if(c=n[t],h=a[c],u=s[c],!l[c]&&!Ae(h,u))if(Ae(h.source,u.source)&&Ae(h["source-layer"],u["source-layer"])&&Ae(h.type,u.type)){for(p in Le(h.layout,u.layout,i,c,null,"setLayoutProperty"),Le(h.paint,u.paint,i,c,null,"setPaintProperty"),Ae(h.filter,u.filter)||Ee(i,{command:"setFilter",args:[c,u.filter]}),Ae(h.minzoom,u.minzoom)&&Ae(h.maxzoom,u.maxzoom)||Ee(i,{command:"setLayerZoomRange",args:[c,u.minzoom,u.maxzoom]}),h)Object.prototype.hasOwnProperty.call(h,p)&&"layout"!==p&&"paint"!==p&&"filter"!==p&&"metadata"!==p&&"minzoom"!==p&&"maxzoom"!==p&&(0===p.indexOf("paint.")?Le(h[p],u[p],i,c,p.slice(6),"setPaintProperty"):Ae(h[p],u[p])||Ee(i,{command:"setLayerProperty",args:[c,p,u[p]]}));for(p in u)Object.prototype.hasOwnProperty.call(u,p)&&!Object.prototype.hasOwnProperty.call(h,p)&&"layout"!==p&&"paint"!==p&&"filter"!==p&&"metadata"!==p&&"minzoom"!==p&&"maxzoom"!==p&&(0===p.indexOf("paint.")?Le(h[p],u[p],i,c,p.slice(6),"setPaintProperty"):Ae(h[p],u[p])||Ee(i,{command:"setLayerProperty",args:[c,p,u[p]]}))}else Ee(i,{command:"removeLayer",args:[c]}),d=o[o.lastIndexOf(c)+1],Ee(i,{command:"addLayer",args:[u,d]})}(a,e.layers,i)}catch(t){console.warn("Unable to compute style diff:",t),i=[{command:"setStyle",args:[e]}]}return i}(r,t),a=this._getOperationsToPerform(n);if(a.unimplemented.length>0)throw new Error(`Unimplemented: ${a.unimplemented.join(", ")}.`);if(0===a.operations.length)return!1;for(const t of a.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const r of t)switch(r.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":case"setRoll":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,r.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,r.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,r.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,r.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,r.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,r.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,r.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,r.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,r.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,r.args)));break;case"setSky":e.push((()=>this.setSky.apply(this,r.args)));break;case"setProjection":this.setProjection.apply(this,r.args);break;case"setGlobalState":e.push((()=>this.setGlobalState.apply(this,r.args)));break;case"setTransition":e.push((()=>{}));break;default:i.push(r.command)}return{operations:e,unimplemented:i}}addImage(t,e){if(this.getImage(t))return this.fire(new Te(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,e),this._afterImageUpdated(t)}updateImage(t,e){this.imageManager.updateImage(t,e)}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new Te(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t)}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,e,i={}){if(this._checkLoaded(),void 0!==this.tileManagers[t])throw new Error(`Source "${t}" already exists.`);if(!e.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(e).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(e.type)>=0&&this._validate(ss.source,`sources.${t}`,e,null,i))return;this.map&&this.map._collectResourceTiming&&(e.collectResourceTiming=!0);const r=this.tileManagers[t]=new qp(t,e,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:t}))),r.onAdd(this.map),this._changed=!0}removeSource(t){if(this._checkLoaded(),void 0===this.tileManagers[t])throw new Error("There is no source with this ID");for(const e in this._layers)if(this._layers[e].source===t)return this.fire(new Te(new Error(`Source "${t}" cannot be removed while layer "${e}" is using it.`)));const e=this.tileManagers[t];delete this.tileManagers[t],delete this._updatedSources[t],e.fire(new we("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),e.setEventedParent(null),e.onRemove(this.map),this._changed=!0}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.tileManagers[t])throw new Error(`There is no source with this ID=${t}`);const i=this.tileManagers[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0}getSource(t){return this.tileManagers[t]&&this.tileManagers[t].getSource()}addLayer(t,e,i={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new Te(new Error(`Layer "${r}" already exists on this map.`)));let n;if("custom"===t.type){if(e_(this,function(t){const e=[],i=t.id;return void 0===i&&e.push({message:`layers.${i}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${i}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),e}(t)))return;n=dd(t,this._globalState)}else{if("source"in t&&"object"==typeof t.source&&(this.addSource(r,t.source),t=wt(t=zt(t),{source:r})),this._validate(ss.layer,`layers.${r}`,t,{arrayIndex:-1},i))return;n=dd(t,this._globalState),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}})}const a=e?this._order.indexOf(e):this._order.length;if(e&&-1===a)this.fire(new Te(new Error(`Cannot add layer "${r}" before non-existing layer "${e}".`)));else{if(this._order.splice(a,0,r),this._layerOrderChanged=!0,this._layers[r]=n,this._removedLayers[r]&&n.source&&"custom"!==n.type){const t=this._removedLayers[r];delete this._removedLayers[r],t.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",this.tileManagers[n.source].pause())}this._updateLayer(n),n.onAdd&&n.onAdd(this.map)}}moveLayer(t,e){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new Te(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===e)return;const i=this._order.indexOf(t);this._order.splice(i,1);const r=e?this._order.indexOf(e):this._order.length;e&&-1===r?this.fire(new Te(new Error(`Cannot move layer "${t}" before non-existing layer "${e}".`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0)}removeLayer(t){this._checkLoaded();const e=this._layers[t];if(!e)return void this.fire(new Te(new Error(`Cannot remove non-existing layer "${t}".`)));e.setEventedParent(null);const i=this._order.indexOf(t);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=e,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],e.onRemove&&e.onRemove(this.map)}getLayer(t){return this._layers[t]}getLayersOrder(){return[...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,e,i){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===e&&r.maxzoom===i||(null!=e&&(r.minzoom=e),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new Te(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)))}setFilter(t,e,i={}){this._checkLoaded();const r=this.getLayer(t);if(r){if(!Et(r.filter,e))return null==e?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(ss.filter,`layers.${r.id}.filter`,e,null,i)||(r.setFilter(zt(e)),this._updateLayer(r)))}else this.fire(new Te(new Error(`Cannot filter non-existing layer "${t}".`)))}getFilter(t){return zt(this.getLayer(t).filter)}setLayoutProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?Et(n.getLayoutProperty(e),i)||(n.setLayoutProperty(e,i,r),this._updateLayer(n)):this.fire(new Te(new Error(`Cannot style non-existing layer "${t}".`)))}getLayoutProperty(t,e){const i=this.getLayer(t);if(i)return i.getLayoutProperty(e);this.fire(new Te(new Error(`Cannot get style of non-existing layer "${t}".`)))}setPaintProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?Et(n.getPaintProperty(e),i)||this._updatePaintProperty(n,e,i,r):this.fire(new Te(new Error(`Cannot style non-existing layer "${t}".`)))}_updatePaintProperty(t,e,i,r={}){t.setPaintProperty(e,i,r)&&this._updateLayer(t),Qs(t)&&"raster-fade-duration"===e&&this.tileManagers[t.source].setRasterFadeDuration(i),this._changed=!0,this._updatedPaintProps[t.id]=!0,this._serializedLayers=null}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,e){this._checkLoaded();const i=t.source,r=t.sourceLayer,n=this.tileManagers[i];if(void 0===n)return void this.fire(new Te(new Error(`The source '${i}' does not exist in the map's style.`)));const a=n.getSource().type;"geojson"===a&&r?this.fire(new Te(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==a||r?(void 0===t.id&&this.fire(new Te(new Error("The feature id parameter must be provided."))),n.setFeatureState(r,t.id,e)):this.fire(new Te(new Error("The sourceLayer parameter must be provided for vector source types.")))}removeFeatureState(t,e){this._checkLoaded();const i=t.source,r=this.tileManagers[i];if(void 0===r)return void this.fire(new Te(new Error(`The source '${i}' does not exist in the map's style.`)));const n=r.getSource().type,a="vector"===n?t.sourceLayer:void 0;"vector"!==n||a?e&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new Te(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(a,t.id,e):this.fire(new Te(new Error("The sourceLayer parameter must be provided for vector source types.")))}getFeatureState(t){this._checkLoaded();const e=t.source,i=t.sourceLayer,r=this.tileManagers[e];if(void 0!==r)return"vector"!==r.getSource().type||i?(void 0===t.id&&this.fire(new Te(new Error("The feature id parameter must be provided."))),r.getFeatureState(i,t.id)):void this.fire(new Te(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new Te(new Error(`The source '${e}' does not exist in the map's style.`)))}getTransition(){return wt({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=Ct(this.tileManagers,(t=>t.serialize())),e=this._serializeByIds(this._order,!0),i=this.map.getTerrain()||void 0,r=this.stylesheet;return At({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:t,layers:e,terrain:i},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.tileManagers[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.tileManagers[t.source].pause()),this._serializedLayers=null,this._changed=!0}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},r=[];for(let n=this._order.length-1;n>=0;n--){const a=this._order[n];if(e(a)){i[a]=n;for(const e of t){const t=e[a];if(t)for(const e of t)r.push(e)}}}r.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const n=[];for(let a=this._order.length-1;a>=0;a--){const s=this._order[a];if(e(s))for(let t=r.length-1;t>=0;t--){const e=r[t].feature;if(i[e.layer.id]<a)break;n.push(e),r.pop()}else for(const e of t){const t=e[s];if(t)for(const e of t)n.push(e.feature)}}return n}queryRenderedFeatures(t,e,i){e&&e.filter&&this._validate(ss.filter,"queryRenderedFeatures.filter",e.filter,null,e);const r={};if(e&&e.layers){if(!(Array.isArray(e.layers)||e.layers instanceof Set))return this.fire(new Te(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const t of e.layers){const e=this._layers[t];if(!e)return this.fire(new Te(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[e.source]=!0}}const n=[];e.availableImages=this._availableImages;const a=this._serializedAllLayers(),s=e.layers instanceof Set?e.layers:Array.isArray(e.layers)?new Set(e.layers):null,o=Object.assign(Object.assign({},e),{layers:s,globalState:this._globalState});for(const s in this.tileManagers)e.layers&&!r[s]||n.push(Vd(this.tileManagers[s],this._layers,a,t,o,i,this.map.terrain?(t,e,i)=>this.map.terrain.getElevation(t,e,i):void 0));return this.placement&&n.push(function(t,e,i,r,n,a,s){const o={},l=a.queryRenderedSymbols(r),c=[];for(const t of Object.keys(l).map(Number))c.push(s[t]);c.sort(Nd);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,{filterSpec:n.filter,globalState:n.globalState},n.layers,n.availableImages,t);for(const t in r){const e=o[t]=o[t]||[],n=r[t];n.sort(((t,e)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(t.featureIndex);return r.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of n)e.push(t)}}return function(t,e,i){for(const r in t)for(const n of t[r])Ud(n,i[e[r].source]);return t}(o,t,i)}(this._layers,a,this.tileManagers,t,o,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(t,e){(null==e?void 0:e.filter)&&this._validate(ss.filter,"querySourceFeatures.filter",e.filter,null,e);const i=this.tileManagers[t];return i?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),r=[],n={};for(let t=0;t<i.length;t++){const a=i[t],s=a.tileID.canonical.key;n[s]||(n[s]=!0,a.querySourceFeatures(r,e))}return r}(i,e?Object.assign(Object.assign({},e),{globalState:this._globalState}):{globalState:this._globalState}):[]}getLight(){return this.light.getLight()}setLight(t,e={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const e in t)if(!Et(t[e],i[e])){r=!0;break}if(!r)return;const n={now:ie(),transition:wt({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,e),this.light.updateTransitions(n)}getProjection(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.projection}setProjection(t){if(this._checkLoaded(),this.projection){if(this.projection.name===t.type)return;this.projection.destroy(),delete this.projection}this.stylesheet.projection=t,this._setProjectionInternal(t.type)}getSky(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.sky}setSky(t,e={}){this._checkLoaded();const i=this.getSky();let r=!1;if(!t&&!i)return;if(t&&!i)r=!0;else if(!t&&i)r=!0;else for(const e in t)if(!Et(t[e],i[e])){r=!0;break}if(!r)return;const n={now:ie(),transition:wt({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=t,this.sky.setSky(t,e),this.sky.updateTransitions(n)}_setProjectionInternal(t){const e=function(t,e){const i={constrain:e};if(Array.isArray(t)){const e=new Rm({type:t});return{projection:e,transform:new Jm(i),cameraHelper:new t_(e)}}switch(t){case"mercator":return{projection:new lm,transform:new _m(i),cameraHelper:new vm};case"globe":{const t=new Rm({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return{projection:t,transform:new Jm(i),cameraHelper:new t_(t)}}case"vertical-perspective":return{projection:new Dm,transform:new Km(i),cameraHelper:new Qm};default:return kt(`Unknown projection name: ${t}. Falling back to mercator projection.`),{projection:new lm,transform:new _m(i),cameraHelper:new vm}}}(t,this.map.transformConstrain);this.projection=e.projection,this.map.migrateProjection(e.transform,e.cameraHelper);for(const t in this.tileManagers)this.tileManagers[t].reload()}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&e_(this,t.call(ss,wt({key:e,style:this.serialize(),value:i,styleSpec:Me},r)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),Ip().off(Pp,this._rtlPluginLoaded);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.tileManagers){const e=this.tileManagers[t];e.setEventedParent(null),e.onRemove(this.map)}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(t)}_clearSource(t){this.tileManagers[t].clearTiles()}_reloadSource(t){this.tileManagers[t].resume(),this.tileManagers[t].reload()}_updateSources(t){for(const e in this.tileManagers)this.tileManagers[e].update(t,this.map.terrain)}_generateCollisionBoxes(){for(const t in this.tileManagers)this._reloadSource(t)}_updatePlacement(t,e,i,r,n=!1){let a=!1,s=!1;const o={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!o[i.source]){const t=this.tileManagers[i.source];o[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,o[i.source],t.center.lng);a=a||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((n=n||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(ie(),t.zoom))&&(this.pauseablePlacement=new Uf(t,this.map.terrain,this._order,n,e,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,o),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(ie()),s=!0),a&&this.pauseablePlacement.placement.setStale()),s||a)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,o[e.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(ie())}_releaseSymbolFadeTiles(){for(const t in this.tileManagers)this.tileManagers[t].releaseSymbolFadeTiles()}getImages(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(e.icons);this._updateTilesForChangedImages();const i=this.tileManagers[e.source];return i&&i.setDependencies(e.tileID.key,e.type,e.icons),t}))}getGlyphs(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(e.stacks),i=this.tileManagers[e.source];return i&&i.setDependencies(e.tileID.key,e.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,e={}){this._checkLoaded(),t&&this._validate(ss.glyphs,"glyphs",t,null,e)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t))}getDashes(t,e){return n(this,void 0,void 0,(function*(){const t={};for(const[i,r]of Object.entries(e.dashes))t[i]=this.lineAtlas.getDash(r.dasharray,r.round);return t}))}addSprite(t,e,i={},r){this._checkLoaded();const n=[{id:t,url:e}],a=[...pd(this.stylesheet.sprite),...n];this._validate(ss.sprite,"sprite",a,null,i)||(this.stylesheet.sprite=a,this._loadSprite(n,!0,r))}removeSprite(t){this._checkLoaded();const e=pd(this.stylesheet.sprite);if(e.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;e.splice(e.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=e.length>0?e:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new we("data",{dataType:"style"}))}else this.fire(new Te(new Error(`Sprite "${t}" doesn't exists on this map.`)))}getSprite(){return pd(this.stylesheet.sprite)}setSprite(t,e={},i){this._checkLoaded(),t&&this._validate(ss.sprite,"sprite",t,null,e)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,i):(this._unloadSprite(),i&&i(null)))}}var n_=no([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class a_{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null}bind(t,e,i,r,n,a,s,o,l){this.context=t;let c=this.boundPaintVertexBuffers.length!==r.length;for(let t=0;!c&&t<r.length;t++)this.boundPaintVertexBuffers[t]!==r[t]&&(c=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==n||this.boundVertexOffset!==a||this.boundDynamicVertexBuffer!==s||this.boundDynamicVertexBuffer2!==o||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,r,n,a,s,o,l):(t.bindVertexArray.set(this.vao),s&&s.bind(),n&&n.dynamicDraw&&n.bind(),o&&o.bind(),l&&l.bind())}freshBind(t,e,i,r,n,a,s,o){const l=t.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffer=a,this.boundDynamicVertexBuffer2=s,this.boundDynamicVertexBuffer3=o,e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);a&&a.enableAttributes(h,t),s&&s.enableAttributes(h,t),o&&o.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,n);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,n);a&&(a.bind(),a.setVertexAttribPointers(h,t,n)),r&&r.bind(),s&&(s.bind(),s.setVertexAttribPointers(h,t,n)),o&&(o.bind(),o.setVertexAttribPointers(h,t,n)),c.currentNumAttributes=l}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null)}}const s_=(t,e,i,r,n)=>({u_texture:0,u_ele_delta:t,u_fog_matrix:e,u_fog_color:i?i.properties.get("fog-color"):Ri.white,u_fog_ground_blend:i?i.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:n?0:i?i.calculateFogBlendOpacity(r):0,u_horizon_color:i?i.properties.get("horizon-color"):Ri.white,u_horizon_fog_blend:i?i.properties.get("horizon-fog-blend"):1,u_is_globe_mode:n?1:0}),o_={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function l_(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const r=t[i].split(" ");e.push(r.pop())}return e}class c_{constructor(t,e,i,r,n,a,s,o,l=[]){const c=t.gl;this.program=c.createProgram();const h=l_(e.staticAttributes),u=i?i.getBinderAttributes():[],d=h.concat(u),p=im.prelude.staticUniforms?l_(im.prelude.staticUniforms):[],f=s.staticUniforms?l_(s.staticUniforms):[],m=e.staticUniforms?l_(e.staticUniforms):[],_=i?i.getBinderUniforms():[],g=p.concat(f).concat(m).concat(_),y=[];for(const t of g)y.indexOf(t)<0&&y.push(t);const x=i?i.defines():[];Cm(c)&&x.unshift("#version 300 es"),n&&x.push("#define OVERDRAW_INSPECTOR;"),a&&x.push("#define TERRAIN3D;"),o&&x.push(o),l&&x.push(...l);let v=x.concat(im.prelude.fragmentSource,s.fragmentSource,e.fragmentSource).join("\n"),b=x.concat(im.prelude.vertexSource,s.vertexSource,e.vertexSource).join("\n");Cm(c)||(v=function(t){return t.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(v),b=function(t){return t.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(b));const w=c.createShader(c.FRAGMENT_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(w,v),c.compileShader(w),!c.getShaderParameter(w,c.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${c.getShaderInfoLog(w)}`);c.attachShader(this.program,w);const T=c.createShader(c.VERTEX_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(T,b),c.compileShader(T),!c.getShaderParameter(T,c.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${c.getShaderInfoLog(T)}`);c.attachShader(this.program,T),this.attributes={};const P={};this.numAttributes=d.length;for(let t=0;t<this.numAttributes;t++)d[t]&&(c.bindAttribLocation(this.program,t,d[t]),this.attributes[d[t]]=t);if(c.linkProgram(this.program),!c.getProgramParameter(this.program,c.LINK_STATUS))throw new Error(`Program failed to link: ${c.getProgramInfoLog(this.program)}`);c.deleteShader(T),c.deleteShader(w);for(let t=0;t<y.length;t++){const e=y[t];if(e&&!P[e]){const t=c.getUniformLocation(this.program,e);t&&(P[e]=t)}}this.fixedUniforms=r(t,P),this.terrainUniforms=((t,e)=>({u_depth:new Cl(t,e.u_depth),u_terrain:new Cl(t,e.u_terrain),u_terrain_dim:new Al(t,e.u_terrain_dim),u_terrain_matrix:new Bl(t,e.u_terrain_matrix),u_terrain_unpack:new Dl(t,e.u_terrain_unpack),u_terrain_exaggeration:new Al(t,e.u_terrain_exaggeration)}))(t,P),this.projectionUniforms=((t,e)=>({u_projection_matrix:new Bl(t,e.u_projection_matrix),u_projection_tile_mercator_coords:new Dl(t,e.u_projection_tile_mercator_coords),u_projection_clipping_plane:new Dl(t,e.u_projection_clipping_plane),u_projection_transition:new Al(t,e.u_projection_transition),u_projection_fallback_matrix:new Bl(t,e.u_projection_fallback_matrix)}))(t,P),this.binderUniforms=i?i.getUniforms(t,P):[]}draw(t,e,i,r,n,a,s,o,l,c,h,u,d,p,f,m,_,g,y){const x=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(r),t.setColorMode(n),t.setCullFace(a),o){t.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,o.depthTexture),t.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,o.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(o[t])}if(l)for(const t in l)this.projectionUniforms[o_[t]].set(l[t]);if(s)for(const t in this.fixedUniforms)this.fixedUniforms[t].set(s[t]);m&&m.setUniforms(t,this.binderUniforms,p,{zoom:f});let v=0;switch(e){case x.LINES:v=2;break;case x.TRIANGLES:v=3;break;case x.LINE_STRIP:v=1}for(const i of d.get()){const r=i.vaos||(i.vaos={});(r[c]||(r[c]=new a_)).bind(t,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,_,g,y),x.drawElements(e,i.primitiveLength*v,x.UNSIGNED_SHORT,i.primitiveOffset*v*2)}}}function h_(t,e,i){const r=1/tt(i,1,e.transform.tileZoom),n=Math.pow(2,i.tileID.overscaledZ),a=i.tileSize*Math.pow(2,e.transform.tileZoom)/n,s=a*(i.tileID.canonical.x+i.tileID.wrap*n),o=a*i.tileID.canonical.y;return{u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[r,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[s>>16,o>>16],u_pixel_coord_lower:[65535&s,65535&o]}}const u_=(t,e,i,r)=>{const n=t.style.light,a=n.properties.get("position"),s=[a.x,a.y,a.z],o=m();var l,c,h,u;"viewport"===n.properties.get("anchor")&&(l=o,c=t.transform.bearingInRadians,h=Math.sin(c),u=Math.cos(c),l[0]=u,l[1]=h,l[2]=0,l[3]=-h,l[4]=u,l[5]=0,l[6]=0,l[7]=0,l[8]=1),function(t,e,i){var r=e[0],n=e[1],a=e[2];t[0]=r*i[0]+n*i[3]+a*i[6],t[1]=r*i[1]+n*i[4]+a*i[7],t[2]=r*i[2]+n*i[5]+a*i[8]}(s,s,o);const d=t.transform.transformLightDirection(s),p=n.properties.get("color");return{u_lightpos:s,u_lightpos_globe:d,u_lightintensity:n.properties.get("intensity"),u_lightcolor:[p.r,p.g,p.b],u_vertical_gradient:+e,u_opacity:i,u_fill_translate:r}},d_=(t,e,i,r,n,a,s)=>wt(u_(t,e,i,r),h_(a,t,s),{u_height_factor:-Math.pow(2,n.overscaledZ)/s.tileSize/8}),p_=(t,e,i,r)=>wt(h_(e,t,i),{u_fill_translate:r}),f_=t=>({u_fill_translate:t}),m_=(t,e)=>({u_world:t,u_fill_translate:e}),__=(t,e,i,r,n)=>wt(p_(t,e,i,n),{u_world:r}),g_=(t,e,i,r,n)=>{const a=t.transform;let s,o,l=0;if("map"===i.paint.get("circle-pitch-alignment")){const t=tt(e,1,a.zoom);s=!0,o=[t,t],l=t/(Q*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*n}else s=!1,o=a.pixelsToGLUnits;return{u_camera_to_center_distance:a.cameraToCenterDistance,u_scale_with_map:+("map"===i.paint.get("circle-pitch-scale")),u_pitch_with_map:+s,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:o,u_globe_extrude_scale:l,u_translate:r}},y_=t=>({u_pixel_extrude_scale:[1/t.width,1/t.height]}),x_=t=>({u_viewport_size:[t.width,t.height]}),v_=(t,e=1)=>({u_color:t,u_overlay:0,u_overlay_scale:e}),b_=(t,e,i,r)=>{const n=tt(t,1,e)/(Q*Math.pow(2,t.tileID.overscaledZ))*2*Math.PI*r;return{u_extrude_scale:tt(t,1,e),u_intensity:i,u_globe_extrude_scale:n}},w_=(t,e,i,r)=>{const n=_();I(n,0,t.width,t.height,0,0,1);const a=t.context.gl;return{u_matrix:n,u_world:[a.drawingBufferWidth,a.drawingBufferHeight],u_image:i,u_color_ramp:r,u_opacity:e.paint.get("heatmap-opacity")}},T_=(t,e,i)=>{const r=i.paint.get("hillshade-accent-color");let n;switch(i.paint.get("hillshade-method")){case"basic":n=4;break;case"combined":n=1;break;case"igor":n=2;break;case"multidirectional":n=3;break;default:n=0}const a=i.getIlluminationProperties();for(let e=0;e<a.directionRadians.length;e++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(a.directionRadians[e]+=t.transform.bearingInRadians);return{u_image:0,u_latrange:M_(0,e.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:a.altitudeRadians,u_azimuths:a.directionRadians,u_accent:r,u_method:n,u_highlights:a.highlightColor,u_shadows:a.shadowColor}},P_=(t,e)=>{const i=e.stride,r=_();return I(r,0,Q,-8192,0,0,1),b(r,r,[0,-8192,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:t.overscaledZ,u_unpack:e.getUnpackVector()}};function M_(t,e){const i=Math.pow(2,e.canonical.z),r=e.canonical.y;return[new ep(0,r/i).toLngLat().lat,new ep(0,(r+1)/i).toLngLat().lat]}const S_=(t,e,i=0)=>({u_image:0,u_unpack:e.getUnpackVector(),u_dimension:[e.stride,e.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:t.paint.get("color-relief-opacity")}),I_=(t,e,i,r)=>{const n=t.transform;return{u_translation:k_(t,e,i),u_ratio:r/tt(e,1,n.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},C_=(t,e,i,r,n)=>wt(I_(t,e,i,r),{u_image:0,u_image_height:n}),A_=(t,e,i,r,n)=>{const a=t.transform,s=D_(e,a);return{u_translation:k_(t,e,i),u_texsize:e.imageAtlasTexture.size,u_ratio:r/tt(e,1,a.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[s,n.fromScale,n.toScale],u_fade:n.t,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]]}},E_=(t,e,i,r,n)=>{const a=D_(e,t.transform);return wt(I_(t,e,i,r),{u_tileratio:a,u_crossfade_from:n.fromScale,u_crossfade_to:n.toScale,u_image:0,u_mix:n.t,u_lineatlas_width:t.lineAtlas.width,u_lineatlas_height:t.lineAtlas.height})},z_=(t,e,i,r,n,a)=>{const s=D_(e,t.transform);return wt(I_(t,e,i,r),{u_image:0,u_image_height:a,u_tileratio:s,u_crossfade_from:n.fromScale,u_crossfade_to:n.toScale,u_image_dash:1,u_mix:n.t,u_lineatlas_width:t.lineAtlas.width,u_lineatlas_height:t.lineAtlas.height})};function D_(t,e){return 1/tt(t,1,e.tileZoom)}function k_(t,e,i){return st(t.transform,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const R_=(t,e,i,r,n)=>{return{u_tl_parent:t,u_scale_parent:e,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(s=r.paint.get("raster-saturation"),s>0?1-1/(1.001-s):-s),u_contrast_factor:(a=r.paint.get("raster-contrast"),a>0?1/(1-a):1+a),u_spin_weights:L_(r.paint.get("raster-hue-rotate")),u_coords_top:[n[0].x,n[0].y,n[1].x,n[1].y],u_coords_bottom:[n[3].x,n[3].y,n[2].x,n[2].y]};var a,s};function L_(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return[(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const F_=(t,e,i,r,n,a,s,o,l,c,h,u,d)=>{const p=s.transform;return{u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:p.cameraToCenterDistance,u_pitch:p.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:p.width/p.height,u_fade_change:s.options.fadeDuration?s.symbolFadeChange:1,u_label_plane_matrix:o,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+r,u_is_along_line:n,u_is_variable_anchor:a,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:d}},B_=(t,e,i,r,n,a,s,o,l,c,h,u,d,p)=>{const f=s.transform;return wt(F_(t,e,i,r,n,a,s,o,l,c,h,u,p),{u_gamma_scale:r?Math.cos(f.pitch*Math.PI/180)*f.cameraToCenterDistance:1,u_device_pixel_ratio:s.pixelRatio,u_is_halo:1})},O_=(t,e,i,r,n,a,s,o,l,c,h,u,d)=>wt(B_(t,e,i,r,n,a,s,o,l,c,!0,h,0,d),{u_texsize_icon:u,u_texture_icon:1}),j_=(t,e)=>({u_opacity:t,u_color:e}),V_=(t,e,i,r,n)=>wt(function(t,e,i,r){const n=i.imageManager.getPattern(t.from.toString()),a=i.imageManager.getPattern(t.to.toString()),{width:s,height:o}=i.imageManager.getPixelSize(),l=Math.pow(2,r.tileID.overscaledZ),c=r.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(r.tileID.canonical.x+r.tileID.wrap*l),u=c*r.tileID.canonical.y;return{u_image:0,u_pattern_tl_a:n.tl,u_pattern_br_a:n.br,u_pattern_tl_b:a.tl,u_pattern_br_b:a.br,u_texsize:[s,o],u_mix:e.t,u_pattern_size_a:n.displaySize,u_pattern_size_b:a.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/tt(r,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(i,n,e,r),{u_opacity:t}),N_=(t,e)=>{},U_={fillExtrusion:(t,e)=>({u_lightpos:new zl(t,e.u_lightpos),u_lightpos_globe:new zl(t,e.u_lightpos_globe),u_lightintensity:new Al(t,e.u_lightintensity),u_lightcolor:new zl(t,e.u_lightcolor),u_vertical_gradient:new Al(t,e.u_vertical_gradient),u_opacity:new Al(t,e.u_opacity),u_fill_translate:new El(t,e.u_fill_translate)}),fillExtrusionPattern:(t,e)=>({u_lightpos:new zl(t,e.u_lightpos),u_lightpos_globe:new zl(t,e.u_lightpos_globe),u_lightintensity:new Al(t,e.u_lightintensity),u_lightcolor:new zl(t,e.u_lightcolor),u_vertical_gradient:new Al(t,e.u_vertical_gradient),u_height_factor:new Al(t,e.u_height_factor),u_opacity:new Al(t,e.u_opacity),u_fill_translate:new El(t,e.u_fill_translate),u_image:new Cl(t,e.u_image),u_texsize:new El(t,e.u_texsize),u_pixel_coord_upper:new El(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new El(t,e.u_pixel_coord_lower),u_scale:new zl(t,e.u_scale),u_fade:new Al(t,e.u_fade)}),fill:(t,e)=>({u_fill_translate:new El(t,e.u_fill_translate)}),fillPattern:(t,e)=>({u_image:new Cl(t,e.u_image),u_texsize:new El(t,e.u_texsize),u_pixel_coord_upper:new El(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new El(t,e.u_pixel_coord_lower),u_scale:new zl(t,e.u_scale),u_fade:new Al(t,e.u_fade),u_fill_translate:new El(t,e.u_fill_translate)}),fillOutline:(t,e)=>({u_world:new El(t,e.u_world),u_fill_translate:new El(t,e.u_fill_translate)}),fillOutlinePattern:(t,e)=>({u_world:new El(t,e.u_world),u_image:new Cl(t,e.u_image),u_texsize:new El(t,e.u_texsize),u_pixel_coord_upper:new El(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new El(t,e.u_pixel_coord_lower),u_scale:new zl(t,e.u_scale),u_fade:new Al(t,e.u_fade),u_fill_translate:new El(t,e.u_fill_translate)}),circle:(t,e)=>({u_camera_to_center_distance:new Al(t,e.u_camera_to_center_distance),u_scale_with_map:new Cl(t,e.u_scale_with_map),u_pitch_with_map:new Cl(t,e.u_pitch_with_map),u_extrude_scale:new El(t,e.u_extrude_scale),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_globe_extrude_scale:new Al(t,e.u_globe_extrude_scale),u_translate:new El(t,e.u_translate)}),collisionBox:(t,e)=>({u_pixel_extrude_scale:new El(t,e.u_pixel_extrude_scale)}),collisionCircle:(t,e)=>({u_viewport_size:new El(t,e.u_viewport_size)}),debug:(t,e)=>({u_color:new kl(t,e.u_color),u_overlay:new Cl(t,e.u_overlay),u_overlay_scale:new Al(t,e.u_overlay_scale)}),depth:N_,clippingMask:N_,heatmap:(t,e)=>({u_extrude_scale:new Al(t,e.u_extrude_scale),u_intensity:new Al(t,e.u_intensity),u_globe_extrude_scale:new Al(t,e.u_globe_extrude_scale)}),heatmapTexture:(t,e)=>({u_matrix:new Bl(t,e.u_matrix),u_world:new El(t,e.u_world),u_image:new Cl(t,e.u_image),u_color_ramp:new Cl(t,e.u_color_ramp),u_opacity:new Al(t,e.u_opacity)}),hillshade:(t,e)=>({u_image:new Cl(t,e.u_image),u_latrange:new El(t,e.u_latrange),u_exaggeration:new Al(t,e.u_exaggeration),u_altitudes:new Ll(t,e.u_altitudes),u_azimuths:new Ll(t,e.u_azimuths),u_accent:new kl(t,e.u_accent),u_method:new Cl(t,e.u_method),u_shadows:new Rl(t,e.u_shadows),u_highlights:new Rl(t,e.u_highlights)}),hillshadePrepare:(t,e)=>({u_matrix:new Bl(t,e.u_matrix),u_image:new Cl(t,e.u_image),u_dimension:new El(t,e.u_dimension),u_zoom:new Al(t,e.u_zoom),u_unpack:new Dl(t,e.u_unpack)}),colorRelief:(t,e)=>({u_image:new Cl(t,e.u_image),u_unpack:new Dl(t,e.u_unpack),u_dimension:new El(t,e.u_dimension),u_elevation_stops:new Cl(t,e.u_elevation_stops),u_color_stops:new Cl(t,e.u_color_stops),u_color_ramp_size:new Cl(t,e.u_color_ramp_size),u_opacity:new Al(t,e.u_opacity)}),line:(t,e)=>({u_translation:new El(t,e.u_translation),u_ratio:new Al(t,e.u_ratio),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_units_to_pixels:new El(t,e.u_units_to_pixels)}),lineGradient:(t,e)=>({u_translation:new El(t,e.u_translation),u_ratio:new Al(t,e.u_ratio),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_units_to_pixels:new El(t,e.u_units_to_pixels),u_image:new Cl(t,e.u_image),u_image_height:new Al(t,e.u_image_height)}),linePattern:(t,e)=>({u_translation:new El(t,e.u_translation),u_texsize:new El(t,e.u_texsize),u_ratio:new Al(t,e.u_ratio),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_image:new Cl(t,e.u_image),u_units_to_pixels:new El(t,e.u_units_to_pixels),u_scale:new zl(t,e.u_scale),u_fade:new Al(t,e.u_fade)}),lineSDF:(t,e)=>({u_translation:new El(t,e.u_translation),u_ratio:new Al(t,e.u_ratio),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_units_to_pixels:new El(t,e.u_units_to_pixels),u_image:new Cl(t,e.u_image),u_mix:new Al(t,e.u_mix),u_tileratio:new Al(t,e.u_tileratio),u_crossfade_from:new Al(t,e.u_crossfade_from),u_crossfade_to:new Al(t,e.u_crossfade_to),u_lineatlas_width:new Al(t,e.u_lineatlas_width),u_lineatlas_height:new Al(t,e.u_lineatlas_height)}),lineGradientSDF:(t,e)=>({u_translation:new El(t,e.u_translation),u_ratio:new Al(t,e.u_ratio),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_units_to_pixels:new El(t,e.u_units_to_pixels),u_image:new Cl(t,e.u_image),u_image_height:new Al(t,e.u_image_height),u_tileratio:new Al(t,e.u_tileratio),u_crossfade_from:new Al(t,e.u_crossfade_from),u_crossfade_to:new Al(t,e.u_crossfade_to),u_image_dash:new Cl(t,e.u_image_dash),u_mix:new Al(t,e.u_mix),u_lineatlas_width:new Al(t,e.u_lineatlas_width),u_lineatlas_height:new Al(t,e.u_lineatlas_height)}),raster:(t,e)=>({u_tl_parent:new El(t,e.u_tl_parent),u_scale_parent:new Al(t,e.u_scale_parent),u_buffer_scale:new Al(t,e.u_buffer_scale),u_fade_t:new Al(t,e.u_fade_t),u_opacity:new Al(t,e.u_opacity),u_image0:new Cl(t,e.u_image0),u_image1:new Cl(t,e.u_image1),u_brightness_low:new Al(t,e.u_brightness_low),u_brightness_high:new Al(t,e.u_brightness_high),u_saturation_factor:new Al(t,e.u_saturation_factor),u_contrast_factor:new Al(t,e.u_contrast_factor),u_spin_weights:new zl(t,e.u_spin_weights),u_coords_top:new Dl(t,e.u_coords_top),u_coords_bottom:new Dl(t,e.u_coords_bottom)}),symbolIcon:(t,e)=>({u_is_size_zoom_constant:new Cl(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Cl(t,e.u_is_size_feature_constant),u_size_t:new Al(t,e.u_size_t),u_size:new Al(t,e.u_size),u_camera_to_center_distance:new Al(t,e.u_camera_to_center_distance),u_pitch:new Al(t,e.u_pitch),u_rotate_symbol:new Cl(t,e.u_rotate_symbol),u_aspect_ratio:new Al(t,e.u_aspect_ratio),u_fade_change:new Al(t,e.u_fade_change),u_label_plane_matrix:new Bl(t,e.u_label_plane_matrix),u_coord_matrix:new Bl(t,e.u_coord_matrix),u_is_text:new Cl(t,e.u_is_text),u_pitch_with_map:new Cl(t,e.u_pitch_with_map),u_is_along_line:new Cl(t,e.u_is_along_line),u_is_variable_anchor:new Cl(t,e.u_is_variable_anchor),u_texsize:new El(t,e.u_texsize),u_texture:new Cl(t,e.u_texture),u_translation:new El(t,e.u_translation),u_pitched_scale:new Al(t,e.u_pitched_scale)}),symbolSDF:(t,e)=>({u_is_size_zoom_constant:new Cl(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Cl(t,e.u_is_size_feature_constant),u_size_t:new Al(t,e.u_size_t),u_size:new Al(t,e.u_size),u_camera_to_center_distance:new Al(t,e.u_camera_to_center_distance),u_pitch:new Al(t,e.u_pitch),u_rotate_symbol:new Cl(t,e.u_rotate_symbol),u_aspect_ratio:new Al(t,e.u_aspect_ratio),u_fade_change:new Al(t,e.u_fade_change),u_label_plane_matrix:new Bl(t,e.u_label_plane_matrix),u_coord_matrix:new Bl(t,e.u_coord_matrix),u_is_text:new Cl(t,e.u_is_text),u_pitch_with_map:new Cl(t,e.u_pitch_with_map),u_is_along_line:new Cl(t,e.u_is_along_line),u_is_variable_anchor:new Cl(t,e.u_is_variable_anchor),u_texsize:new El(t,e.u_texsize),u_texture:new Cl(t,e.u_texture),u_gamma_scale:new Al(t,e.u_gamma_scale),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_is_halo:new Cl(t,e.u_is_halo),u_translation:new El(t,e.u_translation),u_pitched_scale:new Al(t,e.u_pitched_scale)}),symbolTextAndIcon:(t,e)=>({u_is_size_zoom_constant:new Cl(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Cl(t,e.u_is_size_feature_constant),u_size_t:new Al(t,e.u_size_t),u_size:new Al(t,e.u_size),u_camera_to_center_distance:new Al(t,e.u_camera_to_center_distance),u_pitch:new Al(t,e.u_pitch),u_rotate_symbol:new Cl(t,e.u_rotate_symbol),u_aspect_ratio:new Al(t,e.u_aspect_ratio),u_fade_change:new Al(t,e.u_fade_change),u_label_plane_matrix:new Bl(t,e.u_label_plane_matrix),u_coord_matrix:new Bl(t,e.u_coord_matrix),u_is_text:new Cl(t,e.u_is_text),u_pitch_with_map:new Cl(t,e.u_pitch_with_map),u_is_along_line:new Cl(t,e.u_is_along_line),u_is_variable_anchor:new Cl(t,e.u_is_variable_anchor),u_texsize:new El(t,e.u_texsize),u_texsize_icon:new El(t,e.u_texsize_icon),u_texture:new Cl(t,e.u_texture),u_texture_icon:new Cl(t,e.u_texture_icon),u_gamma_scale:new Al(t,e.u_gamma_scale),u_device_pixel_ratio:new Al(t,e.u_device_pixel_ratio),u_is_halo:new Cl(t,e.u_is_halo),u_translation:new El(t,e.u_translation),u_pitched_scale:new Al(t,e.u_pitched_scale)}),background:(t,e)=>({u_opacity:new Al(t,e.u_opacity),u_color:new kl(t,e.u_color)}),backgroundPattern:(t,e)=>({u_opacity:new Al(t,e.u_opacity),u_image:new Cl(t,e.u_image),u_pattern_tl_a:new El(t,e.u_pattern_tl_a),u_pattern_br_a:new El(t,e.u_pattern_br_a),u_pattern_tl_b:new El(t,e.u_pattern_tl_b),u_pattern_br_b:new El(t,e.u_pattern_br_b),u_texsize:new El(t,e.u_texsize),u_mix:new Al(t,e.u_mix),u_pattern_size_a:new El(t,e.u_pattern_size_a),u_pattern_size_b:new El(t,e.u_pattern_size_b),u_scale_a:new Al(t,e.u_scale_a),u_scale_b:new Al(t,e.u_scale_b),u_pixel_coord_upper:new El(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new El(t,e.u_pixel_coord_lower),u_tile_units_to_pixels:new Al(t,e.u_tile_units_to_pixels)}),terrain:(t,e)=>({u_texture:new Cl(t,e.u_texture),u_ele_delta:new Al(t,e.u_ele_delta),u_fog_matrix:new Bl(t,e.u_fog_matrix),u_fog_color:new kl(t,e.u_fog_color),u_fog_ground_blend:new Al(t,e.u_fog_ground_blend),u_fog_ground_blend_opacity:new Al(t,e.u_fog_ground_blend_opacity),u_horizon_color:new kl(t,e.u_horizon_color),u_horizon_fog_blend:new Al(t,e.u_horizon_fog_blend),u_is_globe_mode:new Al(t,e.u_is_globe_mode)}),terrainDepth:(t,e)=>({u_ele_delta:new Al(t,e.u_ele_delta)}),terrainCoords:(t,e)=>({u_texture:new Cl(t,e.u_texture),u_terrain_coords_id:new Al(t,e.u_terrain_coords_id),u_ele_delta:new Al(t,e.u_ele_delta)}),projectionErrorMeasurement:(t,e)=>({u_input:new Al(t,e.u_input),u_output_expected:new Al(t,e.u_output_expected)}),atmosphere:(t,e)=>({u_sun_pos:new zl(t,e.u_sun_pos),u_atmosphere_blend:new Al(t,e.u_atmosphere_blend),u_globe_position:new zl(t,e.u_globe_position),u_globe_radius:new Al(t,e.u_globe_radius),u_inv_proj_matrix:new Bl(t,e.u_inv_proj_matrix)}),sky:(t,e)=>({u_sky_color:new kl(t,e.u_sky_color),u_horizon_color:new kl(t,e.u_horizon_color),u_horizon:new El(t,e.u_horizon),u_horizon_normal:new El(t,e.u_horizon_normal),u_sky_horizon_blend:new Al(t,e.u_sky_horizon_blend),u_sky_blend:new Al(t,e.u_sky_blend)})};class Z_{constructor(t,e,i){this.context=t;const r=t.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const G_={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class $_{constructor(t,e,i,r){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=r,this.context=t;const n=t.gl;this.buffer=n.createBuffer(),t.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer)}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const r=e.attributes[this.attributes[i].name];void 0!==r&&t.enableVertexAttribArray(r)}}setVertexAttribPointers(t,e,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],a=e.attributes[n.name];void 0!==a&&t.vertexAttribPointer(a,n.components,t[G_[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class q_{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class W_ extends q_{getDefault(){return Ri.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class H_ extends q_{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1)}}class X_ extends q_{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1)}}class Y_ extends q_{getDefault(){return[!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class K_ extends q_{getDefault(){return!0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1)}}class J_ extends q_{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1)}}class Q_ extends q_{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1)}}class tg extends q_{getDefault(){const t=this.gl;return[t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1)}}class eg extends q_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1}}class ig extends q_{getDefault(){return[0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1)}}class rg extends q_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1}}class ng extends q_{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1)}}class ag extends q_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1}}class sg extends q_{getDefault(){const t=this.gl;return[t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1)}}class og extends q_{getDefault(){return Ri.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class lg extends q_{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1)}}class cg extends q_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1}}class hg extends q_{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1)}}class ug extends q_{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1)}}class dg extends q_{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1)}}class pg extends q_{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1)}}class fg extends q_{getDefault(){const t=this.gl;return[0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class mg extends q_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1}}class _g extends q_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class gg extends q_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1}}class yg extends q_{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class xg extends q_{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class vg extends q_{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;Cm(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1}}class bg extends q_{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1}}class wg extends q_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1}}class Tg extends q_{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1}}class Pg extends q_{constructor(t,e){super(t),this.context=t,this.parent=e}getDefault(){return null}}class Mg extends Pg{setDirty(){this.dirty=!0}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1}}class Sg extends Pg{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class Ig extends Pg{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}const Cg="Framebuffer is not complete";class Ag{constructor(t,e,i,r,n){this.context=t,this.width=e,this.height=i;const a=t.gl,s=this.framebuffer=a.createFramebuffer();if(this.colorAttachment=new Mg(t,s),r)this.depthAttachment=n?new Ig(t,s):new Sg(t,s);else if(n)throw new Error("Stencil cannot be set without depth");if(a.checkFramebufferStatus(a.FRAMEBUFFER)!==a.FRAMEBUFFER_COMPLETE)throw new Error(Cg)}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e)}t.deleteFramebuffer(this.framebuffer)}}class Eg{constructor(t){var e,i;if(this.gl=t,this.clearColor=new W_(this),this.clearDepth=new H_(this),this.clearStencil=new X_(this),this.colorMask=new Y_(this),this.depthMask=new K_(this),this.stencilMask=new J_(this),this.stencilFunc=new Q_(this),this.stencilOp=new tg(this),this.stencilTest=new eg(this),this.depthRange=new ig(this),this.depthTest=new rg(this),this.depthFunc=new ng(this),this.blend=new ag(this),this.blendFunc=new sg(this),this.blendColor=new og(this),this.blendEquation=new lg(this),this.cullFace=new cg(this),this.cullFaceSide=new hg(this),this.frontFace=new ug(this),this.program=new dg(this),this.activeTexture=new pg(this),this.viewport=new fg(this),this.bindFramebuffer=new mg(this),this.bindRenderbuffer=new _g(this),this.bindTexture=new gg(this),this.bindVertexBuffer=new yg(this),this.bindElementBuffer=new xg(this),this.bindVertexArray=new vg(this),this.pixelStoreUnpack=new bg(this),this.pixelStoreUnpackPremultiplyAlpha=new wg(this),this.pixelStoreUnpackFlipY=new Tg(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),Cm(t)){this.HALF_FLOAT=t.HALF_FLOAT;const r=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,t.getExtension("EXT_color_buffer_float")}else{t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(t,e){return new Z_(this,t,e)}createVertexBuffer(t,e,i){return new $_(this,t,e,i)}createRenderbuffer(t,e,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),n}createFramebuffer(t,e,i,r){return new Ag(this,t,e,i,r)}clear({color:t,depth:e,stencil:i}){const r=this.gl;let n=0;t&&(n|=r.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(n|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(n|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(n)}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace))}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1)}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1)}setColorMode(t){Et(t.blendFunction,bm.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask)}createVertexArray(){var t;return Cm(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return Cm(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null)}}let zg;function Dg(t,e,i,r,n){const a=t.context,s=t.transform,o=a.gl,l=t.useProgram("collisionBox"),c=[];let h=0,u=0;for(let d=0;d<r.length;d++){const p=r[d],f=e.getTile(p).getBucket(i);if(!f)continue;const m=n?f.textCollisionBox:f.iconCollisionBox,_=f.collisionCircleArray;_.length>0&&(c.push({circleArray:_,circleOffset:u,coord:p}),h+=_.length/4,u=h),m&&l.draw(a,o.LINES,Pm.disabled,Sm.disabled,t.colorModeForRenderPass(),Tm.disabled,y_(t.transform),t.style.map.terrain&&t.style.map.terrain.getTerrainData(p),s.getProjectionData({overscaledTileID:p,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,t.transform.zoom,null,null,m.collisionVertexBuffer)}if(!n||!c.length)return;const d=t.useProgram("collisionCircle"),p=new rl;p.resize(4*h),p._trim();let f=0;for(const t of c)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,r=t.circleArray[i+0],n=t.circleArray[i+1],a=t.circleArray[i+2],s=t.circleArray[i+3];p.emplace(f++,r,n,a,s,0),p.emplace(f++,r,n,a,s,1),p.emplace(f++,r,n,a,s,2),p.emplace(f++,r,n,a,s,3)}(!zg||zg.length<2*h)&&(zg=function(t){const e=2*t,i=new al;i.resize(e),i._trim();for(let t=0;t<e;t++){const e=6*t;i.uint16[e+0]=4*t+0,i.uint16[e+1]=4*t+1,i.uint16[e+2]=4*t+2,i.uint16[e+3]=4*t+2,i.uint16[e+4]=4*t+3,i.uint16[e+5]=4*t+0}return i}(h));const m=a.createIndexBuffer(zg,!0),_=a.createVertexBuffer(p,bu.members,!0);for(const e of c){const r=x_(t.transform);d.draw(a,o.TRIANGLES,Pm.disabled,Sm.disabled,t.colorModeForRenderPass(),Tm.disabled,r,t.style.map.terrain&&t.style.map.terrain.getTerrainData(e.coord),null,i.id,_,m,ul.simpleSegment(0,2*e.circleOffset,e.circleArray.length,e.circleArray.length/2),null,t.transform.zoom,null,null,null)}_.destroy(),m.destroy()}const kg=y(new Float32Array(16));function Rg(t,e,i,r,n,s){const{horizontalAlign:o,verticalAlign:l}=$u(t);return new a((-(o-.5)*e/n+r[0])*s,(-(l-.5)*i/n+r[1])*s)}function Lg(t,e,i,r,n,s){const o=e.tileAnchorPoint.add(new a(e.translation[0],e.translation[1]));if(e.pitchWithMap){let t=r.mult(s);i||(t=t.rotate(-n));const a=o.add(t);return ef(a.x,a.y,e.pitchedLabelPlaneMatrix,e.getElevation).point}if(i){const i=uf(e.tileAnchorPoint.x+1,e.tileAnchorPoint.y,e).point.sub(t),n=Math.atan(i.y/i.x)+(i.x<0?Math.PI:0);return t.add(r.rotate(n))}return t.add(r)}function Fg(t,e,i,r,n,s,o,l,c,h,u,d){const p=t.text.placedSymbolArray,f=t.text.dynamicLayoutVertexArray,m=t.icon.dynamicLayoutVertexArray,_={};f.clear();for(let m=0;m<p.length;m++){const g=p.get(m),y=g.hidden||!g.crossTileID||t.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(y){const r=new a(g.anchorX,g.anchorY),p={getElevation:d,width:n.width,height:n.height,pitchedLabelPlaneMatrix:s,pitchWithMap:i,transform:n,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=i?pf(r.x,r.y,p):uf(r.x,r.y,p),x=rf(n.cameraToCenterDistance,m.signedDistanceFromCamera);let v=Wu(t.textSizeData,l,g)*x/24;i&&(v*=t.tilePixelRatio/o);const{width:b,height:w,anchor:T,textOffset:P,textBoxScale:M}=y,S=Rg(T,b,w,P,M,v),I=n.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),C=Lg(m.point,p,e,S,-n.bearingInRadians,I),A=t.allowVerticalPlacement&&g.placedOrientation===Gu.vertical?Math.PI/2:0;for(let t=0;t<g.numGlyphs;t++)Ju(f,C,A);c&&g.associatedIconIndex>=0&&(_[g.associatedIconIndex]={shiftedAnchor:C,angle:A})}else yf(g.numGlyphs,f)}if(c){m.clear();const e=t.icon.placedSymbolArray;for(let t=0;t<e.length;t++){const i=e.get(t);if(i.hidden)yf(i.numGlyphs,m);else{const e=_[t];if(e)for(let t=0;t<i.numGlyphs;t++)Ju(m,e.shiftedAnchor,e.angle);else yf(i.numGlyphs,m)}}t.icon.dynamicLayoutVertexBuffer.updateData(m)}t.text.dynamicLayoutVertexBuffer.updateData(f)}function Bg(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function Og(t,e,i,r,n,a,s,o,l,c,h,u,d){const p=t.context,f=p.gl,m=t.transform,g="map"===o,y="map"===l,v="viewport"!==o&&"point"!==i.layout.get("symbol-placement"),b=g&&!y&&!v,w=!i.layout.get("symbol-sort-key").isConstant();let T=!1;const P=t.getDepthModeForSublayer(0,Pm.ReadOnly),M=i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"),S=[],I=m.getCircleRadiusCorrection();for(const o of r){const r=e.getTile(o),l=r.getBucket(i);if(!l)continue;const h=n?l.text:l.icon;if(!h||!h.segments.get().length||!h.hasVisibleVertices)continue;const u=h.programConfigurations.get(i.id),p=n||l.sdfIcons,P=n?l.textSizeData:l.iconSizeData,C=y||0!==m.pitch,A=t.useProgram(Bg(p,n,l),u),E=Hu(P,m.zoom),z=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o);let D,k,R,L,F=[0,0],B=null;if(n)k=r.glyphAtlasTexture,R=f.LINEAR,D=r.glyphAtlasTexture.size,l.iconsInText&&(F=r.imageAtlasTexture.size,B=r.imageAtlasTexture,L=C||t.options.rotating||t.options.zooming||"composite"===P.kind||"camera"===P.kind?f.LINEAR:f.NEAREST);else{const e=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;k=r.imageAtlasTexture,R=p||t.options.rotating||t.options.zooming||e||C?f.LINEAR:f.NEAREST,D=r.imageAtlasTexture.size}const O=tt(r,1,t.transform.zoom),j=Jp(g,t.transform,O),V=_();x(V,j);const N=Qp(y,g,t.transform,O),U=st(m,r,a,s),Z=m.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!d,applyTerrainMatrix:!0}),G=M&&l.hasTextData(),$="none"!==i.layout.get("icon-text-fit")&&G&&l.hasIconData();if(v){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(o,e,i):null,r="map"===i.layout.get("text-rotation-alignment");af(l,t,n,j,V,y,c,r,o.toUnwrapped(),m.width,m.height,U,e)}const q=n&&M||$,W=v||q?kg:y?j:t.transform.clipSpaceToPixelsMatrix,H=p&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let X;X=p?l.iconsInText?O_(P.kind,E,b,y,v,q,t,W,N,U,D,F,I):B_(P.kind,E,b,y,v,q,t,W,N,U,n,D,0,I):F_(P.kind,E,b,y,v,q,t,W,N,U,n,D,I);const Y={program:A,buffers:h,uniformValues:X,projectionData:Z,atlasTexture:k,atlasTextureIcon:B,atlasInterpolation:R,atlasInterpolationIcon:L,isSDF:p,hasHalo:H};if(w&&l.canOverlap){T=!0;const t=h.segments.get();for(const e of t)S.push({segments:new ul([e]),sortKey:e.sortKey,state:Y,terrainData:z})}else S.push({segments:h.segments,sortKey:0,state:Y,terrainData:z})}T&&S.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of S){const r=e.state;if(p.activeTexture.set(f.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,f.CLAMP_TO_EDGE),r.atlasTextureIcon&&(p.activeTexture.set(f.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,f.CLAMP_TO_EDGE)),r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,jg(r.buffers,e.segments,i,t,r.program,P,h,u,n,r.projectionData,e.terrainData)),n.u_is_halo=0}jg(r.buffers,e.segments,i,t,r.program,P,h,u,r.uniformValues,r.projectionData,e.terrainData)}}function jg(t,e,i,r,n,a,s,o,l,c,h){const u=r.context;n.draw(u,u.gl.TRIANGLES,a,s,o,Tm.backCCW,l,h,c,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,r.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer)}function Vg(t,e,i,r,n){const a=t.context,s=a.gl,o=Sm.disabled,l=new bm([s.ONE,s.ONE],Ri.transparent,[!0,!0,!0,!0]),c=e.getBucket(i);if(!c)return;const h=r.key;let u=i.heatmapFbos.get(h);u||(u=Ug(a,e.tileSize,e.tileSize),i.heatmapFbos.set(h,u)),a.bindFramebuffer.set(u.framebuffer),a.viewport.set([0,0,e.tileSize,e.tileSize]),a.clear({color:Ri.transparent});const d=c.programConfigurations.get(i.id),p=t.useProgram("heatmap",d,!n),f=t.transform.getProjectionData({overscaledTileID:e.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),m=t.style.map.terrain.getTerrainData(r);p.draw(a,s.TRIANGLES,Pm.disabled,o,l,Tm.disabled,b_(e,t.transform.zoom,i.paint.get("heatmap-intensity"),1),m,f,i.id,c.layoutVertexBuffer,c.indexBuffer,c.segments,i.paint,t.transform.zoom,d)}function Ng(t,e,i,r,n){const a=t.context,s=a.gl,o=t.transform;a.setColorMode(t.colorModeForRenderPass());const l=Zg(a,e),c=i.key,h=e.heatmapFbos.get(c);if(!h)return;a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,h.colorAttachment.get()),a.activeTexture.set(s.TEXTURE1),l.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=o.getProjectionData({overscaledTileID:i,applyTerrainMatrix:n,applyGlobeMatrix:!r});t.useProgram("heatmapTexture").draw(a,s.TRIANGLES,Pm.disabled,Sm.disabled,t.colorModeForRenderPass(),Tm.disabled,w_(t,e,0,1),null,u,e.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments,e.paint,o.zoom),h.destroy(),e.heatmapFbos.delete(c)}function Ug(t,e,i){var r,n;const a=t.gl,s=a.createTexture();a.bindTexture(a.TEXTURE_2D,s),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.LINEAR),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.LINEAR);const o=null!==(r=t.HALF_FLOAT)&&void 0!==r?r:a.UNSIGNED_BYTE,l=null!==(n=t.RGBA16F)&&void 0!==n?n:a.RGBA;a.texImage2D(a.TEXTURE_2D,0,l,e,i,0,a.RGBA,o,null);const c=t.createFramebuffer(e,i,!1,!1);return c.colorAttachment.set(s),c}function Zg(t,e){return e.colorRampTexture||(e.colorRampTexture=new Zc(t,e.colorRamp,t.gl.RGBA)),e.colorRampTexture}function Gg(t,e,i,r,n,a,s,o){let l=256;if(n.stepInterpolant){const r=e.getSource().maxzoom,n=s.canonical.z===r?Math.ceil(1<<t.transform.maxZoom-s.canonical.z):1;l=vt((c=a.maxLineLength/Q*1024*n)<=1?1:Math.pow(2,Math.ceil(Math.log(c)/Math.LN2)),256,i.maxTextureSize)}var c;return o.gradient=Lc({expression:n.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:o.gradient||void 0,clips:a.lineClipsArray}),o.texture?o.texture.update(o.gradient):o.texture=new Zc(i,o.gradient,r.RGBA),o.version=n.gradientVersion,o.texture}function $g(t,e,i,r,n){t.activeTexture.set(e.TEXTURE0),i.imageAtlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE),r.updatePaintBuffers(n)}function qg(t,e,i,r,n,a){(n||t.lineAtlas.dirty)&&(e.activeTexture.set(i.TEXTURE0),t.lineAtlas.bind(e)),r.updatePaintBuffers(a)}function Wg(t,e,i,r,n,a,s){const o=a.gradients[n.id];let l=o.texture;n.gradientVersion!==o.version&&(l=Gg(t,e,i,r,n,a,s,o)),i.activeTexture.set(r.TEXTURE0),l.bind(n.stepInterpolant?r.NEAREST:r.LINEAR,r.CLAMP_TO_EDGE)}function Hg(t,e,i,r,n,a,s,o,l){const c=a.gradients[n.id];let h=c.texture;n.gradientVersion!==c.version&&(h=Gg(t,e,i,r,n,a,s,c)),i.activeTexture.set(r.TEXTURE0),h.bind(n.stepInterpolant?r.NEAREST:r.LINEAR,r.CLAMP_TO_EDGE),i.activeTexture.set(r.TEXTURE1),t.lineAtlas.bind(i),o.updatePaintBuffers(l)}function Xg(t,e,i,r,n){if(!i||!r||!r.imageAtlas)return;const a=r.imageAtlas.patternPositions;let s=a[i.to.toString()],o=a[i.from.toString()];if(!s&&o&&(s=o),!o&&s&&(o=s),!s||!o){const t=n.getPaintProperty(e);s=a[t],o=a[t]}s&&o&&t.setConstantPatternPositions(s,o)}function Yg(t,e,i,r,n,a,s,o){const l=t.context.gl,c="fill-pattern",h=i.paint.get(c),u=h&&h.constantOr(1),d=i.getCrossfadeParameters();let p,f,m,_,g;const y=t.transform,x=i.paint.get("fill-translate"),v=i.paint.get("fill-translate-anchor");s?(f=u&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=l.LINES):(f=u?"fillPattern":"fill",p=l.TRIANGLES);const b=h.constantOr(null);for(const h of r){const r=e.getTile(h);if(u&&!r.patternsLoaded())continue;const w=r.getBucket(i);if(!w)continue;const T=w.programConfigurations.get(i.id),P=t.useProgram(f,T),M=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h);u&&(t.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),T.updatePaintBuffers(d)),Xg(T,c,b,r,i);const S=y.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!o,applyTerrainMatrix:!0}),I=st(y,r,x,v);if(s){_=w.indexBuffer2,g=w.segments2;const e=[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===f&&u?__(t,d,r,e,I):m_(e,I)}else _=w.indexBuffer,g=w.segments,m=u?p_(t,d,r,I):f_(I);const C=t.stencilModeForClipping(h);P.draw(t.context,p,n,C,a,Tm.backCCW,m,M,S,i.id,w.layoutVertexBuffer,_,g,i.paint,t.transform.zoom,T)}}function Kg(t,e,i,r,n,a,s,o){const l=t.context,c=l.gl,h="fill-extrusion-pattern",u=i.paint.get(h),d=u.constantOr(1),p=i.getCrossfadeParameters(),f=i.paint.get("fill-extrusion-opacity"),m=u.constantOr(null),_=t.transform;for(const u of r){const r=e.getTile(u),g=r.getBucket(i);if(!g)continue;const y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(u),x=g.programConfigurations.get(i.id),v=t.useProgram(d?"fillExtrusionPattern":"fillExtrusion",x);d&&(t.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),x.updatePaintBuffers(p));const b=_.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!o,applyTerrainMatrix:!0});Xg(x,h,m,r,i);const w=st(_,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),T=i.paint.get("fill-extrusion-vertical-gradient"),P=d?d_(t,T,f,w,u,p,r):u_(t,T,f,w);v.draw(l,l.gl.TRIANGLES,n,a,s,Tm.backCCW,P,y,b,i.id,g.layoutVertexBuffer,g.indexBuffer,g.segments,i.paint,t.transform.zoom,x,t.style.map.terrain&&g.centroidVertexBuffer)}}function Jg(t,e,i,r,n,a,s,o,l){var c;const h=t.style.projection,u=t.context,d=t.transform,p=u.gl,f=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=t.useProgram("hillshade",null,!1,f),_=!t.options.moving;for(const f of r){const r=e.getTile(f),g=r.fbo;if(!g)continue;const y=h.getMeshFromTileID(u,f.canonical,o,!0,"raster"),x=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(f);u.activeTexture.set(p.TEXTURE0),p.bindTexture(p.TEXTURE_2D,g.colorAttachment.get());const v=d.getProjectionData({overscaledTileID:f,aligned:_,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,p.TRIANGLES,a,n[f.overscaledZ],s,Tm.backCCW,T_(t,r,i),x,v,i.id,y.vertexBuffer,y.indexBuffer,y.segments)}}function Qg(t,e,i,r,n,a,s,o,l){var c;const h=t.style.projection,u=t.context,d=t.transform,p=u.gl,f=t.useProgram("colorRelief"),m=!t.options.moving;let _=!0,g=0;for(const y of r){const r=e.getTile(y),x=r.dem;if(_){const t=p.getParameter(p.MAX_TEXTURE_SIZE),{elevationTexture:e,colorTexture:r}=i.getColorRampTextures(u,t,x.getUnpackVector());u.activeTexture.set(p.TEXTURE1),e.bind(p.NEAREST,p.CLAMP_TO_EDGE),u.activeTexture.set(p.TEXTURE4),r.bind(p.LINEAR,p.CLAMP_TO_EDGE),_=!1,g=e.size[0]}if(!x||!x.data)continue;const v=x.stride,b=x.getPixels();if(u.activeTexture.set(p.TEXTURE0),u.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||t.getTileTexture(v),r.demTexture){const t=r.demTexture;t.update(b,{premultiply:!1}),t.bind(p.LINEAR,p.CLAMP_TO_EDGE)}else r.demTexture=new Zc(u,b,p.RGBA,{premultiply:!1}),r.demTexture.bind(p.LINEAR,p.CLAMP_TO_EDGE);const w=h.getMeshFromTileID(u,y.canonical,o,!0,"raster"),T=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(y),P=d.getProjectionData({overscaledTileID:y,aligned:m,applyGlobeMatrix:!l,applyTerrainMatrix:!0});f.draw(u,p.TRIANGLES,a,n[y.overscaledZ],s,Tm.backCCW,S_(i,r.dem,g),T,P,i.id,w.vertexBuffer,w.indexBuffer,w.segments)}}const ty=[new a(0,0),new a(Q,0),new a(Q,Q),new a(0,Q)];function ey(t,e,i,r,n,a,s,o,l=!1,c=!1){const h=r[r.length-1].overscaledZ,u=t.context,d=u.gl,p=t.useProgram("raster"),f=t.transform,m=t.style.projection,_=t.colorModeForRenderPass(),g=!t.options.moving,y=i.paint.get("raster-opacity"),x=i.paint.get("raster-resampling"),v=i.paint.get("raster-fade-duration"),b=!!t.style.map.terrain;for(const w of r){const r=t.getDepthModeForSublayer(w.overscaledZ-h,1===y?Pm.ReadWrite:Pm.ReadOnly,d.LESS),T=e.getTile(w),P="nearest"===x?d.NEAREST:d.LINEAR;u.activeTexture.set(d.TEXTURE0),T.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(d.TEXTURE1);const{parentTile:M,parentScaleBy:S,parentTopLeft:I,fadeValues:C}=iy(T,e,v,b);T.fadeOpacity=C.tileOpacity,M?(M.fadeOpacity=C.parentTileOpacity,M.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST)):T.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),T.texture.useMipmap&&u.extTextureFilterAnisotropic&&t.transform.pitch>20&&d.texParameterf(d.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const A=t.style.map.terrain&&t.style.map.terrain.getTerrainData(w),E=f.getProjectionData({overscaledTileID:w,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),z=R_(I,S,C.fadeMix,i,o),D=m.getMeshFromTileID(u,w.canonical,a,s,"raster");p.draw(u,d.TRIANGLES,r,n?n[w.overscaledZ]:Sm.disabled,_,l?Tm.frontCCW:Tm.backCCW,z,A,E,i.id,D.vertexBuffer,D.indexBuffer,D.segments)}}function iy(t,e,i,r){const n={parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:{tileOpacity:1,parentTileOpacity:1,fadeMix:{opacity:1,mix:0}}};if(0===i||r)return n;if(t.fadingParentID){const r=e.getLoadedTile(t.fadingParentID);if(!r)return n;const a=Math.pow(2,r.tileID.overscaledZ-t.tileID.overscaledZ),s=[t.tileID.canonical.x*a%1,t.tileID.canonical.y*a%1],o=function(t,e,i){const r=ie(),n=(r-e.timeAdded)/i,a=t.fadingDirection===Ap.Incoming,s=vt((r-t.timeAdded)/i,0,1),o=vt(1-n,0,1),l=a?s:o;return{tileOpacity:l,parentTileOpacity:a?o:s,fadeMix:{opacity:1,mix:1-l}}}(t,r,i);return{parentTile:r,parentScaleBy:a,parentTopLeft:s,fadeValues:o}}if(t.selfFading){const e=function(t,e){const i=vt((ie()-t.timeAdded)/e,0,1);return{tileOpacity:i,fadeMix:{opacity:i,mix:0}}}(t,i);return{parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:e}}return n}const ry=new Ri(1,0,0,1),ny=new Ri(0,1,0,1),ay=new Ri(0,0,1,1),sy=new Ri(1,0,1,1),oy=new Ri(0,1,1,1);function ly(t,e,i,r){hy(t,0,e+i/2,t.transform.width,i,r)}function cy(t,e,i,r){hy(t,e-i/2,0,i,t.transform.height,r)}function hy(t,e,i,r,n,a){const s=t.context,o=s.gl;o.enable(o.SCISSOR_TEST),o.scissor(e*t.pixelRatio,i*t.pixelRatio,r*t.pixelRatio,n*t.pixelRatio),s.clear({color:a}),o.disable(o.SCISSOR_TEST)}function uy(t,e,i){const r=t.context,n=r.gl,a=t.useProgram("debug"),s=Pm.disabled,o=Sm.disabled,l=t.colorModeForRenderPass(),c="$debug",h=t.style.map.terrain&&t.style.map.terrain.getTerrainData(i);r.activeTexture.set(n.TEXTURE0);const u=e.getTileByID(i.key).latestRawTileData,d=Math.floor((u&&u.byteLength||0)/1024),p=e.getTile(i).tileSize,f=512/Math.min(p,512)*(i.overscaledZ/t.transform.zoom)*.5;let m=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(m+=` => ${i.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,r=t.context.gl,n=t.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(e,5,5),n.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(t,`${m} ${d}kB`);const _=t.transform.getProjectionData({overscaledTileID:i,applyGlobeMatrix:!0,applyTerrainMatrix:!0});a.draw(r,n.TRIANGLES,s,o,bm.alphaBlended,Tm.disabled,v_(Ri.transparent,f),null,_,c,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),a.draw(r,n.LINE_STRIP,s,o,l,Tm.disabled,v_(Ri.red),h,_,c,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments)}function dy(t,e,i,r){const{isRenderingGlobe:n}=r,a=t.context,s=a.gl,o=t.transform,l=t.colorModeForRenderPass(),c=t.getDepthModeFor3D(),h=t.useProgram("terrain");a.bindFramebuffer.set(null),a.viewport.set([0,0,t.width,t.height]);for(const r of i){const i=e.getTerrainMesh(r.tileID),u=t.renderToTexture.getTexture(r),d=e.getTerrainData(r.tileID);a.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,u.texture);const p=e.getMeshFrameDelta(o.zoom),f=o.calculateFogMatrix(r.tileID.toUnwrapped()),m=s_(p,f,t.style.sky,o.pitch,n),_=o.getProjectionData({overscaledTileID:r.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(a,s.TRIANGLES,c,Sm.disabled,l,Tm.backCCW,m,d,_,"terrain",i.vertexBuffer,i.indexBuffer,i.segments)}}function py(t,e){if(!e.mesh){const i=new Zo;i.emplaceBack(-1,-1),i.emplaceBack(1,-1),i.emplaceBack(1,1),i.emplaceBack(-1,1);const r=new sl;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),e.mesh=new nm(t.createVertexBuffer(i,am.members),t.createIndexBuffer(r),ul.simpleSegment(0,0,i.length,r.length))}return e.mesh}class fy{constructor(t,e){this.context=new Eg(t),this.transform=e,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:y(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=qp.maxUnderzooming+qp.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new tm}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize()}setup(){const t=this.context,e=new Zo;e.emplaceBack(0,0),e.emplaceBack(Q,0),e.emplaceBack(0,Q),e.emplaceBack(Q,Q),this.tileExtentBuffer=t.createVertexBuffer(e,am.members),this.tileExtentSegments=ul.simpleSegment(0,0,4,2);const i=new Zo;i.emplaceBack(0,0),i.emplaceBack(Q,0),i.emplaceBack(0,Q),i.emplaceBack(Q,Q),this.debugBuffer=t.createVertexBuffer(i,am.members),this.debugSegments=ul.simpleSegment(0,0,4,5);const r=new $o;r.emplaceBack(0,0,0,0),r.emplaceBack(Q,0,Q,0),r.emplaceBack(0,Q,0,Q),r.emplaceBack(Q,Q,Q,Q),this.rasterBoundsBuffer=t.createVertexBuffer(r,n_.members),this.rasterBoundsSegments=ul.simpleSegment(0,0,4,2);const n=new Zo;n.emplaceBack(0,0),n.emplaceBack(Q,0),n.emplaceBack(0,Q),n.emplaceBack(Q,Q),this.rasterBoundsBufferPosOnly=t.createVertexBuffer(n,am.members),this.rasterBoundsSegmentsPosOnly=ul.simpleSegment(0,0,4,5);const a=new Zo;a.emplaceBack(0,0),a.emplaceBack(1,0),a.emplaceBack(0,1),a.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(a,am.members),this.viewportSegments=ul.simpleSegment(0,0,4,2);const s=new ll;s.emplaceBack(0),s.emplaceBack(1),s.emplaceBack(3),s.emplaceBack(2),s.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(s);const o=new sl;o.emplaceBack(1,0,2),o.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(o);const l=this.context.gl;this.stencilClearMode=new Sm({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.tileExtentMesh=new nm(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments)}clearStencil(){const t=this.context,e=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const i=_();I(i,0,this.width,this.height,0,0,1),w(i,i,[e.drawingBufferWidth,e.drawingBufferHeight,0]);const r={mainMatrix:i,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:i};this.useProgram("clippingMask",null,!0).draw(t,e.TRIANGLES,Pm.disabled,this.stencilClearMode,bm.disabled,Tm.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}_renderTileClippingMasks(t,e,i){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source,this.nextStencilID+e.length>256&&this.clearStencil();const r=this.context;r.setColorMode(bm.disabled),r.setDepthMode(Pm.disabled);const n={};for(const t of e)n[t.key]=this.nextStencilID++;this._renderTileMasks(n,e,i,!0),this._renderTileMasks(n,e,i,!1),this._tileClippingMaskIDs=n}_renderTileMasks(t,e,i,r){const n=this.context,a=n.gl,s=this.style.projection,o=this.transform,l=this.useProgram("clippingMask");for(const c of e){const e=t[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=s.getMeshFromTileID(this.context,c.canonical,r,!0,"stencil"),d=o.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(n,a.TRIANGLES,Pm.disabled,new Sm({func:a.ALWAYS,mask:0},e,255,a.KEEP,a.KEEP,a.REPLACE),bm.disabled,i?Tm.disabled:Tm.backCCW,null,h,d,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments)}}_renderTilesDepthBuffer(){const t=this.context,e=t.gl,i=this.style.projection,r=this.transform,n=this.useProgram("depth"),a=this.getDepthModeFor3D(),s=Gp(r,{tileSize:r.tileSize});for(const o of s){const s=this.style.map.terrain&&this.style.map.terrain.getTerrainData(o),l=i.getMeshFromTileID(this.context,o.canonical,!0,!0,"raster"),c=r.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!0,applyTerrainMatrix:!0});n.draw(t,e.TRIANGLES,a,Sm.disabled,bm.disabled,Tm.backCCW,null,s,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new Sm({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new Sm({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const t={};for(let i=0;i<n;i++)t[i+r]=new Sm({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=n,[t,i]}return[{[r]:Sm.disabled},i]}stencilConfigForOverlapTwoPass(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(this.clearStencil(),n>1){const t={},a={};for(let i=0;i<n;i++)t[i+r]=new Sm({func:e.GREATER,mask:255},n+1+i,255,e.KEEP,e.KEEP,e.REPLACE),a[i+r]=new Sm({func:e.GREATER,mask:255},1+i,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID=2*n+1,[t,a,i]}return this.nextStencilID=3,[{[r]:new Sm({func:e.GREATER,mask:255},2,255,e.KEEP,e.KEEP,e.REPLACE)},{[r]:new Sm({func:e.GREATER,mask:255},1,255,e.KEEP,e.KEEP,e.REPLACE)},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const e=1/8;return new bm([t.CONSTANT_COLOR,t.ONE],new Ri(e,e,e,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?bm.unblended:bm.alphaBlended}getDepthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return Pm.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new Pm(i||this.context.gl.LEQUAL,e,[r,r])}getDepthModeFor3D(){return new Pm(this.context.gl.LEQUAL,Pm.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,e){var i,r;this.style=t,this.options=e,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(ie()),this.imageManager.beginFrame();const n=this.style._order,a=this.style.tileManagers,s={},o={},l={},c={isRenderingToTexture:!1,isRenderingGlobe:(null===(i=t.projection)||void 0===i?void 0:i.transitionState)>0};for(const t in a){const e=a[t];e.used&&e.prepare(this.context),s[t]=e.getVisibleCoordinates(!1),o[t]=s[t].slice().reverse(),l[t]=e.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let t=0;t<n.length;t++)if(this.style._layers[n[t]].is3D()){this.opaquePassCutoff=t;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of n){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=o[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,a[e.source],e,i,c)}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:t=>this.useProgram(t)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:e.showOverdrawInspector?Ri.black:Ri.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(t,e){const i=t.context,r=i.gl,n=((t,e,i)=>{const r=Math.cos(e.rollInRadians),n=Math.sin(e.rollInRadians),a=Fp(e),s=e.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return{u_sky_color:t.properties.get("sky-color"),u_horizon_color:t.properties.get("horizon-color"),u_horizon:[(e.width/2-a*n)*i,(e.height/2+a*r)*i],u_horizon_normal:[-n,r],u_sky_horizon_blend:t.properties.get("sky-horizon-blend")*e.height/2*i,u_sky_blend:s}})(e,t.style.map.transform,t.pixelRatio),a=new Pm(r.LEQUAL,Pm.ReadWrite,[0,1]),s=Sm.disabled,o=t.colorModeForRenderPass(),l=t.useProgram("sky"),c=py(i,e);l.draw(i,r.TRIANGLES,a,s,o,Tm.disabled,n,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments)}(this,this.style.sky),this._showOverdrawInspector=e.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=n.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[n[this.currentLayer]],e=a[t.source],i=s[t.source];this._renderTileClippingMasks(t,i,!1),this.renderLayer(this,e,t,i,c)}this.renderPass="translucent";let h=!1;for(this.currentLayer=0;this.currentLayer<n.length;this.currentLayer++){const t=this.style._layers[n[this.currentLayer]],e=a[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t,c))continue;this.opaquePassEnabledForLayer()||h||(h=!0,c.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===t.type?l:o)[t.source];this._renderTileClippingMasks(t,s[t.source],!!this.renderToTexture),this.renderLayer(this,e,t,i,c)}if(c.isRenderingGlobe&&function(t,e,i){const r=t.context,n=r.gl,a=t.useProgram("atmosphere"),s=new Pm(n.LEQUAL,Pm.ReadOnly,[0,1]),o=t.transform,l=function(t,e){const i=t.properties.get("position"),r=[-i.x,-i.y,-i.z],n=y(new Float64Array(16));var a,s,o,l,c,h,u;return"map"===t.properties.get("anchor")&&(M(n,n,e.rollInRadians),T(n,n,-e.pitchInRadians),M(n,n,e.bearingInRadians),T(n,n,e.center.lat*Math.PI/180),P(n,n,-e.center.lng*Math.PI/180)),(a=r)[0]=((o=n)[0]*(l=(s=r)[0])+o[4]*(c=s[1])+o[8]*(h=s[2])+o[12])/(u=(u=o[3]*l+o[7]*c+o[11]*h+o[15])||1),a[1]=(o[1]*l+o[5]*c+o[9]*h+o[13])/u,a[2]=(o[2]*l+o[6]*c+o[10]*h+o[14])/u,r}(i,t.transform),c=o.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),h=e.properties.get("atmosphere-blend")*c.projectionTransition;if(0===h)return;const u=Om(o.worldSize,o.center.lat),d=o.inverseProjectionMatrix,p=new Float64Array(4);p[3]=1,G(p,p,o.modelViewProjectionMatrix),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1,G(p,p,d),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1;const f=((t,e,i,r,n)=>({u_sun_pos:t,u_atmosphere_blend:e,u_globe_position:i,u_globe_radius:r,u_inv_proj_matrix:n}))(l,h,[p[0],p[1],p[2]],u,d),m=py(r,e);a.draw(r,n.TRIANGLES,s,Sm.disabled,bm.alphaBlended,Tm.disabled,f,null,null,"atmosphere",m.vertexBuffer,m.indexBuffer,m.segments)}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const t=function(t,e){let i=null;const r=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.tileManagers[i.source]]:[])),n=r.filter((t=>"vector"===t.getSource().type)),a=r.filter((t=>"vector"!==t.getSource().type)),s=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t)};return n.forEach((t=>s(t))),i||a.forEach((t=>s(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let r=0;r<i.length;r++)uy(t,e,i[r])}(this,t,t.getVisibleCoordinates())}this.options.showPadding&&function(t){const e=t.transform.padding;ly(t,t.transform.height-(e.top||0),3,ry),ly(t,e.bottom||0,3,ny),cy(t,e.left||0,3,ay),cy(t,t.transform.width-(e.right||0),3,sy);const i=t.transform.centerPoint;!function(t,e,i,r){hy(t,e-1,i-10,2,20,r),hy(t,e-10,i-1,20,2,r)}(t,i.x,t.transform.height-i.y,oy)}(this),this.context.setDefault()}maybeDrawDepthAndCoords(t){if(!this.style||!this.style.map||!this.style.map.terrain)return;const e=this.terrainFacilitator.matrix,i=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;var n,a;r||(r=t?!((n=e)[0]===(a=i)[0]&&n[1]===a[1]&&n[2]===a[2]&&n[3]===a[3]&&n[4]===a[4]&&n[5]===a[5]&&n[6]===a[6]&&n[7]===a[7]&&n[8]===a[8]&&n[9]===a[9]&&n[10]===a[10]&&n[11]===a[11]&&n[12]===a[12]&&n[13]===a[13]&&n[14]===a[14]&&n[15]===a[15]):!function(t,e){var i=t[0],r=t[1],n=t[2],a=t[3],s=t[4],o=t[5],l=t[6],c=t[7],h=t[8],u=t[9],p=t[10],f=t[11],m=t[12],_=t[13],g=t[14],y=t[15],x=e[0],v=e[1],b=e[2],w=e[3],T=e[4],P=e[5],M=e[6],S=e[7],I=e[8],C=e[9],A=e[10],E=e[11],z=e[12],D=e[13],k=e[14],R=e[15];return Math.abs(i-x)<=d*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(r-v)<=d*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=d*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(a-w)<=d*Math.max(1,Math.abs(a),Math.abs(w))&&Math.abs(s-T)<=d*Math.max(1,Math.abs(s),Math.abs(T))&&Math.abs(o-P)<=d*Math.max(1,Math.abs(o),Math.abs(P))&&Math.abs(l-M)<=d*Math.max(1,Math.abs(l),Math.abs(M))&&Math.abs(c-S)<=d*Math.max(1,Math.abs(c),Math.abs(S))&&Math.abs(h-I)<=d*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(u-C)<=d*Math.max(1,Math.abs(u),Math.abs(C))&&Math.abs(p-A)<=d*Math.max(1,Math.abs(p),Math.abs(A))&&Math.abs(f-E)<=d*Math.max(1,Math.abs(f),Math.abs(E))&&Math.abs(m-z)<=d*Math.max(1,Math.abs(m),Math.abs(z))&&Math.abs(_-D)<=d*Math.max(1,Math.abs(_),Math.abs(D))&&Math.abs(g-k)<=d*Math.max(1,Math.abs(g),Math.abs(k))&&Math.abs(y-R)<=d*Math.max(1,Math.abs(y),Math.abs(R))}(e,i)),r||(r=this.style.map.terrain.tileManager.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]}(e,i),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,e){const i=t.context,r=i.gl,n=t.transform,a=bm.unblended,s=new Pm(r.LEQUAL,Pm.ReadWrite,[0,1]),o=e.tileManager.getRenderableTiles(),l=t.useProgram("terrainDepth");i.bindFramebuffer.set(e.getFramebuffer("depth").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:Ri.transparent,depth:1});for(const t of o){const o=e.getTerrainMesh(t.tileID),c=e.getTerrainData(t.tileID),h=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:e.getMeshFrameDelta(n.zoom)};l.draw(i,r.TRIANGLES,s,Sm.disabled,a,Tm.backCCW,u,c,h,"terrain",o.vertexBuffer,o.indexBuffer,o.segments)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain),function(t,e){const i=t.context,r=i.gl,n=t.transform,a=bm.unblended,s=new Pm(r.LEQUAL,Pm.ReadWrite,[0,1]),o=e.getCoordsTexture(),l=e.tileManager.getRenderableTiles(),c=t.useProgram("terrainCoords");i.bindFramebuffer.set(e.getFramebuffer("coords").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:Ri.transparent,depth:1}),e.coordsIndex=[];for(const t of l){const l=e.getTerrainMesh(t.tileID),h=e.getTerrainData(t.tileID);i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,o.texture);const u={u_terrain_coords_id:(255-e.coordsIndex.length)/255,u_texture:0,u_ele_delta:e.getMeshFrameDelta(n.zoom)},d=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});c.draw(i,r.TRIANGLES,s,Sm.disabled,a,Tm.backCCW,u,h,d,"terrain",l.vertexBuffer,l.indexBuffer,l.segments),e.coordsIndex.push(t.tileID.key)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain))}renderLayer(t,e,i,r,n){i.isHidden(this.transform.zoom)||("background"===i.type||"custom"===i.type||(r||[]).length)&&(this.id=i.id,(t=>"symbol"===t.type)(i)?function(t,e,i,r,n,a){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=a,o=Sm.disabled,l=t.colorModeForRenderPass();(i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,e,i,r,n,a,s,o,l){const c=e.transform,h=e.style.map.terrain,u="map"===n,d="map"===a;for(const n of t){const t=r.getTile(n),a=t.getBucket(i);if(!a||!a.text||!a.text.segments.get().length)continue;const p=Hu(a.textSizeData,c.zoom),f=tt(t,1,e.transform.zoom),m=Jp(u,e.transform,f),_="none"!==i.layout.get("icon-text-fit")&&a.hasIconData();if(p){const e=Math.pow(2,c.zoom-t.tileID.overscaledZ),i=h?(t,e)=>h.getElevation(n,t,e):null;Fg(a,u,d,l,c,m,e,p,_,st(c,t,s,o),n.toUnwrapped(),i)}}}(r,t,i,e,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&Og(t,e,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),o,l,s),0!==i.paint.get("text-opacity").constantOr(1)&&Og(t,e,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),o,l,s),e.map.showCollisionBoxes&&(Dg(t,e,i,r,!0),Dg(t,e,i,r,!1))}(t,e,i,r,this.style.placement.variableOffsets,n):(t=>"circle"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:a}=n,s=i.paint.get("circle-opacity"),o=i.paint.get("circle-stroke-width"),l=i.paint.get("circle-stroke-opacity"),c=!i.layout.get("circle-sort-key").isConstant();if(0===s.constantOr(1)&&(0===o.constantOr(1)||0===l.constantOr(1)))return;const h=t.context,u=h.gl,d=t.transform,p=t.getDepthModeForSublayer(0,Pm.ReadOnly),f=Sm.disabled,m=t.colorModeForRenderPass(),_=[],g=d.getCircleRadiusCorrection();for(let n=0;n<r.length;n++){const s=r[n],o=e.getTile(s),l=o.getBucket(i);if(!l)continue;const h=st(d,o,i.paint.get("circle-translate"),i.paint.get("circle-translate-anchor")),u=l.programConfigurations.get(i.id),p=t.useProgram("circle",u),f=l.layoutVertexBuffer,m=l.indexBuffer,y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(s),x={programConfiguration:u,program:p,layoutVertexBuffer:f,indexBuffer:m,uniformValues:g_(t,o,i,h,g),terrainData:y,projectionData:d.getProjectionData({overscaledTileID:s,applyGlobeMatrix:!a,applyTerrainMatrix:!0})};if(c){const t=l.segments.get();for(const e of t)_.push({segments:new ul([e]),sortKey:e.sortKey,state:x})}else _.push({segments:l.segments,sortKey:0,state:x})}c&&_.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of _){const{programConfiguration:r,program:n,layoutVertexBuffer:a,indexBuffer:s,uniformValues:o,terrainData:l,projectionData:c}=e.state;n.draw(h,u.TRIANGLES,p,f,m,Tm.backCCW,o,l,c,i.id,a,s,e.segments,i.paint,t.transform.zoom,r)}}(t,e,i,r,n):(t=>"heatmap"===t.type)(i)?function(t,e,i,r,n){if(0===i.paint.get("heatmap-opacity"))return;const a=t.context,{isRenderingToTexture:s,isRenderingGlobe:o}=n;if(t.style.map.terrain){for(const n of r){const r=e.getTile(n);e.hasRenderableParent(n)||("offscreen"===t.renderPass?Vg(t,r,i,n,o):"translucent"===t.renderPass&&Ng(t,i,n,s,o))}a.viewport.set([0,0,t.width,t.height])}else"offscreen"===t.renderPass?function(t,e,i,r){const n=t.context,a=n.gl,s=t.transform,o=Sm.disabled,l=new bm([a.ONE,a.ONE],Ri.transparent,[!0,!0,!0,!0]);(function(t,e,i){const r=t.gl;t.activeTexture.set(r.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let n=i.heatmapFbos.get(Fc);n?(r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),t.bindFramebuffer.set(n.framebuffer)):(n=Ug(t,e.width/4,e.height/4),i.heatmapFbos.set(Fc,n))})(n,t,i),n.clear({color:Ri.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(e.hasRenderableParent(h))continue;const u=e.getTile(h),d=u.getBucket(i);if(!d)continue;const p=d.programConfigurations.get(i.id),f=t.useProgram("heatmap",p),m=s.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),_=s.getCircleRadiusCorrection();f.draw(n,a.TRIANGLES,Pm.disabled,o,l,Tm.backCCW,b_(u,s.zoom,i.paint.get("heatmap-intensity"),_),null,m,i.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,i.paint,s.zoom,p)}n.viewport.set([0,0,t.width,t.height])}(t,e,i,r):"translucent"===t.renderPass&&function(t,e){const i=t.context,r=i.gl;i.setColorMode(t.colorModeForRenderPass());const n=e.heatmapFbos.get(Fc);n&&(i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1),Zg(i,e).bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(i,r.TRIANGLES,Pm.disabled,Sm.disabled,t.colorModeForRenderPass(),Tm.disabled,w_(t,e,0,1),null,null,e.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,e.paint,t.transform.zoom))}(t,i)}(t,e,i,r,n):(t=>"line"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:a}=n,s=i.paint.get("line-opacity"),o=i.paint.get("line-width");if(0===s.constantOr(1)||0===o.constantOr(1))return;const l=t.getDepthModeForSublayer(0,Pm.ReadOnly),c=t.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=h.constantOr(1),d=i.paint.get("line-pattern"),p=d.constantOr(1),f=i.paint.get("line-gradient"),m=i.getCrossfadeParameters();let _;_=p?"linePattern":u&&f?"lineGradientSDF":u?"lineSDF":f?"lineGradient":"line";const g=t.context,y=g.gl,x=t.transform;let v=!0;for(const n of r){const r=e.getTile(n);if(p&&!r.patternsLoaded())continue;const s=r.getBucket(i);if(!s)continue;const o=s.programConfigurations.get(i.id),b=t.context.program.get(),w=t.useProgram(_,o),T=v||w.program!==b,P=t.style.map.terrain&&t.style.map.terrain.getTerrainData(n),M=d.constantOr(null),S=h&&h.constantOr(null);if(M&&r.imageAtlas){const t=r.imageAtlas,e=t.patternPositions[M.to.toString()],i=t.patternPositions[M.from.toString()];e&&i&&o.setConstantPatternPositions(e,i)}else if(S){const e="round"===i.layout.get("line-cap"),r=t.lineAtlas.getDash(S.to,e),n=t.lineAtlas.getDash(S.from,e);o.setConstantDashPositions(r,n)}const I=x.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),C=x.getPixelScale();let A;p?(A=A_(t,r,i,C,m),$g(g,y,r,o,m)):u&&f?(A=z_(t,r,i,C,m,s.lineClipsArray.length),Hg(t,e,g,y,i,s,n,o,m)):u?(A=E_(t,r,i,C,m),qg(t,g,y,o,T,m)):f?(A=C_(t,r,i,C,s.lineClipsArray.length),Wg(t,e,g,y,i,s,n)):A=I_(t,r,i,C);const E=t.stencilModeForClipping(n);w.draw(g,y.TRIANGLES,l,E,c,Tm.disabled,A,P,I,i.id,s.layoutVertexBuffer,s.indexBuffer,s.segments,i.paint,t.transform.zoom,o,s.layoutVertexBuffer2),v=!1}}(t,e,i,r,n):(t=>"fill"===t.type)(i)?function(t,e,i,r,n){const a=i.paint.get("fill-color"),s=i.paint.get("fill-opacity");if(0===s.constantOr(1))return;const{isRenderingToTexture:o}=n,l=t.colorModeForRenderPass(),c=i.paint.get("fill-pattern"),h=t.opaquePassEnabledForLayer()&&!c.constantOr(1)&&1===a.constantOr(Ri.transparent).a&&1===s.constantOr(0)?"opaque":"translucent";if(t.renderPass===h){const n=t.getDepthModeForSublayer(1,"opaque"===t.renderPass?Pm.ReadWrite:Pm.ReadOnly);Yg(t,e,i,r,n,l,!1,o)}if("translucent"===t.renderPass&&i.paint.get("fill-antialias")){const n=t.getDepthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,Pm.ReadOnly);Yg(t,e,i,r,n,l,!0,o)}}(t,e,i,r,n):(t=>"fill-extrusion"===t.type)(i)?function(t,e,i,r,n){const a=i.paint.get("fill-extrusion-opacity");if(0===a)return;const{isRenderingToTexture:s}=n;if("translucent"===t.renderPass){const n=new Pm(t.context.gl.LEQUAL,Pm.ReadWrite,t.depthRangeFor3D);if(1!==a||i.paint.get("fill-extrusion-pattern").constantOr(1))Kg(t,e,i,r,n,Sm.disabled,bm.disabled,s),Kg(t,e,i,r,n,t.stencilModeFor3D(),t.colorModeForRenderPass(),s);else{const a=t.colorModeForRenderPass();Kg(t,e,i,r,n,Sm.disabled,a,s)}}}(t,e,i,r,n):(t=>"hillshade"===t.type)(i)?function(t,e,i,r,n){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const{isRenderingToTexture:a}=n,s=t.context,o=t.style.projection.useSubdivision,l=t.getDepthModeForSublayer(0,Pm.ReadOnly),c=t.colorModeForRenderPass();if("offscreen"===t.renderPass)!function(t,e,i,r,n,a,s){const o=t.context,l=o.gl;for(const c of i){const i=e.getTile(c),h=i.dem;if(!h||!h.data)continue;if(!i.needsHillshadePrepare)continue;const u=h.dim,d=h.stride,p=h.getPixels();if(o.activeTexture.set(l.TEXTURE1),o.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(d),i.demTexture){const t=i.demTexture;t.update(p,{premultiply:!1}),t.bind(l.NEAREST,l.CLAMP_TO_EDGE)}else i.demTexture=new Zc(o,p,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);o.activeTexture.set(l.TEXTURE0);let f=i.fbo;if(!f){const t=new Zc(o,{width:u,height:u,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),f=i.fbo=o.createFramebuffer(u,u,!0,!1),f.colorAttachment.set(t.texture)}o.bindFramebuffer.set(f.framebuffer),o.viewport.set([0,0,u,u]),t.useProgram("hillshadePrepare").draw(o,l.TRIANGLES,n,a,s,Tm.disabled,P_(i.tileID,h),null,null,r.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1}}(t,e,r,i,l,Sm.disabled,c),s.viewport.set([0,0,t.width,t.height]);else if("translucent"===t.renderPass)if(o){const[n,s,o]=t.stencilConfigForOverlapTwoPass(r);Jg(t,e,i,o,n,l,c,!1,a),Jg(t,e,i,o,s,l,c,!0,a)}else{const[n,s]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Jg(t,e,i,s,n,l,c,!1,a)}}(t,e,i,r,n):(t=>"color-relief"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(!r.length)return;const{isRenderingToTexture:a}=n,s=t.style.projection.useSubdivision,o=t.getDepthModeForSublayer(0,Pm.ReadOnly),l=t.colorModeForRenderPass();if(s){const[n,s,c]=t.stencilConfigForOverlapTwoPass(r);Qg(t,e,i,c,n,o,l,!1,a),Qg(t,e,i,c,s,o,l,!0,a)}else{const[n,s]=t.getStencilConfigForOverlapAndUpdateStencilID(r);Qg(t,e,i,s,n,o,l,!1,a)}}(t,e,i,r,n):Qs(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const{isRenderingToTexture:a}=n,s=e.getSource(),o=t.style.projection.useSubdivision;if(s instanceof mp)ey(t,e,i,r,null,!1,!1,s.tileCoords,s.flippedWindingOrder,a);else if(o){const[n,s,o]=t.stencilConfigForOverlapTwoPass(r);ey(t,e,i,o,n,!1,!0,ty,!1,a),ey(t,e,i,o,s,!0,!0,ty,!1,a)}else{const[n,s]=t.getStencilConfigForOverlapAndUpdateStencilID(r);ey(t,e,i,s,n,!1,!0,ty,!1,a)}}(t,e,i,r,n):(t=>"background"===t.type)(i)?function(t,e,i,r,n){const a=i.paint.get("background-color"),s=i.paint.get("background-opacity");if(0===s)return;const{isRenderingToTexture:o}=n,l=t.context,c=l.gl,h=t.style.projection,u=t.transform,d=u.tileSize,p=i.paint.get("background-pattern");if(t.isPatternMissing(p))return;const f=!p&&1===a.a&&1===s&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==f)return;const m=Sm.disabled,_=t.getDepthModeForSublayer(0,"opaque"===f?Pm.ReadWrite:Pm.ReadOnly),g=t.colorModeForRenderPass(),y=t.useProgram(p?"backgroundPattern":"background"),x=r||Gp(u,{tileSize:d,terrain:t.style.map.terrain});p&&(l.activeTexture.set(c.TEXTURE0),t.imageManager.bind(t.context));const v=i.getCrossfadeParameters();for(const e of x){const r=u.getProjectionData({overscaledTileID:e,applyGlobeMatrix:!o,applyTerrainMatrix:!0}),n=p?V_(s,t,p,{tileID:e,tileSize:d},v):j_(s,a),f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e),x=h.getMeshFromTileID(l,e.canonical,!1,!0,"raster");y.draw(l,c.TRIANGLES,_,m,g,Tm.backCCW,n,f,r,i.id,x.vertexBuffer,x.indexBuffer,x.segments)}}(t,0,i,r,n):(t=>"custom"===t.type)(i)&&function(t,e,i,r){const{isRenderingGlobe:n}=r,a=t.context,s=i.implementation,o=t.style.projection,l=t.transform,c=l.getProjectionDataForCustomLayer(n),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:o.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${o.shaderPreludeCode.vertexSource}`,define:o.shaderDefine},defaultProjectionData:c},u=s.renderingMode?s.renderingMode:"2d";if("offscreen"===t.renderPass){const e=s.prerender;e&&(t.setCustomLayerDefaults(),a.setColorMode(t.colorModeForRenderPass()),e.call(s,a.gl,h),a.setDirty(),t.setBaseState())}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),a.setColorMode(t.colorModeForRenderPass()),a.setStencilMode(Sm.disabled);const e="3d"===u?t.getDepthModeFor3D():t.getDepthModeForSublayer(0,Pm.ReadOnly);a.setDepthMode(e),s.render(a.gl,h),a.setDirty(),t.setBaseState(),a.bindFramebuffer.set(null)}}(t,0,i,n))}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t]}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return!1;if(!t.from||!t.to)return!0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return!e||!i}useProgram(t,e,i=!1,r=[]){this.cache=this.cache||{};const n=!!this.style.map.terrain,a=this.style.projection,s=i?im.projectionMercator:a.shaderPreludeCode,o=i?sm:a.shaderDefine,l=t+(e?e.cacheKey:"")+`/${i?om:a.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(n?"/terrain":"")+(r?`/${r.join("/")}`:"");return this.cache[l]||(this.cache[l]=new c_(this.context,im[t],e,U_[t],this._showOverdrawInspector,n,s,o,r)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Zc(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy()}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}function my(t,e){let i,r=!1,n=null,a=null;const s=()=>{n=null,r&&(t.apply(a,i),n=setTimeout(s,e),r=!1)};return(...t)=>(r=!0,a=this,i=t,n||s(),n)}class _y{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t)})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(!this._isValidHash(t))return!1;const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,t)},this._removeHash=()=>{const t=this._getCurrentHash();if(0===t.length)return;const e=t.join("/");let i=e;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${e}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let n=window.location.href.replace(/(#.+)?$/,r);n=n.replace("&&","&"),window.history.replaceState(window.history.state,null,n)},this._updateHash=my(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t)}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),a=Math.round(e.lng*n)/n,s=Math.round(e.lat*n)/n,o=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=t?`/${a}/${s}/${i}`:`${i}/${s}/${a}`,(o||l)&&(c+="/"+Math.round(10*o)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===t?(e=!0,`${r}=${c}`):i})).filter((t=>t));return e||i.push(`${t}=${c}`),`#${i.join("&")}`}return`#${c}`}_isValidHash(t){if(t.length<3||t.some(isNaN))return!1;try{new $d(+t[2],+t[1])}catch(t){return!1}const e=+t[0],i=+(t[3]||0),r=+(t[4]||0);return e>=this._map.getMinZoom()&&e<=this._map.getMaxZoom()&&i>=-180&&i<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const gy={linearity:.3,easing:yt(0,0,.3,1)},yy=wt({deceleration:2500,maxSpeed:1400},gy),xy=wt({deceleration:20,maxSpeed:1400},gy),vy=wt({deceleration:1e3,maxSpeed:360},gy),by=wt({deceleration:1e3,maxSpeed:90},gy),wy=wt({deceleration:1e3,maxSpeed:360},gy);class Ty{constructor(t){this._map=t,this.clear()}clear(){this._inertiaBuffer=[]}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:ie(),settings:t})}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=ie();for(;t.length>0&&e-t[0].time>160;)t.shift()}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const e={zoom:0,bearing:0,pitch:0,roll:0,pan:new a(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)e.zoom+=t.zoomDelta||0,e.bearing+=t.bearingDelta||0,e.pitch+=t.pitchDelta||0,e.roll+=t.rollDelta||0,t.panDelta&&e.pan._add(t.panDelta),t.around&&(e.around=t.around),t.pinchAround&&(e.pinchAround=t.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(e.pan.mag()){const n=My(e.pan.mag(),i,wt({},yy,t||{})),a=e.pan.mult(n.amount/e.pan.mag()),s=this._map.cameraHelper.handlePanInertia(a,this._map.transform);r.center=s.easingCenter,r.offset=s.easingOffset,Py(r,n)}if(e.zoom){const t=My(e.zoom,i,xy);r.zoom=this._map.transform.zoom+t.amount,Py(r,t)}if(e.bearing){const t=My(e.bearing,i,vy);r.bearing=this._map.transform.bearing+vt(t.amount,-179,179),Py(r,t)}if(e.pitch){const t=My(e.pitch,i,by);r.pitch=this._map.transform.pitch+t.amount,Py(r,t)}if(e.roll){const t=My(e.roll,i,wy);r.roll=this._map.transform.roll+vt(t.amount,-179,179),Py(r,t)}if(r.zoom||r.bearing){const t=void 0===e.pinchAround?e.around:e.pinchAround;r.around=t?this._map.unproject(t):this._map.getCenter()}return this.clear(),wt(r,{noMoveStart:!0})}}function Py(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing)}function My(t,e,i){const{maxSpeed:r,linearity:n,deceleration:a}=i,s=vt(t*n/(e/1e3),-r,r),o=Math.abs(s)/(a*n);return{easing:i.easing,duration:1e3*o,amount:s*(o/2)}}class Sy extends we{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i,r={}){i=i instanceof MouseEvent?i:new MouseEvent(t,i);const n=re.mousePos(e.getCanvas(),i);super(t,wt({point:n,lngLat:e.unproject(n),originalEvent:i},r)),this._defaultPrevented=!1,this.target=e}}class Iy extends we{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){const r="touchend"===t?i.changedTouches:i.touches,n=re.touchPos(e.getCanvasContainer(),r),s=n.map((t=>e.unproject(t))),o=n.reduce(((t,e,i,r)=>t.add(e.div(r.length))),new a(0,0));super(t,{points:n,point:o,lngLats:s,lngLat:e.unproject(o),originalEvent:i}),this._defaultPrevented=!1}}class Cy extends we{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1}}class Ay{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance}reset(){delete this._mousedownPos}wheel(t){return this._firePreventable(new Cy(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new Sy(t.type,this._map,t))}mouseup(t){this._map.fire(new Sy(t.type,this._map,t))}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new Sy(t.type,this._map,t))}dblclick(t){return this._firePreventable(new Sy(t.type,this._map,t))}mouseover(t){this._map.fire(new Sy(t.type,this._map,t))}mouseout(t){this._map.fire(new Sy(t.type,this._map,t))}touchstart(t){return this._firePreventable(new Iy(t.type,this._map,t))}touchmove(t){this._map.fire(new Iy(t.type,this._map,t))}touchend(t){this._map.fire(new Iy(t.type,this._map,t))}touchcancel(t){this._map.fire(new Iy(t.type,this._map,t))}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Ey{constructor(t){this._map=t}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent}mousemove(t){this._map.fire(new Sy(t.type,this._map,t))}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Sy("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new Sy(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class zy{constructor(t){this._map=t}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return{lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.screenPointToLocation(a.convert(t),this._map.terrain)}}class Dy{constructor(t,e){this._map=t,this._tr=new zy(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(re.disableDrag(),this._startPos=this._lastPos=e,this._active=!0)}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=re.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const n=Math.min(r.x,i.x),a=Math.max(r.x,i.x),s=Math.min(r.y,i.y),o=Math.max(r.y,i.y);re.setTransform(this._box,`translate(${n}px,${s}px)`),this._box.style.width=a-n+"px",this._box.style.height=o-s+"px"}mouseupWindow(t,e){if(!this._active)return;if(0!==t.button)return;const i=this._startPos,r=e;if(this.reset(),re.suppressClick(),i.x!==r.x||i.y!==r.y)return this._map.fire(new we("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(i,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t)}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t))}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(re.remove(this._box),this._box=null),re.enableDrag(),delete this._startPos,delete this._lastPos}_fireEvent(t,e){return this._map.fire(new we(t,{originalEvent:e}))}}function ky(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let r=0;r<t.length;r++)i[t[r].identifier]=e[r];return i}class Ry{constructor(t){this.reset(),this.numTouches=t.numTouches}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1}touchstart(t,e,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),i.length===this.numTouches&&(this.centroid=function(t){const e=new a(0,0);for(const i of t)e._add(i);return e.div(t.length)}(e),this.touches=ky(i,e)))}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const r=ky(i,e);for(const t in this.touches){const e=r[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0)}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class Ly{constructor(t){this.singleTap=new Ry(t),this.numTaps=t.numTaps,this.reset()}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset()}touchstart(t,e,i){this.singleTap.touchstart(t,e,i)}touchmove(t,e,i){this.singleTap.touchmove(t,e,i)}touchend(t,e,i){const r=this.singleTap.touchend(t,e,i);if(r){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class Fy{constructor(t){this._tr=new zy(t),this._zoomIn=new Ly({numTouches:1,numTaps:2}),this._zoomOut=new Ly({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i)}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i)}touchend(t,e,i){const r=this._zoomIn.touchend(t,e,i),n=this._zoomOut.touchend(t,e,i),a=this._tr;return r?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:a.zoom+1,around:a.unproject(r)},{originalEvent:t})}):n?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:a.zoom-1,around:a.unproject(n)},{originalEvent:t})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class By{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset()}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t)}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.rollDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=Array.isArray(e)?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0))}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const r=Array.isArray(e)?e[0]:e;return!this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&re.suppressClick(),this.reset(t))}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const Oy=0,jy=2,Vy={[Oy]:1,[jy]:2};class Ny{constructor(t){this._correctEvent=t.checkCorrectEvent}startMove(t){const e=re.mouseButton(t);this._eventButton=e}endMove(t){delete this._eventButton}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return!function(t,e){const i=Vy[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return re.mouseButton(t)===this._eventButton}}class Uy{constructor(){this._firstTouch=void 0}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier}endMove(t){delete this._firstTouch}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}class Zy{constructor(t=new Ny({checkCorrectEvent:()=>!0}),e=new Uy){this.mouseMoveStateManager=t,this.oneFingerTouchMoveStateManager=e}_executeRelevantHandler(t,e,i){return t instanceof MouseEvent?e(t):"undefined"!=typeof TouchEvent&&t instanceof TouchEvent?i(t):void 0}startMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.startMove(t)),(t=>this.oneFingerTouchMoveStateManager.startMove(t)))}endMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.endMove(t)),(t=>this.oneFingerTouchMoveStateManager.endMove(t)))}isValidStartEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidStartEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidStartEvent(t)))}isValidMoveEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidMoveEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(t)))}isValidEndEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidEndEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidEndEvent(t)))}}const Gy=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=t=>{t.preventDefault()}};class $y{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset()}reset(){this._active=!1,this._touches={},this._sum=new a(0,0)}_shouldBePrevented(t){return t<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active){if(!this._shouldBePrevented(i.length))return t.preventDefault(),this._calculateTransform(t,e,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",t)}}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&this._shouldBePrevented(i.length)&&this.reset()}touchcancel(){this.reset()}_calculateTransform(t,e,i){i.length>0&&(this._active=!0);const r=ky(i,e),n=new a(0,0),s=new a(0,0);let o=0;for(const t in r){const e=r[t],i=this._touches[t];i&&(n._add(e),s._add(e.sub(i)),o++,r[t]=e)}if(this._touches=r,this._shouldBePrevented(o)||!s.mag())return;const l=s.div(o);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(o),panDelta:l}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class qy{constructor(){this.reset()}reset(){this._active=!1,delete this._firstTwoTouches}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]))}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[r,n]=this._firstTwoTouches,a=Wy(i,e,r),s=Wy(i,e,n);if(!a||!s)return;const o=this._aroundCenter?null:a.add(s).div(2);return this._move([a,s],o,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[r,n]=this._firstTwoTouches,a=Wy(i,e,r),s=Wy(i,e,n);a&&s||(this._active&&re.suppressClick(),this.reset())}touchcancel(){this.reset()}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}}function Wy(t,e,i){for(let r=0;r<t.length;r++)if(t[r].identifier===i)return e[r]}function Hy(t,e){return Math.log(t/e)/Math.LN2}class Xy extends qy{reset(){super.reset(),delete this._distance,delete this._startDistance}_start(t){this._startDistance=this._distance=t[0].dist(t[1])}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Hy(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Hy(this._distance,i),pinchAround:e}}}function Yy(t,e){return 180*t.angleWith(e)/Math.PI}class Ky extends qy{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1])}_move(t,e,i){const r=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Yy(this._vector,r),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Yy(t,this._startVector);return Math.abs(i)<e}}function Jy(t){return Math.abs(t.y)>Math.abs(t.x)}class Qy extends qy{constructor(t){super(),this._currentTouchCount=0,this._map=t}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length}_start(t){this._lastPoints=t,Jy(t[0].sub(t[1]))&&(this._valid=!1)}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=t[0].sub(this._lastPoints[0]),n=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,n,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(r.y+n.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const r=t.mag()>=2,n=e.mag()>=2;if(!r&&!n)return;if(!r||!n)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const a=t.y>0==e.y>0;return Jy(t)&&Jy(e)&&a}}const tx={panStep:100,bearingStep:15,pitchStep:10};class ex{constructor(t){this._tr=new zy(t);const e=tx;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1}reset(){this._active=!1}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,r=0,n=0,a=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),n=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),n=1);break;case 38:t.shiftKey?r=1:(t.preventDefault(),a=-1);break;case 40:t.shiftKey?r=-1:(t.preventDefault(),a=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:s=>{const o=this._tr;s.easeTo({duration:300,easeId:"keyboardHandler",easing:ix,zoom:e?Math.round(o.zoom)+e*(t.shiftKey?2:1):o.zoom,bearing:o.bearing+i*this._bearingStep,pitch:o.pitch+r*this._pitchStep,offset:[-n*this._panStep,-a*this._panStep],center:o.center},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function ix(t){return t*(2-t)}const rx=4.000244140625,nx=1/450;class ax{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t)},this._map=t,this._tr=new zy(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=nx}setZoomRate(t){this._defaultZoomRate=t}setWheelZoomRate(t){this._wheelZoomRate=t}isEnabled(){return!!this._enabled}isActive(){return!!this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around)}disable(){this.isEnabled()&&(this._enabled=!1)}_shouldBePrevented(t){return!!this._map.cooperativeGestures.isEnabled()&&!(t.ctrlKey||this._map.cooperativeGestures.isBypassed(t))}wheel(t){if(!this.isEnabled())return;if(this._shouldBePrevented(t))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",t);let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=ie(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%rx==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault()}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=re.mousePos(this._map.getCanvas(),t),i=this._tr;this._aroundPoint=this._aroundCenter?i.transform.locationToScreenPoint($d.convert(i.center)):e,this._frameId||(this._frameId=!0,this._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const e=t.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=e),"number"==typeof this._targetZoom&&(this._targetZoom+=e)}if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>rx?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const r="number"!=typeof this._targetZoom?t.scale:St(this._targetZoom);this._targetZoom=t.constrain(t.getCameraLngLat(),It(r*i)).zoom,"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0}const e="number"!=typeof this._targetZoom?t.zoom:this._targetZoom,i=this._startZoom,r=this._easing;let n,a=!1;if("wheel"===this._type&&i&&r){const t=ie()-this._lastWheelEventTime,s=Math.min((t+5)/200,1),o=r(s);n=wr.number(i,e,o),s<1?this._frameId||(this._frameId=!0):a=!0}else n=e,a=!0;return this._active=!0,a&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout}),200)),this._lastExpectedZoom=n,{noInertia:!0,needsRenderFrame:!a,zoomDelta:n-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let e=xt;if(this._prevEase){const t=this._prevEase,i=(ie()-t.start)/t.duration,r=t.easing(i+.01)-t.easing(i),n=.27/Math.sqrt(r*r+1e-4)*.01;e=yt(n,Math.sqrt(.0729-n*n),.25,1)}return this._prevEase={start:ie(),duration:t,easing:e},e}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout)}}class sx{constructor(t,e){this._clickZoom=t,this._tapZoom=e}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class ox{constructor(t){this._tr=new zy(t),this.reset()}reset(){this._active=!1}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class lx{constructor(){this._tap=new Ly({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset()}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const r=e[0],n=t.timeStamp-this._tapTime<500,a=this._tapPoint.dist(r)<30;n&&a?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset()}else this._tap.touchstart(t,e,i)}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=e[0],n=r.y-this._swipePoint.y;return this._swipePoint=r,t.preventDefault(),this._active=!0,{zoomDelta:n/128}}}else this._tap.touchmove(t,e,i)}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else{const r=this._tap.touchend(t,e,i);r&&(this._tapTime=t.timeStamp,this._tapPoint=r)}}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class cx{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class hx{constructor(t,e,i,r){this._pitchWithRotate=t.pitchWithRotate,this._rollEnabled=t.rollEnabled,this._mouseRotate=e,this._mousePitch=i,this._mouseRoll=r}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class ux{constructor(t,e,i,r){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}class dx{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1}isActive(){return!1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=re.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=e,this._container.appendChild(r);const n=document.createElement("div");n.className="maplibregl-mobile-message",n.textContent=i,this._container.appendChild(n),this._container.setAttribute("aria-hidden","true")}_destroyUI(){this._container&&(re.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container}enable(){this._setupUI(),this._enabled=!0}disable(){this._enabled=!1,this._destroyUI()}isEnabled(){return this._enabled}isBypassed(t){return t[this._bypassKey]}notifyGestureBlocked(t,e){this._enabled&&(this._map.fire(new we("cooperativegestureprevented",{gestureType:t,originalEvent:e})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show")}),100))}}const px=t=>t.zoom||t.drag||t.roll||t.pitch||t.rotate;class fx extends we{}function mx(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta||t.rollDelta}class _x{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`)},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,r={needsRenderFrame:!1},n={},a={};for(const{handlerName:l,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;if(this._blockedByActive(a,h,l))c.reset();else if(c[e||t.type]){if(o=t,Ht[e||t.type]&&(o instanceof MouseEvent||o instanceof WheelEvent)){const i=re.mousePos(this._map.getCanvas(),t);u=c[e||t.type](t,i)}else if(Xt(t,e||t.type)){const i=this._getMapTouches(t.touches),r=re.touchPos(this._map.getCanvas(),i);u=c[e||t.type](t,r,i)}else Wt[s=e||t.type]||Ht[s]||(u=c[e||t.type](t));this.mergeHandlerResult(r,n,u,l,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()}(u||c.isActive())&&(a[l]=c)}var s,o;const l={};for(const t in this._previousActiveHandlers)a[t]||(l[t]=i);this._previousActiveHandlers=a,(Object.keys(l).length||mx(r))&&(this._changes.push([r,n,l]),this._triggerRenderFrame()),(Object.keys(a).length||mx(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:c}=r;c&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],c(this._map))},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new Ty(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)re.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}destroy(){for(const[t,e,i]of this._listeners)re.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new Ay(e,t));const r=e.boxZoom=new Dy(e,t);this._add("boxZoom",r),t.interactive&&t.boxZoom&&r.enable();const n=e.cooperativeGestures=new dx(e,t.cooperativeGestures);this._add("cooperativeGestures",n),t.cooperativeGestures&&n.enable();const s=new Fy(e),o=new ox(e);e.doubleClickZoom=new sx(o,s),this._add("tapZoom",s),this._add("clickZoom",o),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const l=new lx;this._add("tapDragZoom",l);const c=e.touchPitch=new Qy(e);this._add("touchPitch",c),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const h=()=>e.project(e.getCenter()),u=function({enable:t,clickTolerance:e,aroundCenter:i=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:n=.8},s){const o=new Ny({checkCorrectEvent:t=>0===re.mouseButton(t)&&t.ctrlKey||2===re.mouseButton(t)&&!t.ctrlKey});return new By({clickTolerance:e,move:(t,e)=>{const o=s();if(i&&Math.abs(o.y-t.y)>r)return{bearingDelta:Gt(new a(t.x,e.y),e,o)};let l=(e.x-t.x)*n;return i&&e.y<o.y&&(l=-l),{bearingDelta:l}},moveStateManager:o,enable:t,assignEvents:Gy})}(t,h),d=function({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5}){const r=new Ny({checkCorrectEvent:t=>0===re.mouseButton(t)&&t.ctrlKey||2===re.mouseButton(t)});return new By({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:r,enable:t,assignEvents:Gy})}(t),p=function({enable:t,clickTolerance:e,rollDegreesPerPixelMoved:i=.3},r){const n=new Ny({checkCorrectEvent:t=>2===re.mouseButton(t)&&t.ctrlKey});return new By({clickTolerance:e,move:(t,e)=>{const n=r();let a=(e.x-t.x)*i;return e.y<n.y&&(a=-a),{rollDelta:a}},moveStateManager:n,enable:t,assignEvents:Gy})}(t,h);e.dragRotate=new hx(t,u,d,p),this._add("mouseRotate",u,["mousePitch"]),this._add("mousePitch",d,["mouseRotate","mouseRoll"]),this._add("mouseRoll",p,["mousePitch"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const f=function({enable:t,clickTolerance:e}){const i=new Ny({checkCorrectEvent:t=>0===re.mouseButton(t)&&!t.ctrlKey});return new By({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:Gy})}(t),m=new $y(t,e);e.dragPan=new cx(i,f,m),this._add("mousePan",f),this._add("touchPan",m,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const _=new Ky,g=new Xy;e.touchZoomRotate=new ux(i,g,_,l),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",g,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate),this._add("blockableMapEvent",new Ey(e));const y=e.scrollZoom=new ax(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",y,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const x=e.keyboard=new ex(e);this._add("keyboard",x),t.interactive&&t.keyboard&&e.keyboard.enable()}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[]}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return Boolean(px(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const r in t)if(r!==i&&(!e||e.indexOf(r)<0))return!0;return!1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,e,i,r,n){if(!i)return;wt(t,i);const a={handlerName:r,originalEvent:i.originalEvent||n};void 0!==i.zoomDelta&&(e.zoom=a),void 0!==i.panDelta&&(e.drag=a),void 0!==i.rollDelta&&(e.roll=a),void 0!==i.pitchDelta&&(e.pitch=a),void 0!==i.bearingDelta&&(e.rotate=a)}_applyChanges(){const t={},e={},i={};for(const[r,n,s]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new a(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(t.rollDelta=(t.rollDelta||0)+r.rollDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),wt(e,n),wt(i,s);this._updateMapTransform(t,e,i),this._changes=[]}_updateMapTransform(t,e,i){const r=this._map,n=r._getTransformForUpdate(),a=r.terrain;if(!(mx(t)||a&&this._terrainMovement))return this._fireEvents(e,i,!0);r._stop(!0);let{panDelta:s,zoomDelta:o,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:d}=t;void 0!==d&&(u=d),u=u||r.transform.centerPoint,a&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const p={panDelta:s,zoomDelta:o,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const f=u.distSqr(n.centerPoint)<.01?n.center:n.screenPointToLocation(s?u.sub(s):u);this._handleMapControls({terrain:a,tr:n,deltasForHelper:p,preZoomAroundLoc:f,combinedEventsInProgress:e,panDelta:s}),r._applyUpdatedTransform(n),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0)}_handleMapControls({terrain:t,tr:e,deltasForHelper:i,preZoomAroundLoc:r,combinedEventsInProgress:n,panDelta:a}){const s=this._map.cameraHelper;if(s.handleMapControlsRollPitchBearingZoom(i,e),t)return s.useGlobeControls?(this._terrainMovement||!n.drag&&!n.zoom||(this._terrainMovement=!0,this._map._elevationFreeze=!0),void s.handleMapControlsPan(i,e,r)):this._terrainMovement||!n.drag&&!n.zoom?void(n.drag&&this._terrainMovement&&a?e.setCenter(e.screenPointToLocation(e.centerPoint.sub(a))):s.handleMapControlsPan(i,e,r)):(this._terrainMovement=!0,this._map._elevationFreeze=!0,void s.handleMapControlsPan(i,e,r));s.handleMapControlsPan(i,e,r)}_fireEvents(t,e,i){const r=px(this._eventsInProgress),n=px(t),a={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(a[`${e}start`]=i),this._eventsInProgress[e]=t[e]}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const t in a)this._fireEvent(t,a[t]);n&&this._fireEvent("move",n.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i)}const s={};let o;for(const t in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[t];this._handlersById[i].isActive()||(delete this._eventsInProgress[t],o=e[i]||r,s[`${t}end`]=o)}for(const t in s)this._fireEvent(t,s[t]);const l=px(this._eventsInProgress),c=(r||n)&&!l;if(c&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const t=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&t.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(t)}if(i&&c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),e=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&te.prefersReducedMotion?(this._map.fire(new we("moveend",{originalEvent:o})),e(this._map.getBearing())&&this._map.resetNorth()):(e(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:o})),this._updatingCamera=!1}}_fireEvent(t,e){this._map.fire(new we(t,e?{originalEvent:e}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new fx("renderFrame",{timeStamp:t})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}class gx extends Pe{constructor(t,e,i){super(),this._renderFrameCallback=()=>{const t=Math.min((ie()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,this.cameraHelper=e,this.on("moveend",(()=>{delete this._requestedCameraState}))}migrateProjection(t,e){t.apply(this.transform),this.transform=t,this.cameraHelper=e}getCenter(){return new $d(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}getCenterElevation(){return this.transform.elevation}setCenterElevation(t,e){return this.jumpTo({elevation:t},e),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(t){this._centerClampedToGround=t}panBy(t,e,i){return t=a.convert(t).mult(-1),this.panTo(this.transform.center,wt({offset:t},e),i)}panTo(t,e,i){return this.easeTo(wt({center:t},e),i)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,e,i){return this.easeTo(wt({zoom:t},e),i)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(t,e){return t!=this.transform.fov&&(this.transform.setFov(t),this.fire(new we("movestart",e)).fire(new we("move",e)).fire(new we("moveend",e))),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,e,i){return this.easeTo(wt({bearing:t},e),i)}resetNorth(t,e){return this.rotateTo(0,wt({duration:1e3},t),e),this}resetNorthPitch(t,e){return this.easeTo(wt({bearing:0,pitch:0,roll:0,duration:1e3},t),e),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}getRoll(){return this.transform.roll}setRoll(t,e){return this.jumpTo({roll:t},e),this}cameraForBounds(t,e){t=qd.convert(t).adjustAntiMeridian();const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,e,i,r){const n={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=wt({padding:n,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const t=r.padding;r.padding={top:t,bottom:t,right:t,left:t}}const a=wt(n,r.padding);r.padding=a;const s=this.transform,o=new qd(t,e);return this.cameraHelper.cameraForBoxAndBearing(r,a,o,i,s)}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,e,i,r,n){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(a.convert(t)),this.transform.screenPointToLocation(a.convert(e)),i,r),r,n)}_fitInternal(t,e,i){return t?(delete(e=wt(t,e)).padding,e.linear?this.easeTo(e,i):this.flyTo(e,i)):this}jumpTo(t,e){this.stop();const i=this._getTransformForUpdate();let r=!1,n=!1,a=!1;const s=i.zoom;this.cameraHelper.handleJumpToCenterZoom(i,t);const o=i.zoom!==s;return"elevation"in t&&i.elevation!==+t.elevation&&i.setElevation(+t.elevation),"bearing"in t&&i.bearing!==+t.bearing&&(r=!0,i.setBearing(+t.bearing)),"pitch"in t&&i.pitch!==+t.pitch&&(n=!0,i.setPitch(+t.pitch)),"roll"in t&&i.roll!==+t.roll&&(a=!0,i.setRoll(+t.roll)),null==t.padding||i.isPaddingEqual(t.padding)||i.setPadding(t.padding),this._applyUpdatedTransform(i),this.fire(new we("movestart",e)).fire(new we("move",e)),o&&this.fire(new we("zoomstart",e)).fire(new we("zoom",e)).fire(new we("zoomend",e)),r&&this.fire(new we("rotatestart",e)).fire(new we("rotate",e)).fire(new we("rotateend",e)),n&&this.fire(new we("pitchstart",e)).fire(new we("pitch",e)).fire(new we("pitchend",e)),a&&this.fire(new we("rollstart",e)).fire(new we("roll",e)).fire(new we("rollend",e)),this.fire(new we("moveend",e))}calculateCameraOptionsFromTo(t,e,i,r=0){const n=ep.fromLngLat(t,e),a=ep.fromLngLat(i,r),s=a.x-n.x,o=a.y-n.y,l=a.z-n.z,c=Math.hypot(s,o,l);if(0===c)throw new Error("Can't calculate camera options with same From and To");const h=Math.hypot(s,o),u=It(this.transform.cameraToCenterDistance/c/this.transform.tileSize),d=180*Math.atan2(s,-o)/Math.PI;let p=180*Math.acos(h/c)/Math.PI;return p=l<0?90-p:90+p,{center:a.toLngLat(),elevation:r,zoom:u,pitch:p,bearing:d}}calculateCameraOptionsFromCameraLngLatAltRotation(t,e,i,r,n){const a=this.transform.calculateCenterFromCameraLngLatAlt(t,e,i,r);return{center:a.center,elevation:a.elevation,zoom:a.zoom,bearing:i,pitch:r,roll:n}}easeTo(t,e){this._stop(!1,t.easeId),(!1===(t=wt({offset:[0,0],duration:500,easing:xt},t)).animate||!t.essential&&te.prefersReducedMotion)&&(t.duration=0);const i=this._getTransformForUpdate(),r=this.getBearing(),n=i.pitch,s=i.roll,o="bearing"in t?this._normalizeBearing(t.bearing,r):r,l="pitch"in t?+t.pitch:n,c="roll"in t?this._normalizeBearing(t.roll,s):s,h="padding"in t?t.padding:i.padding,u=a.convert(t.offset);let d,p;t.around&&(d=$d.convert(t.around),p=i.locationToScreenPoint(d));const f={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},m=this.cameraHelper.handleEaseTo(i,{bearing:o,pitch:l,roll:c,padding:h,around:d,aroundPoint:p,offsetAsPoint:u,offset:t.offset,zoom:t.zoom,center:t.center});return this._rotating=this._rotating||r!==o,this._pitching=this._pitching||l!==n,this._rolling=this._rolling||c!==s,this._padding=!i.isPaddingEqual(h),this._zooming=this._zooming||m.isZooming,this._easeId=t.easeId,this._prepareEase(e,t.noMoveStart,f),this.terrain&&this._prepareElevation(m.elevationCenter),this._ease((r=>{m.easeFunc(r),this.terrain&&!t.freezeElevation&&this._updateElevation(r),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(i=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e,i)}),t),this}_prepareEase(t,e,i={}){this._moving=!0,e||i.moving||this.fire(new we("movestart",t)),this._zooming&&!i.zooming&&this.fire(new we("zoomstart",t)),this._rotating&&!i.rotating&&this.fire(new we("rotatestart",t)),this._pitching&&!i.pitching&&this.fire(new we("pitchstart",t)),this._rolling&&!i.rolling&&this.fire(new we("rollstart",t))}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0}_updateElevation(t){void 0!==this._elevationStart&&void 0!==this._elevationCenter||this._prepareElevation(this.transform.center),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const e=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&e!==this._elevationTarget){const i=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(i-(e-(i*t+this._elevationStart))/(1-t)),this._elevationTarget=e}this.transform.setElevation(wr.number(this._elevationStart,this._elevationTarget,t))}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain)}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(t){if(!this.terrain&&t.elevation>=0&&t.pitch<=90)return{};const e=t.getCameraLngLat(),i=t.getCameraAltitude(),r=this.terrain?this.terrain.getElevationForLngLatZoom(e,t.zoom):0;if(i<r){const i=this.calculateCameraOptionsFromTo(e,r,t.center,t.elevation);return{pitch:i.pitch,zoom:i.zoom}}return{}}_applyUpdatedTransform(t){const e=[];if(e.push((t=>this._elevateCameraIfInsideTerrain(t))),this.transformCameraUpdate&&e.push((t=>this.transformCameraUpdate(t))),!e.length)return;const i=t.clone();for(const t of e){const e=i.clone(),{center:r,zoom:n,roll:a,pitch:s,bearing:o,elevation:l}=t(e);r&&e.setCenter(r),void 0!==l&&e.setElevation(l),void 0!==n&&e.setZoom(n),void 0!==a&&e.setRoll(a),void 0!==s&&e.setPitch(s),void 0!==o&&e.setBearing(o),i.apply(e)}this.transform.apply(i)}_fireMoveEvents(t){this.fire(new we("move",t)),this._zooming&&this.fire(new we("zoom",t)),this._rotating&&this.fire(new we("rotate",t)),this._pitching&&this.fire(new we("pitch",t)),this._rolling&&this.fire(new we("roll",t))}_afterEase(t,e){if(this._easeId&&e&&this._easeId===e)return;delete this._easeId;const i=this._zooming,r=this._rotating,n=this._pitching,a=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,i&&this.fire(new we("zoomend",t)),r&&this.fire(new we("rotateend",t)),n&&this.fire(new we("pitchend",t)),a&&this.fire(new we("rollend",t)),this.fire(new we("moveend",t))}flyTo(t,e){if(!t.essential&&te.prefersReducedMotion){const i=Tt(t,["center","zoom","bearing","pitch","roll","elevation","padding"]);return this.jumpTo(i,e)}this.stop(),t=wt({offset:[0,0],speed:1.2,curve:1.42,easing:xt},t);const i=this._getTransformForUpdate(),r=i.bearing,n=i.pitch,s=i.roll,o=i.padding,l="bearing"in t?this._normalizeBearing(t.bearing,r):r,c="pitch"in t?+t.pitch:n,h="roll"in t?this._normalizeBearing(t.roll,s):s,u="padding"in t?t.padding:i.padding,d=a.convert(t.offset);let p=i.centerPoint.add(d);const f=i.screenPointToLocation(p),m=this.cameraHelper.handleFlyTo(i,{bearing:l,pitch:c,roll:h,padding:u,locationAtOffset:f,offsetAsPoint:d,center:t.center,minZoom:t.minZoom,zoom:t.zoom});let _=t.curve;const g=Math.max(i.width,i.height),y=g/m.scaleOfZoom,x=m.pixelPathLength;"number"==typeof m.scaleOfMinZoom&&(_=Math.sqrt(g/m.scaleOfMinZoom/x*2));const v=_*_;function b(t){const e=(y*y-g*g+(t?-1:1)*v*v*x*x)/(2*(t?y:g)*v*x);return Math.log(Math.sqrt(e*e+1)-e)}function w(t){return(Math.exp(t)-Math.exp(-t))/2}function T(t){return(Math.exp(t)+Math.exp(-t))/2}const P=b(!1);let M=function(t){return T(P)/T(P+_*t)},S=function(t){return g*((T(P)*(w(e=P+_*t)/T(e))-w(P))/v)/x;var e},I=(b(!0)-P)/_;if(Math.abs(x)<2e-6||!isFinite(I)){if(Math.abs(g-y)<1e-6)return this.easeTo(t,e);const i=y<g?-1:1;I=Math.abs(Math.log(y/g))/_,S=()=>0,M=t=>Math.exp(i*_*t)}return t.duration="duration"in t?+t.duration:1e3*I/("screenSpeed"in t?+t.screenSpeed/_:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=r!==l,this._pitching=c!==n,this._rolling=h!==s,this._padding=!i.isPaddingEqual(u),this._prepareEase(e,!1),this.terrain&&this._prepareElevation(m.targetCenter),this._ease((a=>{const f=a*I,_=1/M(f),g=S(f);this._rotating&&i.setBearing(wr.number(r,l,a)),this._pitching&&i.setPitch(wr.number(n,c,a)),this._rolling&&i.setRoll(wr.number(s,h,a)),this._padding&&(i.interpolatePadding(o,u,a),p=i.centerPoint.add(d)),m.easeFunc(a,_,g,p),this.terrain&&!t.freezeElevation&&this._updateElevation(a),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(()=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e)}),t),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(t,e){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e)}return t||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=ie(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_normalizeBearing(t,e){t=bt(t,-180,180);const i=Math.abs(t-e);return Math.abs(t-360-e)<i&&(t-=360),Math.abs(t+360-e)<i&&(t+=360),t}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom($d.convert(t),this.transform.tileZoom):null}}const yx={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class xx{constructor(t=yx){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")))},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions()},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"))},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show")},this.options=t}getDefaultPosition(){return"bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=re.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=re.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=re.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){re.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i)}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id}const e=this._map.style.tileManagers;for(const i in e){const r=e[i];if(r.used||r.usedForTerrain){const e=r.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution)}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let r=i+1;r<t.length;r++)if(t[r].indexOf(e)>=0)return!1;return!0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=re.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null)}}class vx{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact")}},this.options=t}getDefaultPosition(){return"bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=re.create("div","maplibregl-ctrl");const e=re.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){re.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0}}class bx{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}var wx;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(wx||(wx={}));let Tx=null,Px=[];const Mx=1e3/60,Sx="loadTime",Ix="fullLoadTime",Cx={mark(t){performance.mark(t)},frame(t){const e=t;null!=Tx&&Px.push(e-Tx),Tx=e},clearMetrics(){Tx=null,Px=[],performance.clearMeasures(Sx),performance.clearMeasures(Ix);for(const t in wx)performance.clearMarks(wx[t])},getPerformanceMetrics(){performance.measure(Sx,wx.create,wx.load),performance.measure(Ix,wx.create,wx.fullLoad);const t=performance.getEntriesByName(Sx)[0].duration,e=performance.getEntriesByName(Ix)[0].duration,i=Px.length,r=1/(Px.reduce(((t,e)=>t+e),0)/i/1e3),n=Px.filter((t=>t>Mx)).reduce(((t,e)=>t+(e-Mx)/Mx),0);return{loadTime:t,fullLoadTime:e,fps:r,percentDroppedFrames:n/(i+n)*100,totalFrames:i}}};var Ax=no([{name:"a_pos3d",type:"Int16",components:3}]);class Ex extends Pe{constructor(t){super(),this._lastTilesetChange=ie(),this.tileManager=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=t._source.tileSize*2**this.deltaZoom,t.usedForTerrain=!0,t.tileSize=this.tileSize}destruct(){this.tileManager.usedForTerrain=!1,this.tileManager.tileSize=null}getSource(){return this.tileManager._source}update(t,e){this.tileManager.update(t,e),this._renderableTilesKeys=[];const i={};for(const r of Gp(t,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:e,calculateTileZoom:this.tileManager._source.calculateTileZoom}))i[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),I(r.terrainRttPosMatrix32f,0,Q,Q,0,0,1),this._tiles[r.key]=new Ep(r,this.tileSize),this._lastTilesetChange=ie());for(const t in this._tiles)i[t]||delete this._tiles[t]}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[])}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t,e){return e?this._getTerrainCoordsForTileRanges(t,e):this._getTerrainCoordsForRegularTile(t)}_getTerrainCoordsForRegularTile(t){const e={};for(const i of this._renderableTilesKeys){const r=this._tiles[i].tileID,n=t.clone(),a=rt();if(r.canonical.equals(t.canonical))I(a,0,Q,Q,0,0,1);else if(r.canonical.isChildOf(t.canonical)){const e=r.canonical.z-t.canonical.z,i=r.canonical.x-(r.canonical.x>>e<<e),n=r.canonical.y-(r.canonical.y>>e<<e),s=Q>>e;I(a,0,s,s,0,0,1),b(a,a,[-i*s,-n*s,0])}else{if(!t.canonical.isChildOf(r.canonical))continue;{const e=t.canonical.z-r.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),n=t.canonical.y-(t.canonical.y>>e<<e),s=Q>>e;I(a,0,Q,Q,0,0,1),b(a,a,[i*s,n*s,0]),w(a,a,[1/2**e,1/2**e,0])}}n.terrainRttPosMatrix32f=new Float32Array(a),e[i]=n}return e}_getTerrainCoordsForTileRanges(t,e){const i={};for(const r of this._renderableTilesKeys){const n=this._tiles[r].tileID;if(!this._isWithinTileRanges(n,e))continue;const a=t.clone(),s=rt();if(n.canonical.z===t.canonical.z){const e=t.canonical.x-n.canonical.x,i=t.canonical.y-n.canonical.y;I(s,0,Q,Q,0,0,1),b(s,s,[e*Q,i*Q,0])}else if(n.canonical.z>t.canonical.z){const e=n.canonical.z-t.canonical.z,i=n.canonical.x-(n.canonical.x>>e<<e),r=n.canonical.y-(n.canonical.y>>e<<e),a=t.canonical.x-(n.canonical.x>>e),o=t.canonical.y-(n.canonical.y>>e),l=Q>>e;I(s,0,l,l,0,0,1),b(s,s,[-i*l+a*Q,-r*l+o*Q,0])}else{const e=t.canonical.z-n.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),r=t.canonical.y-(t.canonical.y>>e<<e),a=(t.canonical.x>>e)-n.canonical.x,o=(t.canonical.y>>e)-n.canonical.y,l=Q<<e;I(s,0,l,l,0,0,1),b(s,s,[i*Q+a*l,r*Q+o*l,0])}a.terrainRttPosMatrix32f=new Float32Array(s),i[r]=a}return i}getSourceTile(t,e){const i=this.tileManager._source;let r=t.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(r).key);let n=this.tileManager.getTileByID(this._sourceTileCache[t.key]);if((!n||!n.dem)&&e)for(;r>=i.minzoom&&(!n||!n.dem);)n=this.tileManager.getTileByID(t.scaledTo(r--).key);return n}anyTilesAfterTime(t=Date.now()){return this._lastTilesetChange>=t}_isWithinTileRanges(t,e){return e[t.canonical.z]&&t.canonical.x>=e[t.canonical.z].minTileX&&t.canonical.x<=e[t.canonical.z].maxTileX&&t.canonical.y>=e[t.canonical.z].minTileY&&t.canonical.y<=e[t.canonical.z].maxTileY}}class zx{constructor(t,e,i){this._meshCache={},this.painter=t,this.tileManager=new Ex(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024}getDEMElevation(t,e,i,r=8192){var n;if(!(e>=0&&e<r&&i>=0&&i<r))return 0;const a=this.getTerrainData(t),s=null===(n=a.tile)||void 0===n?void 0:n.dem;if(!s)return 0;const o=function(t,e,i){var r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t}([],[e/r*Q,i/r*Q],a.u_terrain_matrix),l=[o[0]*s.dim,o[1]*s.dim],c=Math.floor(l[0]),h=Math.floor(l[1]),u=l[0]-c,d=l[1]-h;return s.get(c,h)*(1-u)*(1-d)+s.get(c+1,h)*u*(1-d)+s.get(c,h+1)*(1-u)*d+s.get(c+1,h+1)*u*d}getElevationForLngLatZoom(t,e){if(!function(t,e){const{x:i,y:r}=ep.fromLngLat(e);return!(t<0||t>25||r<0||r>=1||i<0||i>=1)}(e,t.wrap()))return 0;const{tileID:i,mercatorX:r,mercatorY:n}=this._getOverscaledTileIDFromLngLatZoom(t,e);return this.getElevation(i,r%Q,n%Q,Q)}getElevation(t,e,i,r=8192){return this.getDEMElevation(t,e,i,r)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,e=new Rc({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new Zc(t,e,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new Zc(t,new Rc({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=y([])}const e=this.tileManager.getSourceTile(t,!0);if(e&&e.dem&&(!e.demTexture||e.needsTerrainPrepare)){const t=this.painter.context;e.demTexture=this.painter.getTileTexture(e.dem.stride),e.demTexture?e.demTexture.update(e.dem.getPixels(),{premultiply:!1}):e.demTexture=new Zc(t,e.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),e.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),e.needsTerrainPrepare=!1}const i=e&&e+e.tileID.key+t.key;if(i&&!this._demMatrixCache[i]){const i=this.tileManager.getSource().maxzoom;let a=t.canonical.z-e.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=i?a=t.canonical.z-i:kt("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const s=t.canonical.x-(t.canonical.x>>a<<a),o=t.canonical.y-(t.canonical.y>>a<<a),l=((r=new Float64Array(16))[0]=(n=[1/(Q<<a),1/(Q<<a),0])[0],r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=n[1],r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=n[2],r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r);b(l,l,[s*Q,o*Q,0]),this._demMatrixCache[t.key]={matrix:l,coord:t}}var r,n;return{u_depth:2,u_terrain:3,u_terrain_dim:e&&e.dem&&e.dem.dim||1,u_terrain_matrix:i?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:e&&e.dem&&e.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(e&&e.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:e}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,r=e.height/devicePixelRatio;return!this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new Zc(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new Zc(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const e=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,i=0;t<this._coordsTextureSize;t++)for(let r=0;r<this._coordsTextureSize;r++,i+=4)e[i+0]=255&r,e[i+1]=255&t,e[i+2]=r>>8<<4|t>>8,e[i+3]=0;const i=new Rc({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(e.buffer)),r=new Zc(t,i,t.gl.RGBA,{premultiply:!1});return r.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(t){this.painter.maybeDrawDepthAndCoords(!0);const e=new Uint8Array(4),i=this.painter.context,r=i.gl,n=Math.round(t.x*this.painter.pixelRatio/devicePixelRatio),a=Math.round(t.y*this.painter.pixelRatio/devicePixelRatio),s=Math.round(this.painter.height/devicePixelRatio);i.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(n,s-a-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null);const o=e[0]+(e[2]>>4<<8),l=e[1]+((15&e[2])<<8),c=this.coordsIndex[255-e[3]],h=c&&this.tileManager.getTileByID(c);if(!h)return null;const u=this._coordsTextureSize,d=(1<<h.tileID.canonical.z)*u;return new ep((h.tileID.canonical.x*u+o)/d+h.tileID.wrap,(h.tileID.canonical.y*u+l)/d,this.getElevation(h.tileID,o,l,u))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(t){var e;const i=(null===(e=this.painter.style.projection)||void 0===e?void 0:e.transitionState)>0,r=i&&0===t.canonical.y,n=i&&t.canonical.y===(1<<t.canonical.z)-1,a=`m_${r?"n":""}_${n?"s":""}`;if(this._meshCache[a])return this._meshCache[a];const s=this.painter.context,o=new Go,l=new sl,c=this.meshSize,h=Q/c,u=c*c;for(let t=0;t<=c;t++)for(let e=0;e<=c;e++)o.emplaceBack(e*h,t*h,0);for(let t=0;t<u;t+=c+1)for(let e=0;e<c;e++)l.emplaceBack(e+t,c+e+t+1,c+e+t+2),l.emplaceBack(e+t,c+e+t+2,e+t+1);const d=o.length,p=d+(c+1),f=(c+1)*c,m=r?Th:0,_=r?0:1,g=n?Ph:Q,y=n?0:1;for(let t=0;t<=c;t++)o.emplaceBack(t*h,m,_);for(let t=0;t<=c;t++)o.emplaceBack(t*h,g,y);for(let t=0;t<c;t++)l.emplaceBack(f+t,p+t,p+t+1),l.emplaceBack(f+t,p+t+1,f+t+1),l.emplaceBack(0+t,d+t+1,d+t),l.emplaceBack(0+t,0+t+1,d+t+1);const x=o.length,v=x+2*(c+1);for(const t of[0,1])for(let e=0;e<=c;e++)for(const i of[0,1])o.emplaceBack(t*Q,e*h,i);for(let t=0;t<2*c;t+=2)l.emplaceBack(x+t,x+t+1,x+t+3),l.emplaceBack(x+t,x+t+3,x+t+2),l.emplaceBack(v+t,v+t+3,v+t+1),l.emplaceBack(v+t,v+t+2,v+t+3);const b=new nm(s.createVertexBuffer(o,Ax.members),s.createIndexBuffer(l),ul.simpleSegment(0,0,o.length,l.length));return this._meshCache[a]=b,b}getMeshFrameDelta(t){return 2*Math.PI*Gd/Math.pow(2,Math.max(t,0))/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,e){const i=ep.fromLngLat(t.wrap()),r=(1<<e)*Q,n=i.x*r,a=i.y*r,s=Math.floor(n/Q),o=Math.floor(a/Q);return{tileID:new lp(e,0,e,s,o),mercatorX:n,mercatorY:a}}}class Dx{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy()}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new Zc(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id)}stampObject(t){t.stamp=++this._stamp}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1}freeAllObjects(){for(const t of this._objects)this.freeObject(t)}isFull(){return!(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const kx={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class Rx{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new Dx(t.context,30,e.tileManager.tileSize*e.qualityFactor)}destruct(){this.pool.destruct()}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.tileManager.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsAscending={};for(const e in t.tileManagers){this._coordsAscending[e]={};const i=t.tileManagers[e].getVisibleCoordinates(),r=t.tileManagers[e].getSource(),n=r instanceof mp?r.terrainTileRanges:null;for(const t of i){const i=this.terrain.tileManager.getTerrainCoords(t,n);for(const t in i)this._coordsAscending[e][t]||(this._coordsAscending[e][t]=[]),this._coordsAscending[e][t].push(i[t])}}this._coordsAscendingStr={};for(const e of t._order){const i=t._layers[e],r=i.source;if(kx[i.type]&&!this._coordsAscendingStr[r]){this._coordsAscendingStr[r]={};for(const t in this._coordsAscending[r])this._coordsAscendingStr[r][t]=this._coordsAscending[r][t].map((t=>t.key)).sort().join()}}for(const t of this._renderableTiles)for(const e in this._coordsAscendingStr){const i=this._coordsAscendingStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[])}}renderLayer(t,e){if(t.isHidden(this.painter.transform.zoom))return!1;const i=Object.assign(Object.assign({},e),{isRenderingToTexture:!0}),r=t.type,n=this.painter,a=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(kx[r]&&(this._prevType&&kx[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(t.id),!a))return!0;if(kx[this._prevType]||kx[r]&&a){this._prevType=r;const t=this._stacks.length-1,e=this._stacks[t]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(dy(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[t]){const e=this.pool.getObjectForId(r.rtt[t].id);if(e.stamp===r.rtt[t].stamp){this.pool.useObject(e);continue}}const a=this.pool.getOrCreateFreeObject();this.pool.useObject(a),this.pool.stampObject(a),r.rtt[t]={id:a.id,stamp:a.stamp},n.context.bindFramebuffer.set(a.fbo.framebuffer),n.context.clear({color:Ri.transparent,stencil:0}),n.currentStencilSource=void 0;for(let t=0;t<e.length;t++){const s=n.style._layers[e[t]],o=s.source?this._coordsAscending[s.source][r.tileID.key]:[r.tileID];n.context.viewport.set([0,0,a.fbo.width,a.fbo.height]),n._renderTileClippingMasks(s,o,!0),n.renderLayer(n,n.style.tileManagers[s.source],s,o,i),s.source&&(r.rttCoords[s.source]=this._coordsAscendingStr[s.source][r.tileID.key])}}return dy(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects(),kx[r]}return!1}}const Lx={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},Fx=r,Bx={hash:!1,interactive:!0,bearingSnap:7,attributionControl:yx,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:ne.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,transformConstrain:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0},Ox={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class jx{constructor(t,e,i=!1){this.mousedown=t=>{this.startMove(t,re.mousePos(this.element,t)),re.addEventListener(window,"mousemove",this.mousemove),re.addEventListener(window,"mouseup",this.mouseup)},this.mousemove=t=>{this.move(t,re.mousePos(this.element,t))},this.mouseup=t=>{this._rotatePitchHandler.dragEnd(t),this.offTemp()},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=re.touchPos(this.element,t.targetTouches)[0],this.startMove(t,this._startPos),re.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),re.addEventListener(window,"touchend",this.touchend))},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=re.touchPos(this.element,t.targetTouches)[0],this.move(t,this._lastPos))},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp()},this.reset=()=>{this._rotatePitchHandler.reset(),delete this._startPos,delete this._lastPos,this.offTemp()},this._clickTolerance=10,this.element=e;const r=new Zy;this._rotatePitchHandler=new By({clickTolerance:3,move:(t,r)=>{const n=e.getBoundingClientRect(),s=new a((n.bottom-n.top)/2,(n.right-n.left)/2);return{bearingDelta:Gt(new a(t.x,r.y),r,s),pitchDelta:i?-.5*(r.y-t.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=t,re.addEventListener(e,"mousedown",this.mousedown),re.addEventListener(e,"touchstart",this.touchstart,{passive:!1}),re.addEventListener(e,"touchcancel",this.reset)}startMove(t,e){this._rotatePitchHandler.dragStart(t,e),re.disableDrag()}move(t,e){const i=this.map,{bearingDelta:r,pitchDelta:n}=this._rotatePitchHandler.dragMove(t,e)||{};r&&i.setBearing(i.getBearing()+r),n&&i.setPitch(i.getPitch()+n)}off(){const t=this.element;re.removeEventListener(t,"mousedown",this.mousedown),re.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),re.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),re.removeEventListener(window,"touchend",this.touchend),re.removeEventListener(t,"touchcancel",this.reset),this.offTemp()}offTemp(){re.enableDrag(),re.removeEventListener(window,"mousemove",this.mousemove),re.removeEventListener(window,"mouseup",this.mouseup),re.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),re.removeEventListener(window,"touchend",this.touchend)}}let Vx;function Nx(t,e,i,r=!1){if(r||!i.getCoveringTilesDetailsProvider().allowWorldCopies())return null==t?void 0:t.wrap();const n=new $d(t.lng,t.lat);if(t=new $d(t.lng,t.lat),e){const r=new $d(t.lng-360,t.lat),n=new $d(t.lng+360,t.lat),a=i.locationToScreenPoint(t).distSqr(e);i.locationToScreenPoint(r).distSqr(e)<a?t=r:i.locationToScreenPoint(n).distSqr(e)<a&&(t=n)}for(;Math.abs(t.lng-i.center.lng)>180;){const e=i.locationToScreenPoint(t);if(e.x>=0&&e.y>=0&&e.x<=i.width&&e.y<=i.height)break;t.lng>i.center.lng?t.lng-=360:t.lng+=360}return t.lng!==n.lng&&i.isPointOnMapSurface(i.locationToScreenPoint(t))?t:n}const Ux={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Zx(t,e,i){const r=t.classList;for(const t in Ux)r.remove(`maplibregl-${i}-anchor-${t}`);r.add(`maplibregl-${i}-anchor-${e}`)}class Gx extends Pe{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup()},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup()},this._update=t=>{if(!this._map)return;const e=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!e)&&this._map.once("render",this._update),this._lngLat=Nx(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let r="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?r="rotateX(0deg)":"map"===this._pitchAlignment&&(r=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||t&&"moveend"!==t.type||(this._pos=this._pos.round()),re.setTransform(this._element,`${Ux[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${r} ${i}`),te.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type)})).catch((()=>{}))},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new we("dragstart"))),this.fire(new we("drag")))},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new we("dragend")),this._state="inactive"},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp))},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._subpixelPositioning=t&&t.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=a.convert(t&&t.offset||[0,0]);else{this._defaultMarker=!0,this._element=re.create("div");const e=re.createNS("http://www.w3.org/2000/svg","svg"),i=41,r=27;e.setAttributeNS(null,"display","block"),e.setAttributeNS(null,"height",`${i}px`),e.setAttributeNS(null,"width",`${r}px`),e.setAttributeNS(null,"viewBox",`0 0 ${r} ${i}`);const n=re.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const s=re.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const o=re.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"transform","translate(3.0, 29.0)"),o.setAttributeNS(null,"fill","#000000");const l=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of l){const e=re.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),o.appendChild(e)}const c=re.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const h=re.createNS("http://www.w3.org/2000/svg","path");h.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(h);const u=re.createNS("http://www.w3.org/2000/svg","g");u.setAttributeNS(null,"opacity","0.25"),u.setAttributeNS(null,"fill","#000000");const d=re.createNS("http://www.w3.org/2000/svg","path");d.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),u.appendChild(d);const p=re.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const f=re.createNS("http://www.w3.org/2000/svg","g");f.setAttributeNS(null,"transform","translate(8.0, 8.0)");const m=re.createNS("http://www.w3.org/2000/svg","circle");m.setAttributeNS(null,"fill","#000000"),m.setAttributeNS(null,"opacity","0.25"),m.setAttributeNS(null,"cx","5.5"),m.setAttributeNS(null,"cy","5.5"),m.setAttributeNS(null,"r","5.4999962");const _=re.createNS("http://www.w3.org/2000/svg","circle");_.setAttributeNS(null,"fill","#FFFFFF"),_.setAttributeNS(null,"cx","5.5"),_.setAttributeNS(null,"cy","5.5"),_.setAttributeNS(null,"r","5.4999962"),f.appendChild(m),f.appendChild(_),s.appendChild(o),s.appendChild(c),s.appendChild(u),s.appendChild(p),s.appendChild(f),e.appendChild(s),e.setAttributeNS(null,"height",i*this._scale+"px"),e.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(e),this._offset=a.convert(t&&t.offset||[0,-14])}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault()})),this._element.addEventListener("mousedown",(t=>{t.preventDefault()})),Zx(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null}addTo(t){return this.remove(),this._map=t,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",t._getUIString("Marker.Title")),this._element.hasAttribute("role")||this._element.setAttribute("role","button"),t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),t.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),re.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=$d.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[r,-1*(e-i+r)],"bottom-right":[-r,-1*(e-i+r)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress)}return this}setSubpixelPositioning(t){return this._subpixelPositioning=t,this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var e,i;const r=null===(e=this._map)||void 0===e?void 0:e.terrain,n=this._map.transform.isLocationOccluded(this._lngLat);if(!r||n){const t=n?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==t&&(this._element.style.opacity=t))}if(t)this._opacityTimeout=null;else{if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null}),100)}const s=this._map,o=s.terrain.depthAtPoint(this._pos),l=s.terrain.getElevationForLngLatZoom(this._lngLat,s.transform.tileZoom);if(s.transform.lngLatToCameraDepth(this._lngLat,l)-o<.006)return void(this._element.style.opacity=this._opacity);const c=-this._offset.y/s.transform.pixelsPerMeter,h=Math.sin(s.getPitch()*Math.PI/180)*c,u=s.terrain.depthAtPoint(new a(this._pos.x,this._pos.y-this._offset.y)),d=s.transform.lngLatToCameraDepth(this._lngLat,l+h)-u>.006;(null===(i=this._popup)||void 0===i?void 0:i.isOpen())&&d&&this._popup.remove(),this._element.style.opacity=d?this._opacityWhenCovered:this._opacity}getOffset(){return this._offset}setOffset(t){return this._offset=a.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t)}removeClassName(t){this._element.classList.remove(t)}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return(void 0===this._opacity||void 0===t&&void 0===e)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const $x={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let qx=0,Wx=!1;const Hx={maxWidth:100,unit:"metric"};function Xx(t,e,i){const r=i&&i.maxWidth||100,n=t._container.clientHeight/2,a=t._container.clientWidth/2,s=t.unproject([a-r/2,n]),o=t.unproject([a+r/2,n]),l=Math.round(t.project(o).x-t.project(s).x),c=Math.min(r,l,t._container.clientWidth),h=s.distanceTo(o);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?Yx(e,c,i/5280,t._getUIString("ScaleControl.Miles")):Yx(e,c,i,t._getUIString("ScaleControl.Feet"))}else i&&"nautical"===i.unit?Yx(e,c,h/1852,t._getUIString("ScaleControl.NauticalMiles")):h>=1e3?Yx(e,c,h/1e3,t._getUIString("ScaleControl.Kilometers")):Yx(e,c,h,t._getUIString("ScaleControl.Meters"))}function Yx(t,e,i,r){const n=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(n/i)+"px",t.innerHTML=`${n}&nbsp;${r}`}const Kx={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0},Jx=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Qx(t){if(t){if("number"==typeof t){const e=Math.round(Math.abs(t)/Math.SQRT2);return{center:new a(0,0),top:new a(0,t),"top-left":new a(e,e),"top-right":new a(-e,e),bottom:new a(0,-t),"bottom-left":new a(e,-e),"bottom-right":new a(-e,-e),left:new a(t,0),right:new a(-t,0)}}if(t instanceof a||Array.isArray(t)){const e=a.convert(t);return{center:e,top:e,"top-left":e,"top-right":e,bottom:e,"bottom-left":e,"bottom-right":e,left:e,right:e}}return{center:a.convert(t.center||[0,0]),top:a.convert(t.top||[0,0]),"top-left":a.convert(t["top-left"]||[0,0]),"top-right":a.convert(t["top-right"]||[0,0]),bottom:a.convert(t.bottom||[0,0]),"bottom-left":a.convert(t["bottom-left"]||[0,0]),"bottom-right":a.convert(t["bottom-right"]||[0,0]),left:a.convert(t.left||[0,0]),right:a.convert(t.right||[0,0])}}return Qx(new a(0,0))}const tv=r;t.AJAXError=oe,t.AttributionControl=xx,t.BoxZoomHandler=Dy,t.CanvasSource=gp,t.CooperativeGesturesHandler=dx,t.DoubleClickZoomHandler=sx,t.DragPanHandler=cx,t.DragRotateHandler=hx,t.EdgeInsets=cm,t.Event=we,t.Evented=Pe,t.FullscreenControl=class extends Pe{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange()},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen()},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:kt("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange")}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){re.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange)}_setupUI(){const t=this._fullscreenButton=re.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);re.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange)}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new we("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new we("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable())}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen()}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen()}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize()}},t.GeoJSONSource=pp,t.GeolocateControl=class extends Pe{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new we("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new we("geolocate",t)),this._finish()}},this._updateCamera=t=>{const e=new $d(t.coords.longitude,t.coords.latitude),i=t.coords.accuracy,r=wt({bearing:this._map.getBearing()},this.options.fitBoundsOptions),n=qd.fromLngLat(e,i);this._map.fitBounds(n,r,{geolocateSource:!0})},this._updateMarker=t=>{if(t){const e=new $d(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(e).addTo(this._map),this._userLocationDotMarker.setLngLat(e).addTo(this._map),this._accuracy=t.coords.accuracy,this._updateCircleRadiusIfNeeded()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()},this._onUpdate=()=>{this._updateCircleRadiusIfNeeded()},this._onError=t=>{if(this._map){if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===t.code&&Wx)return;this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new we("error",t)),this._finish()}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=re.create("button","maplibregl-ctrl-geolocate",this._container),re.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0)},this._finishSetupUI=t=>{if(this._map){if(!1===t){kt("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}else{const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=re.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new Gx({element:this._dotElement}),this._circleElement=re.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Gx({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onUpdate),this._map.on("move",this._onUpdate),this._map.on("rotate",this._onUpdate),this._map.on("pitch",this._onUpdate)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{const e=(null==t?void 0:t[0])instanceof ResizeObserverEntry;t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||e||this._map.isZooming()||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new we("trackuserlocationend")),this.fire(new we("userlocationlostfocus")))}))}},this.options=wt({},$x,t)}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return n(this,arguments,void 0,(function*(t=!1){if(void 0!==Vx&&!t)return Vx;if(void 0===window.navigator.permissions)return Vx=!!window.navigator.geolocation,Vx;try{const t=yield window.navigator.permissions.query({name:"geolocation"});Vx="denied"!==t.state}catch(t){Vx=!!window.navigator.geolocation}return Vx}))}().then((t=>this._finishSetupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),re.remove(this._container),this._map.off("zoom",this._onUpdate),this._map.off("move",this._onUpdate),this._map.off("rotate",this._onUpdate),this._map.off("pitch",this._onUpdate),this._map=void 0,qx=0,Wx=!1}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":case"BACKGROUND_ERROR":case"OFF":case void 0:break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadiusIfNeeded(){const t=this._userLocationDotMarker.getLngLat();if(!(this.options.showUserLocation&&this.options.showAccuracyCircle&&this._accuracy&&t))return;const e=this._map.project(t),i=this._map.unproject([e.x+100,e.y]),r=t.distanceTo(i)/100,n=2*this._accuracy/r;this._circleElement.style.width=`${n.toFixed(2)}px`,this._circleElement.style.height=`${n.toFixed(2)}px`}trigger(){if(!this._setup)return kt("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new we("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":qx--,Wx=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new we("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new we("trackuserlocationstart")),this.fire(new we("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),qx++,qx>1?(t={maximumAge:6e5,timeout:0},Wx=!0):(t=this.options.positionOptions,Wx=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t)}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},t.GlobeControl=class{constructor(){this._toggleProjection=()=>{var t;const e=null===(t=this._map.getProjection())||void 0===t?void 0:t.type;this._map.setProjection("mercator"!==e&&e?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon()},this._updateGlobeIcon=()=>{var t;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(t=this._map.getProjection())||void 0===t?void 0:t.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"))}}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=re.create("button","maplibregl-ctrl-globe",this._container),re.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){re.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0}},t.Hash=_y,t.ImageSource=mp,t.KeyboardHandler=ex,t.LngLat=$d,t.LngLatBounds=qd,t.LogoControl=vx,t.Map=class extends gx{constructor(t){var e,i;Cx.mark(wx.create);const r=Object.assign(Object.assign(Object.assign({},Bx),t),{canvasContextAttributes:Object.assign(Object.assign({},Bx.canvasContextAttributes),t.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const n=new _m,a=new vm;if(void 0!==r.minZoom&&n.setMinZoom(r.minZoom),void 0!==r.maxZoom&&n.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&n.setMinPitch(r.minPitch),void 0!==r.maxPitch&&n.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&n.setRenderWorldCopies(r.renderWorldCopies),null!==r.transformConstrain&&n.setConstrain(r.transformConstrain),super(n,a,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new bx,this._controls=[],this._mapId=Mt(),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new we("webglcontextlost",{originalEvent:t}))},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new we("webglcontextrestored",{originalEvent:t}))},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update()},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},Lx),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this.transformCameraUpdate=r.transformCameraUpdate,this.transformConstrain=r.transformConstrain,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=ye.addThrottleControl((()=>this.isMoving())),this._requestManager=new xe(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else{if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0)})),this.once("idle",(()=>{this._idleTriggered=!0})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=my((t=>{this._trackResize&&!this._removed&&(this.resize(t),this.redraw())}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0})),this._resizeObserver.observe(this._container)}this.handlers=new _x(this,r),this._hash=r.hash&&new _y("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,wt({},r.fitBoundsOptions,{duration:0}))));const s="string"==typeof r.style||!("globe"===(null===(i=null===(e=r.style)||void 0===e?void 0:e.projection)||void 0===i?void 0:i.type));this.resize(null,s),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new xx("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new vx,r.logoPosition),this.on("style.load",(()=>{if(s||this._resizeTransform(),this.transform.unmodified){const t=Tt(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(t)}})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new we(`${t.dataType}data`,t))})),this.on("dataloading",(t=>{this.fire(new we(`${t.dataType}dataloading`,t))})),this.on("dataabort",(t=>{this.fire(new we("sourcedataabort",t))}))}_getMapId(){return this._mapId}setGlobalStateProperty(t,e){return this.style.setGlobalStateProperty(t,e),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(t,e){if(void 0===e&&(e=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new Te(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[e];return-1!==e.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new Te(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const e=this._controls.indexOf(t);return e>-1&&this._controls.splice(e,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}coveringTiles(t){return Gp(this.transform,t)}calculateCameraOptionsFromTo(t,e,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,r)}resize(t,e=!0){const[i,r]=this._containerDimensions(),n=this._getClampedPixelRatio(i,r);if(this._resizeCanvas(i,r,n),this.painter.resize(i,r,n),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(i,r);this._resizeCanvas(i,r,e),this.painter.resize(i,r,e)}this._resizeTransform(e);const a=!this._moving;return a&&(this.stop(),this.fire(new we("movestart",t)).fire(new we("move",t))),this.fire(new we("resize",t)),a&&this.fire(new we("moveend",t)),this}_resizeTransform(t=!0){var e;const[i,r]=this._containerDimensions();this.transform.resize(i,r,t),null===(e=this._requestedCameraState)||void 0===e||e.resize(i,r,t)}_getClampedPixelRatio(t,e){const{0:i,1:r}=this._maxCanvasSize,n=this.getPixelRatio(),a=t*n,s=e*n;return Math.min(a>i?i/a:1,s>r?r/s:1)*n}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize()}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(qd.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.setMinZoom(t),this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.setMaxZoom(t),this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.setMinPitch(t),this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>180)throw new Error("maxPitch must be less than or equal to 180");if(t>=this.transform.minPitch)return this.transform.setMaxPitch(t),this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.setRenderWorldCopies(t),this._update()}setTransformConstrain(t){return this.transform.setConstrain(t),this._update()}project(t){return this.transform.locationToScreenPoint($d.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.screenPointToLocation(a.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let r=!1;const n=n=>{const a=e.filter((t=>this.getLayer(t))),s=0!==a.length?this.queryRenderedFeatures(n.point,{layers:a}):[];s.length?r||(r=!0,i.call(this,new Sy(t,this,n.originalEvent,{features:s}))):r=!1};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:()=>{r=!1}}}}if("mouseleave"===t||"mouseout"===t){let r=!1;const n=n=>{const a=e.filter((t=>this.getLayer(t)));(0!==a.length?this.queryRenderedFeatures(n.point,{layers:a}):[]).length?r=!0:r&&(r=!1,i.call(this,new Sy(t,this,n.originalEvent)))},a=e=>{r&&(r=!1,i.call(this,new Sy(t,this,e.originalEvent)))};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:a}}}{const r=t=>{const r=e.filter((t=>this.getLayer(t))),n=0!==r.length?this.queryRenderedFeatures(t.point,{layers:r}):[];n.length&&(t.features=n,i.call(this,t),delete t.features)};return{layers:e,listener:i,delegates:{[t]:r}}}}_saveDelegatedListener(t,e){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(e)}_removeDelegatedListener(t,e,i){if(!this._delegatedListeners||!this._delegatedListeners[t])return;const r=this._delegatedListeners[t];for(let t=0;t<r.length;t++){const n=r[t];if(n.listener===i&&n.layers.length===e.length&&n.layers.every((t=>e.includes(t)))){for(const t in n.delegates)this.off(t,n.delegates[t]);return void r.splice(t,1)}}}on(t,e,i){if(void 0===i)return super.on(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);this._saveDelegatedListener(t,n);for(const t in n.delegates)this.on(t,n.delegates[t]);return{unsubscribe:()=>{this._removeDelegatedListener(t,r,i)}}}once(t,e,i){if(void 0===i)return super.once(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);for(const e in n.delegates){const a=n.delegates[e];n.delegates[e]=(...e)=>{this._removeDelegatedListener(t,r,i),a(...e)}}this._saveDelegatedListener(t,n);for(const t in n.delegates)this.once(t,n.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._removeDelegatedListener(t,"string"==typeof e?[e]:e,i),this)}queryRenderedFeatures(t,e){if(!this.style)return[];let i;const r=t instanceof a||Array.isArray(t),n=r?t:[[0,0],[this.transform.width,this.transform.height]];if(e=e||(r?{}:t)||{},n instanceof a||"number"==typeof n[0])i=[a.convert(n)];else{const t=a.convert(n[0]),e=a.convert(n[1]);i=[t,new a(e.x,t.y),e,new a(t.x,e.y),t]}return this.style.queryRenderedFeatures(i,e,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,e){return!1!==(e=wt({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},e)).diff&&e.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,e),this):(this._localIdeographFontFamily=e.localIdeographFontFamily,this._updateStyle(t,e))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){var i,r;if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const n=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new r_(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,n):this.style.loadJSON(t,e,n),this):(null===(r=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===r||r.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new r_(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(t,e){if("string"==typeof t){const i=this._requestManager.transformRequest(t,"Style");he(i,new AbortController).then((t=>{this._updateDiff(t.data,e)})).catch((t=>{t&&this.fire(new Te(t))}))}else"object"==typeof t&&this._updateDiff(t,e)}_updateDiff(t,e){try{this.style.setState(t,e)&&this._update(!0)}catch(i){kt(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(t,e)}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():kt("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const e=this.style&&this.style.tileManagers[t];if(void 0!==e)return e.loaded();this.fire(new Te(new Error(`There is no tile manager with ID '${t}'`)))}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const e=this.style.tileManagers[t.source];if(!e)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&e.reload();for(const e in this.style._layers){const i=this.style._layers[e];"hillshade"===i.type&&i.source===t.source&&kt("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===i.type&&i.source===t.source&&kt("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.")}this.terrain=new zx(this.painter,e,t),this.painter.renderToTexture=new Rx(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=e=>{var i;"style"===e.dataType?this.terrain.tileManager.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=e.source)||void 0===i?void 0:i.type)?this.terrain.tileManager.freeRtt():this.terrain.tileManager.freeRtt(e.tile.tileID))},this.style.on("data",this._terrainDataCallback)}else this.terrain&&this.terrain.tileManager.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new we("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.tileManagers;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}}return!0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}setSourceTileLodParams(t,e,i){if(i){const r=this.getSource(i);if(!r)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);r.calculateTileZoom=Np(Math.max(1,t),Math.max(1,e))}else for(const i in this.style.tileManagers)this.style.tileManagers[i].getSource().calculateTileZoom=Np(Math.max(1,t),Math.max(1,e));return this._update(!0),this}refreshTiles(t,e){const i=this.style.tileManagers[t];if(!i)throw new Error(`There is no tile manager with ID "${t}", cannot refresh tile`);void 0===e?i.reload(!0):i.refreshTiles(e.map((t=>new sp(t.z,t.x,t.y))))}addImage(t,e,i={}){const{pixelRatio:r=1,sdf:n=!1,stretchX:a,stretchY:s,content:o,textFitWidth:l,textFitHeight:c}=i;if(this._lazyInitEmptyStyle(),!(e instanceof HTMLImageElement||Ot(e))){if(void 0===e.width||void 0===e.height)return this.fire(new Te(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:i,height:h,data:u}=e,d=e;return this.style.addImage(t,{data:new Rc({width:i,height:h},new Uint8Array(u)),pixelRatio:r,stretchX:a,stretchY:s,content:o,textFitWidth:l,textFitHeight:c,sdf:n,version:0,userImage:d}),d.onAdd&&d.onAdd(this,t),this}}{const{width:i,height:h,data:u}=te.getImageData(e);this.style.addImage(t,{data:new Rc({width:i,height:h},u),pixelRatio:r,stretchX:a,stretchY:s,content:o,textFitWidth:l,textFitHeight:c,sdf:n,version:0})}}updateImage(t,e){const i=this.style.getImage(t);if(!i)return this.fire(new Te(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=e instanceof HTMLImageElement||Ot(e)?te.getImageData(e):e,{width:n,height:a,data:s}=r;if(void 0===n||void 0===a)return this.fire(new Te(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(n!==i.data.width||a!==i.data.height)return this.fire(new Te(new Error("The width and height of the updated image must be that same as the previous version of the image")));const o=!(e instanceof HTMLImageElement||Ot(e));return i.data.replace(s,o),this.style.updateImage(t,i),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new Te(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t)}loadImage(t){return ye.getImage(this._requestManager.transformRequest(t,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,r={}){return this.style.setPaintProperty(t,e,i,r),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,r={}){return this.style.setLayoutProperty(t,e,i,r),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0)})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0)})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setSky(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSky(t,e),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=re.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=re.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const n=this._controlContainer=re.create("div","maplibregl-control-container",t),a=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{a[t]=re.create("div",`maplibregl-ctrl-${t} `,n)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`}_setupPainter(){const t=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type)}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,t):this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t),!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new fy(i,this.transform),de.testSupport(i)}migrateProjection(t,e){super.migrateProjection(t,e),this.painter.transform=t,this.fire(new we("projectiontransition",{newProjection:this.style.projection.name}))}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t)}_render(t){var e,i,r,n,a;const s=this._idleTriggered?this._fadeDuration:0,o=(null===(e=this.style.projection)||void 0===e?void 0:e.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let l=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,e=ie();this.style.zoomHistory.update(t,e);const i=new ks(t,{now:e,fadeDuration:s,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=i.crossFadingFactor();1===r&&r===this._crossFadingFactor||(l=!0,this._crossFadingFactor=r),this.style.update(i)}const c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0!==o;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(n=this.style.projection)||void 0===n?void 0:n.transitionState,null===(a=this.style.projection)||void 0===a?void 0:a.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||c)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.tileManager.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,s,this._crossSourceCollisions,c),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:s,showPadding:this.showPadding}),this.fire(new we("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,Cx.mark(wx.load),this.fire(new we("load"))),this.style&&(this.style.hasTransitions()||l)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const h=this._sourcesDirty||this._styleDirty||this._placementDirty;return h||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new we("idle")),!this._loaded||this._fullyLoaded||h||(this._fullyLoaded=!0,Cx.mark(wx.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),ye.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const e=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==e?void 0:e.loseContext)&&e.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),re.remove(this._canvasContainer),re.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),Cx.clearMetrics(),this._removed=!0,this.fire(new we("remove"))}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,te.frame(this._frameRequest,(t=>{Cx.frame(t),this._frameRequest=null;try{this._render(t)}catch(t){if(!function(t){return t.message===Yt}(t)&&!function(t){return t.message===Cg}(t))throw t}}),(()=>{})))}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update())}get showPadding(){return!!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update())}get repaint(){return!!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(t){this._vertices=t,this._update()}get version(){return Fx}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(t){return this._lazyInitEmptyStyle(),this.style.setProjection(t),this._update(!0)}},t.MapMouseEvent=Sy,t.MapTouchEvent=Iy,t.MapWheelEvent=Cy,t.Marker=Gx,t.MercatorCoordinate=ep,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString())},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i)},this.options=wt({},Ox,t),this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),re.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),re.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t})})),this._compassIcon=re.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new jx(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){re.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map}_createButton(t,e){const i=re.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Point=a,t.Popup=class extends Pe{constructor(t){super(),this._updateOpacity=()=>{void 0!==this.options.locationOccludedOpacity&&(this._container.style.opacity=this._map.transform.isLocationOccluded(this.getLngLat())?`${this.options.locationOccludedOpacity}`:"")},this.remove=()=>(this._content&&re.remove(this._content),this._container&&(re.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new we("close"))),this),this._onMouseUp=t=>{this._update(t.point)},this._onMouseMove=t=>{this._update(t.point)},this._onDrag=t=>{this._update(t.point)},this._update=t=>{if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=re.create("div","maplibregl-popup",this._map.getContainer()),this._tip=re.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer")}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=Nx(this._lngLat,this._flatPos,this._map.transform,this._trackPointer),this._trackPointer&&!t)return;const e=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationToScreenPoint(this._lngLat));let i=this.options.anchor;const r=Qx(this.options.offset);if(!i){const t=this._container.offsetWidth,n=this._container.offsetHeight;let a;a=e.y+r.bottom.y<n?["top"]:e.y>this._map.transform.height-n?["bottom"]:[],e.x<t/2?a.push("left"):e.x>this._map.transform.width-t/2&&a.push("right"),i=0===a.length?"bottom":a.join("-")}let n=e.add(r[i]);this.options.subpixelPositioning||(n=n.round()),re.setTransform(this._container,`${Ux[i]} translate(${n.x}px,${n.y}px)`),Zx(this._container,i,"popup"),this._updateOpacity()},this._onClose=()=>{this.remove()},this.options=wt(Object.create(Kx),t)}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new we("open")),this}isOpen(){return!!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=$d.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=t;r=i.firstChild,r;)e.appendChild(r);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=re.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){return this._container&&this._container.classList.add(t),this}removeClassName(t){return this._container&&this._container.classList.remove(t),this}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t}_createCloseButton(){this.options.closeButton&&(this._closeButton=re.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose))}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(Jx);t&&t.focus()}},t.RasterDEMTileSource=hp,t.RasterTileSource=np,t.ScaleControl=class{constructor(t){this._onMove=()=>{Xx(this._map,this._container,this.options)},this.setUnit=t=>{this.options.unit=t,Xx(this._map,this._container,this.options)},this.options=Object.assign(Object.assign({},Hx),t)}getDefaultPosition(){return"bottom-left"}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){re.remove(this._container),this._map.off("move",this._onMove),this._map=void 0}},t.ScrollZoomHandler=ax,t.Style=r_,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon()},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"))},this.options=t}onAdd(t){return this._map=t,this._container=re.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=re.create("button","maplibregl-ctrl-terrain",this._container),re.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){re.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0}},t.TwoFingersTouchPitchHandler=Qy,t.TwoFingersTouchRotateHandler=Ky,t.TwoFingersTouchZoomHandler=Xy,t.TwoFingersTouchZoomRotateHandler=ux,t.VectorTileSource=rp,t.VideoSource=_p,t.addProtocol=function(t,e){ne.REGISTERED_PROTOCOLS[t]=e},t.addSourceType=(t,e)=>n(void 0,void 0,void 0,(function*(){if(xp(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{yp[t]=e})(t,e)})),t.clearPrewarmedResources=function(){const t=Rd;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(zd),Rd=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},t.config=ne,t.createTileMesh=Em,t.getMaxParallelImageRequests=function(){return ne.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return Ip().getRTLTextPluginStatus()},t.getVersion=function(){return tv},t.getWorkerCount=function(){return Dd.workerCount},t.getWorkerUrl=function(){return ne.WORKER_URL},t.importScriptInWorkers=function(t){return Od().broadcast("IS",t)},t.isTimeFrozen=function(){return ee.isFrozen()},t.now=ie,t.prewarm=function(){Fd().acquire(zd)},t.removeProtocol=function(t){delete ne.REGISTERED_PROTOCOLS[t]},t.restoreNow=function(){ee.restoreNow()},t.setMaxParallelImageRequests=function(t){ne.MAX_PARALLEL_IMAGE_REQUESTS=t},t.setNow=function(t){ee.setNow(t)},t.setRTLTextPlugin=function(t,e){return Ip().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){Dd.workerCount=t},t.setWorkerUrl=function(t){ne.WORKER_URL=t}}));
//# sourceMappingURL=maplibre-gl-csp.js.map
