"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readFile = void 0;
exports.doesFileExist = doesFileExist;
exports.doesFolderExist = doesFolderExist;
exports.writeFileAsync = writeFileAsync;
const tslib_1 = require("tslib");
const promises_1 = tslib_1.__importDefault(require("fs/promises"));
const path_1 = require("path");
var promises_2 = require("fs/promises");
Object.defineProperty(exports, "readFile", { enumerable: true, get: function () { return promises_2.readFile; } });
const UTF8 = "utf-8";
function doesFileExist(path) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const stats = yield promises_1.default.stat(path);
            return stats.isFile();
        }
        catch (_a) {
            return false;
        }
    });
}
function doesFolderExist(path) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const stats = yield promises_1.default.stat(path);
            return stats.isDirectory();
        }
        catch (_a) {
            return false;
        }
    });
}
function writeFileAsync(filePath, content) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const directory = (0, path_1.dirname)(filePath);
        const directoryExists = yield doesFolderExist(directory);
        if (!directoryExists) {
            yield promises_1.default.mkdir(directory, { recursive: true });
        }
        return yield promises_1.default.writeFile(filePath, content, { encoding: UTF8 });
    });
}
//# sourceMappingURL=file.utils.js.map