export declare const lineEndings: readonly ["crlf", "lf"];
/**
 * Used to specify which line endings to use in the generated file.
 *
 * Possible values are:
 *
 * `crlf` (`\r\n`)
 *
 * `lf` (`\n`)
 */
export type LineEnding = (typeof lineEndings)[number];
declare const lineEndingsMap: {
    readonly crlf: "\r\n";
    readonly lf: "\n";
};
export type LineEndingCharacters = (typeof lineEndingsMap)[LineEnding];
export declare const lineEndingCharacters: ("\n" | "\r\n")[];
export declare const isLineEnding: (input: unknown) => input is LineEnding;
export declare const getLineEndingCharacters: (input: LineEnding | undefined) => LineEndingCharacters;
export {};
