"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveNotices = void 0;
const tslib_1 = require("tslib");
const glob_1 = require("glob");
const file_utils_1 = require("../../utils/file.utils");
const resolveNotices = (directory) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const noticeFiles = yield (0, glob_1.glob)("notice{,-*,.*}", {
        nocase: true,
        nodir: true,
        absolute: true,
        cwd: directory,
        maxDepth: 1,
    });
    if (noticeFiles.length === 0) {
        return [];
    }
    const contents = yield Promise.all(noticeFiles.map((f) => tslib_1.__awaiter(void 0, void 0, void 0, function* () { return yield (0, file_utils_1.readFile)(f, { encoding: "utf-8" }); })));
    return contents;
});
exports.resolveNotices = resolveNotices;
//# sourceMappingURL=index.js.map