"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveLicenses = void 0;
const tslib_1 = require("tslib");
const resolveDependencies_1 = require("./resolveDependencies");
const resolveLicenses = (packageJsons, options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const licensesMap = new Map();
    for (const packageJson of packageJsons) {
        yield (0, resolveDependencies_1.resolveDependencies)(packageJson, licensesMap, options);
    }
    return Array.from(licensesMap.values());
});
exports.resolveLicenses = resolveLicenses;
//# sourceMappingURL=resolveLicenses.js.map