"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveLicenseContent = void 0;
const tslib_1 = require("tslib");
const licenseFile_1 = require("./licenseFile");
const packageJsonLicense_1 = require("./packageJsonLicense");
const replacementFile_1 = require("./replacementFile");
const replacementHttp_1 = require("./replacementHttp");
const spdxExpression_1 = require("./spdxExpression");
const resolutions = [packageJsonLicense_1.packageJsonLicense, licenseFile_1.licenseFile, spdxExpression_1.spdxExpression];
const replacementResolutions = [replacementHttp_1.replacementHttp, replacementFile_1.replacementFile];
const resolveLicenseContent = (directory, packageJson, replacements) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const replacementPath = replacements[`${packageJson.name}@${packageJson.version}`] ||
        replacements[`${packageJson.name}`];
    if (replacementPath) {
        return runReplacementResolutions(replacementPath, packageJson);
    }
    const resolutionInputs = { directory, packageJson };
    return runResolutions(resolutionInputs, packageJson);
});
exports.resolveLicenseContent = resolveLicenseContent;
const runReplacementResolutions = (replacementPath, packageJson) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    for (const resolution of replacementResolutions) {
        const result = yield resolution(replacementPath);
        if (result) {
            return result;
        }
    }
    throw new Error(`Could not find replacement content at ${replacementPath} for ${packageJson.name}@${packageJson.version}`);
});
const runResolutions = (inputs, packageJson) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    for (const resolution of resolutions) {
        const result = yield resolution(inputs);
        if (result) {
            return result;
        }
    }
    throw new Error(`Could not find license content for ${packageJson.name}@${packageJson.version}`);
});
//# sourceMappingURL=index.js.map