"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveDependencies = void 0;
const tslib_1 = require("tslib");
const path_1 = require("path");
const file_utils_1 = require("../../utils/file.utils");
const resolveNpmDependencies_1 = require("./resolveNpmDependencies");
const resolvePnpmDependencies_1 = require("./resolvePnpmDependencies");
const resolveDependencies = (packageJson, licensesMap, options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const packageManager = yield resolvePackageManager(packageJson);
    switch (packageManager) {
        case "npm":
            yield (0, resolveNpmDependencies_1.resolveDependenciesForNpmProject)(packageJson, licensesMap, options);
            break;
        case "pnpm":
            yield (0, resolvePnpmDependencies_1.resolveDependenciesForPnpmProject)(packageJson, licensesMap, options);
            break;
        // istanbul ignore next
        default: {
            const _exhaustiveCheck = packageManager;
            throw new Error(`Unknown package manager: ${packageManager}`);
        }
    }
});
exports.resolveDependencies = resolveDependencies;
const resolvePackageManager = (packageJson) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const directory = (0, path_1.dirname)(packageJson);
    const potentialPnpmLockFile = (0, path_1.join)(directory, "pnpm-lock.yaml");
    if (yield (0, file_utils_1.doesFileExist)(potentialPnpmLockFile)) {
        return "pnpm";
    }
    return "npm";
});
//# sourceMappingURL=index.js.map