import { ILicense } from "./models/license";
import { ExcludeOption } from "./options/exclude";
import { OmitVersionsOption } from "./options/omitVersions";
import { IntersectionExpander } from "./options/optionsExpander";
import { ReplaceOption } from "./options/replace";
export type GetProjectLicensesOptions = IntersectionExpander<ReplaceOption & ExcludeOption & OmitVersionsOption>;
/**
 * Scans the project found at the given path and returns an array of objects each
 * containing the details of an identified license and the dependencies it pertains to.
 * @param pathToPackageJson A path to the package.json for the project
 * @param options Additional options for the license discovery
 * @returns Array of `ILicense`s each containing the license content and respective dependencies
 */
export declare function getProjectLicenses(pathToPackageJson: string, options?: GetProjectLicensesOptions): Promise<ILicense[]>;
