"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLicenseFileText = getLicenseFileText;
const tslib_1 = require("tslib");
const resolveLicenses_1 = require("./internal/resolveLicenses");
const lineEndings_1 = require("./lineEndings");
const license_1 = require("./models/license");
const file_utils_1 = require("./utils/file.utils");
const string_utils_1 = require("./utils/string.utils");
const SUFFIX = "-----------";
const CREDIT1 = "This file was generated with the generate-license-file npm package!";
const CREDIT2 = "https://www.npmjs.com/package/generate-license-file";
function getLicenseFileText(pathsToPackageJsons, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        var _a;
        if (typeof pathsToPackageJsons === "string") {
            pathsToPackageJsons = [pathsToPackageJsons];
        }
        const EOL = (0, lineEndings_1.getLineEndingCharacters)(options === null || options === void 0 ? void 0 : options.lineEnding);
        const credit = getCredit(EOL);
        const licenses = yield (0, resolveLicenses_1.resolveLicenses)(pathsToPackageJsons, options);
        const sortedLicenses = licenses.sort((a, b) => a.licenseContent.localeCompare(b.licenseContent));
        let licenseFile = credit + EOL + EOL;
        for (const resolvedLicense of sortedLicenses) {
            const dependencies = resolvedLicense.dependencies.map(dep => {
                var _a;
                if (options === null || options === void 0 ? void 0 : options.omitVersions) {
                    return dep.name;
                }
                return `${dep.name}@${(_a = dep.version) !== null && _a !== void 0 ? _a : "unknown"}`;
            });
            const license = new license_1.License(resolvedLicense.licenseContent, resolvedLicense.notices, dependencies);
            licenseFile += license.format(EOL) + EOL + EOL + SUFFIX + EOL + EOL;
        }
        for (const appendixFilePath of (_a = options === null || options === void 0 ? void 0 : options.append) !== null && _a !== void 0 ? _a : []) {
            const appendixContent = yield (0, file_utils_1.readFile)(appendixFilePath, { encoding: "utf-8" });
            const formattedAppendixContent = (0, string_utils_1.prepareContentForOutput)(appendixContent, EOL);
            licenseFile += formattedAppendixContent + EOL + EOL + SUFFIX + EOL + EOL;
        }
        licenseFile += credit + EOL;
        return licenseFile;
    });
}
const getCredit = (EOL) => CREDIT1 + EOL + CREDIT2;
//# sourceMappingURL=getLicenseFileText.js.map