import { AppendOption } from "./options/append";
import { ExcludeOption } from "./options/exclude";
import { LineEndingOption } from "./options/lineEnding";
import { OmitVersionsOption } from "./options/omitVersions";
import { IntersectionExpander } from "./options/optionsExpander";
import { ReplaceOption } from "./options/replace";
export type GetLicenseFileTextOptions = IntersectionExpander<LineEndingOption & ReplaceOption & ExcludeOption & AppendOption & OmitVersionsOption>;
/**
 * Scans the project found at the given path and returns a string containing the licenses for all of the dependencies
 * @param pathToPackageJson A path to the package.json for the project
 * @param options Additional options for the license text generation
 * @returns A promise that resolves to the license file text
 */
export declare function getLicenseFileText(pathToPackageJson: string, options?: GetLicenseFileTextOptions): Promise<string>;
/**
 * Scans the projects found at the given paths and returns a string containing the licenses for all the dependencies across all the projects
 * @param pathsToPackageJsons Paths to the package.jsons for the projects
 * @param options Additional options for the license text generation
 * @returns A promise that resolves to the license file text
 */
export declare function getLicenseFileText(pathsToPackageJsons: string[], options?: GetLicenseFileTextOptions): Promise<string>;
