import { z } from "zod";
export declare const configSchema: z.ZodOptional<z.ZodObject<{
    inputs: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    output: z.ZodOptional<z.ZodString>;
    overwrite: z.ZodEffects<z.ZodOptional<z.ZodBoolean>, true | undefined, boolean | undefined>;
    spinner: z.ZodOptional<z.ZodBoolean>;
    ci: z.ZodOptional<z.ZodBoolean>;
    eol: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"crlf">, z.ZodLiteral<"lf">]>>;
    replace: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    exclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    append: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    spinner?: boolean | undefined;
    replace?: Record<string, string> | undefined;
    exclude?: string[] | undefined;
    append?: string[] | undefined;
    eol?: "crlf" | "lf" | undefined;
    inputs?: string[] | undefined;
    output?: string | undefined;
    overwrite?: true | undefined;
    ci?: boolean | undefined;
}, {
    spinner?: boolean | undefined;
    replace?: Record<string, string> | undefined;
    exclude?: string[] | undefined;
    append?: string[] | undefined;
    eol?: "crlf" | "lf" | undefined;
    inputs?: string[] | undefined;
    output?: string | undefined;
    overwrite?: boolean | undefined;
    ci?: boolean | undefined;
}>>;
export type ConfigSchema = z.infer<typeof configSchema>;
export declare const parseSchema: (input: unknown) => ConfigSchema;
