"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findConfig = exports.loadConfig = void 0;
const tslib_1 = require("tslib");
const cosmiconfig_1 = require("cosmiconfig");
const json5_1 = require("./parsers/json5");
const json5Loader = (_filepath, content) => (0, json5_1.json5Parse)(content);
const loadConfig = (filePath) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const options = {
        loaders: {
            ".json": json5Loader,
            ".jsonc": json5Loader,
            ".json5": json5Loader,
        },
    };
    const explorer = (0, cosmiconfig_1.cosmiconfig)("generate-license-file", options);
    const result = yield explorer.load(filePath);
    if (result !== null && !(result === null || result === void 0 ? void 0 : result.isEmpty)) {
        return {
            path: result.filepath,
            config: result.config,
        };
    }
    return;
});
exports.loadConfig = loadConfig;
const moduleNames = ["glf", "glfrc", "generatelicensefile", "generatelicensefilerc"];
const generateSearchPlaces = (moduleName) => [
    `.${moduleName}`,
    `.${moduleName}.json`,
    `.${moduleName}.jsonc`,
    `.${moduleName}.json5`,
    `.${moduleName}.yaml`,
    `.${moduleName}.yml`,
    `.${moduleName}.js`,
    `.${moduleName}.cjs`,
    `.config/${moduleName}`,
    `.config/${moduleName}.json`,
    `.config/${moduleName}.jsonc`,
    `.config/${moduleName}.json5`,
    `.config/${moduleName}.yaml`,
    `.config/${moduleName}.yml`,
    `.config/${moduleName}.js`,
    `.config/${moduleName}.cjs`,
    `${moduleName}.config.js`,
    `${moduleName}.config.cjs`,
];
const searchPlaces = ["package.json"];
for (const moduleName of moduleNames) {
    searchPlaces.push(...generateSearchPlaces(moduleName));
}
const findConfig = (directory) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const options = {
        stopDir: directory,
        loaders: {
            ".json": json5Loader,
            ".jsonc": json5Loader,
            ".json5": json5Loader,
        },
        searchPlaces,
    };
    const explorer = (0, cosmiconfig_1.cosmiconfig)("generate-license-file", options);
    const result = yield explorer.search(directory);
    if (result !== null && !(result === null || result === void 0 ? void 0 : result.isEmpty)) {
        return {
            path: result.filepath,
            config: result.config,
        };
    }
    return;
});
exports.findConfig = findConfig;
//# sourceMappingURL=configFile.js.map