"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Eol = void 0;
const tslib_1 = require("tslib");
const lineEndings_1 = require("../../lineEndings");
const argument_1 = require("./argument");
class Eol extends argument_1.Argument {
    constructor() {
        super(...arguments);
        this.choices = {
            CRLF: "crlf",
            LF: "lf",
            "System default": undefined,
        };
    }
    resolve(config) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { eol } = config;
            if (eol === undefined || (0, lineEndings_1.isLineEnding)(eol)) {
                return eol;
            }
            const answer = yield this.promptForMultipleChoice("Invalid line ending given. Please choose a line ending: ", this.choices);
            return answer;
        });
    }
    parse(config) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { eol } = config;
            if (eol !== undefined && !(0, lineEndings_1.isLineEnding)(eol)) {
                throw new Error(`Invalid line ending given: '${eol}'. Possible values are 'crlf' or 'lf'. Omit the --eol flag to use the system default.`);
            }
            return eol;
        });
    }
}
exports.Eol = Eol;
//# sourceMappingURL=eol.js.map