"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Argument = void 0;
const tslib_1 = require("tslib");
const enquirer_1 = require("enquirer");
class Argument {
    promptForString(question, initialValue) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const answer = yield (0, enquirer_1.prompt)({
                type: "input",
                name: "value",
                initial: initialValue,
                message: question,
            });
            const formattedInput = taperDoubleQuotes(answer.value);
            return formattedInput;
        });
    }
    promptForBoolean(question) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const answer = yield (0, enquirer_1.prompt)({
                type: "confirm",
                name: "value",
                message: question,
            });
            return answer.value;
        });
    }
    promptForMultipleChoice(question, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const answer = yield (0, enquirer_1.prompt)({
                type: "select",
                name: "value",
                message: question,
                choices: Object.keys(options),
            });
            const selection = answer.value;
            return options[selection];
        });
    }
}
exports.Argument = Argument;
/**
 * Process a strings double quotes in the same way that process.argv appears to.
 * It 'downgrades' their escape-level. Unescaped quotes are removed, and escaped quotes
 * become just quotes.
 */
const taperDoubleQuotes = (input) => {
    // Step 1: Remove all unescaped double-quotes ("). Won't replace (\").
    // Example:
    //
    // "my\"file".txt" -> my\"file.txt
    input = input.replace(/(?<!\\)"/g, "");
    // Step 2: Replace all escaped double-quotes (\") with unescaped double-quotes (").
    // my\"file.txt -> my"file.txt
    return input.replace(/\\"/g, '"');
};
//# sourceMappingURL=argument.js.map