# @turf/points-within-polygon

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## pointsWithinPolygon

Finds [Points][1] or [MultiPoint][2] coordinate positions that fall within [(Multi)Polygon(s)][3].

### Parameters

*   `points` **([Feature][4] | [FeatureCollection][5]<([Point][1] | [MultiPoint][2])>)** Point(s) or MultiPoint(s) as input search
*   `polygons` **([FeatureCollection][5] | [Geometry][6] | [Feature][4]<([Polygon][3] | [MultiPolygon][7])>)** (Multi)Polygon(s) to check if points are within

### Examples

```javascript
var points = turf.points([
    [-46.6318, -23.5523],
    [-46.6246, -23.5325],
    [-46.6062, -23.5513],
    [-46.663, -23.554],
    [-46.643, -23.557]
]);

var searchWithin = turf.polygon([[
    [-46.653,-23.543],
    [-46.634,-23.5346],
    [-46.613,-23.543],
    [-46.614,-23.559],
    [-46.631,-23.567],
    [-46.653,-23.560],
    [-46.653,-23.543]
]]);

var ptsWithin = turf.pointsWithinPolygon(points, searchWithin);

//addToMap
var addToMap = [points, searchWithin, ptsWithin]
turf.featureEach(ptsWithin, function (currentFeature) {
  currentFeature.properties['marker-size'] = 'large';
  currentFeature.properties['marker-color'] = '#000';
});
```

Returns **[FeatureCollection][5]<([Point][1] | [MultiPoint][2])>** Point(s) or MultiPoint(s) with positions that land within at least one polygon.  The geometry type will match what was passsed in

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.3

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[4]: https://tools.ietf.org/html/rfc7946#section-3.2

[5]: https://tools.ietf.org/html/rfc7946#section-3.3

[6]: https://tools.ietf.org/html/rfc7946#section-3.1

[7]: https://tools.ietf.org/html/rfc7946#section-3.1.7

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/points-within-polygon
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
