<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

*   [Compare][1]
    *   [Parameters][2]
    *   [Examples][3]
    *   [setSlider][4]
        *   [Parameters][5]
    *   [on][6]
        *   [Parameters][7]
    *   [fire][8]
        *   [Parameters][9]
    *   [off][10]
        *   [Parameters][11]

## Compare

*   **See**: [Swipe between maps][12]

### Parameters

*   `a` **[Object][13]** The first MapLibre GL Map
*   `b` **[Object][13]** The second MapLibre GL Map
*   `container` **([string][14] | [HTMLElement][15])** An HTML Element, or an element selector string for the compare container. It should be a wrapper around the two map Elements.
*   `options` **[Object][13]** 

    *   `options.orientation` **[string][14]** The orientation of the compare slider. `vertical` creates a vertical slider bar to compare one map on the left (map A) with another map on the right (map B). `horizontal` creates a horizontal slider bar to compare on mop on the top (map A) and another map on the bottom (map B). (optional, default `vertical`)
    *   `options.mousemove` **[boolean][16]** If `true` the compare slider will move with the cursor, otherwise the slider will need to be dragged to move. (optional, default `false`)

### Examples

```javascript
var compare = new maplibregl.Compare(beforeMap, afterMap, '#wrapper', {
  orientation: 'vertical',
  mousemove: true
});
```

### setSlider

Set the position of the slider.

#### Parameters

*   `x` **[number][17]** Slider position in pixels from left/top.

### on

Adds a listener for events of a specified type.

#### Parameters

*   `type` **[string][14]** The event type to listen for; one of `slideend`.
*   `fn`  
*   `listener` **[Function][18]** The function to be called when the event is fired.

Returns **[Compare][19]** `this`

### fire

Fire an event of a specified type.

#### Parameters

*   `type` **[string][14]** The event type to fire; one of `slideend`.
*   `data` **[Object][13]** Data passed to the event listener.

Returns **[Compare][19]** `this`

### off

Removes an event listener previously added with `Compare#on`.

#### Parameters

*   `type` **[string][14]** The event type previously used to install the listener.
*   `fn`  
*   `listener` **[Function][18]** The function previously installed as a listener.

Returns **[Compare][19]** `this`

[1]: #compare

[2]: #parameters

[3]: #examples

[4]: #setslider

[5]: #parameters-1

[6]: #on

[7]: #parameters-2

[8]: #fire

[9]: #parameters-3

[10]: #off

[11]: #parameters-4

[12]: https://maplibre.org/maplibre-gl-js-docs/plugins/

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[15]: https://developer.mozilla.org/docs/Web/HTML/Element

[16]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[17]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[19]: #compare
