"use strict";
(self["webpackChunkcartes_ign_app"] = self["webpackChunkcartes_ign_app"] || []).push([[573],{

/***/ 7954:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NetworkWeb: () => (/* binding */ NetworkWeb)
/* harmony export */ });
/* unused harmony export Network */
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5036);

function translatedConnection() {
  const connection = window.navigator.connection || window.navigator.mozConnection || window.navigator.webkitConnection;
  let result = 'unknown';
  const type = connection ? connection.type || connection.effectiveType : null;
  if (type && typeof type === 'string') {
    switch (type) {
      // possible type values
      case 'bluetooth':
      case 'cellular':
        result = 'cellular';
        break;
      case 'none':
        result = 'none';
        break;
      case 'ethernet':
      case 'wifi':
      case 'wimax':
        result = 'wifi';
        break;
      case 'other':
      case 'unknown':
        result = 'unknown';
        break;
      // possible effectiveType values
      case 'slow-2g':
      case '2g':
      case '3g':
        result = 'cellular';
        break;
      case '4g':
        result = 'wifi';
        break;
      default:
        break;
    }
  }
  return result;
}
class NetworkWeb extends _capacitor_core__WEBPACK_IMPORTED_MODULE_0__/* .WebPlugin */ .E_ {
  constructor() {
    super();
    this.handleOnline = () => {
      const connectionType = translatedConnection();
      const status = {
        connected: true,
        connectionType: connectionType
      };
      this.notifyListeners('networkStatusChange', status);
    };
    this.handleOffline = () => {
      const status = {
        connected: false,
        connectionType: 'none'
      };
      this.notifyListeners('networkStatusChange', status);
    };
    if (typeof window !== 'undefined') {
      window.addEventListener('online', this.handleOnline);
      window.addEventListener('offline', this.handleOffline);
    }
  }
  async getStatus() {
    if (!window.navigator) {
      throw this.unavailable('Browser does not support the Network Information API');
    }
    const connected = window.navigator.onLine;
    const connectionType = translatedConnection();
    const status = {
      connected,
      connectionType: connected ? connectionType : 'none'
    };
    return status;
  }
}
const Network = new NetworkWeb();


/***/ })

}]);