"use strict";
(self["webpackChunkcartes_ign_app"] = self["webpackChunkcartes_ign_app"] || []).push([[526],{

/***/ 526:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KeepAwakeWeb: () => (/* binding */ KeepAwakeWeb)
/* harmony export */ });
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5036);

class KeepAwakeWeb extends _capacitor_core__WEBPACK_IMPORTED_MODULE_0__/* .WebPlugin */ .E_ {
  constructor() {
    super(...arguments);
    this.wakeLock = null;
    this._isSupported = typeof navigator !== 'undefined' && 'wakeLock' in navigator;
    this.handleVisibilityChange = () => {
      if (document.visibilityState === 'visible') this.keepAwake();
    };
  }
  async keepAwake() {
    if (!this._isSupported) {
      this.throwUnsupportedError();
    }
    if (this.wakeLock) {
      await this.allowSleep();
    }
    this.wakeLock = await navigator.wakeLock.request('screen');
    document.addEventListener('visibilitychange', this.handleVisibilityChange);
    document.addEventListener('fullscreenchange', this.handleVisibilityChange);
  }
  async allowSleep() {
    var _a;
    if (!this._isSupported) {
      this.throwUnsupportedError();
    }
    (_a = this.wakeLock) === null || _a === void 0 ? void 0 : _a.release();
    this.wakeLock = null;
    document.removeEventListener('visibilitychange', this.handleVisibilityChange);
    document.removeEventListener('fullscreenchange', this.handleVisibilityChange);
  }
  async isSupported() {
    const result = {
      isSupported: this._isSupported
    };
    return result;
  }
  async isKeptAwake() {
    if (!this._isSupported) {
      this.throwUnsupportedError();
    }
    const result = {
      isKeptAwake: !!this.wakeLock
    };
    return result;
  }
  throwUnsupportedError() {
    throw this.unavailable('Screen Wake Lock API not available in this browser.');
  }
}

/***/ })

}]);