/**
 * Copyright (c) Institut national de l'information géographique et forestière
 *
 * This program and the accompanying materials are made available under the terms of the GPL License, Version 3.0.
 */

const days = {
  "Lu": "lundi",
  "Ma": "mardi",
  "Me": "mercredi",
  "Je": "jeudi",
  "Ve": "vendredi",
  "Sa": "samedi",
  "Di": "dimanche",
};

/**
 *  Convertit un horaire OSM brut en horaire plus sympathique
 * @param {String} horaire Horaire OSM de type : "Lu-Ve 07:00-21:00/ Di 08:00-20:00"
 * @returns String horaire formaté plus joliment
 */
function parseOsmOpeningHours(horaire) {
  if (horaire === "closed") {
    return "Fermé définitivement";
  }
  const result = [];
  // cas où les différents jours sont séparés par des virgules
  if (horaire.match(/, ?[A-Z]/g)) {
    horaire = horaire.replace(/[0-9], ?L/g, "/ L");
    horaire = horaire.replace(/[0-9], ?M/g, "/ M");
    horaire = horaire.replace(/[0-9], ?J/g, "/ J");
    horaire = horaire.replace(/[0-9], ?V/g, "/ V");
    horaire = horaire.replace(/[0-9], ?S/g, "/ S");
    horaire = horaire.replace(/[0-9], ?D/g, "/ D");
  }
  const horaireSplit = horaire.split("/").map((el) => el.trim());
  for (let a = 0; a < horaireSplit.length; a++) {
    if (horaireSplit[a].match(/, /g)) {
      horaireSplit[a] = horaireSplit[a].replace(/, /g, ",");
    }
    if (horaireSplit[a].match(/ ?- ?/g)) {
      horaireSplit[a] = horaireSplit[a].replace(/ ?- ?/g, "-");
    }
    const daySplit = horaireSplit[a].split(" ");
    if (daySplit[0].includes("-")) {
      const daysNames = daySplit[0].split("-");
      result.push(`du ${days[daysNames[0]]} au ${days[daysNames[1]]} `);
    } else if (daySplit[0].includes(",")) {
      const daysNames = daySplit[0].split(",");
      for (let i = 0; i < daysNames.length; i++) {
        if (i === daysNames.length - 1) {
          result.push(` et ${days[daysNames[i]]} `);
        } else {
          result.push(days[daysNames[i]]);
        }
        if (i !== daysNames.length - 2) {
          result.push(", ");
        }
      }
    } else {
      result.push(`le ${days[daySplit[0]]} `);
    }
    const hourSplit = daySplit[1].split(",");
    for (let i = 0; i < hourSplit.length; i++) {
      const hourRange = hourSplit[i].split("-");
      if (i === hourSplit.length - 1 && i > 0) {
        result.push(` et de ${hourRange[0]} à ${hourRange[1]}`);
      } else {
        result.push(`de ${hourRange[0]} à ${hourRange[1]}`);
      }
    }
    if (horaireSplit.length >= 2 && a === horaireSplit.length - 2) {
      result.push(" et ");
    } else if (horaireSplit.length > 2 && a < horaireSplit.length - 1) {
      result.push(", ");
    }
  }
  const resultString = result.join("");
  if (resultString.includes("undefined")) {
    return horaire;
  }
  return resultString[0].toUpperCase() + resultString.slice(1);
}

export default parseOsmOpeningHours;
