"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPnpmProjectDependencies = exports.getPnpmVersion = void 0;
const tslib_1 = require("tslib");
const zod_1 = require("zod");
const console_utils_1 = tslib_1.__importDefault(require("./console.utils"));
const exec_utils_1 = require("./exec.utils");
const v8DependencyValidator = zod_1.z.object({
    name: zod_1.z.string(),
    path: zod_1.z.string(),
});
const v9DependencyValidator = zod_1.z.object({
    name: zod_1.z.string(),
    paths: zod_1.z.string().array(),
});
const dependencyValidator = v8DependencyValidator.or(v9DependencyValidator).transform(dep => ({
    name: dep.name,
    paths: "paths" in dep ? dep.paths : [dep.path],
}));
const pnpmLsJsonStdOutValidator = zod_1.z.record(zod_1.z.array(dependencyValidator));
const getPnpmVersion = () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const { stdout } = yield (0, exec_utils_1.execAsync)("pnpm --version");
    const [major, minor, patch] = stdout.split(".").map(Number);
    return { major, minor, patch };
});
exports.getPnpmVersion = getPnpmVersion;
const getPnpmProjectDependencies = (projectDirectory) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const { stdout } = yield (0, exec_utils_1.execAsync)("pnpm licenses list --json --prod", { cwd: projectDirectory });
    const parsedOutput = JSON.parse(stdout);
    const commandOutput = pnpmLsJsonStdOutValidator.safeParse(parsedOutput);
    if (!commandOutput.success) {
        const errors = JSON.stringify(commandOutput.error.flatten());
        console_utils_1.default.error("Failed to parse pnpm licenses list output: " + errors);
        throw new Error("Failed to parse pnpm licenses list output");
    }
    return Object.values(commandOutput.data).flatMap(dependencies => dependencies);
});
exports.getPnpmProjectDependencies = getPnpmProjectDependencies;
//# sourceMappingURL=pnpmCli.utils.js.map