import { z } from "zod";
export type PnpmVersion = {
    major: number;
    minor: number;
    patch: number;
};
declare const dependencyValidator: z.ZodEffects<z.ZodUnion<[z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
}, "strip", z.ZodTypeAny, {
    path: string;
    name: string;
}, {
    path: string;
    name: string;
}>, z.ZodObject<{
    name: z.ZodString;
    paths: z.ZodArray<z.ZodString, "many">;
}, "strip", z.ZodTypeAny, {
    name: string;
    paths: string[];
}, {
    name: string;
    paths: string[];
}>]>, {
    name: string;
    paths: string[];
}, {
    path: string;
    name: string;
} | {
    name: string;
    paths: string[];
}>;
export type PnpmDependency = z.infer<typeof dependencyValidator>;
export declare const getPnpmVersion: () => Promise<PnpmVersion>;
export declare const getPnpmProjectDependencies: (projectDirectory: string) => Promise<PnpmDependency[]>;
export {};
