"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readPackageJson = void 0;
const tslib_1 = require("tslib");
const file_utils_1 = require("./file.utils");
const readPackageJson = (pathToPackageJson) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const doesPackageJsonExist = yield (0, file_utils_1.doesFileExist)(pathToPackageJson);
    if (!doesPackageJsonExist) {
        throw new Error(`Cannot find the file: '${pathToPackageJson}'`);
    }
    const packageJsonAsString = yield (0, file_utils_1.readFile)(pathToPackageJson, { encoding: "utf-8" });
    return JSON.parse(packageJsonAsString);
});
exports.readPackageJson = readPackageJson;
//# sourceMappingURL=packageJson.utils.js.map