"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable @typescript-eslint/no-explicit-any */
const spinner_1 = require("../cli/spinner");
class ConsoleUtils {
    log(message, ...optionalParams) {
        this.writeMessage(global.console.log, message, ...optionalParams);
    }
    warn(message, ...optionalParams) {
        this.writeMessage(global.console.warn, message, ...optionalParams);
    }
    error(message, ...optionalParams) {
        this.writeMessage(global.console.error, message, ...optionalParams);
    }
    writeMessage(logger, message, ...optionalParams) {
        const isSpinning = spinner_1.spinner.isSpinning;
        if (isSpinning) {
            spinner_1.spinner.stop();
        }
        logger(message, ...optionalParams);
        if (isSpinning) {
            spinner_1.spinner.start();
        }
    }
}
const consoleUtils = new ConsoleUtils();
exports.default = consoleUtils;
//# sourceMappingURL=console.utils.js.map