"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.License = void 0;
const string_utils_1 = require("../utils/string.utils");
const BULLET = " - ";
const PREFIX = "The following npm package may be included in this product:";
const PREFIX_PLURAL = "The following npm packages may be included in this product:";
const MIDFIX = "This package contains the following license:";
const MIDFIX_PLURAL = "These packages each contain the following license:";
const NOTICES_PREFIX = "With the following notices:";
class License {
    constructor(content, notices, dependencies) {
        this.content = content;
        this.notices = notices;
        this.dependencies = dependencies;
    }
    format(lineEnding) {
        let formattedText = this.prefix(lineEnding) +
            this.formatDependencies(lineEnding) +
            this.midfix(lineEnding) +
            (0, string_utils_1.prepareContentForOutput)(this.content.trim(), lineEnding);
        if (this.notices.length > 0) {
            const noticeContent = this.notices.map(notice => notice.trim()).join(lineEnding);
            // Append the notices to the formatted text, preparing content for output to ensure
            // the line endings inside each notice content are consistent.
            formattedText +=
                this.noticesPrefix(lineEnding) + (0, string_utils_1.prepareContentForOutput)(noticeContent, lineEnding);
        }
        return formattedText;
    }
    prefix(EOL) {
        if (this.dependencies.length === 1) {
            return PREFIX + EOL + EOL;
        }
        return PREFIX_PLURAL + EOL + EOL;
    }
    noticesPrefix(EOL) {
        return EOL + EOL + NOTICES_PREFIX + EOL + EOL;
    }
    formatDependencies(EOL) {
        const formattedText = this.dependencies
            .sort((a, b) => a.localeCompare(b))
            .map(dependency => {
            return BULLET + dependency + EOL;
        });
        return formattedText.join("");
    }
    midfix(EOL) {
        if (this.dependencies.length === 1) {
            return EOL + MIDFIX + EOL + EOL;
        }
        return EOL + MIDFIX_PLURAL + EOL + EOL;
    }
}
exports.License = License;
//# sourceMappingURL=license.js.map