import { LineEndingCharacters } from "../lineEndings";
/**
 * ILicense contains the content of a given license and the list of dependencies it pertains to.
 */
export interface ILicense {
    /**
     * Body of the license.
     */
    content: string;
    /**
     * Notices for the license.
     */
    notices: string[];
    /**
     * List of node packages that this license applies to.
     */
    dependencies: string[];
}
export declare class License implements ILicense {
    content: string;
    notices: string[];
    dependencies: string[];
    constructor(content: string, notices: string[], dependencies: string[]);
    format(lineEnding: LineEndingCharacters): string;
    private prefix;
    private noticesPrefix;
    private formatDependencies;
    private midfix;
}
