"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLineEndingCharacters = exports.isLineEnding = exports.lineEndingCharacters = exports.lineEndings = void 0;
const tslib_1 = require("tslib");
const os_1 = tslib_1.__importDefault(require("os"));
exports.lineEndings = ["crlf", "lf"];
const lineEndingsMap = {
    crlf: "\r\n",
    lf: "\n",
};
exports.lineEndingCharacters = Object.values(lineEndingsMap);
const isLineEnding = (input) => exports.lineEndings.includes(input);
exports.isLineEnding = isLineEnding;
const getLineEndingCharacters = (input) => {
    if (input === undefined) {
        return os_1.default.EOL;
    }
    return lineEndingsMap[input];
};
exports.getLineEndingCharacters = getLineEndingCharacters;
//# sourceMappingURL=lineEndings.js.map