type ResolveLicensesOptions = {
    replace?: Record<string, string>;
    exclude?: string[];
};
export type LicenseContent = string;
export type NoticeKey = string;
export type LicenseNoticeKey = `${LicenseContent}:${NoticeKey}`;
export type Dependency = {
    name: string;
    version: string | undefined;
};
export type ResolvedLicense = {
    licenseContent: LicenseContent;
    notices: string[];
    dependencies: Dependency[];
};
export declare const resolveLicenses: (packageJsons: string[], options?: ResolveLicensesOptions) => Promise<ResolvedLicense[]>;
export {};
