"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveDependenciesForNpmProject = void 0;
const tslib_1 = require("tslib");
const arborist_1 = tslib_1.__importDefault(require("@npmcli/arborist"));
const path_1 = require("path");
const console_utils_1 = tslib_1.__importDefault(require("../../utils/console.utils"));
const packageJson_utils_1 = require("../../utils/packageJson.utils");
const resolveLicenseContent_1 = require("../resolveLicenseContent");
const resolveNoticeContent_1 = require("../resolveNoticeContent");
const resolveDependenciesForNpmProject = (packageJson, licensesMap, options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;
    const replacements = (_a = options === null || options === void 0 ? void 0 : options.replace) !== null && _a !== void 0 ? _a : {};
    const exclude = (_b = options === null || options === void 0 ? void 0 : options.exclude) !== null && _b !== void 0 ? _b : [];
    const path = resolvePath(packageJson);
    const arborist = new arborist_1.default({ path });
    const topNode = yield arborist.loadActual();
    const parseNode = (node) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
        var _a, _b;
        if (node.dev || node.peer) {
            return;
        }
        const packageJson = yield (0, packageJson_utils_1.readPackageJson)((0, path_1.join)(node.realpath, "package.json"));
        if (exclude.includes(`${packageJson.name}@${packageJson.version}`) ||
            exclude.includes(`${packageJson.name}`)) {
            return;
        }
        try {
            const licenseContent = yield (0, resolveLicenseContent_1.resolveLicenseContent)(node.realpath, packageJson, replacements);
            const notices = yield (0, resolveNoticeContent_1.resolveNotices)(node.realpath);
            const noticeContent = notices.length === 0 ? "" : notices.join("\n");
            const licenseNoticeKey = `${licenseContent}:${noticeContent}`;
            const resolvedLicense = (_a = licensesMap.get(licenseNoticeKey)) !== null && _a !== void 0 ? _a : {
                dependencies: [],
                licenseContent,
                notices,
            };
            const alreadyExists = resolvedLicense.dependencies.find(dep => dep.name === node.package.name && dep.version === node.package.version);
            if (!alreadyExists) {
                resolvedLicense.dependencies.push({
                    name: (_b = node.package.name) !== null && _b !== void 0 ? _b : node.name,
                    version: node.package.version,
                });
            }
            licensesMap.set(licenseNoticeKey, resolvedLicense);
        }
        catch (error) {
            const warningLines = [
                `Unable to determine license content for ${packageJson.name}@${packageJson.version} with error:`,
                error instanceof Error ? error.message : error === null || error === void 0 ? void 0 : error.toString(),
                "", // Empty line for spacing
            ];
            console_utils_1.default.warn(warningLines.join("\n"));
        }
        for (const child of node.children.values()) {
            yield parseNode(child);
        }
    });
    for (const child of topNode.children.values()) {
        yield parseNode(child);
    }
});
exports.resolveDependenciesForNpmProject = resolveDependenciesForNpmProject;
const resolvePath = (path) => {
    const absolutePackageJson = (0, path_1.isAbsolute)(path) ? path : (0, path_1.join)(process.cwd(), path);
    return (0, path_1.dirname)(absolutePackageJson);
};
//# sourceMappingURL=resolveNpmDependencies.js.map