"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProjectLicenses = getProjectLicenses;
const tslib_1 = require("tslib");
const resolveLicenses_1 = require("./internal/resolveLicenses");
/**
 * Scans the project found at the given path and returns an array of objects each
 * containing the details of an identified license and the dependencies it pertains to.
 * @param pathToPackageJson A path to the package.json for the project
 * @param options Additional options for the license discovery
 * @returns Array of `ILicense`s each containing the license content and respective dependencies
 */
function getProjectLicenses(pathToPackageJson, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const licenses = yield (0, resolveLicenses_1.resolveLicenses)([pathToPackageJson], options);
        const results = [];
        for (const license of licenses) {
            const dependencies = license.dependencies.map(dep => {
                var _a;
                if (options === null || options === void 0 ? void 0 : options.omitVersions) {
                    return dep.name;
                }
                return `${dep.name}@${(_a = dep.version) !== null && _a !== void 0 ? _a : "unknown"}`;
            });
            results.push({
                content: license.licenseContent,
                notices: license.notices,
                dependencies,
            });
        }
        return results;
    });
}
//# sourceMappingURL=getProjectLicenses.js.map